/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.IConfigType;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.impl.ConfigTypeImpl;

public class ConfigReference
extends Reference {
    protected IConfigServer m_configServer = null;
    protected IConfigElement m_owner = null;
    protected IConfigElement m_configElement = null;

    protected ConfigReference(String elementName, IConfigServer configServer) {
        super(elementName);
        if (configServer == null) {
            throw new IllegalArgumentException("Failed to create reference to config element: null config server reference.");
        }
        this.m_configServer = configServer;
    }

    protected ConfigReference(IConfigElement configElement) {
        super(configElement == null ? null : (configElement instanceof IConfigType ? ((ConfigTypeImpl)((Object)configElement)).getDSName() : configElement.getName()));
        this.m_configElement = configElement;
        if (configElement != null) {
            this.m_configServer = configElement.getConfigServer();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        return this.getElementName().equals(((ConfigReference)((Object)obj)).getElementName());
    }

    public int hashCode() {
        return this.getElementName().hashCode();
    }

    public IConfigElement getConfigElement() throws ConfigServiceException {
        if (this.m_configElement == null) {
            this.m_configElement = this.m_configServer.loadConfigElement(this.getElementName());
        }
        return this.m_configElement;
    }

    public IConfigElement getLocalConfigElement() throws ConfigServiceException {
        if (this.m_configElement == null) {
            this.m_configElement = ((ConfigServer)this.m_configServer).loadConfigElement(this.getElementName(), true);
        }
        return this.m_configElement;
    }

    public IConfigElement getOwner() {
        return this.m_owner;
    }

    void setOwner(IConfigElement owner) throws ConfigServiceException {
        if (this.m_owner != null && owner != null) {
            throw new ConfigServiceException("Reference to config element can not be added to " + owner.getName() + ": reference is already contained within " + this.m_owner.getName() + ".");
        }
        if (owner != null && owner.getConfigServer() != this.m_configServer) {
            throw new ConfigServiceException("Reference to config element can not be added to " + owner.getName() + ": config element is stored in a different config server.");
        }
        this.m_owner = owner;
    }

    public String toString() {
        return this.getElementName();
    }
}

