/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.tools;

import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class XProperties
extends Properties {
    private static final String START_CONST = "{";
    private static final String END_CONST = "}";
    private static final int MAX_SUBST_DEPTH = 5;

    public XProperties() {
    }

    public XProperties(Properties defaults) {
        super(defaults);
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, 0);
    }

    private String getProperty(String key, int level) {
        String value = super.getProperty(key);
        if (value != null) {
            int beginIndex = 0;
            int startName = value.indexOf(START_CONST, beginIndex);
            while (startName != -1) {
                if (level + 1 > 5) {
                    return value;
                }
                int endName = value.indexOf(END_CONST, startName);
                if (endName == -1) {
                    return value;
                }
                String constName = value.substring(startName + 1, endName);
                String constValue = this.getProperty(constName, level + 1);
                if (constValue == null) {
                    return value;
                }
                String newValue = startName > 0 ? value.substring(0, startName) : "";
                newValue = newValue + constValue;
                beginIndex = newValue.length();
                value = newValue = newValue + value.substring(endName + 1);
                startName = value.indexOf(START_CONST, beginIndex);
            }
        }
        return value;
    }

    public String[] getStringArrayProperty(String key) {
        return this.getStringArrayProperty(key, null);
    }

    public String[] getStringArrayProperty(String key, String[] defaultValue) {
        StringTokenizer st = new StringTokenizer(this.getProperty(key), ",");
        ArrayList<String> list = new ArrayList<String>(st.countTokens());
        while (st.hasMoreElements()) {
            list.add(st.nextToken().trim());
        }
        return list.isEmpty() ? defaultValue : list.toArray(new String[list.size()]);
    }

    public boolean getBooleanProperty(String key) {
        return this.getBooleanProperty(key, false);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        boolean res = defaultValue;
        String value = this.getProperty(key);
        if (value != null) {
            if ((value = value.trim().toLowerCase()).equals("true")) {
                res = true;
            } else if (value.equals("false")) {
                res = false;
            }
        }
        return res;
    }
}

