/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.tools.admin;

import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.framework.directory.DirectoryServiceFactory;
import com.sonicsw.mf.framework.directory.IDirectoryService;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.impl.ConfigTypeDocument;
import com.sonicsw.mx.config.impl.ConfigTypeImpl;
import com.sonicsw.mx.config.impl.InitialValuesImpl;
import com.sonicsw.mx.config.util.ConfigHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public final class ConfigTypesSeeder {
    private static final String DIRECTORY_PREFIX = "/mx/configTypes/";
    private static final String DOMAIN_NAME = "@DOMAIN_NAME@";
    private IDirectoryService m_ds;
    private String m_domainName;

    public static void main(String[] args) throws Exception {
        if (args.length < 1 || args[0].equals("?")) {
            ConfigTypesSeeder.printUsage();
        }
        String file = args[0];
        String dsFile = null;
        if (args.length > 1) {
            dsFile = args[1];
        }
        try {
            new ConfigTypesSeeder(file, dsFile);
        }
        catch (Throwable e) {
            ConfigHelper.printExceptionInfo(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigTypesSeeder(String file, String dsFile) throws Exception {
        File dsDir = null;
        if (dsFile == null) {
            String tempDir = System.getProperty("java.io.tmpdir");
            if (tempDir == null || tempDir.trim().length() == 0) {
                throw new Exception("System temporary directory is not defined");
            }
            dsDir = new File(tempDir, "ds" + System.currentTimeMillis());
            dsDir.mkdir();
            this.m_ds = this.createDSInstance(dsDir);
        } else {
            String dsXML = this.getXMLStringFromFile(dsFile);
            this.m_ds = this.createDSInstance(dsXML);
        }
        ConfigServer server = new ConfigServer();
        try {
            this.m_ds.createDirectory("/mx");
            this.m_ds.createDirectory(DIRECTORY_PREFIX);
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            String importParent = new File(file).getAbsoluteFile().getParent() + File.separator;
            String[] importEntries = this.getImportListFromFile(file);
            for (int i = 0; i < importEntries.length; ++i) {
                String entry = importEntries[i];
                int index = entry.indexOf(32);
                if (index == -1) {
                    throw new Exception("Namespace is not defined for " + entry);
                }
                String xsdName = entry.substring(0, index);
                String ivName = this.generateIVName(xsdName);
                String nSpace = entry.substring(index + 1);
                if (xsdName.trim().length() == 0) {
                    throw new Exception("Name is not defined for " + entry);
                }
                if (nSpace.trim().length() == 0) {
                    throw new Exception("Namespace is not defined for " + entry);
                }
                String importName = importParent + xsdName;
                System.out.println("Importing Config Type from " + importName);
                Collection types = ConfigTypeDocument.parse(nSpace, importName, server, null);
                ConfigTypeImpl configType = null;
                Iterator iter = types.iterator();
                while (iter.hasNext()) {
                    File ivFile;
                    configType = (ConfigTypeImpl)iter.next();
                    try {
                        this.m_ds.createDirectory(configType.getDSDirectory());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.m_ds.deleteElement(configType.getDSName(), null);
                    if (!iter.hasNext() && (ivFile = new File(importParent + ivName)).exists()) {
                        System.out.println("  with Initial Values from " + ivFile.toString());
                        InitialValuesImpl.attach(configType, ivFile.toString());
                    }
                    this.m_ds.setElement(configType.doneUpdate(), null);
                }
            }
            this.deleteDirectory("/_MFSchema");
            String generatedXML = this.m_ds.exportDirectoryToXML("/");
            if (dsFile == null) {
                int index = file.lastIndexOf(46);
                String exportFile = null;
                exportFile = index == -1 ? file + ".seed" : file.substring(0, index) + ".seed";
                BufferedWriter writer = new BufferedWriter(new FileWriter(exportFile));
                writer.write(generatedXML);
                writer.flush();
                writer.close();
                System.out.println("Successfully generated Config Types to " + exportFile);
            } else {
                System.out.println("Seeding directory store ...");
                this.m_ds.importFromXML(generatedXML);
                System.out.println("Successfully seeded directory store");
            }
        }
        finally {
            if (this.m_ds != null) {
                this.m_ds.close();
            }
            if (dsDir != null) {
                System.out.println("Deleting temporary DS file system");
                this.deleteDir(dsDir);
            }
        }
        System.exit(0);
    }

    private void deleteDir(File dir) throws IOException {
        File[] files = dir.listFiles();
        for (int x = 0; x < files.length; ++x) {
            if (files[x].isDirectory()) {
                this.deleteDir(files[x]);
                continue;
            }
            files[x].delete();
        }
        dir.delete();
    }

    void deleteDirectory(String path) throws DirectoryServiceException {
        try {
            try {
                this.m_ds.listAll(path);
            }
            catch (DirectoryServiceException e) {
                return;
            }
            IElementIdentity[] ids = this.m_ds.listElements(path);
            for (int i = 0; i < ids.length; ++i) {
                this.m_ds.deleteElement(ids[i].getName(), null);
            }
            IDirIdentity[] dirIds = this.m_ds.listDirectories(path);
            for (int i = 0; i < dirIds.length; ++i) {
                this.deleteDirectory(dirIds[i].getName());
            }
            this.m_ds.deleteDirectory(path);
        }
        catch (Exception e) {
            DirectoryServiceException ex = new DirectoryServiceException("Failed to delete directory '" + path + "'");
            ex.setLinkedException(e);
            throw ex;
        }
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("Usage: com.sonicsw.mx.config.tools.admin.ConfigTypesSeeder <import.lst> [ds.xml]");
        System.out.println();
        System.out.println("Where: <import.lst>   File containing names of type schemas to import.");
        System.out.println("           <ds.xml>   A DS boot file. If this is specified the seeder will");
        System.out.println("                      seed the data directly into the DS.");
        System.exit(1);
    }

    private String[] getImportListFromFile(String file) throws IOException {
        String line;
        BufferedReader bReader = new BufferedReader(new FileReader(file));
        ArrayList<String> list = new ArrayList<String>();
        while ((line = bReader.readLine()) != null) {
            list.add(line);
        }
        return list.toArray(new String[0]);
    }

    private String getXMLStringFromFile(String xmlFilename) throws Exception {
        FileInputStream fis = new FileInputStream(xmlFilename);
        byte[] bytes = new byte[fis.available()];
        fis.read(bytes);
        return new String(bytes);
    }

    private IDirectoryService createDSInstance(File hostDir) throws Exception {
        System.out.println("Creating temporary DS in " + hostDir.toString());
        this.m_domainName = DOMAIN_NAME;
        Hashtable<String, String> directoryEnv = new Hashtable<String, String>();
        directoryEnv.put("STORAGE_TYPE_ATTRIBUTE", "PSE_STORAGE");
        directoryEnv.put("HOST_DIRECTORY_ATTRIBUTE", hostDir.toString());
        DirectoryServiceFactory factory = new DirectoryServiceFactory(directoryEnv);
        return factory.createDirectoryService(this.m_domainName);
    }

    private IDirectoryService createDSInstance(String dsXML) throws Exception {
        System.out.println("Seeding directly to specified DS location");
        IDirElement dsConfig = ElementFactory.importElementFromXML((String)dsXML, null, (String)"MF_DIRECTORY_SERVICE");
        if (dsConfig == null) {
            dsConfig = ElementFactory.importElementFromXML((String)dsXML, null, (String)"MF_BACKUP_DIRECTORY_SERVICE");
        }
        IAttributeSet dsAttributes = dsConfig.getAttributes();
        String hostDir = (String)dsAttributes.getAttribute("HOST_DIRECTORY");
        String domainName = (String)dsAttributes.getAttribute("DOMAIN_NAME");
        Object tmp = dsAttributes.getAttribute("FILE_SYSTEM_STORAGE");
        if (domainName == null || tmp == null) {
            throw new MFRuntimeException("Bad Directory Service Configuration - must contain DOMAIN_NAME and FILE_SYSTEM_STORAGE.");
        }
        if (!(tmp instanceof IAttributeSet)) {
            throw new MFRuntimeException("Bad Directory Service Configuration - FILE_SYSTEM_STORAGE must be an attribute set.");
        }
        this.m_domainName = domainName;
        IAttributeSet fsStorage = (IAttributeSet)tmp;
        String hostDirDepricated = (String)fsStorage.getAttribute("HOST_DIRECTORY");
        String password = (String)fsStorage.getAttribute("PASSWORD");
        Hashtable<String, String> directoryEnv = new Hashtable<String, String>();
        directoryEnv.put("STORAGE_TYPE_ATTRIBUTE", "PSE_STORAGE");
        if (hostDirDepricated != null) {
            directoryEnv.put("FS_HOST_DIRECTORY_ATTRIBUTE", hostDirDepricated);
        }
        if (hostDir != null) {
            directoryEnv.put("HOST_DIRECTORY_ATTRIBUTE", hostDir);
        }
        if (password != null && password.length() != 0) {
            directoryEnv.put("PASSWORD", password);
        }
        DirectoryServiceFactory factory = new DirectoryServiceFactory(directoryEnv);
        return factory.createDirectoryService(domainName);
    }

    private String generateIVName(String xsdName) {
        int lastIndex = xsdName.lastIndexOf(46);
        String prefix = xsdName.substring(0, Math.max(0, lastIndex));
        return prefix + ".iv";
    }
}

