/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.util;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mx.config.util.SonicFSException;
import java.util.Objects;
import java.util.StringTokenizer;

public class SonicFSFile {
    protected long m_creationTimestamp;
    protected long m_lastModified;
    protected int m_size;
    protected String m_createdBy;
    protected String m_fullname;
    protected boolean m_isDir = false;

    protected SonicFSFile(SonicFSFile copy) {
        this.m_creationTimestamp = copy.m_creationTimestamp;
        this.m_lastModified = copy.m_lastModified;
        this.m_size = copy.m_size;
        this.m_createdBy = copy.m_createdBy;
        this.m_fullname = copy.m_fullname;
        this.m_isDir = copy.m_isDir;
    }

    protected SonicFSFile(String name) {
        this.m_fullname = name;
    }

    static SonicFSFile createFile(String name) {
        SonicFSFile info = new SonicFSFile(name);
        info.m_isDir = false;
        return info;
    }

    static SonicFSFile createDirectory(String name) {
        SonicFSFile info = new SonicFSFile(name);
        info.m_isDir = true;
        return info;
    }

    static SonicFSFile createFile(IDirElement element) {
        SonicFSFile info = SonicFSFile.createFile(element.getIdentity().getName());
        IAttributeSet set = element.getAttributes();
        info.m_creationTimestamp = (Long)set.getAttribute("CREATION_TIME");
        info.m_lastModified = (Long)set.getAttribute("LAST_MODIFIED_TIME");
        info.m_size = (Integer)set.getAttribute("SIZE");
        info.m_createdBy = (String)set.getAttribute("CREATED_BY");
        return info;
    }

    public static String toName(String name) {
        return name.substring(name.lastIndexOf(47) + 1);
    }

    public long getCreationTimestamp() {
        return this.m_creationTimestamp;
    }

    public long getLastModified() {
        return this.m_lastModified;
    }

    public String getName() {
        return SonicFSFile.toName(this.getFullName());
    }

    public String getFullName() {
        return this.m_fullname;
    }

    public int getSize() {
        return this.m_size;
    }

    public String getCreatedBy() {
        return this.m_createdBy;
    }

    public boolean isFile() {
        return !this.m_isDir;
    }

    public boolean isDirectory() {
        return this.m_isDir;
    }

    public boolean isAbsolute() {
        return this.getFullName().startsWith("/");
    }

    public boolean isParent(SonicFSFile file) {
        SonicFSFile parent;
        return file != null && (parent = file.getParentFile()) != null && parent.equals(this);
    }

    public String getParent() {
        return SonicFSFile.toParent(this.getFullName());
    }

    public static String toParent(String name) {
        String[] c = SonicFSFile.split(name);
        return c.length >= 1 ? SonicFSFile.combine(c, 0, c.length - 1) : null;
    }

    public SonicFSFile getParentFile() {
        String res = this.getParent();
        return res != null ? SonicFSFile.createDirectory(res) : null;
    }

    protected static String[] split(String name) {
        StringTokenizer st = new StringTokenizer(name, "/");
        String[] res = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            res[i++] = st.nextToken();
        }
        return res;
    }

    protected static String combine(String[] s, int start, int stop) {
        StringBuffer sb = new StringBuffer("/");
        for (int i = start; i < stop; ++i) {
            if (i != start) {
                sb.append('/');
            }
            sb.append(s[i]);
        }
        return sb.toString();
    }

    public String toURL() {
        return "sonicfs://" + this.getFullName();
    }

    public String toString() {
        return this.getFullName();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (((SonicFSFile)o).isDirectory() != this.isDirectory()) {
            return false;
        }
        return ((SonicFSFile)o).getFullName().equals(this.getFullName());
    }

    public int hashCode() {
        return Objects.hash(this.isDirectory(), this.getFullName());
    }

    static String getCanonicalDirPath(String path) throws SonicFSException {
        int canonicalLength;
        if (!path.startsWith("/")) {
            throw new SonicFSException("\"" + path + "\" does not start with /");
        }
        StringBuffer sb = new StringBuffer();
        int pathLength = path.length();
        boolean prevWasSeparator = false;
        for (int i = 0; i < pathLength; ++i) {
            char c = path.charAt(i);
            if (prevWasSeparator && c == '/') continue;
            sb.append(c);
            prevWasSeparator = c == '/';
        }
        String canonical = sb.toString();
        if (canonical.charAt((canonicalLength = canonical.length()) - 1) != '/') {
            canonical = canonical + "/";
        }
        return canonical;
    }
}

