/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mx.config.ConfigChange;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.impl.ConfigElementImpl;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.impl.DispatcherModule;

public class CacheDispatcherModule
extends DispatcherModule {
    public CacheDispatcherModule(ConfigServer cs) {
        super(cs);
    }

    @Override
    public boolean processConfigChange(ConfigChange configChange) {
        switch (configChange.getChangeType()) {
            case 1: {
                try {
                    IConfigElement local = this.m_cs.loadLocalConfigElement(configChange.getName());
                    if (local == null) break;
                    if (!local.isModified()) {
                        local.refresh();
                        break;
                    }
                    this.m_cs.debugPrintln("CacheDispatcherModule - ignore update for " + configChange.getName() + " since config is modified");
                }
                catch (ConfigServiceException local) {}
                break;
            }
            case 2: {
                try {
                    IConfigElement local = this.m_cs.loadLocalConfigElement(configChange.getName());
                    if (local == null) break;
                    ((ConfigElementImpl)local).setRemoved();
                }
                catch (ConfigServiceException local) {}
                break;
            }
            case 6: {
                try {
                    Object[] list = this.m_cs.getElementCache().lookup(configChange.getName());
                    this.m_cs.debugPrintln("rename " + configChange.getName() + " > " + configChange.getNewName() + " : " + list.length);
                    for (int i = 0; i < list.length; ++i) {
                        ConfigElementImpl local;
                        if (list[i] == null || !(list[i] instanceof ConfigElementImpl) || (local = (ConfigElementImpl)list[i]).isNew()) continue;
                        int index = local.getName().indexOf(configChange.getName());
                        String newName = configChange.getNewName() + local.getName().substring(index + configChange.getName().length());
                        this.m_cs.debugPrintln("rename[" + i + "] : " + local.getName() + " to " + newName);
                        this.m_cs.getElementCache().remove(local.getName(), "");
                        local.setDirectoryElementName(newName);
                        local.m_name = newName;
                        if (this.m_cs.getElementCache().lookup(newName, "") != null) continue;
                        this.m_cs.getElementCache().add(newName, "", local);
                    }
                    break;
                }
                catch (ConfigServiceException configServiceException) {
                    break;
                }
            }
        }
        return true;
    }
}

