/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.tools.admin;

import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.ObjectName;

public class DSImporter {
    private static final String OBJNAME = ".DIRECTORY SERVICE:ID=DIRECTORY SERVICE";
    private static final String DEFAULT_URL = "localhost";
    private static final String DEFAULT_USER = "Administrator";
    private static final String DEFAULT_PASSWORD = "Administrator";
    private static final String DEFAULT_DOMAIN = "Domain1";
    private String m_url = "localhost";
    private String m_user = "Administrator";
    private String m_password = "Administrator";
    private String m_domain = "Domain1";
    private Vector m_files = new Vector();
    private DirectoryServiceProxy m_dsProxy = null;
    private JMSConnectorClient m_connector = null;

    public DSImporter(String[] args) {
        try {
            this.parseArgs(args);
            this.m_connector = this.createConnectorClient();
            this.m_dsProxy = new DirectoryServiceProxy((IRemoteMBeanServer)this.m_connector, new ObjectName(this.m_domain + OBJNAME));
            this.importFiles();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.m_connector != null) {
                this.m_connector.disconnect();
            }
        }
    }

    private JMSConnectorClient createConnectorClient() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("ConnectionURLs", this.m_url);
        env.put("DefaultUser", this.m_user);
        env.put("DefaultPassword", this.m_password);
        JMSConnectorAddress address = new JMSConnectorAddress(env);
        this.m_connector = new JMSConnectorClient();
        this.m_connector.connect(address);
        return this.m_connector;
    }

    private void importFiles() {
        try {
            for (int i = 0; i < this.m_files.size(); ++i) {
                this.m_dsProxy.importFromXML(this.readFile((String)this.m_files.get(i)));
            }
        }
        catch (Exception e) {
            System.out.println("Warning: Failed to import file: " + e.getMessage());
        }
    }

    public String readFile(String file) throws Exception {
        String contents = null;
        BufferedReader reader = null;
        StringWriter writer = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            writer = new StringWriter();
            char[] buffer = new char[1024];
            int read = reader.read(buffer, 0, 1024);
            while (read != -1) {
                writer.write(buffer, 0, read);
                read = reader.read(buffer, 0, 1024);
            }
            contents = writer.toString();
        }
        catch (Exception e) {
            throw new Exception("Error reading file:" + file + e.getMessage());
        }
        finally {
            try {
                reader.close();
                writer.close();
            }
            catch (Exception exception) {}
        }
        return contents;
    }

    private void parseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-url")) {
                this.m_url = args[++i];
                continue;
            }
            if (args[i].equals("-user")) {
                this.m_user = args[++i];
                continue;
            }
            if (args[i].equals("-password")) {
                this.m_password = args[++i];
                continue;
            }
            if (args[i].equals("-domain")) {
                this.m_domain = args[++i];
                continue;
            }
            if (!args[i].equals("-importFiles")) continue;
            StringTokenizer strTok = new StringTokenizer(args[++i], ",");
            while (strTok.hasMoreTokens()) {
                this.m_files.add(strTok.nextToken());
            }
        }
    }

    private static void printUsage() {
        System.out.println("com.sonicsw.mx.config.tools.admin.DSImporter ");
        System.out.println("    [-url brokerUrl]       (Default = localhost)");
        System.out.println("    [-user userName]       (Default = Administrator)");
        System.out.println("    [-password password]   (Default = Administrator)");
        System.out.println("    [-domain domainName]   (Default = Domain1)");
        System.out.println("    [-importFiles filename1,filename2] ");
    }

    public static void main(String[] args) {
        DSImporter seeder = new DSImporter(args);
        System.exit(0);
    }
}

