/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.IConfigType;
import com.sonicsw.mx.config.impl.AttributeDescriptionImpl;
import com.sonicsw.mx.config.impl.AttributeListImpl;
import com.sonicsw.mx.config.impl.AttributeMapImpl;
import com.sonicsw.mx.config.impl.ConfigBeanImpl;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.impl.ConfigTypeImpl;
import com.sonicsw.mx.config.impl.Util;
import java.io.IOException;
import java.io.StringReader;
import java.util.EmptyStackException;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ConfigBeanDocument {
    public static final boolean DEBUG = false;

    private ConfigBeanDocument() {
    }

    public static IConfigBean parse(String beanDocumentURL, IConfigServer configServer) throws ConfigServiceException {
        return ConfigBeanDocument.parse(beanDocumentURL, configServer, false);
    }

    public static IConfigBean parse(String beanDocumentURLParam, IConfigServer configServer, boolean replaceConfigBean) throws ConfigServiceException {
        String beanDocumentURL = beanDocumentURLParam;
        try {
            Handler handler = new Handler(configServer, replaceConfigBean);
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            parser.setContentHandler(handler);
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            beanDocumentURL = ConfigBeanDocument.retrieveBeanDocumentURL(beanDocumentURL, parser);
            return handler.m_bean;
        }
        catch (SAXException e) {
            Exception ex = e.getException();
            if (ex != null) {
                throw new ConfigServiceException("cbd-parse-failed", new Object[]{beanDocumentURL}, ex);
            }
            throw new ConfigServiceException("cbd-parse-failed", new Object[]{beanDocumentURL}, e);
        }
        catch (Exception e) {
            throw new ConfigServiceException("cbd-parse-failed", new Object[]{beanDocumentURL}, e);
        }
    }

    public static String parseVersion(String typeURLParam) throws ConfigServiceException {
        String typeURL = typeURLParam;
        try {
            VersionHandler handler = new VersionHandler();
            typeURL = ConfigBeanDocument.createReaderRetrieveBeanDocumentUrl(handler, typeURL);
            return handler.m_version;
        }
        catch (SAXException e) {
            Exception ex = e.getException();
            if (ex != null) {
                throw new ConfigServiceException("cbd-parse-version-failed", new Object[]{typeURL}, ex);
            }
            throw new ConfigServiceException("cbd-parse-version-failed", new Object[]{typeURL}, e);
        }
        catch (Exception e) {
            throw new ConfigServiceException("cbd-parse-identity-failed", new Object[]{typeURL}, e);
        }
    }

    public static ConfigBeanIdentity parseIdentity(String beanDocumentURLParam) throws ConfigServiceException {
        String beanDocumentURL = beanDocumentURLParam;
        try {
            IdentityHandler handler = new IdentityHandler();
            beanDocumentURL = ConfigBeanDocument.createReaderRetrieveBeanDocumentUrl(handler, beanDocumentURL);
            return new ConfigBeanIdentity(handler.m_name, handler.m_typeName, handler.m_version, handler.m_productVersion);
        }
        catch (SAXException e) {
            Exception ex = e.getException();
            if (ex != null) {
                throw new ConfigServiceException("cbd-parse-identity-failed", new Object[]{beanDocumentURL}, ex);
            }
            throw new ConfigServiceException("cbd-parse-identity-failed", new Object[]{beanDocumentURL}, e);
        }
        catch (Exception e) {
            throw new ConfigServiceException("cbd-parse-identity-failed", new Object[]{beanDocumentURL}, e);
        }
    }

    private static String createReaderRetrieveBeanDocumentUrl(DefaultHandler handler, String beanDocumentURL) throws IOException, SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        parser.setContentHandler(handler);
        return ConfigBeanDocument.retrieveBeanDocumentURL(beanDocumentURL, parser);
    }

    private static String retrieveBeanDocumentURL(String beanDocumentURLParam, XMLReader parser) throws IOException, SAXException {
        String beanDocumentURL = beanDocumentURLParam;
        if (!beanDocumentURL.startsWith("file:")) {
            beanDocumentURL = "file:" + beanDocumentURL;
        }
        parser.parse(beanDocumentURL);
        return beanDocumentURL;
    }

    public static ConfigBeanIdentity parseIdentityContent(String beanDocumentContents) throws ConfigServiceException {
        try {
            IdentityHandler handler = new IdentityHandler();
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            parser.setContentHandler(handler);
            StringReader stringReader = new StringReader(beanDocumentContents);
            InputSource inputSource = new InputSource(stringReader);
            parser.parse(inputSource);
            return new ConfigBeanIdentity(handler.m_name, handler.m_typeName, handler.m_version, handler.m_productVersion);
        }
        catch (SAXException e) {
            Exception ex = e.getException();
            if (ex != null) {
                throw new ConfigServiceException("cbd-parse-identity-content-failed", ex);
            }
            throw new ConfigServiceException("cbd-parse-identity-content-failed", e);
        }
        catch (Exception e) {
            throw new ConfigServiceException("cbd-parse-identity-content-failed", e);
        }
    }

    public static IConfigBean parseContent(String beanDocumentContents, IConfigServer configServer) throws ConfigServiceException {
        return ConfigBeanDocument.parseContent(beanDocumentContents, configServer, false);
    }

    public static IConfigBean parseContent(String beanDocumentContents, IConfigServer configServer, boolean replaceConfigBean) throws ConfigServiceException {
        try {
            Handler handler = new Handler(configServer, replaceConfigBean);
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            parser.setContentHandler(handler);
            StringReader stringReader = new StringReader(beanDocumentContents);
            InputSource inputSource = new InputSource(stringReader);
            parser.parse(inputSource);
            return handler.m_bean;
        }
        catch (SAXException e) {
            Exception ex = e.getException();
            if (ex != null) {
                throw new ConfigServiceException("cbd-parse-content-failed", ex);
            }
            throw new ConfigServiceException("cbd-parse-content-failed", e);
        }
        catch (Exception e) {
            throw new ConfigServiceException("cbd-parse-content-failed", e);
        }
    }

    public static class Handler
    extends DefaultHandler
    implements LexicalHandler {
        ConfigBeanImpl m_bean = null;
        private boolean m_startedRootElement = false;
        Stack m_parentConfigObjects = new Stack();
        Stack m_configObjectDescs = new Stack();
        StringBuffer m_characterContent = null;
        IConfigServer m_configServer = null;
        IConfigType m_configType = null;
        Locator m_locator = null;
        boolean m_replaceConfigBean = false;
        private static final String UNENUM_NAME = "com.sonicsw.mx.config.impl.ConfigBeanDocument.unenumName";
        private boolean isAnnotation = false;
        private boolean m_isCData = false;
        private StringBuffer m_contentCDATA = new StringBuffer();

        public Handler(IConfigServer configServer) {
            this.m_configServer = configServer;
        }

        public Handler(IConfigServer configServer, boolean replaceConfigBean) {
            this.m_configServer = configServer;
            this.m_replaceConfigBean = replaceConfigBean;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.m_locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
            if (!this.m_startedRootElement) {
                this.m_startedRootElement = true;
                String name = null;
                String version = null;
                String productVersion = null;
                int length = attributes.getLength();
                for (int i = 0; i < length; ++i) {
                    if (attributes.getLocalName(i).equals("name")) {
                        name = Util.url2Name(attributes.getValue(i));
                        continue;
                    }
                    if (attributes.getLocalName(i).equals("version")) {
                        version = attributes.getValue(i);
                        continue;
                    }
                    if (!attributes.getLocalName(i).equals("productVersion")) continue;
                    productVersion = attributes.getValue(i);
                }
                if (name == null) {
                    throw new SAXException("Error in configuration document '" + this.m_locator.getSystemId() + "' at line number '" + this.m_locator.getLineNumber() + "' column number '" + this.m_locator.getColumnNumber() + "' : config bean element '" + localName + "' has no 'name' attribute defined.");
                }
                if (version == null) {
                    throw new SAXException("Error in configuration document '" + this.m_locator.getSystemId() + "' at line number '" + this.m_locator.getLineNumber() + "' column number '" + this.m_locator.getColumnNumber() + "' : config bean element '" + localName + "' has no 'version' attribute defined.");
                }
                if (this.m_configType != null) {
                    if (!this.m_configType.getName().equals(localName)) {
                        throw new SAXException("Error in configuration document '" + this.m_locator.getSystemId() + "' at line number '" + this.m_locator.getLineNumber() + "' column number '" + this.m_locator.getColumnNumber() + "' : configuration type '" + localName + "' does not match " + this.m_configType.getName() + ".");
                    }
                } else {
                    try {
                        this.m_configType = this.m_configServer.loadConfigType(localName, version);
                        if (this.m_configType == null) {
                            throw this.createConfigurationDocumentError(localName);
                        }
                    }
                    catch (ConfigServiceException e) {
                        throw this.createConfigurationDocumentError(localName);
                    }
                }
                this.m_configObjectDescs.push(this.m_configType);
                try {
                    if (this.m_replaceConfigBean) {
                        try {
                            this.m_bean = (ConfigBeanImpl)this.m_configServer.loadConfigElement(name);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (this.m_bean != null) {
                        this.m_bean.clear();
                        if (!this.m_bean.isPrototypeInstance() && ((ConfigTypeImpl)this.m_configType).hasInitialValues()) {
                            ((ConfigTypeImpl)this.m_configType).applyInitialValuesTo(this.m_bean);
                        }
                    } else {
                        this.m_bean = new ConfigBeanImpl(name, localName, version, (ConfigServer)this.m_configServer);
                    }
                    this.m_parentConfigObjects.push(this.m_bean);
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
            if (localName.equals("TOOL_ANNOTATION")) {
                this.isAnnotation = true;
            } else {
                IAttributeDescription parentAttrDesc = (IAttributeDescription)this.m_configObjectDescs.peek();
                if (parentAttrDesc == null) {
                    throw new SAXException("Configuration bean document parser encountered an internal error while parsing configuration document '" + this.m_locator.getSystemId() + "' at line number '" + this.m_locator.getLineNumber() + "' column number '" + this.m_locator.getColumnNumber() + "' : An attribute description for the parent of the element '" + localName + "' does not exist.");
                }
                IAttributeDescription attrDesc = parentAttrDesc.getAttributeDescription(localName);
                if (attrDesc == null) {
                    throw new SAXException("Configuration bean document parser encountered an internal error while parsing configuration document '" + this.m_locator.getSystemId() + "' at line number '" + this.m_locator.getLineNumber() + "' column number '" + this.m_locator.getColumnNumber() + "' : An attribute description for the element '" + localName + "' does not exist.");
                }
                this.m_configObjectDescs.push(attrDesc);
                if (parentAttrDesc.getProperty("mx.config.unenumMap") != null) {
                    String name = null;
                    int length = attributes.getLength();
                    for (int i = 0; i < length; ++i) {
                        if (!attributes.getLocalName(i).equals("name")) continue;
                        name = attributes.getValue(i);
                        break;
                    }
                    if (name == null) {
                        throw new SAXException("Error in configuration document '" + this.m_locator.getSystemId() + "' at line number '" + this.m_locator.getLineNumber() + "' column number '" + this.m_locator.getColumnNumber() + "' : element '" + localName + "' in unenumerated attribute map does not have 'name' attribute defined.");
                    }
                    try {
                        ((AttributeDescriptionImpl)attrDesc).setProperty(UNENUM_NAME, name);
                    }
                    catch (ConfigServiceException e) {
                        throw new SAXException((Exception)((Object)e));
                    }
                }
                if (attrDesc.getType().equals(IAttributeMap.class)) {
                    AttributeMapImpl attrMap = new AttributeMapImpl(attrDesc);
                    this.m_parentConfigObjects.push(attrMap);
                } else if (attrDesc.getType().equals(IAttributeList.class)) {
                    AttributeListImpl attrList = new AttributeListImpl(attrDesc);
                    this.m_parentConfigObjects.push(attrList);
                } else {
                    this.m_characterContent = new StringBuffer();
                }
            }
        }

        private SAXException createConfigurationDocumentError(String localName) {
            return new SAXException("Error in configuration document '" + this.m_locator.getSystemId() + "' at line number '" + this.m_locator.getLineNumber() + "' column number '" + this.m_locator.getColumnNumber() + "' : configuration type '" + localName + "' does not exist in config server.");
        }

        @Override
        public void characters(char[] ch, int offset, int length) throws SAXException {
            if (this.m_isCData) {
                this.m_contentCDATA.append(ch, offset, length);
            }
            if (this.m_characterContent != null) {
                this.m_characterContent.append(ch, offset, length);
            }
        }

        @Override
        public void startCDATA() throws SAXException {
            this.m_isCData = true;
        }

        @Override
        public void endCDATA() throws SAXException {
            this.m_isCData = false;
            if (this.isAnnotation) {
                this.m_bean.setAnnotation(this.m_contentCDATA.toString());
            }
            this.m_contentCDATA.setLength(0);
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String qname) throws SAXException {
            block18: {
                Object configObject = null;
                if (localName.equals("TOOL_ANNOTATION")) {
                    this.isAnnotation = false;
                } else {
                    IAttributeDescription attrDesc = (IAttributeDescription)this.m_configObjectDescs.pop();
                    if (attrDesc.getType().equals(IAttributeMap.class)) {
                        configObject = this.m_parentConfigObjects.pop();
                    } else if (attrDesc.getType().equals(IAttributeList.class)) {
                        configObject = this.m_parentConfigObjects.pop();
                    } else {
                        String content = this.m_characterContent.toString();
                        this.m_characterContent = null;
                        try {
                            configObject = attrDesc.validate(content);
                        }
                        catch (ConfigServiceException e) {
                            throw new SAXException((Exception)((Object)e));
                        }
                    }
                    try {
                        IAttributeDescription parentAttrDesc = (IAttributeDescription)this.m_configObjectDescs.peek();
                        if (parentAttrDesc.getType().equals(IAttributeMap.class)) {
                            try {
                                IAttributeMap attrMap = (IAttributeMap)this.m_parentConfigObjects.peek();
                                String unenumName = (String)((AttributeDescriptionImpl)attrDesc).removeProperty(UNENUM_NAME);
                                if (unenumName != null) {
                                    attrMap.setAttribute(unenumName, configObject);
                                } else {
                                    attrMap.setAttribute(localName, configObject);
                                }
                                break block18;
                            }
                            catch (ConfigServiceException e) {
                                throw new SAXException((Exception)((Object)e));
                            }
                        }
                        if (parentAttrDesc.getType().equals(IAttributeList.class)) {
                            try {
                                IAttributeList attrList = (IAttributeList)this.m_parentConfigObjects.peek();
                                attrList.addAttribute(configObject);
                                break block18;
                            }
                            catch (ConfigServiceException e) {
                                throw new SAXException((Exception)((Object)e));
                            }
                        }
                        throw new SAXException("Configuration bean document parser encountered an internal error while parsing configuration document '" + this.m_locator.getSystemId() + "' at line number '" + this.m_locator.getLineNumber() + "' column number '" + this.m_locator.getColumnNumber() + "' : element '" + localName + "' has unknown parent element type.");
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static class VersionHandler
    extends DefaultHandler {
        private boolean m_startedRootElement = false;
        Locator m_locator = null;
        String m_version = null;

        @Override
        public void setDocumentLocator(Locator locator) {
            this.m_locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
            if (!this.m_startedRootElement) {
                this.m_startedRootElement = true;
                int length = attributes.getLength();
                for (int i = 0; i < length; ++i) {
                    if (!attributes.getLocalName(i).equals("version")) continue;
                    this.m_version = attributes.getValue(i);
                }
                if (this.m_version == null) {
                    throw new SAXException("Error in configuration document '" + this.m_locator.getSystemId() + "' at line number '" + this.m_locator.getLineNumber() + "' column number '" + this.m_locator.getColumnNumber() + "' : config bean element '" + localName + "' has no 'version' attribute defined.");
                }
            }
        }
    }

    public static class IdentityHandler
    extends DefaultHandler {
        private boolean m_startedRootElement = false;
        Locator m_locator = null;
        String m_name = null;
        String m_typeName = null;
        String m_version = null;
        String m_productVersion = null;

        @Override
        public void setDocumentLocator(Locator locator) {
            this.m_locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
            if (!this.m_startedRootElement) {
                this.m_startedRootElement = true;
                this.m_typeName = localName;
                int length = attributes.getLength();
                for (int i = 0; i < length; ++i) {
                    if (attributes.getLocalName(i).equals("name")) {
                        this.m_name = Util.url2Name(attributes.getValue(i));
                        continue;
                    }
                    if (attributes.getLocalName(i).equals("version")) {
                        this.m_version = attributes.getValue(i);
                        continue;
                    }
                    if (!attributes.getLocalName(i).equals("productVersion")) continue;
                    this.m_productVersion = attributes.getValue(i);
                }
                if (this.m_name == null) {
                    throw new SAXException("Error in configuration document '" + this.m_locator.getSystemId() + "' at line number '" + this.m_locator.getLineNumber() + "' column number '" + this.m_locator.getColumnNumber() + "' : config bean element '" + localName + "' has no 'name' attribute defined.");
                }
                if (this.m_version == null) {
                    throw new SAXException("Error in configuration document '" + this.m_locator.getSystemId() + "' at line number '" + this.m_locator.getLineNumber() + "' column number '" + this.m_locator.getColumnNumber() + "' : config bean element '" + localName + "' has no 'version' attribute defined.");
                }
            }
        }
    }

    public static class ConfigBeanIdentity {
        public final String m_name;
        public final String m_typeName;
        public final String m_version;
        public final String m_productVersion;

        public ConfigBeanIdentity(String name, String typeName, String version, String productVersion) {
            this.m_name = name;
            this.m_typeName = typeName;
            this.m_version = version;
            this.m_productVersion = productVersion;
        }

        public String toString() {
            return "ConfigBeanIdentity { " + this.m_name + " [" + this.m_typeName + "," + this.m_version + "] }";
        }
    }
}

