/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mf.common.IDSTransaction;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.DSTransaction;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mx.config.ConfigAttributeException;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.ConfigTypeException;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.impl.AttributeDescriptionImpl;
import com.sonicsw.mx.config.impl.AttributeListImpl;
import com.sonicsw.mx.config.impl.AttributeMapImpl;
import com.sonicsw.mx.config.impl.BasicElementPrinter;
import com.sonicsw.mx.config.impl.ConfigElementImpl;
import com.sonicsw.mx.config.impl.ConfigReference;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.util.MessageFormatter;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.xerces.impl.dv.util.HexBin;

public class Util {
    private static final String MA_TOOL_ATTRIBUTES = "TOOL_ATTRIBUTES";
    public static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private static final String XDECIMAL = "org.apache.xerces.impl.dv.xs.DecimalDV$XDecimal";
    public static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final ThreadLocal<GregorianCalendar> CALENDER_THREAD_LOCAL = new ThreadLocal<GregorianCalendar>(){

        @Override
        protected GregorianCalendar initialValue() {
            return new GregorianCalendar();
        }
    };

    public static Object validateAttributeName(Object attributeName) throws ConfigServiceException {
        if (!(attributeName instanceof String)) {
            String name = attributeName == null ? "null" : attributeName.toString();
            String type = attributeName == null ? "na" : attributeName.getClass().getName();
            throw new ClassCastException("Invalid Attribute Name [" + name + ", " + type + "]");
        }
        return attributeName;
    }

    public static Object validateAttributeValue(IConfigPath attributeName, Object attributeValue, IConfigServer configServer, IAttributeDescription parentAttrDesc) throws ConfigAttributeException {
        return Util.validateAttributeValue(attributeName, attributeValue, configServer, parentAttrDesc, true);
    }

    public static Object validateAttributeValue(IConfigPath attributeName, Object attributeValueParam, IConfigServer configServer, IAttributeDescription parentAttrDesc, boolean filterDefaults) throws ConfigAttributeException {
        Object attributeValue = attributeValueParam;
        IAttributeDescription attrDesc = null;
        Object tmp = null;
        if (parentAttrDesc != null && !attributeName.getLastComponent().equals("_MF_SYSTEM_ATTRIBUTES")) {
            if (parentAttrDesc.getType() == IAttributeList.class || parentAttrDesc.getProperty("mx.config.unenumMap") != null) {
                Set names = parentAttrDesc.getAttributeDescriptionNames();
                if (names.isEmpty()) {
                    throw new ConfigAttributeException(attributeName, "config-attr-desc-invalid", (Exception)((Object)new ConfigTypeException("no-entry-in-list-desc")));
                }
                if (names.size() > 1) {
                    System.err.println(MessageFormatter.formatMessage("com.sonicsw.mx.config.ConfigTypeErrors", "multi-entry-in-list-desc", new Object[]{attributeName.toString()}));
                }
                String entryDescName = (String)names.iterator().next();
                attrDesc = parentAttrDesc.getAttributeDescription(entryDescName);
            } else {
                attrDesc = parentAttrDesc.getAttributeDescription(attributeName.getLastComponent());
                if (attrDesc == null) {
                    throw new ConfigAttributeException(attributeName, "config-attr-not-defined");
                }
            }
        }
        if (attributeValue == null) {
            throw new ConfigAttributeException(attributeName, "config-attr-val-is-null");
        }
        if (!(attributeValue instanceof Boolean || attributeValue instanceof Integer || attributeValue instanceof Long || attributeValue instanceof BigDecimal)) {
            if (attributeValue.getClass().getName().equals(XDECIMAL)) {
                attributeValue = new BigDecimal(attributeValue.toString());
            } else if (!(attributeValue instanceof String)) {
                if (attributeValue instanceof Date) {
                    attributeValue = ((Date)attributeValue).clone();
                } else if (attributeValue.getClass().equals(byte[].class)) {
                    attributeValue = ((byte[])attributeValue).clone();
                } else if (attributeValue.getClass().equals(int[].class)) {
                    attributeValue = Util.convertToDate((int[])attributeValue);
                } else if (attributeValue instanceof com.sonicsw.mf.common.config.IAttributeList) {
                    attributeValue = new AttributeListImpl((com.sonicsw.mf.common.config.IAttributeList)attributeValue, attrDesc, (ConfigServer)configServer);
                } else if (attributeValue instanceof IAttributeSet) {
                    attributeValue = new AttributeMapImpl((IAttributeSet)attributeValue, attrDesc, (ConfigServer)configServer, filterDefaults);
                } else if (attributeValue instanceof IConfigElement) {
                    attributeValue = new ConfigReference((IConfigElement)attributeValue);
                } else if (attributeValue instanceof IAttributeMap) {
                    attributeValue = ((IAttributeMap)attributeValue).clone();
                } else if (attributeValue instanceof IAttributeList) {
                    attributeValue = ((IAttributeList)attributeValue).clone();
                } else if (attributeValue instanceof Reference) {
                    attributeValue = new ConfigReference(Util.filterReferenceStrings(((Reference)attributeValue).getElementName()), configServer);
                } else if (!(attributeValue instanceof AttributeMapImpl.RemovedAttribute)) {
                    throw new ConfigAttributeException(attributeName, "config-attr-val-invalid-type", new Object[]{attributeValue, attributeValue.getClass().getName()});
                }
            }
        }
        if (attrDesc != null && !attributeValue.getClass().equals(AttributeMapImpl.RemovedAttribute.class)) {
            tmp = attrDesc.getProperty("mx.config.fixed");
            if (tmp != null && !Util.areEqual(attributeValue, tmp)) {
                throw new ConfigAttributeException(attributeName, "config-attr-val-no-match-fixed", new Object[]{attributeValue, tmp});
            }
            if (attributeValue instanceof IAttributeMap) {
                if (((AttributeMapImpl)attributeValue).m_attrDescription != attrDesc) {
                    throw new ConfigAttributeException(attributeName, "config-attr-val-incorrect-map-type");
                }
            } else if (attributeValue instanceof IAttributeList) {
                if (((AttributeListImpl)attributeValue).m_attrDescription != attrDesc) {
                    throw new ConfigAttributeException(attributeName, "config-attr-val-incorrect-list-type");
                }
            } else {
                try {
                    attrDesc.validate(attributeValue);
                }
                catch (ConfigTypeException e) {
                    throw new ConfigAttributeException(attributeName, "config-attr-val-failed-validation", new Object[]{attributeValue}, (Exception)((Object)e));
                }
                catch (ConfigAttributeException e) {
                    e.setAttributeName(attributeName);
                    throw e;
                }
                catch (ConfigServiceException e) {
                    throw new ConfigAttributeException(attributeName, "config-attr-val-failed-validation", new Object[]{attributeValue}, (Exception)((Object)e));
                }
            }
        }
        return attributeValue;
    }

    public static Object validateAttributeDescriptionName(Object descriptionName) throws ConfigServiceException {
        return Util.validateAttributeName(descriptionName);
    }

    public static Object validateAttributeDescriptionValue(Object descriptionValue) throws ConfigServiceException {
        if (descriptionValue instanceof IAttributeDescription) {
            return ((AttributeDescriptionImpl)descriptionValue).clone();
        }
        throw new ClassCastException("Invalid Attribute Description Value");
    }

    public static String filterReferenceStrings(String elementPathParam) {
        String elementPath = elementPathParam;
        if (elementPath.startsWith("DELETED:")) {
            elementPath = elementPath.substring("DELETED:".length());
        }
        if (elementPath.startsWith("/NO_STORAGE:")) {
            elementPath = elementPath.substring("/NO_STORAGE:".length());
        }
        return elementPath;
    }

    public static String url2Name(String elementURL) {
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        while (true) {
            int newIndex;
            if ((newIndex = elementURL.indexOf("%20", index)) == -1) break;
            buffer.append(elementURL.substring(index, newIndex));
            buffer.append(" ");
            index = newIndex + 3;
        }
        buffer.append(elementURL.substring(index));
        return buffer.toString();
    }

    public static String name2Url(String name) {
        StringBuffer buffer = new StringBuffer(name);
        for (int index = 0; index < buffer.length(); ++index) {
            if (buffer.charAt(index) != ' ') continue;
            buffer.replace(index, index + 1, "%20");
            ++index;
            ++index;
        }
        return buffer.toString();
    }

    public static Date convertToDate(int[] dateTime) {
        if (dateTime.length < 8) {
            throw new ClassCastException("Invalid Attribute Value: " + dateTime.getClass().getName());
        }
        GregorianCalendar calendar = CALENDER_THREAD_LOCAL.get();
        calendar.clear();
        calendar.set(dateTime[0], dateTime[1] - 1, dateTime[2], dateTime[3], dateTime[4], dateTime[5]);
        calendar.add(14, dateTime[6]);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        return calendar.getTime();
    }

    public static int[] convertFromDate(Date date) {
        int[] dateTime = new int[8];
        GregorianCalendar calendar = CALENDER_THREAD_LOCAL.get();
        calendar.setTime(date);
        dateTime[0] = calendar.get(1);
        dateTime[1] = calendar.get(2) + 1;
        dateTime[2] = calendar.get(5);
        dateTime[3] = calendar.get(11);
        dateTime[4] = calendar.get(12);
        dateTime[5] = calendar.get(13);
        dateTime[6] = calendar.get(14);
        dateTime[7] = 90;
        return dateTime;
    }

    public static boolean areEqual(Object attribute1, Object attribute2) {
        if (attribute1 == null || attribute2 == null) {
            return false;
        }
        if (!attribute1.getClass().isInstance(attribute2)) {
            return false;
        }
        if (attribute1 instanceof byte[]) {
            return Arrays.equals((byte[])attribute1, (byte[])attribute2);
        }
        if (attribute1 instanceof Reference) {
            return ((Reference)attribute1).getElementName().equals(((Reference)attribute2).getElementName());
        }
        return attribute1.equals(attribute2);
    }

    public static String toString(Object value) {
        StringBuffer buffer = new StringBuffer();
        if (value instanceof byte[]) {
            return HexBin.encode((byte[])((byte[])value));
        }
        if (value instanceof Date) {
            int[] date = Util.convertFromDate((Date)value);
            NumberFormat formatter = NumberFormat.getInstance();
            formatter.setMinimumIntegerDigits(4);
            formatter.setGroupingUsed(false);
            buffer.append(formatter.format(date[0]));
            buffer.append('-');
            formatter.setMinimumIntegerDigits(2);
            buffer.append(formatter.format(date[1]));
            buffer.append('-');
            buffer.append(formatter.format(date[2]));
            buffer.append('T');
            buffer.append(formatter.format(date[3]));
            buffer.append(':');
            buffer.append(formatter.format(date[4]));
            buffer.append(':');
            buffer.append(formatter.format(date[5]));
            buffer.append('.');
            buffer.append(formatter.format(date[6]));
            buffer.append((char)date[7]);
        } else if (value instanceof Reference) {
            buffer.append(Util.name2Url(((Reference)value).getElementName()));
        } else {
            buffer.append(value);
        }
        return buffer.toString();
    }

    public static void validateConfigBeanName(String name) throws ConfigServiceException {
        if (name.charAt(0) != '/') {
            throw new ConfigServiceException("config-bean-name-not-abs", new Object[]{name});
        }
        Util.validateConfigName(name);
    }

    public static void validateConfigTypeName(String name) throws ConfigServiceException {
        Util.validateConfigName(name);
    }

    public static void validateConfigName(String name) throws ConfigServiceException {
        Object error = null;
        if (name == null) {
            throw new ConfigServiceException("config-bean-name-is-null", new Object[]{name});
        }
        if (name.length() == 0) {
            throw new ConfigServiceException("config-bean-name-is-empty", new Object[]{name});
        }
        if (name.indexOf("$") == 0) {
            throw new ConfigServiceException("config-bean-name-contains-$", new Object[]{name});
        }
        if (name.indexOf("\\") >= 0) {
            throw new ConfigServiceException("config-bean-name-contains-\\", new Object[]{name});
        }
        if (name.indexOf("::") >= 0) {
            throw new ConfigServiceException("config-bean-name-contains-::", new Object[]{name});
        }
        if (name.indexOf(".*.") >= 0) {
            throw new ConfigServiceException("config-bean-name-contains-.*.", new Object[]{name});
        }
        if (name.indexOf(".#.") >= 0) {
            throw new ConfigServiceException("config-bean-name-contains-.#.", new Object[]{name});
        }
        if (name.indexOf("<") >= 0) {
            throw new ConfigServiceException("config-bean-name-contains-<", new Object[]{name});
        }
        if (name.indexOf(">") >= 0) {
            throw new ConfigServiceException("config-bean-name-contains->", new Object[]{name});
        }
        if (name.indexOf("&") >= 0) {
            throw new ConfigServiceException("config-bean-name-contains-&", new Object[]{name});
        }
    }

    public static boolean isDefaultValue(String attributeName, Object attributeValue, IAttributeDescription parentAttrDesc) {
        String entryDescName;
        Set names;
        if (attributeValue == null || parentAttrDesc == null) {
            return false;
        }
        Object tmp = null;
        IAttributeDescription attrDesc = null;
        if (parentAttrDesc.getType() == IAttributeList.class || parentAttrDesc.getProperty("mx.config.unenumMap") != null ? (names = parentAttrDesc.getAttributeDescriptionNames()).size() == 1 && (attrDesc = parentAttrDesc.getAttributeDescription(entryDescName = (String)names.iterator().next())) != null && (tmp = attrDesc.getProperty("mx.config.default")) != null : (attrDesc = parentAttrDesc.getAttributeDescription(attributeName)) != null && (tmp = attrDesc.getProperty("mx.config.default")) != null) {
            return tmp.equals(attributeValue);
        }
        return false;
    }

    public static final HashMap mapToHashMap(Map map) {
        if (map == null) {
            return null;
        }
        if (map instanceof HashMap) {
            return (HashMap)map;
        }
        return new HashMap(map);
    }

    public static HashMap splitToolMetaAttributes(HashMap map) throws ConfigServiceException {
        return Util.mapToHashMap(Util.splitToolMetaAttributes((Map)map));
    }

    public static Map splitToolMetaAttributes(Map map) throws ConfigServiceException {
        if (map == null) {
            return null;
        }
        try {
            String ma = (String)map.remove(MA_TOOL_ATTRIBUTES);
            if (ma == null) {
                return map;
            }
            StringTokenizer st = new StringTokenizer(ma, ";", false);
            while (st.hasMoreTokens()) {
                String item = st.nextToken();
                int index = item.indexOf(61);
                if (index == -1) continue;
                String key = item.substring(0, index);
                String value = item.substring(index + 1);
                if (map.containsKey(key)) continue;
                map.put(key, value);
            }
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-list-failed", e);
        }
        return map;
    }

    public static HashMap combineToolMetaAttributes(HashMap map) {
        return (HashMap)Util.combineToolMetaAttributes((Map)map);
    }

    public static Map combineToolMetaAttributes(Map map) {
        if (map == null) {
            return null;
        }
        HashMap res = new HashMap(map.size());
        Iterator i = map.keySet().iterator();
        StringBuffer sb = new StringBuffer();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (key.equals("_ELEMENT_IDENTITY") || key.equals("_FOLDER_NAME") || key.equals("_IS_COMPLEX")) {
                res.put(key, map.get(key));
                continue;
            }
            Object value = map.get(key);
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append(key).append("=").append(value);
        }
        res.put(MA_TOOL_ATTRIBUTES, sb.toString());
        return res;
    }

    public static String txnToString(IDSTransaction txn) {
        ArrayList actions = ((DSTransaction)txn).getActions();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < actions.size(); ++i) {
            DSTransaction.Action action = (DSTransaction.Action)actions.get(i);
            if (action instanceof DSTransaction.AttachBlob) {
                DSTransaction.AttachBlob attachBlob = (DSTransaction.AttachBlob)action;
                buffer.append("AttachBlob: element=" + attachBlob.m_element.getIdentity().getName() + ":" + attachBlob.m_element.getIdentity().getVersion());
                buffer.append("\r\n");
                continue;
            }
            if (action instanceof DSTransaction.CreateElement) {
                DSTransaction.CreateElement createElement = (DSTransaction.CreateElement)action;
                buffer.append("CreateElement: element=" + createElement.m_element.getIdentity().getName() + ":" + createElement.m_element.getIdentity().getVersion());
                buffer.append("\r\n");
                continue;
            }
            if (action instanceof DSTransaction.CreateElements) {
                DSTransaction.CreateElements createElements = (DSTransaction.CreateElements)action;
                buffer.append("CreateElements: ");
                IDirElement[] elements = createElements.m_elements;
                for (int j = 0; j < elements.length; ++j) {
                    buffer.append(" element=" + elements[j].getIdentity().getName() + ":" + elements[j].getIdentity().getVersion());
                }
                buffer.append("\r\n");
                continue;
            }
            if (action instanceof DSTransaction.CreateFolder) {
                DSTransaction.CreateFolder createFolder = (DSTransaction.CreateFolder)action;
                buffer.append("CreateFolder: folder=" + createFolder.m_folderName + " existingOk = " + createFolder.m_existingOk);
                buffer.append("\r\n");
                continue;
            }
            if (action instanceof DSTransaction.DeleteElement) {
                DSTransaction.DeleteElement deleteElement = (DSTransaction.DeleteElement)action;
                buffer.append("DeleteElement: element=" + deleteElement.m_elementName);
                buffer.append("\r\n");
                continue;
            }
            if (action instanceof DSTransaction.DeleteFolder) {
                DSTransaction.DeleteFolder deleteFolder = (DSTransaction.DeleteFolder)action;
                buffer.append("DeleteFolder: folder=" + deleteFolder.m_folderName);
                buffer.append("\r\n");
                continue;
            }
            if (action instanceof DSTransaction.DetachBlob) {
                DSTransaction.DetachBlob detachBlob = (DSTransaction.DetachBlob)action;
                buffer.append("DetachBlob: element=" + detachBlob.m_delta.getIdentity().getName() + ":" + detachBlob.m_delta.getIdentity().getVersion());
                buffer.append("\r\n");
                continue;
            }
            if (action instanceof DSTransaction.Rename) {
                DSTransaction.Rename rename = (DSTransaction.Rename)action;
                buffer.append("Rename: oldName=" + rename.m_oldName + " newName = " + rename.m_newName);
                buffer.append("\r\n");
                continue;
            }
            if (action instanceof DSTransaction.SetAttributes) {
                DSTransaction.SetAttributes setAttributes = (DSTransaction.SetAttributes)action;
                buffer.append("SetAttributes: name=" + setAttributes.m_name + " : " + setAttributes.m_attributes);
                buffer.append("\r\n");
                continue;
            }
            if (action instanceof DSTransaction.SubclassElement) {
                DSTransaction.SubclassElement subclassElement = (DSTransaction.SubclassElement)action;
                buffer.append("SubclassElement: newElementPath=" + subclassElement.m_newElementPath);
                buffer.append("\r\n");
                continue;
            }
            if (!(action instanceof DSTransaction.UpdateElement)) continue;
            DSTransaction.UpdateElement updateElement = (DSTransaction.UpdateElement)action;
            buffer.append("UpdateElement: element=" + updateElement.m_element.getIdentity().getName() + ":" + updateElement.m_element.getIdentity().getVersion());
            buffer.append("\r\n");
        }
        return buffer.toString();
    }

    public static IConfigElement createConfigElement(IDirElement dirElement, ConfigServer configServer) throws ConfigServiceException {
        return new ConfigElementImpl(dirElement, configServer);
    }

    public static void printBasicElement(IBasicElement element) {
        System.err.println(new BasicElementPrinter(element));
    }
}

