/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.evs.nio.nwlink.http;

import com.sonicsw.blackbird.Version;
import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.DelegatingNetworkLinkConfig;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLinkResult;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsAsyncWriteListener;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.INetworkLinkConfig;
import com.sonicsw.blackbird.evs.nio.nwlink.http.EvsHTTPNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.http.prAccessor;
import com.sonicsw.blackbird.evs.nio.nwlink.util.WakeupPipe;
import com.sonicsw.blackbird.http.IHTTPConnection;
import com.sonicsw.blackbird.http.IHTTPRequest;
import com.sonicsw.blackbird.http.IHTTPResponse;
import com.sonicsw.blackbird.http.impl.HTTPParseUtil;
import com.sonicsw.blackbird.http.impl.server.HTTPServer;
import com.sonicsw.blackbird.http.server.IHTTPRequestHandler;
import com.sonicsw.blackbird.http.server.IHTTPServer;
import com.sonicsw.blackbird.http.server.IHTTPServerRequest;
import com.sonicsw.blackbird.http.server.IHTTPServerResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import progress.message.resources.prMessageFormat;

public class EvsHTTPServerNetworkLink
extends EvsHTTPNetworkLink
implements IHTTPRequestHandler {
    private static final boolean DEBUG;
    private static final boolean DEBUG1;
    private static final boolean DEBUG_UNEXPECTED;
    private static final boolean DEBUG_PERFORMANCE;
    private static final boolean DEBUG_LIFECYCLE;
    private static final boolean DEBUG_WARN = true;
    private static final boolean ALLOW_MULTI_REQUEST_READ = false;
    private IHTTPServer m_httpServer = null;
    private final Map m_connections = Collections.synchronizedMap(new HashMap());
    private long KEEPALIVE_INTERVAL;
    private long READ_TIMEOUT;
    private long IDLE_TIMEOUT;
    private int m_nextConnectionId = 0;
    private int m_linkType = 0;
    private int m_remotePort = -1;
    private InetAddress m_remoteInetAddress = null;
    private int m_localPort = -1;
    private InetAddress m_localInetAddress = null;
    private RequestQueue m_acceptQueue;
    private static final Object KEEPALIVE_IDENTIFIER;
    private int m_id = -1;
    private String m_idString = "-1";
    private final ReadContext m_readContext;
    private final WriteContext m_writeContext;
    private final int PEER_TUNNELING_VERSION;
    private final int HTTP_HEADER_RESERVE = 512;
    private final int MAX_REQUEST_SIZE;
    private final boolean PIPELINE_ENABLED;
    private final EvsHTTPServerNetworkLink m_passiveLink;
    private final String m_name;

    EvsHTTPServerNetworkLink(int type, SelectableChannel channel, INetworkLinkConfig config) throws EEvsIOException {
        super(config);
        this.m_writeContext = null;
        this.m_readContext = null;
        this.PEER_TUNNELING_VERSION = 1;
        this.MAX_REQUEST_SIZE = this.m_config.getHTTPMaxMessagetSize();
        this.m_passiveLink = null;
        if (type == 0) {
            try {
                this.m_acceptQueue = new RequestQueue(false);
            }
            catch (IOException ex) {
                throw new EEvsIOException(prAccessor.getString("HTTP server link accept queue create"), (Exception)ex);
            }
        } else {
            this.m_name = null;
            throw new EEvsIOException(prAccessor.getString("Invalid Server Link Type: ACTIVE"), null);
        }
        this.m_httpServer = new HTTPServer((INetworkLinkConfig)new EvsServerNetworkLinkConfig(config));
        this.m_localPort = ((HTTPServer)this.m_httpServer).getServerLink().getLocalPort();
        this.m_localInetAddress = ((HTTPServer)this.m_httpServer).getServerLink().getLocalInetAddress();
        this.m_name = "Passive HTTP link: " + this.m_localInetAddress.getHostName() + ":" + this.m_localPort;
        this.m_httpServer.registerHandler(CLOSE_PATH.getRawPath(), (IHTTPRequestHandler)this);
        this.m_httpServer.registerHandler(CONNECT_PATH.getRawPath(), (IHTTPRequestHandler)this);
        this.m_httpServer.registerHandler(WRITE_DATA_PATH.getRawPath(), (IHTTPRequestHandler)this);
        this.m_httpServer.registerHandler(GET_DATA_PATH.getRawPath(), (IHTTPRequestHandler)this);
        this.m_httpServer.registerHandler(KEEP_ALIVE_PATH.getRawPath(), (IHTTPRequestHandler)this);
        this.m_httpServer.start();
        this.PIPELINE_ENABLED = true;
    }

    private EvsHTTPServerNetworkLink(int id, IHTTPServerRequest request, IHTTPResponse response, INetworkLinkConfig config, EvsHTTPServerNetworkLink parent) throws EEvsIOException, IOException {
        super(config);
        this.m_id = id;
        this.m_idString = Long.toString(this.m_id);
        this.m_linkType = 1;
        IHTTPConnection connection = request.getHTTPConnection();
        this.m_remotePort = connection.getRemotePort();
        this.m_remoteInetAddress = connection.getRemoteInetAddress();
        this.m_localPort = connection.getLocalPort();
        this.m_localInetAddress = connection.getLocalInetAddress();
        this.m_passiveLink = parent;
        this.IDLE_TIMEOUT = this.m_config.getHTTPServerLinkIdleTimeout();
        this.KEEPALIVE_INTERVAL = Math.min(this.IDLE_TIMEOUT, this.m_config.getHTTPServerConnectionIdleTimeout()) / 2L;
        this.READ_TIMEOUT = Math.min(config.getHTTPServerReadResponseTimeout(), this.IDLE_TIMEOUT);
        this.m_name = "HTTPServerNetworkLink tunnel id:" + this.m_id + " source: " + this.m_remoteInetAddress.getCanonicalHostName() + " local: " + this.m_passiveLink.getNetworkLinkConfig().getLocalInterfaceAddress() + ":" + this.m_passiveLink.getLocalPort();
        int protocol = request.getHeaderAsInt("SonicTunnelingProtocol");
        if (protocol == 1) {
            this.PEER_TUNNELING_VERSION = 1;
            Properties props = HTTPParseUtil.parseHeaderParams(request.getHeaderValue("SonicTunnelingParams"));
            if (DEBUG) {
                this.debug("Got client tunneling properties: " + props);
            }
            int clientMaxRequestSize = 0;
            try {
                clientMaxRequestSize = Integer.parseInt(props.getProperty("max-msg-size", "" + config.getHTTPMaxMessagetSize()));
            }
            catch (NumberFormatException ex) {
                throw new EEvsIOException("Malformed parameter in connect request header:max-msg-size:" + props.getProperty("max-msg-size"));
            }
            this.MAX_REQUEST_SIZE = Math.min(config.getHTTPMaxMessagetSize(), clientMaxRequestSize);
            boolean clientPipelineEnabled = Boolean.valueOf(props.getProperty("pipeline-enabled", "false"));
            if (DEBUG_PERFORMANCE) {
                this.debug("HTTP pipelining at client: " + clientPipelineEnabled + ", server pipelining: " + config.getHTTPPipeliningEnabled());
            }
            this.PIPELINE_ENABLED = config.getHTTPPipeliningEnabled() && clientPipelineEnabled;
        } else {
            if (DEBUG) {
                this.debug("Got pre 7.5 connnect: " + request);
            }
            this.PEER_TUNNELING_VERSION = 0;
            this.MAX_REQUEST_SIZE = config.getHTTPMaxMessagetSize();
            this.PIPELINE_ENABLED = false;
        }
        this.m_writeContext = new WriteContext();
        this.m_readContext = new ReadContext();
        response.setHeader("SonicTunnelingProtocol", "1");
        response.setHeader("ConnectionId", "" + id);
        response.addHeader("SonicTunnelingParams", "max-msg-size=" + this.MAX_REQUEST_SIZE);
        response.addHeader("SonicTunnelingParams", "idle-timeout=" + this.IDLE_TIMEOUT);
        response.addHeader("SonicTunnelingParams", "server-id=java");
        response.addHeader("SonicTunnelingParams", "server-version=" + Version.getFullVersion());
        response.addHeader("SonicTunnelingParams", "pipeline-enabled=" + this.PIPELINE_ENABLED);
        if (this.PEER_TUNNELING_VERSION == 0) {
            response.setHeader("SonicPingInterval", "" + this.KEEPALIVE_INTERVAL * 2L);
        } else {
            response.setHeader("SonicPingInterval", "" + this.KEEPALIVE_INTERVAL);
        }
    }

    @Override
    public final boolean isBlocking() {
        return this.m_config.getBlockingIO();
    }

    @Override
    public void setSOTimeout(int timeout) throws EEvsIOException {
    }

    @Override
    public int getSOTimeout() throws EEvsIOException {
        return (int)this.IDLE_TIMEOUT;
    }

    public final boolean isThreaded() {
        return true;
    }

    public final IHTTPRequestHandler handleRequest(IHTTPServerRequest request) {
        IHTTPServerResponse response = request.getHTTPServerResponse();
        if (!request.getMethod().equals("POST")) {
            request.setHandled();
            response.setStatusCode((short)405);
            response.setReasonPhrase("Method Not Allowed: " + request.getMethod());
            response.setHandled();
            return this;
        }
        String path = request.getRequestURI().getPath();
        if (DEBUG) {
            response.setHeader("AgentId", Thread.currentThread().getName());
            int seqNo = request.getHeaderAsInt("SequenceNumber");
            this.debug(Thread.currentThread() + " handling " + path + ", sequence number = " + seqNo);
        }
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Content-Type", "application/octet-stream");
        if (path.equals(WRITE_DATA_PATH.getPath())) {
            return this.handleWriteData(request, (IHTTPResponse)response);
        }
        if (path.equals(GET_DATA_PATH.getPath())) {
            return this.handleReadData(request, (IHTTPResponse)response);
        }
        if (path.equals(KEEP_ALIVE_PATH.getPath())) {
            return this.handleKeepAlive(request, response);
        }
        if (path.equals(CONNECT_PATH.getPath())) {
            return this.handleConnect(request, response);
        }
        if (path.equals(CLOSE_PATH.getPath())) {
            return this.handleClose((IHTTPRequest)request, (IHTTPResponse)response);
        }
        request.setHandled();
        response.setStatusCode((short)404);
        response.setReasonPhrase("Not Found -- bad URI");
        response.setHandled();
        if (DEBUG) {
            this.debug("HTTP Connection bad request path: " + request);
        }
        return this;
    }

    private IHTTPRequestHandler handleConnect(IHTTPServerRequest request, IHTTPServerResponse response) {
        int id = request.getHeaderAsInt("SONIC_CLIENT_PING");
        if (id != -1) {
            EvsHTTPServerNetworkLink link;
            if (DEBUG) {
                this.debug("HTTP Connection " + id + " pinging at " + new Date(System.currentTimeMillis()));
            }
            if ((link = (EvsHTTPServerNetworkLink)this.m_connections.get(new Integer(id))) == null) {
                if (DEBUG) {
                    this.debug("HTTP Connection " + id + ": non-existent or socket closed by broker, response = " + 400);
                }
            } else {
                return link.handleKeepAlive(request, response);
            }
            request.setHandled();
            response.setStatusCode((short)404);
            response.setReasonPhrase("Not Found -- unknown connection");
            response.setHeader("SonicConnection", "closed");
            response.setHandled();
            return this;
        }
        EvsHTTPServerNetworkLink link = null;
        try {
            id = this.getNextConnectionId();
            link = new EvsHTTPServerNetworkLink(id, request, (IHTTPResponse)response, this.m_config, this);
        }
        catch (IOException ex) {
            if (DEBUG || DEBUG_UNEXPECTED) {
                this.debug("Error creating client link: " + ex.getMessage(), ex);
            }
            request.setHandled();
            response.setStatusCode((short)500);
            response.setReasonPhrase("Internal Server Error ... Link Create");
            response.setHandled();
            return this;
        }
        catch (EEvsIOException ex) {
            if (DEBUG || DEBUG_UNEXPECTED) {
                this.debug("Error creating client link: " + ex.getMessage(), ex);
            }
            request.setHandled();
            response.setStatusCode((short)500);
            response.setReasonPhrase("Internal Server Error ... Link Create");
            response.setHandled();
            return this;
        }
        this.m_connections.put(new Integer(id), link);
        if (DEBUG) {
            this.debug("HTTP Connection " + id + ": created. Setting response: " + 200);
        }
        request.setHandled();
        try {
            response.setStatusCode((short)200);
            response.setReasonPhrase("OK");
            response.setHandled();
            this.m_acceptQueue.addRequest(request);
        }
        catch (IOException ex1) {
            response.setStatusCode((short)500);
            response.setReasonPhrase("Internal Server Error ... Connect Request Add");
            response.setHandled();
        }
        return this;
    }

    private final IHTTPRequestHandler handleKeepAlive(IHTTPServerRequest request, IHTTPServerResponse response) {
        if (this.m_linkType == 0) {
            int id = request.getHeaderAsInt("ConnectionId");
            EvsHTTPServerNetworkLink link = (EvsHTTPServerNetworkLink)this.m_connections.get(new Integer(id));
            if (link == null) {
                if (DEBUG) {
                    this.debug("HTTP Connection Ping " + id + ": non-existent socket. Setting response: " + 400);
                }
                request.setHandled();
                response.setStatusCode((short)400);
                response.setReasonPhrase("Bad Request -- no connection");
                response.setHeader("SonicConnection", "closed");
                response.setHandled();
                return this;
            }
            return link.handleKeepAlive(request, response);
        }
        request.setAttachment(KEEPALIVE_IDENTIFIER);
        request.setHandled();
        try {
            this.m_readContext.addWriteDataRequest(request);
        }
        catch (IOException ex) {
            response.setStatusCode((short)500);
            response.setReasonPhrase("Internal Server Error ... Write Request Add");
            response.setHandled();
        }
        return this;
    }

    private IHTTPRequestHandler handleClose(IHTTPRequest request, IHTTPResponse response) {
        if (this.m_linkType == 0) {
            int id = request.getHeaderAsInt("ConnectionId");
            EvsHTTPServerNetworkLink link = (EvsHTTPServerNetworkLink)this.m_connections.get(new Integer(id));
            if (link == null) {
                if (DEBUG) {
                    this.debug("HTTP Connection " + id + ": non-existent socket. Setting response: " + 200);
                }
                request.setHandled();
                response.setStatusCode((short)200);
                response.setReasonPhrase("OK ... already closed");
                response.setHandled();
                return this;
            }
            link.handleClose(request, response);
            this.m_connections.remove(new Integer(id));
            return link;
        }
        this.m_writeContext.closeRequestQueue();
        this.m_readContext.closeRequestQueue();
        if (DEBUG || DEBUG_LIFECYCLE) {
            this.debug("HTTP Connection " + this.m_id + ": closed by the client, timestamp = " + System.currentTimeMillis() + " Setting response: " + 200);
        }
        request.setHandled();
        response.setStatusCode((short)200);
        response.setReasonPhrase("OK");
        response.setHandled();
        return this;
    }

    private IHTTPRequestHandler handleWriteData(IHTTPServerRequest request, IHTTPResponse response) {
        if (this.m_linkType == 0) {
            int id = request.getHeaderAsInt("ConnectionId");
            EvsHTTPServerNetworkLink link = (EvsHTTPServerNetworkLink)this.m_connections.get(new Integer(id));
            if (link == null) {
                if (DEBUG) {
                    this.debug("HTTP Connection Write " + id + ": non-existent socket. Setting response: " + 400);
                }
                request.setHandled();
                response.setStatusCode((short)400);
                response.setReasonPhrase("Bad Request -- no connection");
                response.setHeader("SonicConnection", "closed");
                response.setHandled();
                return this;
            }
            return link.handleWriteData(request, response);
        }
        if (DEBUG) {
            this.debug("HTTP Link Write Request Received: " + request);
        }
        try {
            this.m_readContext.addWriteDataRequest(request);
        }
        catch (IOException ex) {
            request.setHandled();
            response.setStatusCode((short)500);
            response.setReasonPhrase("Internal Server Error ... Write Request Add");
            response.setHandled();
        }
        return this;
    }

    private IHTTPRequestHandler handleReadData(IHTTPServerRequest request, IHTTPResponse response) {
        if (this.m_linkType == 0) {
            int id = request.getHeaderAsInt("ConnectionId");
            EvsHTTPServerNetworkLink link = (EvsHTTPServerNetworkLink)this.m_connections.get(new Integer(id));
            if (link == null) {
                if (DEBUG) {
                    this.debug("HTTP Connection Read " + id + ": non-existent socket. Setting response: " + 400);
                }
                request.setHandled();
                response.setStatusCode((short)400);
                response.setReasonPhrase("Bad Request -- no connection");
                response.setHeader("SonicConnection", "closed");
                response.setHandled();
                return this;
            }
            return link.handleReadData(request, response);
        }
        if (DEBUG) {
            this.debug("HTTP Link Read Request Received: " + request);
        }
        try {
            this.m_writeContext.addGetDataRequest(request);
            request.setHandled();
        }
        catch (IOException ex) {
            if (DEBUG) {
                this.debug("Error adding read request to write queue", ex);
            }
            request.setHandled();
            response.setStatusCode((short)500);
            response.setReasonPhrase("Internal Server Error ... Read Request Add");
            response.setHandled();
        }
        return this;
    }

    private synchronized int getNextConnectionId() throws IOException {
        this.m_nextConnectionId = this.m_nextConnectionId == Integer.MAX_VALUE ? 0 : ++this.m_nextConnectionId;
        int save = this.m_nextConnectionId;
        while (this.m_connections.get(new Integer(this.m_nextConnectionId)) != null) {
            this.m_nextConnectionId = this.m_nextConnectionId == Integer.MAX_VALUE ? 0 : ++this.m_nextConnectionId;
            if (this.m_nextConnectionId != save) continue;
            throw new IOException("Max connections exceeded.");
        }
        return this.m_nextConnectionId;
    }

    private void pingReceived() {
    }

    private final long getIdleTimeout() {
        return this.IDLE_TIMEOUT;
    }

    @Override
    public boolean connect(EvsNetworkLinkResult result) throws EEvsIOException {
        return true;
    }

    @Override
    public int getRemotePort() {
        return this.m_remotePort;
    }

    @Override
    public InetAddress getRemoteInetAddress() {
        return this.m_remoteInetAddress;
    }

    @Override
    public int getLocalPort() {
        return this.m_localPort;
    }

    @Override
    public InetAddress getLocalInetAddress() {
        return this.m_localInetAddress;
    }

    @Override
    public IEvsNetworkLink accept(EvsNetworkLinkResult result) throws EEvsIOException {
        try {
            IHTTPServerRequest connRequest = this.m_acceptQueue.removeRequest(0L);
            if (connRequest == null) {
                if (this.m_config.getBlockingIO()) {
                    throw new IOException("closed");
                }
                result.channel = this.m_acceptQueue.getChannel();
                result.blockingOps |= 1;
                return null;
            }
            int id = connRequest.getResponse().getHeaderAsInt("ConnectionId");
            EvsHTTPNetworkLink link = (EvsHTTPNetworkLink)this.m_connections.get(new Integer(id));
            if (link == null) {
                if (DEBUG || DEBUG_UNEXPECTED) {
                    this.debug("No link exists for: " + id + " skipping connect");
                }
                return this.accept(result);
            }
            result.blockingOps &= 0xFFFFFFFE;
            return link;
        }
        catch (IOException ioe) {
            if (DEBUG_LIFECYCLE) {
                this.debug("Accept queue closed... closing", ioe);
            }
            this.close();
            throw new EEvsIOException(prAccessor.getString("HTTP Server Link accept"), (Exception)ioe);
        }
    }

    @Override
    public int read(ByteBuffer buffer, EvsNetworkLinkResult result) throws EEvsIOException {
        return this.m_readContext.processReadState(buffer, result);
    }

    @Override
    public final void addWrite(ByteBuffer buffer, IEvsAsyncWriteListener listener) throws EEvsIOException {
        if (buffer == null) {
            throw new NullPointerException("null write buffer");
        }
        this.m_writeContext.addWriteData(buffer, listener);
    }

    @Override
    public final boolean write(EvsNetworkLinkResult result) throws EEvsIOException {
        return this.m_writeContext.processWriteState(result);
    }

    @Override
    public long getKeepAlive() {
        if (this.m_linkType == 0) {
            return 0L;
        }
        return Math.min(this.KEEPALIVE_INTERVAL, this.READ_TIMEOUT);
    }

    @Override
    public boolean close(EvsNetworkLinkResult result, boolean immediate) throws EEvsIOException {
        return this.close();
    }

    private final boolean close() {
        if (DEBUG || DEBUG_LIFECYCLE) {
            this.debug("Closing link on " + Thread.currentThread());
            Thread.dumpStack();
        }
        if (this.m_linkType == 0) {
            this.m_acceptQueue.close();
            this.m_httpServer.close();
        } else {
            this.m_passiveLink.m_connections.remove(new Integer(this.m_id));
            this.m_readContext.close();
            this.m_writeContext.close();
        }
        return true;
    }

    @Override
    public SelectableChannel getChannel() {
        return null;
    }

    @Override
    public final SelectableChannel getServerChannel() {
        return this.m_acceptQueue.getChannel();
    }

    @Override
    public int getRequestedHeaderReserve() {
        return 512;
    }

    @Override
    public int getRequestedTrailerReserve() {
        return 0;
    }

    public final String toString() {
        return this.m_name;
    }

    static {
        DEBUG1 = DEBUG = EvsHTTPNetworkLink.DEBUG_NEW_HTTP;
        DEBUG_UNEXPECTED = DEBUG || EvsHTTPNetworkLink.DEBUG_UNEXPECTED;
        DEBUG_PERFORMANCE = EvsHTTPNetworkLink.DEBUG_PERFORMANCE;
        DEBUG_LIFECYCLE = DEBUG || EvsHTTPNetworkLink.DEBUG_LIFECYCLE;
        KEEPALIVE_IDENTIFIER = new Object();
    }

    final class EvsServerNetworkLinkConfig
    extends DelegatingNetworkLinkConfig {
        EvsServerNetworkLinkConfig(INetworkLinkConfig config) {
            super(config);
        }

        @Override
        public final boolean getBlockingIO() {
            return false;
        }
    }

    final class RequestQueue {
        private LinkedList m_queue;
        private boolean m_open = true;
        private final WakeupPipe m_wakeupPipe;
        private final boolean m_isBlocking;
        private int m_ackSeqNo = -1;
        private boolean m_notify = true;
        private final boolean m_trackAcks;
        private final TreeMap m_unackedQueue;
        private final WriteHolderQueue m_ackedData;

        RequestQueue(boolean trackAcks) throws IOException {
            this.m_isBlocking = EvsHTTPServerNetworkLink.this.m_config.getBlockingIO();
            this.m_trackAcks = trackAcks;
            if (this.m_trackAcks) {
                this.m_unackedQueue = new TreeMap();
                this.m_ackedData = new WriteHolderQueue();
            } else {
                this.m_unackedQueue = null;
                this.m_ackedData = null;
            }
            if (!this.m_isBlocking) {
                this.m_wakeupPipe = new WakeupPipe();
                if (DEBUG_LIFECYCLE) {
                    EvsHTTPServerNetworkLink.this.debug("Opened wakeup pipe: " + this.m_wakeupPipe);
                }
            } else {
                this.m_wakeupPipe = null;
            }
            this.m_queue = new LinkedList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void addRequest(IHTTPServerRequest request) throws IOException {
            int reqSeqNo = 0;
            int ackSeqNo = 0;
            if (this.m_trackAcks) {
                reqSeqNo = request.getHeaderAsInt("SequenceNumber");
                ackSeqNo = EvsHTTPServerNetworkLink.this.PEER_TUNNELING_VERSION < 1 ? reqSeqNo : request.getHeaderAsInt("SonicAckSeqNo");
            }
            RequestQueue requestQueue = this;
            synchronized (requestQueue) {
                boolean ackProcessed = true;
                if (this.m_trackAcks && ackSeqNo > this.m_ackSeqNo) {
                    this.m_ackSeqNo = ackSeqNo;
                    this.processAck(this.m_ackSeqNo);
                }
                if (!this.m_open) {
                    throw new IOException(prAccessor.getString("Request Queue Closed"));
                }
                if (!this.m_isBlocking) {
                    this.m_wakeupPipe.wakeup();
                } else if (this.m_queue.isEmpty() || ackProcessed && this.m_notify) {
                    this.notifyAll();
                }
                if (!this.m_trackAcks || !this.processRequestRetry(reqSeqNo, request.getHTTPServerResponse())) {
                    this.m_queue.add(request);
                }
            }
        }

        final synchronized IHTTPServerRequest removeRequest(long timeout) throws IOException {
            if (!this.m_open) {
                throw new IOException("closed");
            }
            if (this.m_queue.isEmpty()) {
                if (!this.m_isBlocking) {
                    this.m_wakeupPipe.clearWakeup();
                    return null;
                }
                if (timeout >= 0L) {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (!this.m_open && this.m_queue.isEmpty()) {
                    throw new IOException("closed");
                }
            }
            if (this.m_queue.isEmpty()) {
                return null;
            }
            return (IHTTPServerRequest)this.m_queue.removeFirst();
        }

        final synchronized void addUnackedResponse(int seqNo, IHTTPResponse response) {
            this.m_unackedQueue.put(new Integer(seqNo), response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final WriteHolder getFreedData(long timeout) throws IOException {
            WriteHolder freed = null;
            RequestQueue requestQueue = this;
            synchronized (requestQueue) {
                if (this.m_isBlocking) {
                    while (this.m_ackedData.isEmpty() && timeout >= 0L) {
                        if (!this.m_open) {
                            throw new IOException("closed");
                        }
                        this.m_notify = true;
                        long start = System.currentTimeMillis();
                        try {
                            this.wait(timeout);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                        finally {
                            this.m_notify = false;
                        }
                        if ((timeout -= System.currentTimeMillis() - start) > 0L) continue;
                        break;
                    }
                } else if (this.m_queue.isEmpty()) {
                    this.m_wakeupPipe.clearWakeup();
                }
                if (!this.m_ackedData.isEmpty()) {
                    freed = this.m_ackedData.m_head;
                    this.m_ackedData.m_head = null;
                    this.m_ackedData.m_tail = null;
                }
            }
            return freed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean processRequestRetry(int reqSeqNo, IHTTPServerResponse response) {
            IHTTPServerResponse oldResp = null;
            RequestQueue requestQueue = this;
            synchronized (requestQueue) {
                oldResp = (IHTTPServerResponse)this.m_unackedQueue.get(new Integer(reqSeqNo + 1));
            }
            if (oldResp != null) {
                ByteBuffer[] data = oldResp.getResetBodyCopy();
                response.setBody(data);
                response.setStatusCode(oldResp.getStatusCode());
                response.setReasonPhrase(oldResp.getReasonPhrase());
                response.setHeader("SequenceNumber", "" + (reqSeqNo + 1));
                if (DEBUG || DEBUG_UNEXPECTED || DEBUG_PERFORMANCE) {
                    EvsHTTPServerNetworkLink.this.debug("DUPLICATE request, retransmitting response " + response);
                }
                response.setHandled();
                return true;
            }
            return false;
        }

        private final boolean processAck(int seqNo) {
            if (this.m_unackedQueue.isEmpty()) {
                return false;
            }
            boolean ret = false;
            if (EvsHTTPServerNetworkLink.this.PEER_TUNNELING_VERSION < 1) {
                if (seqNo >= (Integer)this.m_unackedQueue.firstKey()) {
                    for (IHTTPServerResponse resp : this.m_unackedQueue.values()) {
                        if (DEBUG) {
                            EvsHTTPServerNetworkLink.this.debug("Processing ack for: " + EvsHTTPNetworkLink.debugHTTPMsg((IHTTPResponse)resp));
                        }
                        if (resp.getAttachment() == null) continue;
                        this.m_ackedData.add((WriteHolder)resp.getAttachment());
                        ret = true;
                    }
                    this.m_unackedQueue.clear();
                }
            } else {
                while (!this.m_unackedQueue.isEmpty() && seqNo >= (Integer)this.m_unackedQueue.firstKey()) {
                    IHTTPServerResponse resp = (IHTTPServerResponse)this.m_unackedQueue.remove(this.m_unackedQueue.firstKey());
                    if (DEBUG) {
                        EvsHTTPServerNetworkLink.this.debug("Processing ack for: " + EvsHTTPNetworkLink.debugHTTPMsg((IHTTPResponse)resp));
                    }
                    if (resp.getAttachment() == null) continue;
                    this.m_ackedData.add((WriteHolder)resp.getAttachment());
                    ret = true;
                }
            }
            return ret;
        }

        final synchronized void close() {
            if (this.m_open) {
                if (DEBUG_LIFECYCLE) {
                    EvsHTTPServerNetworkLink.this.debug("Closing request queue pipe: " + this.m_wakeupPipe);
                }
                if (!this.m_isBlocking) {
                    try {
                        this.m_wakeupPipe.close();
                    }
                    catch (IOException ioe) {
                        if (DEBUG_LIFECYCLE) {
                            EvsHTTPServerNetworkLink.this.debug("Error draining wakeup pipe", ioe);
                        }
                    }
                } else {
                    this.notifyAll();
                }
                this.m_open = false;
                while (!this.m_queue.isEmpty()) {
                    IHTTPRequest request = (IHTTPRequest)this.m_queue.removeFirst();
                    request.setHandled();
                    IHTTPResponse response = request.getResponse();
                    response.setStatusCode((short)400);
                    response.setReasonPhrase("Bad Request -- closed");
                    response.setHeader("SonicConnection", "closed");
                    response.setHandled();
                }
            }
        }

        SelectableChannel getChannel() {
            if (this.m_isBlocking) {
                return null;
            }
            return this.m_wakeupPipe.getWakeupChannel();
        }

        public final String toString() {
            return "Request Queue [" + this.m_wakeupPipe + " open: " + this.m_open + " size: " + this.m_queue.size() + "]";
        }
    }

    final class WriteHolderQueue {
        WriteHolder m_head;
        WriteHolder m_tail;

        WriteHolderQueue() {
        }

        final void add(WriteHolder holder) {
            if (this.m_head == null) {
                this.m_head = this.m_tail = holder;
            } else {
                this.m_tail.next = holder;
                this.m_tail = holder;
            }
            while (this.m_tail.next != null) {
                this.m_tail = this.m_tail.next;
            }
        }

        final WriteHolder remove() {
            if (this.m_head == null) {
                return null;
            }
            WriteHolder ret = this.m_head;
            if (this.m_head.next == null) {
                this.m_tail = null;
                this.m_head = null;
                return ret;
            }
            this.m_head = this.m_head.next;
            ret.next = null;
            return ret;
        }

        final boolean isEmpty() {
            return this.m_head == null;
        }
    }

    final class WriteHolder {
        final ByteBuffer data;
        WriteHolder next;
        final IEvsAsyncWriteListener listener;
        final ByteBuffer freeBuffer;
        boolean reqEnd = false;
        final int m_id;

        WriteHolder(ByteBuffer data, IEvsAsyncWriteListener listener, ByteBuffer freeBuffer) {
            this.data = data;
            this.listener = listener;
            this.freeBuffer = freeBuffer;
            this.m_id = EvsHTTPServerNetworkLink.this.m_writeContext.m_writeCount++;
        }
    }

    private final class WriteContext {
        private static final int STATE_REQUEST_WAIT = 1;
        private static final int STATE_HANDLE_REQUEST = 2;
        private static final int STATE_CLOSED = 3;
        private int m_state = 1;
        private final RequestQueue m_requestQueue;
        private final WriteHolderQueue m_dataQueue;
        private IHTTPServerRequest m_request = null;
        private IHTTPServerResponse m_response = null;
        private int m_seqNo = 1;
        private EvsNetworkLinkResult m_lastResult = null;
        private IHTTPRequest m_lastRequest = null;
        private int m_dataResponsesOutstanding = 0;
        private final boolean m_isBlocking;
        private int m_writeCount;
        private boolean m_pipelineTested = false;
        private boolean m_pipelineTest = false;
        private long m_pipelineTestStart = -1L;
        private boolean m_pipelineCapable = false;

        private WriteContext() throws IOException {
            this.m_isBlocking = EvsHTTPServerNetworkLink.this.m_config.getBlockingIO();
            this.m_requestQueue = new RequestQueue(true);
            this.m_dataQueue = new WriteHolderQueue();
            if (!EvsHTTPServerNetworkLink.this.PIPELINE_ENABLED) {
                this.m_pipelineTested = true;
                this.m_pipelineCapable = false;
                if (DEBUG_PERFORMANCE) {
                    EvsHTTPServerNetworkLink.this.debug("HTTP Pipelining disabled by connect protocol negotiation");
                }
            }
        }

        final void closeRequestQueue() {
            this.m_requestQueue.close();
        }

        final void close() {
            this.m_requestQueue.close();
            this.m_state = 3;
            IHTTPServerRequest request = this.m_request;
            if (request != null) {
                IHTTPServerResponse abort = request.buildNewResponse();
                abort.setStatusCode((short)400);
                abort.setReasonPhrase("Bad Request -- closed");
                abort.setHeader("SonicConnection", "closed");
                abort.setHandled();
                request.abortRequest(abort);
            }
        }

        final void addGetDataRequest(IHTTPServerRequest request) throws IOException {
            if (DEBUG_UNEXPECTED) {
                request.getResponse().addHeader("ConnectionId", EvsHTTPServerNetworkLink.this.m_idString);
            }
            this.m_requestQueue.addRequest(request);
        }

        final void addWriteData(ByteBuffer data, IEvsAsyncWriteListener listener) {
            if (data.remaining() > EvsHTTPServerNetworkLink.this.MAX_REQUEST_SIZE) {
                ByteBuffer dup = data.duplicate();
                dup.position(0);
                dup.limit(data.position() + EvsHTTPServerNetworkLink.this.MAX_REQUEST_SIZE);
                int limit = data.limit();
                ByteBuffer segment = dup.slice();
                segment.position(data.position());
                this.m_dataQueue.add(new WriteHolder(segment, listener, null));
                dup.position(dup.limit());
                dup.limit(limit);
                while (dup.remaining() > EvsHTTPServerNetworkLink.this.MAX_REQUEST_SIZE) {
                    dup.limit(dup.position() + EvsHTTPServerNetworkLink.this.MAX_REQUEST_SIZE);
                    this.m_dataQueue.add(new WriteHolder(dup.slice(), listener, null));
                    dup.position(dup.limit());
                    dup.limit(limit);
                }
                this.m_dataQueue.add(new WriteHolder(dup.slice(), listener, data));
            } else {
                this.m_dataQueue.add(new WriteHolder(data, listener, data));
            }
        }

        final boolean processWriteState(EvsNetworkLinkResult result) throws EEvsIOException {
            result.maxMsBeforeRetry = EvsHTTPServerNetworkLink.this.KEEPALIVE_INTERVAL;
            block7: while (true) {
                if (DEBUG) {
                    this.m_lastResult = result;
                }
                switch (this.m_state) {
                    case 1: {
                        this.m_request = null;
                        this.m_response = null;
                        try {
                            this.m_request = this.m_requestQueue.removeRequest(this.writeComplete(result.freeBuf) ? -1L : 0L);
                        }
                        catch (IOException ioe) {
                            if (DEBUG || DEBUG_LIFECYCLE) {
                                EvsHTTPServerNetworkLink.this.debug("Unable to get next read request assuming link is closing");
                                ioe.printStackTrace();
                            }
                            throw new EEvsIOException(prAccessor.getString("HTTP Connection closed, no more requests"), (Exception)ioe);
                        }
                        if (this.m_request == null) {
                            if (DEBUG) {
                                EvsHTTPServerNetworkLink.this.debug("No read request currently available for write operation, blocking on RequestQueue");
                            }
                            if (this.m_dataQueue.isEmpty()) {
                                result.blockingOps = 0;
                                return true;
                            }
                            if (this.m_isBlocking) {
                                throw new EEvsIOException(prAccessor.getString("HTTP Connection closed, no more requests"));
                            }
                            result.blockingOps = 1;
                            result.channel = this.m_requestQueue.getChannel();
                            return false;
                        }
                        result.blockingOps = 0;
                        if (DEBUG1) {
                            this.m_lastRequest = this.m_request;
                            EvsHTTPServerNetworkLink.this.debug("Got new client get data request for write op: " + this.m_request);
                        }
                        this.m_response = this.m_request.getHTTPServerResponse();
                        int seqNo = this.m_request.getHeaderAsInt("SequenceNumber");
                        if (seqNo < this.m_seqNo) {
                            if (this.m_requestQueue.processRequestRetry(seqNo, this.m_response)) continue block7;
                            if (DEBUG || DEBUG_UNEXPECTED || DEBUG_PERFORMANCE) {
                                EvsHTTPServerNetworkLink.this.debug("DUPLICATE request and no longer have the data, sending 404! " + this.m_request);
                            }
                            this.m_response.setStatusCode((short)404);
                            this.m_response.setReasonPhrase("Not Found -- data discarded");
                            this.m_response.setHandled();
                            continue block7;
                        }
                        if (seqNo > this.m_seqNo) {
                            if (DEBUG || DEBUG_UNEXPECTED || DEBUG_PERFORMANCE) {
                                EvsHTTPServerNetworkLink.this.debug("Skipped request, expected: " + this.m_seqNo + " sending 400 for: " + this.m_request);
                            }
                            this.m_response.setStatusCode((short)400);
                            this.m_response.setReasonPhrase("Bad Request -- out of sequence");
                            this.m_response.setHandled();
                            continue block7;
                        }
                        this.m_state = 2;
                    }
                    case 2: {
                        WriteHolder head;
                        String pipeline;
                        if (this.m_pipelineTest) {
                            String pipeline2;
                            if (!this.m_pipelineTested) {
                                long remaining = (long)EvsHTTPNetworkLink.HTTP_PIPELINE_DETECT_TIMEOUT - (System.currentTimeMillis() - this.m_pipelineTestStart);
                                if (DEBUG) {
                                    EvsHTTPServerNetworkLink.this.debug("Beginning pipeline test with " + this.m_dataResponsesOutstanding + " outstanding and " + remaining + "ms left");
                                }
                                while (this.m_dataResponsesOutstanding > 0) {
                                    if (remaining <= 0L) {
                                        remaining = -1L;
                                    }
                                    this.processFreedData(remaining);
                                    if (remaining < 0L) break;
                                    remaining = (long)EvsHTTPNetworkLink.HTTP_PIPELINE_DETECT_TIMEOUT - (System.currentTimeMillis() - this.m_pipelineTestStart);
                                }
                                if (this.m_dataResponsesOutstanding == 0) {
                                    if (DEBUG_PERFORMANCE) {
                                        EvsHTTPServerNetworkLink.this.debug("PASSED pipeline test after: " + (System.currentTimeMillis() - this.m_pipelineTestStart) + "ms");
                                    }
                                    this.m_response.setHeader("SonicPipelineTest", "true");
                                    this.m_pipelineCapable = true;
                                    this.m_pipelineTest = false;
                                } else {
                                    EvsHTTPServerNetworkLink.this.debug("WARNING: Unable to verify http pipeline capability after " + (System.currentTimeMillis() - this.m_pipelineTestStart) + "ms");
                                    this.m_response.setHeader("SonicPipelineTest", "false");
                                    this.m_pipelineCapable = false;
                                }
                                this.m_pipelineTested = true;
                            }
                            if ((pipeline2 = this.m_request.getHeaderValue("SonicPipelineTest")) == null) {
                                this.m_pipelineTest = false;
                            }
                        }
                        if (this.m_dataQueue.isEmpty()) {
                            long elapsed = System.currentTimeMillis() - this.m_request.getTimeReceived();
                            if (elapsed >= EvsHTTPServerNetworkLink.this.READ_TIMEOUT || this.m_pipelineTest) {
                                if (DEBUG) {
                                    EvsHTTPServerNetworkLink.this.debug("Sending 204 response after: " + elapsed + " for " + this.m_request);
                                }
                                this.m_response.setStatusCode((short)204);
                                this.m_response.setReasonPhrase("No Content");
                                this.m_response.setHeader("SequenceNumber", "" + ++this.m_seqNo);
                                this.m_requestQueue.addUnackedResponse(this.m_seqNo, (IHTTPResponse)this.m_response);
                                this.m_response.setHandled();
                                this.m_state = 1;
                                continue block7;
                            }
                            if (this.m_dataResponsesOutstanding > 0 && result.freeBuf) {
                                if (!this.processFreedData(EvsHTTPServerNetworkLink.this.READ_TIMEOUT - elapsed)) continue block7;
                                return this.writeComplete(false);
                            }
                            if (this.m_dataResponsesOutstanding > 0) {
                                this.processFreedData(-1L);
                            }
                            if (DEBUG) {
                                EvsHTTPServerNetworkLink.this.debug("No data available but haven't reached READ_TIMEOUT: " + elapsed + " of " + EvsHTTPServerNetworkLink.this.READ_TIMEOUT);
                            }
                            result.maxMsBeforeRetry = EvsHTTPServerNetworkLink.this.READ_TIMEOUT - elapsed;
                            return this.writeComplete(false);
                        }
                        if (!this.m_pipelineTested && !this.m_pipelineTest && (pipeline = this.m_request.getHeaderValue("SonicPipelineTest")) != null) {
                            if (this.m_request.getHTTPMinorVersion() == 0) {
                                this.m_response.setHeader("SonicPipelineTest", "false");
                                EvsHTTPServerNetworkLink.this.debug("HTTP 1.0 proxy detected failed pipeline test");
                                this.m_pipelineTested = true;
                            }
                            this.m_pipelineTest = true;
                            this.m_pipelineTestStart = System.currentTimeMillis();
                        }
                        WriteHolder tail = head = this.m_dataQueue.remove();
                        int count = 1;
                        int size = EvsHTTPServerNetworkLink.this.MAX_REQUEST_SIZE - head.data.remaining();
                        while (!this.m_dataQueue.isEmpty() && this.m_dataQueue.m_head.data.remaining() < size) {
                            tail.next = this.m_dataQueue.remove();
                            size -= tail.data.remaining();
                            ++count;
                        }
                        tail.reqEnd = true;
                        if (count > 1) {
                            ByteBuffer[] body = new ByteBuffer[count];
                            WriteHolder wh = head;
                            for (int i = 0; i < count; ++i) {
                                body[i] = wh.data;
                            }
                        } else {
                            this.m_response.setBody(head.data);
                        }
                        this.m_response.setBody(head.data);
                        this.m_response.setHeader("SequenceNumber", "" + ++this.m_seqNo);
                        this.m_response.setStatusCode((short)200);
                        this.m_response.setReasonPhrase("OK");
                        this.m_response.setAttachment((Object)head);
                        ++this.m_dataResponsesOutstanding;
                        this.m_requestQueue.addUnackedResponse(this.m_seqNo, (IHTTPResponse)this.m_response);
                        if (DEBUG) {
                            EvsHTTPServerNetworkLink.this.debug("Wrote get data response: " + this.m_response);
                        }
                        this.m_response.setHandled();
                        this.m_state = 1;
                        continue block7;
                    }
                    case 3: {
                        if (this.m_request != null && !this.m_request.isHandled()) {
                            this.m_request.setHandled();
                            this.m_request = null;
                        }
                        if (this.m_response != null && !this.m_response.isHandled()) {
                            this.m_response.setHandled();
                            this.m_request = null;
                        }
                        throw new EEvsIOException(prAccessor.getString("HTTP Connection closed, no more requests"));
                    }
                }
                break;
            }
            throw new IllegalStateException(prMessageFormat.format(prAccessor.getString("Unhandled state in HTTP server link write: {0}"), new Object[]{"" + this.m_state}));
        }

        private final boolean writeComplete(boolean freeBuf) {
            return this.m_dataQueue.isEmpty() && !this.m_pipelineTest && (this.m_dataResponsesOutstanding == 0 || !freeBuf);
        }

        private final boolean processFreedData(long timeout) throws EEvsIOException {
            try {
                WriteHolder freed = this.m_requestQueue.getFreedData(timeout);
                if (freed != null) {
                    while (freed != null) {
                        if (freed.data != null) {
                            freed.listener.onAsyncWriteComplete(freed.freeBuffer);
                        }
                        if (freed.reqEnd) {
                            --this.m_dataResponsesOutstanding;
                        }
                        freed = freed.next;
                    }
                    return true;
                }
                return false;
            }
            catch (IOException ioe) {
                throw new EEvsIOException(prAccessor.getString("HTTP Connection closed, no more requests"), (Exception)ioe);
            }
        }

        public final String toString() {
            return "WriteContext [Request: " + EvsHTTPNetworkLink.debugHTTPMsg((IHTTPRequest)this.m_request) + ", Last Request: " + EvsHTTPNetworkLink.debugHTTPMsg(this.m_lastRequest) + ", State: " + this.m_state + ", last result: " + this.m_lastResult + ", Request Queue: " + this.m_requestQueue + "]";
        }
    }

    private final class ReadContext {
        private static final int STATE_NEW_READ = 0;
        private static final int STATE_DRAIN_EXCESS_BUFFER = 1;
        private static final int STATE_REQUEST_WAIT = 2;
        private static final int STATE_REQUEST_READ = 3;
        private static final int STATE_FILL_EXCESS_BUFFER = 4;
        private static final int STATE_REQUEST_DONE = 5;
        private static final int STATE_OUT_OF_SEQUENCE_WRITE = 6;
        private static final int STATE_CLOSED = 7;
        private int m_state = 0;
        private int m_bytesRead = 0;
        private int m_readBufferRewindPos;
        private int m_readSeqNo = 0;
        private boolean m_continuedRead = false;
        private final RequestQueue m_writeRequestQueue;
        private IHTTPServerRequest m_request = null;
        private IHTTPServerResponse m_response = null;
        private EvsNetworkLinkResult m_lastResult;
        private ByteBuffer m_excessBuffer;
        private int m_excessBytesAlreadyRead;
        private long m_idleSince = 0L;
        private final boolean m_isBlocking;
        private final EvsNetworkLinkResult m_blockingResult;

        ReadContext() throws IOException {
            this.m_isBlocking = EvsHTTPServerNetworkLink.this.m_config.getBlockingIO();
            this.m_blockingResult = this.m_isBlocking ? new EvsNetworkLinkResult() : null;
            this.m_writeRequestQueue = new RequestQueue(true);
        }

        final void addWriteDataRequest(IHTTPServerRequest request) throws IOException {
            if (DEBUG_UNEXPECTED) {
                request.getResponse().addHeader("ConnectionId", EvsHTTPServerNetworkLink.this.m_idString);
            }
            this.m_writeRequestQueue.addRequest(request);
        }

        final void closeRequestQueue() {
            this.m_writeRequestQueue.close();
            IHTTPServerRequest request = this.m_request;
            if (request != null) {
                request.wakeupReadWait();
            }
        }

        final void close() {
            this.closeRequestQueue();
            this.m_state = 7;
            IHTTPServerRequest request = this.m_request;
            if (request != null) {
                IHTTPServerResponse abort = request.buildNewResponse();
                abort.setStatusCode((short)400);
                abort.setReasonPhrase("Bad Request -- closed");
                abort.setHeader("SonicConnection", "closed");
                abort.setHandled();
                request.abortRequest(abort);
            }
        }

        private final int processReadState(ByteBuffer buffer, EvsNetworkLinkResult result) {
            if (this.m_isBlocking) {
                result = this.m_blockingResult;
            }
            result.maxMsBeforeRetry = EvsHTTPServerNetworkLink.this.IDLE_TIMEOUT;
            block24: while (true) {
                if (DEBUG) {
                    this.m_lastResult = result;
                }
                switch (this.m_state) {
                    case 0: {
                        if (!buffer.hasRemaining()) {
                            throw new IllegalStateException("Buffer Underflow");
                        }
                        if (DEBUG) {
                            EvsHTTPServerNetworkLink.this.debug("STATE_NEW_READ: with: " + buffer.remaining());
                        }
                        this.m_bytesRead = 0;
                        this.m_continuedRead = false;
                        this.m_state = 1;
                    }
                    case 1: {
                        if (this.m_excessBuffer != null) {
                            if (this.m_excessBuffer.remaining() > buffer.remaining()) {
                                int limit = this.m_excessBuffer.limit();
                                this.m_excessBuffer.limit(this.m_excessBuffer.position() + buffer.remaining());
                                this.m_bytesRead = buffer.remaining();
                                if (DEBUG_PERFORMANCE) {
                                    EvsHTTPServerNetworkLink.this.debug("Draining " + this.m_bytesRead + " from excess buffer");
                                }
                                buffer.put(this.m_excessBuffer);
                                this.m_excessBuffer.limit(limit);
                            } else {
                                this.m_bytesRead = this.m_excessBuffer.remaining();
                                if (DEBUG_PERFORMANCE) {
                                    EvsHTTPServerNetworkLink.this.debug("Completely Draining excess buffer: " + this.m_bytesRead);
                                }
                                buffer.put(this.m_excessBuffer);
                                this.m_excessBuffer = null;
                            }
                            this.m_state = 0;
                            return this.m_bytesRead;
                        }
                        this.m_state = 2;
                    }
                    case 2: {
                        if (DEBUG) {
                            EvsHTTPServerNetworkLink.this.debug("STATE_REQUEST_WAIT: with: " + buffer.remaining());
                        }
                        this.m_request = null;
                        try {
                            if (this.m_isBlocking) {
                                this.m_request = this.m_writeRequestQueue.removeRequest(EvsHTTPServerNetworkLink.this.IDLE_TIMEOUT);
                                if (this.m_request == null) {
                                    if (DEBUG || DEBUG_LIFECYCLE || DEBUG_UNEXPECTED) {
                                        EvsHTTPServerNetworkLink.this.debug("Idle timeout reached closing after no data read in " + EvsHTTPServerNetworkLink.this.IDLE_TIMEOUT + "ms");
                                    }
                                    return -1;
                                }
                            } else {
                                this.m_request = this.m_writeRequestQueue.removeRequest(0L);
                            }
                        }
                        catch (IOException ioe) {
                            if (DEBUG || DEBUG_LIFECYCLE) {
                                EvsHTTPServerNetworkLink.this.debug("Unable to get next request, request queue closed", ioe);
                            }
                            result.blockingOps = 0;
                            this.m_state = 0;
                            if (this.m_continuedRead) {
                                return this.m_bytesRead;
                            }
                            return -1;
                        }
                        if (this.m_request == null) {
                            if (this.m_continuedRead) {
                                if (DEBUG) {
                                    EvsHTTPServerNetworkLink.this.debug("In STATE_REQUEST_WAIT with " + this.m_bytesRead + " already read and no new request available so returning what we've got");
                                }
                                this.m_state = 0;
                                return this.m_bytesRead;
                            }
                            if (this.m_idleSince == 0L) {
                                this.m_idleSince = System.currentTimeMillis();
                            } else {
                                long idle = System.currentTimeMillis() - this.m_idleSince;
                                if (idle >= EvsHTTPServerNetworkLink.this.IDLE_TIMEOUT) {
                                    if (DEBUG || DEBUG_LIFECYCLE || DEBUG_UNEXPECTED) {
                                        EvsHTTPServerNetworkLink.this.debug("Idle timeout reached closing after no data read in " + EvsHTTPServerNetworkLink.this.IDLE_TIMEOUT + "ms");
                                    }
                                    result.channel = this.m_writeRequestQueue.getChannel();
                                    result.blockingOps |= 0;
                                    return -1;
                                }
                                result.maxMsBeforeRetry = EvsHTTPServerNetworkLink.this.IDLE_TIMEOUT - idle;
                            }
                            if (DEBUG) {
                                EvsHTTPServerNetworkLink.this.debug("STATE_REQUEST_WAIT: no write request currently available");
                            }
                            result.channel = this.m_writeRequestQueue.getChannel();
                            result.blockingOps |= 1;
                            return 0;
                        }
                        if (DEBUG1) {
                            EvsHTTPServerNetworkLink.this.debug("Got write request: " + this.m_request);
                        }
                        this.m_idleSince = 0L;
                        result.blockingOps = 0;
                        this.m_response = this.m_request.getHTTPServerResponse();
                        if (this.m_request.getAttachment() == KEEPALIVE_IDENTIFIER) {
                            if (DEBUG) {
                                EvsHTTPServerNetworkLink.this.debug("KEEP ALIVE Request received");
                            }
                            this.m_request.setHandled();
                            this.m_response.setStatusCode((short)200);
                            this.m_response.setReasonPhrase("OK");
                            this.m_response.setHandled();
                            continue block24;
                        }
                        int seqNo = this.m_request.getHeaderAsInt("SequenceNumber");
                        if (seqNo != this.m_readSeqNo) {
                            if (seqNo < this.m_readSeqNo) {
                                if (DEBUG_UNEXPECTED) {
                                    EvsHTTPServerNetworkLink.this.debug("Duplicate message detected got: " + seqNo + " expected: " + this.m_readSeqNo + " Skipping request");
                                }
                                this.m_request.setHandled();
                                this.m_response.setHeader("SequenceNumber", "" + seqNo);
                                this.m_response.setStatusCode((short)200);
                                this.m_response.setReasonPhrase("OK");
                                this.m_response.setHandled();
                                continue block24;
                            }
                            if (DEBUG || DEBUG_UNEXPECTED) {
                                EvsHTTPServerNetworkLink.this.debug("Out of sequence message detected got: " + seqNo + " expected: " + this.m_readSeqNo);
                            }
                            this.m_state = 6;
                            continue block24;
                        }
                        if (DEBUG) {
                            EvsHTTPServerNetworkLink.this.debug("GOT NEW WRITE REQUEST: " + this.m_request);
                        }
                        this.m_readBufferRewindPos = buffer.position();
                        this.m_state = 3;
                    }
                    case 3: {
                        if (!this.m_request.isFinished()) {
                            try {
                                int pos = buffer.position();
                                this.m_request.readBody(buffer, result);
                                this.m_bytesRead += buffer.position() - pos;
                            }
                            catch (EEvsIOException ex) {
                                if (DEBUG || DEBUG_UNEXPECTED) {
                                    EvsHTTPServerNetworkLink.this.debug("Got an I/O error reading write request: " + ex.getMessage(), ex);
                                }
                                this.m_request.setHandled();
                                this.m_response.setStatusCode((short)204);
                                this.m_response.setReasonPhrase("No Content - read error");
                                this.m_response.setHandled();
                                buffer.position(this.m_readBufferRewindPos);
                                this.m_state = 2;
                                continue block24;
                            }
                        }
                        if (this.m_request.isFinished()) {
                            this.m_state = 5;
                            continue block24;
                        }
                        if (buffer.hasRemaining()) {
                            if (DEBUG) {
                                EvsHTTPServerNetworkLink.this.debug("Unable to finish reading request " + this.m_request.getRemainingBody() + " left in request. Read So far" + this.m_bytesRead + " " + result);
                            }
                            if (this.m_isBlocking) {
                                try {
                                    try {
                                        this.m_request.waitForReadReady(result);
                                        result.blockingOps = 0;
                                        continue block24;
                                    }
                                    catch (InterruptedException ie) {
                                        IOException ioe = new IOException("Interrupted waiting for read data");
                                        ioe.initCause(ie);
                                        throw ioe;
                                    }
                                }
                                catch (IOException ioe) {
                                    if (DEBUG_UNEXPECTED) {
                                        EvsHTTPServerNetworkLink.this.debug("Error in internal select ... signaling close", ioe);
                                    }
                                    this.m_request.setHandled();
                                    this.m_response.setStatusCode((short)404);
                                    this.m_response.setReasonPhrase("404 - read select failure");
                                    this.m_response.setHeader("SonicConnection", "closed");
                                    this.m_response.setHandled();
                                    return -1;
                                }
                            }
                            return 0;
                        }
                        this.m_excessBytesAlreadyRead = buffer.position() - this.m_readBufferRewindPos;
                        this.m_excessBuffer = this.m_request.getContentLength() >= 0 ? ByteBuffer.allocate(this.m_request.getContentLength() - this.m_excessBytesAlreadyRead) : ByteBuffer.allocate(EvsHTTPServerNetworkLink.this.MAX_REQUEST_SIZE - this.m_excessBytesAlreadyRead);
                        if (DEBUG || DEBUG_PERFORMANCE) {
                            EvsHTTPServerNetworkLink.this.debug("Didn't finish processing client write request: " + this.m_bytesRead + " remaining: " + this.m_request.getRemainingBody() + " " + result);
                        }
                        this.m_state = 4;
                    }
                    case 4: {
                        if (!this.m_request.isFinished()) {
                            try {
                                this.m_request.readBody(this.m_excessBuffer, result);
                            }
                            catch (EEvsIOException ex) {
                                if (DEBUG || DEBUG_UNEXPECTED) {
                                    EvsHTTPServerNetworkLink.this.debug("Got an I/O error reading write request into EXCESS buffer: " + ex.getMessage(), ex);
                                }
                                this.m_request.setHandled();
                                this.m_response.setStatusCode((short)204);
                                this.m_response.setReasonPhrase("No Content");
                                this.m_response.setHandled();
                                this.m_excessBuffer = null;
                                buffer.position(this.m_readBufferRewindPos);
                                this.m_state = 2;
                                continue block24;
                            }
                        }
                        if (this.m_request.isFinished()) {
                            this.m_excessBuffer.flip();
                            this.m_state = 5;
                            continue block24;
                        }
                        if (this.m_excessBuffer.hasRemaining()) {
                            if (DEBUG) {
                                EvsHTTPServerNetworkLink.this.debug("Unable to finish reading request into EXCESS buffer " + this.m_request.getRemainingBody() + " left in response. Read So far" + this.m_bytesRead + " " + result);
                            }
                            if (this.m_isBlocking) {
                                try {
                                    try {
                                        this.m_request.waitForReadReady(result);
                                        result.blockingOps = 0;
                                        continue block24;
                                    }
                                    catch (InterruptedException ie) {
                                        IOException ioe = new IOException("Interrupted waiting for read data");
                                        ioe.initCause(ie);
                                        throw ioe;
                                    }
                                }
                                catch (IOException ioe) {
                                    if (DEBUG_UNEXPECTED) {
                                        EvsHTTPServerNetworkLink.this.debug("Error in internal select ... signaling close", ioe);
                                    }
                                    this.m_request.setHandled();
                                    this.m_response.setStatusCode((short)404);
                                    this.m_response.setReasonPhrase("404 - read select failure");
                                    this.m_response.setHeader("SonicConnection", "closed");
                                    this.m_response.setHandled();
                                    return -1;
                                }
                            }
                            return 0;
                        }
                        if (DEBUG_UNEXPECTED) {
                            EvsHTTPServerNetworkLink.this.debug("Maximum request size exceeded sending back 204: " + this.m_excessBuffer.capacity() + this.m_bytesRead + " bytes read, request: " + this.m_request);
                        }
                        buffer.position(this.m_readBufferRewindPos);
                        this.m_excessBuffer = null;
                        this.m_request.setHandled();
                        this.m_response.setHeader("SequenceNumber", "" + this.m_readSeqNo);
                        this.m_response.setStatusCode((short)204);
                        this.m_response.setReasonPhrase("No Content");
                        this.m_response.setHandled();
                        this.m_state = 2;
                        continue block24;
                    }
                    case 5: {
                        this.m_request.setHandled();
                        this.m_response.setHeader("SequenceNumber", "" + this.m_readSeqNo);
                        this.m_response.setStatusCode((short)200);
                        this.m_response.setReasonPhrase("OK");
                        ++this.m_readSeqNo;
                        this.m_response.setHandled();
                        if (!this.m_isBlocking) {
                            // empty if block
                        }
                        this.m_state = 0;
                        return this.m_bytesRead;
                    }
                    case 6: {
                        this.m_request.setHandled();
                        this.m_response.setHeader("SequenceNumber", "" + this.m_readSeqNo);
                        this.m_response.setStatusCode((short)400);
                        this.m_response.setReasonPhrase("Bad Request -- out of sequence");
                        this.m_response.setHandled();
                        this.m_state = 2;
                        continue block24;
                    }
                    case 7: {
                        if (this.m_request != null && !this.m_request.isHandled()) {
                            this.m_request.setHandled();
                            this.m_request = null;
                        }
                        if (this.m_response != null && !this.m_response.isHandled()) {
                            this.m_response.setHandled();
                            this.m_request = null;
                        }
                        if (this.m_bytesRead > 0) {
                            int ret = this.m_bytesRead;
                            this.m_bytesRead = 0;
                            return ret;
                        }
                        return -1;
                    }
                }
                break;
            }
            throw new IllegalStateException(prAccessor.getString("Illegal state in http server link request read"));
        }

        public final String toString() {
            return "Read Context[state " + this.m_state + " req: " + EvsHTTPNetworkLink.debugHTTPMsg((IHTTPRequest)this.m_request) + " bytesRead: " + this.m_bytesRead + " pos: " + this.m_readBufferRewindPos + " request queue: " + this.m_writeRequestQueue + "]";
        }
    }
}

