/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.evs.nio.nwlink.http.proxy;

import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.DelegatingNetworkLinkConfig;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLinkFactory;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLinkResult;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsAsyncWriteListener;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.INetworkLinkConfig;
import com.sonicsw.blackbird.evs.nio.nwlink.http.prAccessor;
import com.sonicsw.blackbird.http.IHTTPRequest;
import com.sonicsw.blackbird.http.IHTTPResponse;
import com.sonicsw.blackbird.http.client.HTTPClientFactory;
import com.sonicsw.blackbird.http.client.IHTTPClient;
import com.sonicsw.blackbird.http.client.IHTTPCredentialsProvider;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import progress.message.resources.prMessageFormat;

public final class EvsHTTPProxyNetworkLink
implements IEvsNetworkLink {
    private static final int STATE_INIT = 0;
    private static final int STATE_TUNNEL_CONNECT = 1;
    private static final int STATE_LINK_UPGRADE = 2;
    private static final int STATE_LINK_CONNECT = 3;
    private static final int STATE_CONNECTED = 4;
    private static final int STATE_CLOSE_WAIT = 5;
    private static final int STATE_CLOSED = 6;
    private int m_state = 0;
    private IEvsNetworkLink m_link = null;
    private final INetworkLinkConfig m_config;
    private INetworkLinkConfig m_proxyConfig = null;
    private IHTTPClient m_tunnelClient = null;
    private final URI m_originServerURI;

    private EvsHTTPProxyNetworkLink(int type, INetworkLinkConfig config) throws EEvsIOException {
        this.m_config = config;
        try {
            this.m_originServerURI = new URI(null, null, this.m_config.getRemoteInterfaceAddress(), this.m_config.getRemotePort(), null, null, null);
        }
        catch (URISyntaxException ex) {
            throw new EEvsIOException(ex.getMessage(), (Exception)ex);
        }
        this.m_proxyConfig = new HTTPProxyConfig(this.m_config);
    }

    public static final IEvsNetworkLink create(int type, INetworkLinkConfig config) throws EEvsIOException {
        return new EvsHTTPProxyNetworkLink(type, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean connect(EvsNetworkLinkResult result) throws EEvsIOException {
        block19: while (true) {
            switch (this.m_state) {
                case 0: {
                    EvsHTTPProxyNetworkLink evsHTTPProxyNetworkLink = this;
                    synchronized (evsHTTPProxyNetworkLink) {
                        if (this.m_state == 0) {
                            if (this.m_config.getHTTPProxyTunnel()) {
                                this.m_tunnelClient = HTTPClientFactory.createHTTPClient(this.m_proxyConfig);
                                IHTTPRequest request = this.m_tunnelClient.createRequest();
                                request.setMethod("CONNECT");
                                request.setRequestURI(this.m_originServerURI);
                                this.m_tunnelClient.addRequest(request);
                                this.setState(1);
                            } else {
                                this.m_link = EvsNetworkLinkFactory.create(this.m_proxyConfig.getLinkType(), 1, null, this.m_proxyConfig);
                                this.setState(3);
                            }
                        }
                        continue block19;
                    }
                }
                case 1: {
                    IHTTPResponse response = null;
                    try {
                        response = this.m_tunnelClient.getResponse(result);
                        if (response == null || !this.m_tunnelClient.skipResponseBody(result)) {
                            return false;
                        }
                    }
                    catch (IllegalStateException ex) {
                        this.setState(5);
                        throw new EEvsIOException(ex.getMessage(), (Exception)ex);
                    }
                    switch (response.getStatusCodeClass()) {
                        case 2: {
                            if (response.getStatusCode() != 200) {
                                throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Unexpected response to tunnel establishment request: {0} {1}"), new Object[]{"" + response.getStatusCode(), response.getReasonPhrase()}), null);
                            }
                            EvsHTTPProxyNetworkLink evsHTTPProxyNetworkLink = this;
                            synchronized (evsHTTPProxyNetworkLink) {
                                if (this.m_state != 1) {
                                    continue block19;
                                }
                                this.m_link = (IEvsNetworkLink)this.m_tunnelClient.getHTTPConnection().getTransport();
                            }
                            response.setHandled();
                            if (this.m_config.getHTTPProxyTunnel() && (this.m_config.getLinkType() == "https" || this.m_config.getLinkType() == "ssl")) {
                                this.setState(2);
                                continue block19;
                            }
                            this.setState(4);
                            continue block19;
                        }
                    }
                    this.setState(5);
                    throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Unexpected response to tunnel establishment request: {0} {1}"), new Object[]{"" + response.getStatusCode(), response.getReasonPhrase()}), null);
                }
                case 2: {
                    throw new UnsupportedOperationException("Tunnel upgrade not yet implemented");
                }
                case 3: {
                    if (!this.m_link.connect(result)) {
                        return false;
                    }
                    this.setState(4);
                    continue block19;
                }
                case 4: {
                    return true;
                }
                case 5: 
                case 6: {
                    throw new EEvsIOException(prAccessor.getString("Link has been closed."));
                }
            }
            break;
        }
        throw new IllegalStateException(prMessageFormat.format(prAccessor.getString("Illegal state in HTTP Proxy Tunnel establishment: {0}"), new Object[]{"" + this.m_state}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setState(int state) {
        EvsHTTPProxyNetworkLink evsHTTPProxyNetworkLink = this;
        synchronized (evsHTTPProxyNetworkLink) {
            switch (this.m_state) {
                case 5: {
                    if (state != 6) break;
                    this.m_state = 6;
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    this.m_state = state;
                }
            }
        }
    }

    @Override
    public INetworkLinkConfig getNetworkLinkConfig() {
        return this.m_config;
    }

    @Override
    public final boolean isBlocking() {
        return this.m_config.getBlockingIO();
    }

    @Override
    public void setSOTimeout(int timeout) throws EEvsIOException {
        if (this.m_link != null) {
            this.m_link.setSOTimeout(timeout);
        } else if (this.m_tunnelClient != null) {
            throw new EEvsIOException("not connected");
        }
    }

    @Override
    public int getSOTimeout() throws EEvsIOException {
        if (this.m_link != null) {
            return this.m_link.getSOTimeout();
        }
        throw new EEvsIOException("not connected");
    }

    @Override
    public IEvsNetworkLink accept(EvsNetworkLinkResult result) throws EEvsIOException {
        throw new EEvsIOException(prAccessor.getString("Accept not supported for client link"), null);
    }

    @Override
    public int read(ByteBuffer buffer, EvsNetworkLinkResult result) throws EEvsIOException {
        if (this.m_state < 4) {
            throw new EEvsIOException(prAccessor.getString("read"), null);
        }
        return this.m_link.read(buffer, result);
    }

    @Override
    public void addWrite(ByteBuffer buffer, IEvsAsyncWriteListener listener) throws EEvsIOException {
        if (this.m_state < 4) {
            throw new EEvsIOException(prAccessor.getString("write"), null);
        }
        this.m_link.addWrite(buffer, listener);
    }

    @Override
    public boolean write(EvsNetworkLinkResult result) throws EEvsIOException {
        if (this.m_state < 4) {
            throw new EEvsIOException(prAccessor.getString("write"), null);
        }
        return this.m_link.write(result);
    }

    @Override
    public boolean close(EvsNetworkLinkResult result, boolean immediate) throws EEvsIOException {
        if (this.m_state == 6) {
            return true;
        }
        this.setState(5);
        if (this.m_tunnelClient != null) {
            this.m_tunnelClient.close(result);
        }
        if (this.m_link != null) {
            if (this.m_link.close(result, immediate)) {
                this.setState(6);
                return true;
            }
            return false;
        }
        this.setState(6);
        return true;
    }

    @Override
    public final int getRemotePort() {
        if (this.m_link == null) {
            return -1;
        }
        return this.m_link.getRemotePort();
    }

    @Override
    public final InetAddress getRemoteInetAddress() {
        if (this.m_link == null) {
            return null;
        }
        return this.m_link.getRemoteInetAddress();
    }

    @Override
    public int getLocalPort() {
        if (this.m_link != null) {
            return this.m_link.getLocalPort();
        }
        return -1;
    }

    @Override
    public InetAddress getLocalInetAddress() {
        if (this.m_link != null) {
            return this.m_link.getLocalInetAddress();
        }
        return null;
    }

    @Override
    public final SelectableChannel getChannel() {
        return this.m_link.getChannel();
    }

    @Override
    public final SelectableChannel getServerChannel() {
        return this.m_link.getServerChannel();
    }

    @Override
    public int getRequestedHeaderReserve() {
        return this.m_link.getRequestedHeaderReserve();
    }

    @Override
    public int getRequestedTrailerReserve() {
        return this.m_link.getRequestedTrailerReserve();
    }

    @Override
    public long getKeepAlive() {
        if (this.m_link != null) {
            return this.m_link.getKeepAlive();
        }
        return 0L;
    }

    private final class HTTPProxyConfig
    extends DelegatingNetworkLinkConfig {
        private final String LINK_TYPE;

        public HTTPProxyConfig(INetworkLinkConfig config) {
            super(config);
            this.LINK_TYPE = EvsHTTPProxyNetworkLink.this.m_config.getHTTPProxyTunnel() ? "tcp" : (EvsHTTPProxyNetworkLink.this.m_config.getHTTPProxyProtocol().trim().equalsIgnoreCase("http") ? "tcp" : (EvsHTTPProxyNetworkLink.this.m_config.getHTTPProxyProtocol().trim().equalsIgnoreCase("https") ? "ssl" : EvsHTTPProxyNetworkLink.this.m_config.getHTTPProxyProtocol()));
        }

        @Override
        public final String getLinkType() {
            return this.LINK_TYPE;
        }

        @Override
        public final String getRemoteInterfaceAddress() {
            return EvsHTTPProxyNetworkLink.this.m_config.getHTTPProxyHost();
        }

        @Override
        public final int getRemotePort() {
            return EvsHTTPProxyNetworkLink.this.m_config.getHTTPProxyPort();
        }

        @Override
        public IHTTPCredentialsProvider getHTTPCredentialsProvider() {
            return EvsHTTPProxyNetworkLink.this.m_config.getHTTPProxyCredentialsProvider();
        }

        @Override
        public final boolean getHTTPProxyEnabled() {
            return false;
        }

        @Override
        public final boolean getHTTPProxyTunnel() {
            return false;
        }
    }
}

