/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.http.impl;

import com.sonicsw.blackbird.evs.EEvsEOFException;
import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLinkResult;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsAsyncWriteListener;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsNetworkLink;
import com.sonicsw.blackbird.http.IHTTPConnection;
import com.sonicsw.blackbird.http.impl.HTTPConstants;
import com.sonicsw.blackbird.http.impl.HTTPParseUtil;
import com.sonicsw.blackbird.http.impl.prAccessor;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;

public final class HTTPConnection
implements IHTTPConnection {
    private final boolean DEBUG = HTTPConstants.DEBUG;
    private final boolean USE_DIRECT_BUFFERS = true;
    private final int INITIAL_HTTP_RESERVE_SPACE = 512;
    private final int INPUT_BUFFER_GROWTH_INCREMENT = 64;
    private ByteBuffer m_outputBuffer = ByteBuffer.allocateDirect(512);
    private int m_requestedReserve = -1;
    private ByteBuffer m_inBuf = ByteBuffer.allocate(256);
    private IEvsNetworkLink m_link = null;
    private static final int STATE_CLOSED = -1;
    private static final int STATE_UNCONNECTED = 1;
    private static final int STATE_CONNECTED = 2;
    private int m_state = 1;

    public HTTPConnection() {
        this.reset();
    }

    public final void reset() {
        this.m_state = 1;
        this.m_outputBuffer.clear();
        this.m_inBuf.clear();
        this.m_inBuf.limit(0);
    }

    public final void setNetworkLink(IEvsNetworkLink link) {
        this.m_link = link;
    }

    @Override
    public final Object getTransport() {
        return this.getNetworkLink();
    }

    public final IEvsNetworkLink getNetworkLink() {
        return this.m_link;
    }

    public final SelectableChannel getChannel() {
        if (this.m_link != null) {
            return this.m_link.getChannel();
        }
        return null;
    }

    @Override
    public final int getRemotePort() {
        if (this.m_link != null) {
            return this.m_link.getRemotePort();
        }
        return -1;
    }

    @Override
    public final InetAddress getRemoteInetAddress() {
        if (this.m_link != null) {
            return this.m_link.getRemoteInetAddress();
        }
        return null;
    }

    @Override
    public int getLocalPort() {
        if (this.m_link != null) {
            return this.m_link.getLocalPort();
        }
        return -1;
    }

    @Override
    public InetAddress getLocalInetAddress() {
        if (this.m_link != null) {
            return this.m_link.getLocalInetAddress();
        }
        return null;
    }

    public final boolean connect(EvsNetworkLinkResult result) throws EEvsIOException {
        switch (this.m_state) {
            case 1: {
                if (!this.m_link.connect(result) && this.DEBUG) {
                    this.debug("HTTPConnection connect didn't succeed: " + result);
                }
                this.m_state = 2;
                return true;
            }
            case 2: {
                return true;
            }
            case -1: {
                throw new EEvsIOException(prAccessor.getString("HTTP Connection Closed!"), null);
            }
        }
        throw new IllegalStateException(prAccessor.getString("Illegal connect state for HTTPConnection"));
    }

    public final boolean close(EvsNetworkLinkResult result) throws EEvsIOException {
        switch (this.m_state) {
            case -1: {
                return true;
            }
        }
        try {
            if (this.m_link != null) {
                if (this.m_link.close(result, true)) {
                    this.m_state = -1;
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (EEvsIOException ex) {
            this.m_state = -1;
            throw ex;
        }
    }

    final void addData(ByteBuffer data, IEvsAsyncWriteListener listener) throws EEvsIOException {
        if (this.m_outputBuffer.position() > 0) {
            if (this.m_outputBuffer.position() > this.m_requestedReserve) {
                this.m_requestedReserve = this.m_outputBuffer.position();
                if (this.DEBUG) {
                    this.debug("Increasing requested reserve space: " + this.m_requestedReserve);
                }
            }
            if (this.m_outputBuffer.position() < data.position()) {
                this.m_outputBuffer.flip();
                int newPos = data.position() - this.m_outputBuffer.remaining();
                data.position(newPos);
                data.put(this.m_outputBuffer);
                data.position(newPos);
                this.m_outputBuffer.clear();
            } else {
                this.commitBufferedData(null);
            }
        }
        this.m_link.addWrite(data, listener);
    }

    public final boolean write(EvsNetworkLinkResult result) throws EEvsIOException {
        this.commitBufferedData(null);
        return this.m_link.write(result);
    }

    final String readLine(int maxLength, EvsNetworkLinkResult result) throws EEvsIOException {
        boolean cr = false;
        byte[] array = this.m_inBuf.array();
        int pos = this.m_inBuf.position();
        int remaining = this.m_inBuf.remaining();
        for (int length = 0; length < maxLength; ++length) {
            byte c;
            if (length >= remaining) {
                this.fillInputBuffer(result);
                remaining = this.m_inBuf.remaining();
                if (length >= remaining) {
                    return null;
                }
                array = this.m_inBuf.array();
                pos = this.m_inBuf.position();
            }
            if ((c = array[length + pos]) == -1) {
                throw new EEvsIOException(prAccessor.getString("EOF reading HTTP Message!"), null);
            }
            if (cr && c == 10) {
                char[] line = new char[length - 2];
                for (int i = 0; i < line.length; ++i) {
                    line[i] = HTTPParseUtil.decodeASCII(0xFF & array[i + pos]);
                }
                this.m_inBuf.position(pos + length);
                return new String(line);
            }
            if (c == 13) {
                cr = true;
                continue;
            }
            cr = false;
        }
        throw new EEvsIOException(prAccessor.getString("Error reading http line, maximum length reached!"), null);
    }

    public final boolean hasReadDataBuffered() {
        return this.m_inBuf.hasRemaining();
    }

    private final void fillInputBuffer(EvsNetworkLinkResult result) throws EEvsIOException, EEvsEOFException {
        int pos = this.m_inBuf.position();
        if (this.m_inBuf.limit() == this.m_inBuf.capacity()) {
            if (pos == 0 || this.m_inBuf.capacity() < HTTPConstants.MAX_HTTP_HEADER_BUFFER_SIZE) {
                ByteBuffer newBuf = ByteBuffer.allocate(this.m_inBuf.capacity() + 64);
                if (this.DEBUG) {
                    this.debug("Input Buffer size increased to: " + this.m_inBuf.capacity());
                }
                newBuf.put(this.m_inBuf);
                this.m_inBuf = newBuf;
                pos = 0;
            } else {
                if (HTTPConstants.DEBUG_PERFORMANCE) {
                    this.debug("Compacted inBuf: " + this.m_inBuf.remaining());
                }
                this.m_inBuf.compact();
                pos = 0;
            }
        } else {
            this.m_inBuf.position(this.m_inBuf.limit());
            this.m_inBuf.limit(this.m_inBuf.capacity());
        }
        int read = this.m_link.read(this.m_inBuf, result);
        if (read == -1) {
            throw new EEvsEOFException(prAccessor.getString("HTTP Connection Closed!"), null);
        }
        this.m_inBuf.limit(this.m_inBuf.position());
        this.m_inBuf.position(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int read(ByteBuffer b, int readLimit, EvsNetworkLinkResult result) throws EEvsEOFException, EEvsIOException {
        if (b.remaining() > readLimit) {
            int limit = b.limit();
            try {
                b.limit(b.position() + readLimit);
                int n = this.read(b, result);
                return n;
            }
            finally {
                b.limit(limit);
            }
        }
        return this.read(b, result);
    }

    final int read(ByteBuffer b, EvsNetworkLinkResult result) throws EEvsEOFException, EEvsIOException {
        int read;
        int bufferedData = this.m_inBuf.remaining();
        if (bufferedData > 0) {
            if (this.m_inBuf.remaining() <= b.remaining()) {
                bufferedData = this.m_inBuf.remaining();
                b.put(this.m_inBuf);
                this.m_inBuf.clear();
                this.m_inBuf.limit(0);
                if (!b.hasRemaining()) {
                    return bufferedData;
                }
            } else {
                int limit = this.m_inBuf.limit();
                int ret = b.remaining();
                this.m_inBuf.limit(b.remaining() + this.m_inBuf.position());
                b.put(this.m_inBuf);
                this.m_inBuf.limit(limit);
                return ret;
            }
        }
        if ((read = this.m_link.read(b, result)) == -1) {
            if (bufferedData > 0) {
                return bufferedData;
            }
            throw new EEvsEOFException(prAccessor.getString("HTTP Connection Closed!"), null);
        }
        return read + bufferedData;
    }

    final void bufferedWrite(byte[] data, EvsNetworkLinkResult result) throws EEvsIOException {
        if (this.m_outputBuffer.remaining() >= data.length) {
            this.m_outputBuffer.put(data);
        } else {
            if (this.m_outputBuffer.capacity() < HTTPConstants.MAX_HTTP_HEADER_BUFFER_SIZE) {
                ByteBuffer newBuf = ByteBuffer.allocateDirect(Math.min(this.m_outputBuffer.capacity() * 2, HTTPConstants.MAX_HTTP_HEADER_BUFFER_SIZE));
                if (this.DEBUG) {
                    this.debug("Output Buffer size increased to: " + this.m_outputBuffer.capacity());
                }
                this.m_outputBuffer.flip();
                newBuf.put(this.m_outputBuffer);
                this.m_outputBuffer = newBuf;
            }
            if (this.m_outputBuffer.remaining() < data.length) {
                if (this.DEBUG) {
                    this.debug("Flushing output buffer to free space");
                }
                this.commitBufferedData(null);
            }
            if (this.m_outputBuffer.remaining() >= data.length) {
                this.m_outputBuffer.put(data);
            } else {
                throw new EEvsIOException(prAccessor.getString("HTTP Connection Output buffer capacity reached!"), null);
            }
        }
    }

    public final boolean commitBufferedData(IEvsAsyncWriteListener listener) throws EEvsIOException {
        if (this.m_outputBuffer.position() > 0) {
            if (this.DEBUG) {
                this.debug("Adding output buffer to transport: " + this.m_outputBuffer.position());
            }
            this.m_outputBuffer.flip();
            this.m_link.addWrite(this.m_outputBuffer, listener);
            this.m_outputBuffer = ByteBuffer.allocateDirect(this.m_outputBuffer.capacity());
        }
        return true;
    }

    public final int getRequestedHttpDataReserve() {
        if (this.m_requestedReserve == -1) {
            return 512;
        }
        return this.m_requestedReserve;
    }

    private final void debug(String str) {
        System.out.println("HTTPConnection: " + str);
    }
}

