/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.http.impl.client;

import com.sonicsw.blackbird.Version;
import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLinkFactory;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLinkResult;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.INetworkLinkConfig;
import com.sonicsw.blackbird.http.IHTTPConnection;
import com.sonicsw.blackbird.http.IHTTPMessage;
import com.sonicsw.blackbird.http.IHTTPRequest;
import com.sonicsw.blackbird.http.IHTTPResponse;
import com.sonicsw.blackbird.http.client.HTTPAuthenticationException;
import com.sonicsw.blackbird.http.client.IHTTPClient;
import com.sonicsw.blackbird.http.impl.HTTPConnection;
import com.sonicsw.blackbird.http.impl.HTTPConstants;
import com.sonicsw.blackbird.http.impl.HTTPMessageQueue;
import com.sonicsw.blackbird.http.impl.HTTPRequest;
import com.sonicsw.blackbird.http.impl.HTTPResponse;
import com.sonicsw.blackbird.http.impl.client.HTTPAuthManager;
import com.sonicsw.blackbird.http.impl.client.HTTPClientClosedException;
import com.sonicsw.blackbird.http.impl.prAccessor;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import progress.message.resources.prMessageFormat;

public class HTTPClient
implements IHTTPClient {
    public static final String USER_AGENT = "Sonic/Java-" + Version.getFullVersion();
    private static final boolean DEBUG = HTTPConstants.DEBUG;
    private static final boolean DEBUG_UNEXPECTED = HTTPConstants.DEBUG_UNEXPECTED;
    private static final int STATE_INIT = 0;
    private static final int STATE_CONNECTING = 1;
    private static final int STATE_CONNECTED = 2;
    private static final int STATE_CLOSE_WAIT = 3;
    private static final int STATE_CLOSED = 4;
    private int m_state = 0;
    public final HashMap m_standardHeaders = new HashMap();
    private final URI m_originServerURI;
    private final boolean m_usingProxy;
    private final HTTPConnection m_connection;
    private int m_connectAttempt = 0;
    private final INetworkLinkConfig m_config;
    private final String m_linkClass;
    private final HTTPMessageQueue m_requestPipeline = new HTTPMessageQueue();
    private int m_requestsOnWire = 0;
    private final HTTPAuthManager m_authManager;
    private boolean m_pipelineDisabled = false;
    private int m_maxPipelineLength = Integer.MAX_VALUE;
    private int m_chunkingThreshold = 0;
    private HTTPResponse m_currentResponse = null;
    private int m_retryCount = 0;
    private HTTPResponse m_nextResponse = null;
    private IHTTPResponse m_lastResponse = null;
    private boolean m_responseTimeoutEnabled = false;
    private int m_responseTimeout = 0;
    private long m_idleResponseTime = 0L;
    private boolean m_isBlocking = false;
    private final int MAX_REQUEST_ATTEMPTS;

    public HTTPClient(INetworkLinkConfig config) throws EEvsIOException {
        this.m_config = config;
        this.m_connection = new HTTPConnection();
        this.m_usingProxy = this.m_config.getHTTPProxyEnabled();
        if (this.m_config.getHTTPRetryAttempts() < 0) {
            if (DEBUG_UNEXPECTED) {
                this.debug("Invalid Http Retry Attempts property: " + this.m_config.getHTTPRetryAttempts() + "Using default instead: " + 3);
            }
            this.MAX_REQUEST_ATTEMPTS = 3 + 1;
        } else {
            this.MAX_REQUEST_ATTEMPTS = this.m_config.getHTTPRetryAttempts() + 1;
        }
        this.m_authManager = new HTTPAuthManager(this.m_config);
        this.setMaxPipelineLength(HTTPConstants.HTTP_MAX_PIPELINE_REQUESTS);
        this.m_linkClass = this.m_config.getLinkType().equalsIgnoreCase("http") ? "tcp" : (this.m_config.getLinkType().equalsIgnoreCase("https") ? "ssl" : this.m_config.getLinkType());
        String originServerAddr = this.m_config.getRemoteInterfaceAddress();
        if (this.m_config.getHTTPMapHostToIp()) {
            InetAddress addr = EvsNetworkLink.LINK_INTERCEPTOR.getInetAddressByName(originServerAddr);
            originServerAddr = addr instanceof Inet6Address ? "[" + addr.getHostAddress() + "]" : addr.getHostAddress();
        }
        if (this.m_linkClass == "ssl") {
            this.m_originServerURI = URI.create("https://" + originServerAddr + ":" + this.m_config.getRemotePort());
            this.m_originServerURI.isAbsolute();
        } else {
            this.m_originServerURI = URI.create("http://" + originServerAddr + ":" + this.m_config.getRemotePort());
        }
        this.m_standardHeaders.put("User-Agent", USER_AGENT);
        this.m_standardHeaders.put("Host", originServerAddr + ":" + this.m_config.getRemotePort());
    }

    @Override
    public final void setMaxPipelineLength(int length) {
        this.m_maxPipelineLength = length >= 1 && this.getPipelineEnabled() ? length : 1;
    }

    @Override
    public final int getMaxPipelineLength() {
        if (this.m_pipelineDisabled || this.m_authManager.expectingAuthChallenge()) {
            return 1;
        }
        return this.m_maxPipelineLength;
    }

    @Override
    public final void setChunkingThreshold(int length) {
        if (DEBUG) {
            this.debug("Chunking threshold set to: " + length);
        }
        this.m_chunkingThreshold = length;
    }

    public final int getChunkingThreshold(int length) {
        return this.m_chunkingThreshold;
    }

    @Override
    public final void setResponseTimeout(int ms) throws EEvsIOException {
        if (ms > 0) {
            IEvsNetworkLink link;
            this.m_responseTimeoutEnabled = true;
            this.m_responseTimeout = ms;
            if (this.m_isBlocking && (link = this.m_connection.getNetworkLink()) != null) {
                link.setSOTimeout(this.m_responseTimeout);
            }
        } else {
            IEvsNetworkLink link;
            this.m_responseTimeoutEnabled = false;
            this.m_responseTimeout = 0;
            if (this.m_isBlocking && (link = this.m_connection.getNetworkLink()) != null) {
                link.setSOTimeout(this.m_responseTimeout);
            }
        }
    }

    @Override
    public final long getResponseTimeout() {
        return this.m_responseTimeout;
    }

    @Override
    public final boolean connect(EvsNetworkLinkResult result) throws EEvsIOException, HTTPClientClosedException {
        switch (this.m_state) {
            case 0: {
                ++this.m_connectAttempt;
                try {
                    if (DEBUG) {
                        this.debug("Connecting HTTP Client to " + this.m_originServerURI + (this.m_usingProxy ? " through proxy at " + this.m_config.getHTTPProxyProtocol() + "://" + this.m_config.getHTTPProxyHost() + ":" + this.m_config.getHTTPProxyPort() + " Tunneling?: " + this.m_config.getHTTPProxyTunnel() : ""));
                    }
                    this.m_connection.reset();
                    IEvsNetworkLink link = EvsNetworkLinkFactory.create(this.m_linkClass, 1, null, this.m_config);
                    this.m_connection.setNetworkLink(link);
                    this.m_pipelineDisabled = this.m_isBlocking = link.isBlocking();
                    if (this.m_isBlocking) {
                        link.setSOTimeout(this.m_responseTimeout);
                    }
                }
                catch (EEvsIOException eeioe) {
                    IOException ioe = new IOException(eeioe.getMessage());
                    ioe.initCause(eeioe);
                    throw eeioe;
                }
                this.m_state = 1;
            }
            case 1: {
                if (!this.m_connection.connect(result)) {
                    return false;
                }
                this.m_state = 2;
            }
            case 2: {
                this.m_connectAttempt = 0;
                this.m_authManager.onNewConnect();
                return true;
            }
            case 3: 
            case 4: {
                throw new HTTPClientClosedException(prAccessor.getString("HTTP Client Closed!"));
            }
        }
        throw new IllegalStateException(prAccessor.getString("Illegal connect state for HTTP Client"));
    }

    @Override
    public final IHTTPConnection getHTTPConnection() {
        return this.m_connection;
    }

    @Override
    public final boolean close(EvsNetworkLinkResult result) throws EEvsIOException {
        switch (this.m_state) {
            case 4: {
                return true;
            }
        }
        this.m_state = 3;
        if (this.m_connection.close(result)) {
            this.m_state = 4;
            return true;
        }
        return false;
    }

    @Override
    public final void addStandardHeader(String headerName, String headerVal) {
        this.m_standardHeaders.put(headerName, headerVal);
    }

    @Override
    public final void removeStandardHeader(String headerName) {
        this.m_standardHeaders.remove(headerName);
    }

    @Override
    public final IHTTPRequest createRequest() {
        HTTPRequest request = new HTTPRequest(this.m_connection, 0);
        request.setMethod("POST");
        return request;
    }

    @Override
    public boolean getPipelineEnabled() {
        return HTTPConstants.HTTP_MAX_PIPELINE_REQUESTS > 1;
    }

    @Override
    public final void addRequest(IHTTPRequest request) {
        if (!this.m_standardHeaders.isEmpty()) {
            for (String headerName : this.m_standardHeaders.keySet()) {
                request.setHeader(headerName, (String)this.m_standardHeaders.get(headerName));
            }
        }
        if (this.m_usingProxy) {
            try {
                request.setRequestURI(new URI(this.m_originServerURI.getScheme(), this.m_originServerURI.getUserInfo(), this.m_originServerURI.getHost(), this.m_originServerURI.getPort(), request.getRequestURI().getPath(), request.getRequestURI().getQuery(), request.getRequestURI().getFragment()));
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
        request.setHandled();
        this.m_requestPipeline.addMessage(request);
    }

    @Override
    public final boolean writeRequests(EvsNetworkLinkResult result) throws EEvsIOException {
        if (this.m_retryCount >= this.MAX_REQUEST_ATTEMPTS) {
            IHTTPRequest first = (IHTTPRequest)this.m_requestPipeline.getFirst();
            throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("HTTP request retry limit reached for {0}, last response: {1}"), new Object[]{first != null ? first.getMethod() + " " + first.getRequestURI() : "???", this.m_lastResponse == null ? " unavailable " : this.m_lastResponse.getStatusCode() + " " + this.m_lastResponse.getReasonPhrase()}));
        }
        if (this.m_requestPipeline.isEmtpy()) {
            return true;
        }
        if (!this.connect(result)) {
            return false;
        }
        try {
            if (!((HTTPRequest)this.m_requestPipeline.getLast()).isAddedToConnection()) {
                Iterator i = this.m_requestPipeline.iterator();
                while (i.hasNext()) {
                    HTTPRequest request = (HTTPRequest)i.next();
                    if (request.isAddedToConnection()) continue;
                    if (this.m_requestsOnWire >= this.getMaxPipelineLength()) break;
                    if (!request.isTransportStarted()) {
                        this.m_authManager.prepareAuthHeaders(request);
                        if (DEBUG_UNEXPECTED) {
                            request.addHeader("SonicTimeSent", "" + System.currentTimeMillis());
                        }
                        request.setChunkThreshold(this.m_chunkingThreshold);
                    }
                    if (!request.addToConnection(result)) break;
                    if (DEBUG) {
                        this.debug("Added request to connection: " + request);
                    }
                    ++this.m_requestsOnWire;
                    if (!request.hasCloseHeader()) continue;
                    break;
                }
            }
            this.m_connection.write(result);
            return this.m_requestPipeline.getLast().isFinished();
        }
        catch (HTTPClientClosedException hcce) {
            throw hcce;
        }
        catch (HTTPAuthenticationException hae) {
            throw hae;
        }
        catch (EEvsIOException ioe) {
            this.resetConnection(true);
            return this.writeRequests(result);
        }
    }

    @Override
    public IHTTPResponse getResponse(EvsNetworkLinkResult result) throws EEvsIOException {
        IHTTPMessage request;
        if (this.m_state == 4 || this.m_state == 3) {
            throw new HTTPClientClosedException(prAccessor.getString("HTTP Client Closed!"));
        }
        if (this.m_responseTimeoutEnabled) {
            result.maxMsBeforeRetry = this.m_responseTimeout;
        }
        if (this.m_currentResponse != null) {
            if (!this.m_currentResponse.isHandled()) {
                return this.m_currentResponse;
            }
            try {
                if (!this.m_currentResponse.isFinished() && !this.skipResponseBody(result)) {
                    return null;
                }
            }
            catch (EEvsIOException ioe) {
                if (DEBUG || DEBUG_UNEXPECTED) {
                    this.debug("Resetting connection after failure to skip handled response");
                }
                this.resetConnection(true);
            }
            if (this.m_currentResponse.getHTTPRequest() != null && this.m_currentResponse.getHTTPRequest() == this.m_requestPipeline.getFirst()) {
                this.m_requestPipeline.removeFirst();
                --this.m_requestsOnWire;
            }
            if (this.m_currentResponse.hasCloseHeader() || this.m_currentResponse.getHTTPRequest() != null && this.m_currentResponse.getHTTPRequest().hasCloseHeader()) {
                this.resetConnection(true);
            }
            this.m_currentResponse = null;
            this.m_retryCount = 0;
        }
        this.writeRequests(result);
        if (this.m_nextResponse == null) {
            request = (HTTPRequest)this.m_requestPipeline.getFirst();
            if (request == null) {
                if (DEBUG_UNEXPECTED) {
                    this.debug("getResponse with no outstanding requests");
                }
                throw new IllegalStateException(prAccessor.getString("Unable to get response with no requests outstanding"));
            }
            if (!request.isFinished()) {
                if (this.m_responseTimeoutEnabled) {
                    if (this.m_idleResponseTime == 0L) {
                        this.m_idleResponseTime = System.currentTimeMillis();
                    } else if (System.currentTimeMillis() - this.m_idleResponseTime > (long)this.m_responseTimeout) {
                        if (DEBUG_UNEXPECTED) {
                            this.debug("Timed out writing request: " + request);
                        }
                        if (!this.resetRequestQueue(false)) {
                            throw new EEvsIOException(prAccessor.getString("Request Timed Out!"));
                        }
                        return this.getResponse(result);
                    }
                }
                return null;
            }
            this.m_idleResponseTime = 0L;
            this.m_nextResponse = new HTTPResponse(this.m_connection, 1);
        }
        if (!this.m_nextResponse.isHeaderFinished()) {
            try {
                if (!this.m_nextResponse.readMessageHeader(result)) {
                    if (this.m_responseTimeoutEnabled) {
                        if (this.m_idleResponseTime == 0L) {
                            this.m_idleResponseTime = System.currentTimeMillis();
                        } else if (System.currentTimeMillis() - this.m_idleResponseTime > (long)this.m_responseTimeout) {
                            request = this.m_requestPipeline.getFirst();
                            if (DEBUG_UNEXPECTED) {
                                this.debug("Timed out reading response for request: (" + this.m_responseTimeout + "ms) " + request + " attemtps: " + this.m_retryCount + " - " + System.currentTimeMillis() + "/" + this.m_idleResponseTime + " res: " + result);
                            }
                            if (!this.resetRequestQueue(false)) {
                                throw new EEvsIOException(prAccessor.getString("Timed Out Reading Request Response!"));
                            }
                            return this.getResponse(result);
                        }
                    }
                    return null;
                }
                this.m_lastResponse = this.m_nextResponse;
                this.m_idleResponseTime = 0L;
                if (this.m_nextResponse.getStatusCodeClass() == 2) {
                    this.m_authManager.onOkResponse(this.m_nextResponse.getHTTPRequest());
                }
            }
            catch (EEvsIOException ioe) {
                if (DEBUG || DEBUG_UNEXPECTED) {
                    this.debug("Error getting next response: " + ioe.getMessage());
                    ioe.printStackTrace();
                }
                this.resetConnection(true);
                return this.getResponse(result);
            }
        }
        try {
            switch (this.m_nextResponse.getStatusCode()) {
                case 100: {
                    if (DEBUG) {
                        this.debug("Handling continue response: " + this.m_nextResponse);
                    }
                    this.m_currentResponse = this.m_nextResponse;
                    this.m_currentResponse.setHandled();
                    this.m_nextResponse = null;
                    return this.getResponse(result);
                }
                case 401: 
                case 407: {
                    if (DEBUG) {
                        this.debug("Handling authorization response: " + this.m_nextResponse);
                    }
                    if (this.m_nextResponse.skipBody(result)) {
                        boolean proxy = this.m_nextResponse.getStatusCode() == 407;
                        boolean complete = this.m_authManager.handleAuthResponse(this.m_nextResponse, (IHTTPRequest)this.m_requestPipeline.getFirst(), proxy);
                        this.resetConnection(this.m_nextResponse.hasCloseHeader());
                        if (!complete && this.m_retryCount >= 1) {
                            --this.m_retryCount;
                        }
                        this.m_nextResponse = null;
                        return this.getResponse(result);
                    }
                    return null;
                }
            }
            this.m_currentResponse = this.m_nextResponse;
            this.m_nextResponse = null;
            this.m_currentResponse.setHTTPRequest((HTTPRequest)this.m_requestPipeline.getFirst());
            if ((DEBUG || DEBUG_UNEXPECTED) && this.m_currentResponse.getStatusCodeClass() != 2) {
                this.debug("Bad response received: " + this.m_currentResponse);
            } else if (DEBUG) {
                this.debug("Returning response :" + this.m_currentResponse);
            }
            return this.m_currentResponse;
        }
        catch (EEvsIOException ioe) {
            if (DEBUG || DEBUG_UNEXPECTED) {
                this.debug("Error getting next response: " + ioe.getMessage());
                ioe.printStackTrace();
            }
            this.resetConnection(true);
            throw ioe;
        }
    }

    @Override
    public final boolean resetRequestQueue(boolean resetRetryCount) {
        this.resetConnection(true);
        if (resetRetryCount) {
            this.m_retryCount = 0;
        } else if (this.m_retryCount >= this.MAX_REQUEST_ATTEMPTS) {
            return false;
        }
        return true;
    }

    private final void resetConnection(boolean forceClose) {
        if (this.m_state == 4 || this.m_state == 3) {
            return;
        }
        if (DEBUG) {
            this.debug("Reseting HTTP connection");
        }
        if (this.m_requestsOnWire > 0) {
            ++this.m_retryCount;
        }
        if (this.m_state != 0 && (forceClose || this.m_requestsOnWire > 1)) {
            block10: {
                try {
                    this.m_connection.close(new EvsNetworkLinkResult());
                }
                catch (EEvsIOException ioe) {
                    if (!DEBUG_UNEXPECTED) break block10;
                    this.debug("Error closing http connection on response close header: " + ioe.getMessage());
                }
            }
            this.m_state = 0;
        }
        if (!this.m_requestPipeline.isEmtpy()) {
            HTTPRequest request = (HTTPRequest)this.m_requestPipeline.getFirst();
            IHTTPResponse response = request.getResponse();
            if (response != null && response.isHandled()) {
                this.m_requestPipeline.removeFirst();
                this.m_retryCount = 0;
                if (DEBUG) {
                    this.debug("Resetting retry count from: " + this.m_retryCount);
                    Thread.currentThread();
                    Thread.dumpStack();
                }
            }
            Iterator i = this.m_requestPipeline.iterator();
            while (i.hasNext() && (request = (HTTPRequest)i.next()).isTransportStarted()) {
                request.reset();
            }
        }
        this.m_nextResponse = null;
        this.m_currentResponse = null;
        this.m_requestsOnWire = 0;
        this.m_idleResponseTime = 0L;
    }

    @Override
    public final boolean skipResponseBody(EvsNetworkLinkResult result) throws EEvsIOException {
        if (this.m_currentResponse != null && !this.m_currentResponse.isFinished()) {
            try {
                return this.m_currentResponse.skipBody(result);
            }
            catch (EEvsIOException ex) {
                if (this.m_currentResponse.isHandled()) {
                    if (DEBUG_UNEXPECTED) {
                        this.debug("IOException while skipping message but response is handled so resetting conneciton: " + ex.getMessage());
                        ex.printStackTrace();
                    }
                    this.resetConnection(true);
                    this.m_retryCount = 0;
                    return true;
                }
                throw ex;
            }
        }
        return true;
    }

    @Override
    public boolean readResponseBody(ByteBuffer body, EvsNetworkLinkResult result) throws EEvsIOException {
        if (this.m_currentResponse != null && !this.m_currentResponse.isFinished()) {
            this.m_currentResponse.readBody(body, result);
            return this.m_currentResponse.isFinished();
        }
        return true;
    }

    @Override
    public final int getRequestedHttpDataReserve() {
        return this.m_connection.getRequestedHttpDataReserve();
    }

    private final void debug(String str) {
        System.out.println("HTTPClient  for: " + this.m_originServerURI + " " + str);
    }
}

