/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sdf.impl;

import com.sonicsw.sdf.IDiagnosticsConstants;
import com.sonicsw.sdf.IStateWriter;
import com.sonicsw.sdf.ITracer;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class RolloverLogger
implements IDiagnosticsConstants,
ITracer,
IStateWriter {
    private static final ThreadLocal<SimpleDateFormat> SIMPLE_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yy/MM/dd HH:mm:ss");
        }
    };
    private static Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String OVRFLW_STRING = "_ovrflw";
    private static final boolean ON_WINDOWS = File.separatorChar == '\\';
    private static final int EOLN_LENGTH = ON_WINDOWS ? 2 : 1;
    private PrintWriter m_currentWriter;
    private String m_logPath;
    private String m_ovrflwLogPath;
    private File m_logFile;
    private File m_ovrflwLogFile;
    private File m_crntLogFile;
    private boolean m_crntOvrflw;
    private long m_totalLength;
    private long m_maxLength;

    public static void main(String[] args) throws Exception {
        RolloverLogger logger = new RolloverLogger("c:/sonic/test/trace.txt", 10000L);
        for (int i = 0; i < 7000; ++i) {
            System.out.println("print " + i);
            Exception e1 = new Exception("Cause " + i);
            Exception e = new Exception(e1);
            logger.trace("xxxxxxxxx " + i, true);
        }
    }

    RolloverLogger(String logPath, long maxLength) throws IOException {
        this.m_maxLength = maxLength;
        this.m_logPath = logPath;
        this.m_ovrflwLogPath = RolloverLogger.getOvrflwName(logPath);
        this.m_logFile = new File(this.m_logPath);
        this.m_ovrflwLogFile = new File(this.m_ovrflwLogPath);
        if (!this.m_logFile.exists() && this.m_ovrflwLogFile.exists()) {
            this.m_ovrflwLogFile.renameTo(this.m_logFile);
        }
        if (this.m_logFile.exists()) {
            this.m_totalLength = this.m_logFile.length();
        }
        if (this.m_ovrflwLogFile.exists()) {
            this.m_totalLength += this.m_ovrflwLogFile.length();
        }
        this.m_crntLogFile = this.m_ovrflwLogFile.exists() ? this.m_ovrflwLogFile : this.m_logFile;
        this.m_crntOvrflw = this.m_crntLogFile == this.m_ovrflwLogFile;
        this.openCurrent();
    }

    @Override
    public String getFilePath() {
        return this.m_logFile.getAbsolutePath();
    }

    @Override
    public void write(String message) throws IOException {
        this.logMessageInternal(message, false);
    }

    @Override
    public void writeln(String message) throws IOException {
        this.logMessageInternal(message, true);
    }

    @Override
    public void writeln() throws IOException {
        this.logMessageInternal("", true);
    }

    @Override
    public void trace(String message, Throwable exception, boolean logTimestamp) throws IOException {
        if (exception != null) {
            message = this.appendThrowableToMessage(message, exception);
        }
        this.logMessageInternal(this.createLogMessage(message, logTimestamp), true);
    }

    @Override
    public void trace(String message, boolean logTimestamp) throws IOException {
        this.logMessageInternal(this.createLogMessage(message, logTimestamp), true);
    }

    @Override
    public void close() {
        this.m_currentWriter.close();
    }

    static String formatTime(long time) {
        return SIMPLE_DATE_FORMAT.get().format(new Date(time));
    }

    private void logMessageInternal(String message, boolean newline) throws IOException {
        if (this.m_crntOvrflw) {
            if (this.m_maxLength != -1L && this.m_totalLength + (long)RolloverLogger.estimateBytes(message.length()) > this.m_maxLength) {
                this.rollover();
            }
        } else if (this.m_maxLength != -1L && this.m_totalLength + (long)RolloverLogger.estimateBytes(message.length()) > this.m_maxLength / 2L) {
            this.startOverflow();
        }
        if (newline) {
            this.m_currentWriter.println(message);
        } else {
            this.m_currentWriter.print(message);
        }
        this.m_totalLength += (long)RolloverLogger.estimateBytes(message.length());
    }

    private static int estimateBytes(int msgLength) {
        return msgLength + EOLN_LENGTH;
    }

    private void rollover() throws IOException {
        this.m_currentWriter.close();
        this.m_logFile.delete();
        if (!this.m_ovrflwLogFile.renameTo(this.m_logFile)) {
            throw new IOException("Failed to rename '" + this.m_ovrflwLogPath + "' to '" + this.m_logPath + "'");
        }
        this.m_totalLength = this.m_logFile.length();
        this.m_crntLogFile = this.m_ovrflwLogFile;
        this.openCurrent();
    }

    private void startOverflow() throws IOException {
        this.m_currentWriter.close();
        this.m_crntOvrflw = true;
        this.m_totalLength = this.m_logFile.length();
        this.m_crntLogFile = this.m_ovrflwLogFile;
        this.openCurrent();
    }

    private void openCurrent() throws IOException {
        this.m_currentWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.m_crntLogFile, true)), true);
    }

    private static String getOvrflwName(String logName) {
        int postfixIndex = logName.lastIndexOf(".");
        if (postfixIndex == -1) {
            return logName + OVRFLW_STRING;
        }
        String name = logName.substring(0, postfixIndex);
        return name + OVRFLW_STRING + logName.substring(postfixIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createLogMessage(String message, boolean logTimestamp) {
        StringBuffer timestampedMessage = new StringBuffer();
        if (logTimestamp) {
            timestampedMessage.append('[');
            ThreadLocal<SimpleDateFormat> threadLocal = SIMPLE_DATE_FORMAT;
            synchronized (threadLocal) {
                timestampedMessage.append(RolloverLogger.formatTime(System.currentTimeMillis()));
            }
            timestampedMessage.append("] ");
        }
        timestampedMessage.append(message);
        return timestampedMessage.toString();
    }

    private String appendThrowableToMessage(String message, Throwable exception) {
        StringBuffer buffer = new StringBuffer(message);
        buffer.append(NEWLINE);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(out, true);
        this.printStackTrace(exception, writer);
        byte[] data = out.toByteArray();
        buffer.append(new String(data));
        return buffer.toString();
    }

    private String printStackTrace(Throwable exception, String message) {
        StringBuffer buffer = new StringBuffer(message);
        buffer.append(NEWLINE);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(out, true);
        this.printStackTrace(exception, writer);
        byte[] data = out.toByteArray();
        try {
            out.close();
        }
        catch (IOException io) {
            // empty catch block
        }
        buffer.append(new String(data));
        return buffer.toString();
    }

    private void printStackTrace(Throwable exception, PrintWriter writer) {
        exception.printStackTrace(writer);
        Class<?> exceptionClass = exception.getClass();
        try {
            Method getTargetExceptionMethod = exceptionClass.getMethod("getTargetException", EMPTY_CLASS_ARRAY);
            Throwable targetException = (Throwable)getTargetExceptionMethod.invoke((Object)exception, EMPTY_OBJECT_ARRAY);
            if (targetException != null) {
                writer.println("Caused by...");
                this.printStackTrace(targetException, writer);
                return;
            }
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ite) {
            // empty catch block
        }
        try {
            Method getTargetErrorMethod = exceptionClass.getMethod("getTargetError", EMPTY_CLASS_ARRAY);
            Throwable targetError = (Throwable)getTargetErrorMethod.invoke((Object)exception, EMPTY_OBJECT_ARRAY);
            if (targetError != null) {
                writer.println("Caused by...");
                this.printStackTrace(targetError, writer);
                return;
            }
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ite) {
            // empty catch block
        }
        try {
            Method getLinkedExceptionMethod = exceptionClass.getMethod("getLinkedException", EMPTY_CLASS_ARRAY);
            Throwable linkedException = (Throwable)getLinkedExceptionMethod.invoke((Object)exception, EMPTY_OBJECT_ARRAY);
            if (linkedException != null) {
                writer.println("Caused by...");
                this.printStackTrace(linkedException, writer);
                return;
            }
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ite) {
            // empty catch block
        }
        if (exceptionClass.getName().indexOf("MFProxyRuntimeException") == -1 && exceptionClass.getName().indexOf("MFProxyException") == -1) {
            try {
                Method getActualExceptionMethod = exceptionClass.getMethod("getActualException", EMPTY_CLASS_ARRAY);
                Throwable cause = (Throwable)getActualExceptionMethod.invoke((Object)exception, EMPTY_OBJECT_ARRAY);
                if (cause != null) {
                    writer.println("Caused by...");
                    this.printStackTrace(cause, writer);
                    return;
                }
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (InvocationTargetException ite) {
                // empty catch block
            }
        }
    }
}

