/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.util.msgutil.impl;

import com.sonicsw.util.msgutil.ConverterException;
import com.sonicsw.util.msgutil.JMSMessageToXmlConverter;
import com.sonicsw.util.msgutil.impl.BuilderFactory;
import com.sonicsw.util.msgutil.impl.MessageType;
import com.sonicsw.util.msgutil.impl.Schema;
import com.sonicsw.util.msgutil.impl.SchemaFactory;
import com.sonicsw.util.msgutil.impl.SerializeUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import progress.message.jclient.Header;
import progress.message.jclient.MultipartMessage;
import progress.message.jclient.Part;
import progress.message.jclient.XMLMessage;

public class JMSMessageToXmlConverterImpl
implements JMSMessageToXmlConverter {
    private DocumentBuilder m_builder;
    private Schema m_schema;

    public JMSMessageToXmlConverterImpl() {
        try {
            this.m_builder = BuilderFactory.newBuilder();
            this.m_schema = SchemaFactory.newSchema();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JMSMessageToXmlConverterImpl(String schemaURI) {
        try {
            this.m_builder = BuilderFactory.newBuilder();
            this.m_schema = SchemaFactory.newSchema(schemaURI);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Document getAsDocument(Message msg) throws ConverterException {
        try {
            return this.convert(msg);
        }
        catch (Exception e) {
            throw new ConverterException("Not able to get Document representation of Message", e);
        }
    }

    @Override
    public Document getAsDocument(Part part) throws ConverterException {
        try {
            return this.convert(part);
        }
        catch (Exception e) {
            throw new ConverterException("Not able to get Document representation of Part", e);
        }
    }

    @Override
    public String getAsString(Message msg) throws ConverterException {
        try {
            Document document = this.convert(msg);
            return SerializeUtils.serializeAsXml(document);
        }
        catch (Exception e) {
            throw new ConverterException("Not able to get String representation of Message", e);
        }
    }

    @Override
    public String getAsString(Part part) throws ConverterException {
        try {
            Document document = this.convert(part);
            return SerializeUtils.serializeAsXml(document);
        }
        catch (Exception e) {
            throw new ConverterException("Not able to get String representation of Part", e);
        }
    }

    private Document convert(Part part) throws Exception {
        Document partDoc = this.m_builder.newDocument();
        Element msgPart = this.m_schema.createPartElement(partDoc);
        partDoc.appendChild(msgPart);
        this.setPartType(msgPart, part);
        return partDoc;
    }

    private Document convert(Message msg) throws Exception {
        Document msgDocument = this.m_builder.newDocument();
        if (msg instanceof MultipartMessage) {
            Element msgElement = this.m_schema.createMessageElement(msgDocument, MessageType.MULTI_PART_MESSAGE);
            msgDocument.appendChild(msgElement);
            this.setHeaders(msgDocument, msg);
            this.setProperties(msgDocument, msg);
            MultipartMessage mpm = (MultipartMessage)msg;
            for (int i = 0; i < mpm.getPartCount(); ++i) {
                Element msgPart = this.m_schema.createPartElement(msgDocument);
                msgElement.appendChild(msgPart);
                Part part = mpm.getPart(i);
                this.setPartType(msgPart, part);
            }
        } else if (msg instanceof XMLMessage) {
            Element msgElement = this.m_schema.createMessageElement(msgDocument, MessageType.XML_MESSAGE);
            msgDocument.appendChild(msgElement);
            this.setHeaders(msgDocument, msg);
            this.setProperties(msgDocument, msg);
            Element bodyPart = this.m_schema.createBodyElement(msgDocument);
            msgElement.appendChild(bodyPart);
            this.setBodyType(bodyPart, ((XMLMessage)msg).getText(), "text/xml");
        } else if (msg instanceof TextMessage) {
            Element msgElement = this.m_schema.createMessageElement(msgDocument, MessageType.TEXT_MESSAGE);
            msgDocument.appendChild(msgElement);
            this.setHeaders(msgDocument, msg);
            this.setProperties(msgDocument, msg);
            Element bodyPart = this.m_schema.createBodyElement(msgDocument);
            msgElement.appendChild(bodyPart);
            this.setBodyType(bodyPart, ((TextMessage)msg).getText(), "text/plain");
        } else {
            Element msgElement = this.m_schema.createBodyElement(msgDocument);
            msgDocument.appendChild(msgElement);
            this.setHeaders(msgDocument, msg);
            this.setProperties(msgDocument, msg);
        }
        return msgDocument;
    }

    private void setHeaders(Document msgDocument, Message msg) throws Exception {
        Element msgElement = (Element)msgDocument.getFirstChild();
        HashMap<String, Object> jmsProperties = this.getJMSProperties(msg);
        for (String hdrName : jmsProperties.keySet()) {
            Object valueObj = jmsProperties.get(hdrName);
            if (valueObj == null) continue;
            String destType = null;
            String value = null;
            if (valueObj instanceof Queue) {
                destType = "Queue";
                value = ((Queue)valueObj).getQueueName();
            } else if (valueObj instanceof Topic) {
                destType = "Topic";
                value = ((Topic)valueObj).getTopicName();
            } else {
                value = valueObj.toString();
            }
            Element newElementNode = this.m_schema.createHeaderElement(msgDocument, hdrName, value, destType);
            msgElement.appendChild(newElementNode);
        }
    }

    private void setProperties(Document msgDocument, Message msg) throws Exception {
        Element msgElement = (Element)msgDocument.getFirstChild();
        Enumeration iter = msg.getPropertyNames();
        while (iter.hasMoreElements()) {
            String hdrName = (String)iter.nextElement();
            Object hdrObj = msg.getObjectProperty(hdrName);
            String value = hdrObj == null ? null : hdrObj.toString();
            if (value == null || value.length() == 0) continue;
            String jclz = null;
            if (!(hdrObj instanceof String)) {
                jclz = hdrObj.getClass().getName();
            }
            Element newElementNode = this.m_schema.createPropertyElement(msgDocument, hdrName, value, jclz);
            msgElement.appendChild(newElementNode);
        }
    }

    private void setPartType(Element msgPart, Part part) throws Exception {
        Text valueNode;
        Document document = msgPart.getOwnerDocument();
        if (part.getHeader().getContentType().equals("text/plain")) {
            valueNode = document.createTextNode(this.coercePartContentToString(part));
            msgPart.appendChild(valueNode);
        } else if (this.m_schema.useCDATAForPartAndBodyContent()) {
            valueNode = document.createTextNode(this.coercePartContentToString(part));
            msgPart.appendChild(valueNode);
        } else {
            try {
                Document inner = this.m_builder.parse(this.coercePartContentToUTF8InputStream(part));
                msgPart.appendChild(document.importNode(inner.getFirstChild(), true));
            }
            catch (Exception e) {
                Text valueNode2 = document.createTextNode(this.coercePartContentToString(part));
                msgPart.appendChild(valueNode2);
            }
        }
        Header hdr = part.getHeader();
        Enumeration it = hdr.getHeaderFieldNames();
        if (hdr.getContentId() != null) {
            msgPart.setAttribute("content-id", hdr.getContentId());
        }
        if (hdr.getContentType() != null) {
            msgPart.setAttribute("content-type", hdr.getContentType());
        }
        while (it.hasMoreElements()) {
            String headerName = it.nextElement().toString();
            String headerVal = hdr.getHeaderField(headerName);
            if (headerName == null || headerVal == null || "Content-ID".equals(headerName) || "Content-Type".equals(headerName)) continue;
            msgPart.setAttribute(headerName, headerVal);
        }
    }

    private String coercePartContentToString(Part part) {
        Object content = part.getContent();
        if (content instanceof String) {
            return (String)content;
        }
        return new String(part.getContentBytes());
    }

    private InputStream coercePartContentToUTF8InputStream(Part part) throws Exception {
        Object content = part.getContent();
        if (content instanceof String) {
            return new ByteArrayInputStream(((String)content).getBytes("UTF-8"));
        }
        Charset ctCharset = SerializeUtils.getCharset(part.getHeader().getContentType());
        if (this.utf8CompatibleCharset(ctCharset)) {
            return part.getInputStream();
        }
        String decodedContent = new String(part.getContentBytes(), ctCharset.name());
        return new ByteArrayInputStream(decodedContent.getBytes("UTF-8"));
    }

    private boolean utf8CompatibleCharset(Charset charset) {
        return charset.compareTo(Charset.forName("utf-8")) == 0;
    }

    private void setBodyType(Element msgBody, String content, String contentType) throws Exception {
        Document document = msgBody.getOwnerDocument();
        if (contentType.equals("text/plain")) {
            Text valueNode = document.createTextNode(content);
            msgBody.appendChild(valueNode);
        } else {
            try {
                Document inner = this.m_builder.parse(new ByteArrayInputStream(content.getBytes("UTF-8")));
                msgBody.appendChild(document.importNode(inner.getFirstChild(), true));
            }
            catch (Exception e) {
                Text valueNode = document.createTextNode(content);
                msgBody.appendChild(valueNode);
            }
        }
        msgBody.setAttribute("content-type", contentType);
    }

    private HashMap<String, Object> getJMSProperties(Message msg) throws JMSException {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        if (msg.getJMSDestination() != null) {
            headers.put("JMSDestination", msg.getJMSDestination());
        }
        headers.put("JMSDeliveryMode", Integer.valueOf(msg.getJMSDeliveryMode()).toString());
        if (msg.getJMSMessageID() != null) {
            headers.put("JMSMessageID", msg.getJMSMessageID());
        }
        headers.put("JMSTimestamp", Long.valueOf(msg.getJMSTimestamp()).toString());
        if (msg.getJMSCorrelationID() != null) {
            headers.put("JMSCorrelationID", msg.getJMSCorrelationID());
        }
        if (msg.getJMSReplyTo() != null) {
            headers.put("JMSReplyTo", msg.getJMSReplyTo());
        }
        headers.put("JMSRedelivered", Boolean.valueOf(msg.getJMSRedelivered()).toString());
        headers.put("JMSExpiration", Long.valueOf(msg.getJMSExpiration()).toString());
        headers.put("JMSPriority", Integer.valueOf(msg.getJMSPriority()).toString());
        return headers;
    }
}

