/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.util.msgutil.impl;

import com.sonicsw.util.msgutil.impl.BuilderFactory;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import javax.activation.MimeType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SerializeUtils {
    public static String serializeNodeAsXml(Node node) throws Exception {
        DocumentBuilder builder = BuilderFactory.newBuilder();
        Document holderDoc = builder.newDocument();
        Node importedNode = holderDoc.importNode(node, true);
        holderDoc.appendChild(importedNode);
        return SerializeUtils.serializeAsXml(holderDoc, true, false);
    }

    public static String serializeAsXml(Document doc) throws Exception {
        return SerializeUtils.serializeAsXml(doc, false, true);
    }

    public static String serializeAsXml(Document doc, boolean omit, boolean indent) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(baos);
        DOMSource domSource = new DOMSource(doc);
        StreamResult streamResult = new StreamResult(out);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = tf.newTransformer();
        serializer.setOutputProperty("encoding", "UTF-8");
        serializer.setOutputProperty("indent", indent ? "yes" : "no");
        serializer.setOutputProperty("omit-xml-declaration", omit ? "yes" : "no");
        serializer.transform(domSource, streamResult);
        return baos.toString("UTF-8");
    }

    public static String getTextContent(InputStream inputStream, String contentType) throws Exception {
        try {
            InputStreamReader r = new InputStreamReader(inputStream, SerializeUtils.getCharset(contentType));
            BufferedReader br = new BufferedReader(r);
            StringBuffer buf = new StringBuffer();
            char[] cbuf = new char[4096];
            int i = 0;
            while ((i = br.read(cbuf, 0, cbuf.length)) != -1) {
                buf.append(cbuf, 0, i);
            }
            return buf.toString();
        }
        catch (Exception e) {
            throw new Exception("Not able to get Text content from file reference", e);
        }
    }

    public static byte[] getBinaryContent(InputStream inputStream) throws Exception {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int read = 0;
            byte[] buf = new byte[4096];
            while ((read = inputStream.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new Exception("Not able to get Binary content from file reference", e);
        }
    }

    public static Charset getCharset(String contentType) throws Exception {
        try {
            MimeType mimeType = new MimeType(contentType);
            String charset = mimeType.getParameter("charset");
            if (charset != null) {
                return Charset.forName(charset);
            }
            charset = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
            return Charset.forName(charset);
        }
        catch (Exception e) {
            throw new Exception("Not able to get charset", e);
        }
    }
}

