/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import com.sonicsw.security.pass.client.ILogin;
import java.applet.Applet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import progress.message.client.Credentials;
import progress.message.client.EAlreadyConnected;
import progress.message.client.EAnonymousConnectionDisallowed;
import progress.message.client.EBrokerRedirected;
import progress.message.client.EBrokerStateDiscarded;
import progress.message.client.EBrokerVersionMismatch;
import progress.message.client.EBrokerVersionMismatchNoSSL;
import progress.message.client.EConnectionLimitExceeded;
import progress.message.client.EConnectionNotResumable;
import progress.message.client.ECredentialInUse;
import progress.message.client.EDefaultHandlerNotSet;
import progress.message.client.EExclusiveQueueOpen;
import progress.message.client.EGeneralException;
import progress.message.client.EInauthenticBroker;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.EInvalidApplicationId;
import progress.message.client.EInvalidCompressionFactory;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.EInvalidUserId;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENotConnected;
import progress.message.client.EParameterIsNull;
import progress.message.client.EPasswordExpired;
import progress.message.client.ESecurityGeneralException;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.ETemporaryQueueLimitExceeded;
import progress.message.client.EUnknownBrokerHost;
import progress.message.client.EUnresolvedConnectionURLs;
import progress.message.client.EUnusableConnection;
import progress.message.client.EUserAlreadyConnected;
import progress.message.client.prAccessor;
import progress.message.jclient.Channel;
import progress.message.jclient.ConnectionFactory;
import progress.message.jclient.ConnectionStateChangeListener;
import progress.message.jclient.RejectionListener;
import progress.message.jimpl.ChannelAdmin;
import progress.message.jimpl.ChannelAdminFactory;
import progress.message.jimpl.ConnectionMetaData;
import progress.message.jimpl.DurableSubscriber;
import progress.message.jimpl.ICCFactory;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Lock;
import progress.message.jimpl.MessageConsumer;
import progress.message.jimpl.QueueReceiver;
import progress.message.jimpl.RejectionProcessor;
import progress.message.jimpl.Session;
import progress.message.jimpl.TemporaryQueue;
import progress.message.jimpl.TemporaryTopic;
import progress.message.jimpl.TopicSubscriber;
import progress.message.jimpl.ZConnectionFactory;
import progress.message.net.ESocketConnectTimeout;
import progress.message.net.ProgressInetAddress;
import progress.message.resources.prMessageFormat;
import progress.message.util.BiDirHashMap;
import progress.message.util.BiDirMap;
import progress.message.util.IMetricsListener;
import progress.message.zclient.ClientData;
import progress.message.zclient.EUnexpectedMgram;
import progress.message.zclient.Envelope;
import progress.message.zclient.IJobResolver;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.xonce.IDoubtResolver;
import progress.message.zclient.xonce.IDoubtResolverCompletionListener;

public class Connection
implements progress.message.jclient.Connection,
IDoubtResolver {
    private static final String CONNECTION_CONSUMER_FACTORY_CLASS = "progress.message.jimpl.aspi.CCFactory";
    protected progress.message.zclient.Connection m_zconnection = null;
    MessageHandler m_zmessageHandler = null;
    private ExceptionListener exceptionListener = null;
    ConnectionStateChangeListener connectionStateChangeListener = null;
    ZConnectionFactory m_zConnectionFactory;
    private String m_clientID = null;
    private long m_brokerID;
    private long m_connID;
    private long m_lastLocalID = 0L;
    private Object m_lastLocalIdObject = new Object();
    private static final int MAX_LOCALID = 65535;
    private boolean m_deliveryStarted = false;
    private volatile boolean m_closed = false;
    private volatile boolean m_closing = false;
    private volatile boolean m_stopping = false;
    private volatile int m_connectionState = 3;
    private Lock m_closeLock;
    private ReentrantLock m_startStopLock = new ReentrantLock();
    private Vector<progress.message.zclient.Connection> m_zconnections = new Vector();
    private String m_storeDir = null;
    private boolean m_isSecure = false;
    private boolean m_defaultToPersistentDelivery = false;
    boolean m_hasCC = false;
    protected progress.message.zclient.Session m_ackSession = null;
    private Vector<Session> m_jmsSessions = new Vector();
    private Hashtable<String, DurableSubscriber> m_DurableConnConsumers = new Hashtable();
    private Vector<MessageConsumer> m_NonDurConnConsumers = new Vector();
    static final int START = 1;
    static final int STOP = 2;
    static final int CLOSE = 3;
    private boolean m_isSelectorAtBroker = false;
    private boolean m_isFaultTolerant = false;
    private boolean m_defaultDurableMessageOrder = false;
    private int m_prefetchCount = -1;
    private int m_prefetchThreshold = -1;
    private boolean m_minimizeSubscriberTraffic = false;
    protected int m_sendTimeoutMs = 0;
    protected javax.jms.Session m_defaultJSession = null;
    private Hashtable<String, TemporaryQueue> m_tempQueues;
    private final Object m_tempQueuesSync = new Object();
    private Hashtable<String, TemporaryTopic> m_tempTopics;
    private final Object m_tempTopicsSync = new Object();
    private int m_defaultTxnBatchSize = 51200;
    private int m_flowToDisk = 0;
    private boolean m_splitMultiTopicDelivery = false;
    private boolean m_rethrowCCRuntimeExceptions = false;
    private int m_qopCacheSize = 128;
    private int m_maxDeliveryCount = 0;
    private final int m_asyncDeliveryMode;
    private final int m_deliveryDoubtWindow;
    private final long m_deliveryCloseTimeout;
    private final RejectionProcessor m_rejectionProc;
    private BiDirMap m_sessionMap = new BiDirHashMap();
    private InvocationMap m_invocationMap = new StopCloseInvocationMap(this.m_sessionMap);
    private InvocationGraph m_invocationGraph = new InvocationGraph(this.m_sessionMap, this.m_invocationMap);
    IDoubtResolverCompletionListener m_doubtlistener = null;

    @Override
    public boolean isSecure() {
        return this.m_isSecure;
    }

    public Connection(String connectID, String username, String password, Applet applet, String clientID, Hashtable environment) throws JMSException {
        this.m_closeLock = new Lock(this);
        Hashtable env = null;
        if (environment != null) {
            env = (Hashtable)environment.clone();
        }
        String pingInterval = null;
        long pingIntervalValue = -1L;
        Integer asyncDeliveryMode = null;
        if (env != null) {
            asyncDeliveryMode = (Integer)env.get("ASYNCHRONOUS_DELIVERY_MODE");
        }
        this.m_asyncDeliveryMode = asyncDeliveryMode != null ? asyncDeliveryMode.intValue() : ConnectionFactory.ASYNCHRONOUS_DELIVERY_MODE_DEFAULT.intValue();
        Long deliveryCloseTimeout = null;
        if (env != null) {
            deliveryCloseTimeout = (Long)env.get("DELIVERY_CLOSE_TIMEOUT");
        }
        this.m_deliveryCloseTimeout = deliveryCloseTimeout != null ? deliveryCloseTimeout : (long)ConnectionFactory.DELIVERY_CLOSE_TIMEOUT_DEFAULT.intValue();
        Integer deliveryDoubtWindow = null;
        if (env != null) {
            deliveryDoubtWindow = (Integer)env.get("DELIVERY_DOUBT_WINDOW");
        }
        this.m_deliveryDoubtWindow = deliveryDoubtWindow != null ? deliveryDoubtWindow.intValue() : ConnectionFactory.DELIVERY_DOUBT_WINDOW_DEFAULT.intValue();
        this.m_rejectionProc = new RejectionProcessor(this);
        try {
            Integer initRcvIOBufSize;
            Integer minRcvIOBufSize;
            Integer maxRcvIOBufSize;
            Integer initSendIOBufSize;
            Integer minSendIOBufSize;
            Integer qopCacheSize;
            Boolean rethrowCCRuntimeExceptions;
            Boolean splitMTDelivery;
            Integer setting;
            Integer size;
            String clientHost;
            String monitorIntervalString;
            String loadBalancing;
            Integer socketConnectTimeout;
            Integer initialConnectTimeout;
            Integer failoverReconnectTimeout;
            if (username != null && (username.indexOf("*") != -1 || username.indexOf("#") != -1 || username.indexOf("$") != -1)) {
                throw JMSExceptionUtil.createJMSSecurityException(prAccessor.getString("CONN_INVALID_USER"), null);
            }
            username = username.replace('.', '$');
            ILogin loginSpi = null;
            if (env != null && env.containsKey("login_spi_object")) {
                loginSpi = (ILogin)env.get("login_spi_object");
            }
            if (loginSpi == null && SessionConfig.LOGIN_SPI_CLASS_NAME != null && SessionConfig.LOGIN_SPI_CLASS_NAME.trim().length() != 0) {
                loginSpi = SessionConfig.createILoginInstance(SessionConfig.LOGIN_SPI_CLASS_NAME);
            }
            Credentials credentials = new Credentials(username, password, loginSpi != null ? loginSpi.getLoginSPI() : null);
            this.m_zmessageHandler = new DefaultMessageHandler();
            String connectIdParm = connectID;
            if (connectID == null) {
                connectID = "";
            }
            connectID = connectID + "$CONNECTION$";
            if (clientID != null) {
                this.m_clientID = clientID;
            }
            this.m_zConnectionFactory = new ZConnectionFactory(this, env, connectIdParm);
            this.m_zconnection = this.m_zConnectionFactory.createZConnection(connectID, credentials, this.m_zmessageHandler, true, this.m_rejectionProc);
            if (loginSpi != null) {
                this.m_zconnection.setAuthenticationSPIEnabled(true);
            } else {
                this.m_zconnection.setAuthenticationSPIEnabled(false);
            }
            this.addZConnection(this.m_zconnection);
            this.m_ackSession = this.m_zmessageHandler.getSession();
            if (applet != null) {
                this.m_zconnection.setApplet(applet);
            }
            this.m_storeDir = (String)env.get("LocalStoreDirectory");
            Boolean faultTolerant = (Boolean)env.get("faultTolerant");
            this.m_isFaultTolerant = faultTolerant != null ? faultTolerant : false;
            this.m_zconnection.setEnableFaultTolerance(this.m_isFaultTolerant);
            if (this.m_isFaultTolerant) {
                this.m_zconnection.setApplicationLevelResolver(this);
            }
            if ((failoverReconnectTimeout = (Integer)env.get("faultTolerantReconnectTimeout")) != null) {
                this.m_zconnection.setFailoverReconnectTimeout(failoverReconnectTimeout * 1000);
            }
            if ((initialConnectTimeout = (Integer)env.get("initialConnectTimeout")) != null) {
                int ict = initialConnectTimeout;
                if (ict < 0) {
                    this.m_zconnection.setInitialConnectTimeout(-1L);
                } else {
                    this.m_zconnection.setInitialConnectTimeout(ict * 1000);
                }
            }
            if ((socketConnectTimeout = (Integer)env.get("SOCKET_CONNECT_TIMEOUT")) != null) {
                this.m_zconnection.setSocketConnectTimeout(socketConnectTimeout.intValue());
            }
            pingInterval = (String)env.get("pingInterval");
            pingIntervalValue = 60L;
            if (pingInterval != null && !"".equals(pingInterval)) {
                try {
                    pingIntervalValue = Long.parseLong(pingInterval);
                }
                catch (NumberFormatException nfe) {
                    if (this.m_zconnection != null) {
                        this.m_zconnection.cleanUp();
                    }
                    throw JMSExceptionUtil.createJMSException(nfe);
                }
            }
            this.setPingInterval(pingIntervalValue);
            Long txBufferSize = (Long)env.get("clientTransactionBufferSize");
            if (txBufferSize != null) {
                this.m_zconnection.setTxBufferSize(txBufferSize);
            }
            boolean enableLoadBalancing = (loadBalancing = (String)env.get("loadBalancing")) != null ? Boolean.valueOf(loadBalancing.trim()) : false;
            String persistentDelivery = (String)env.get("persistentDelivery");
            boolean bl = this.m_defaultToPersistentDelivery = persistentDelivery != null ? Boolean.valueOf(persistentDelivery.trim()) : false;
            if (env.containsKey("durableSubscriberMessageOrder")) {
                this.m_defaultDurableMessageOrder = (Boolean)env.get("durableSubscriberMessageOrder");
            }
            Integer monitorInterval = (monitorIntervalString = (String)env.get("monitorInterval")) != null ? new Integer(monitorIntervalString) : new Integer(-1);
            this.m_zconnection.setMonitorInterval(monitorInterval);
            String clientPreferences = (String)env.get("clientData");
            try {
                clientHost = ProgressInetAddress.getLocalHostName();
            }
            catch (Exception e) {
                clientHost = "localhost";
            }
            ClientData clientData = new ClientData(clientHost, 0, this.m_clientID, clientPreferences);
            String brokerList = (String)env.get("RESOLVED_BROKER_LIST");
            if (brokerList == null || brokerList.length() == 0) {
                throw new EUnresolvedConnectionURLs((String)env.get("brokerList"), brokerList);
            }
            String[] brokers = this.parseBrokerList(brokerList);
            String randomize = (String)env.get("randomizeBrokers");
            boolean enableRandomize = randomize != null ? Boolean.valueOf(randomize.trim()) : false;
            String factorList = (String)env.get("brokerRandomFactors");
            int[] factors = null;
            if (factorList != null) {
                factors = this.parseFactorList(factorList);
                enableRandomize = true;
            }
            if ((size = (Integer)env.get("defaultTxnBatchSize")) != null) {
                this.m_defaultTxnBatchSize = size;
            }
            if ((setting = (Integer)env.get("FLOW_TO_DISK")) != null) {
                this.m_flowToDisk = setting;
            }
            if ((splitMTDelivery = (Boolean)env.get("MULTI_TOPIC_SPLIT_DELIVERY")) != null) {
                this.m_splitMultiTopicDelivery = splitMTDelivery;
            }
            if ((rethrowCCRuntimeExceptions = (Boolean)env.get("RETHROW_CC_RUNTIME_EXCEPTIONS")) != null) {
                this.m_rethrowCCRuntimeExceptions = rethrowCCRuntimeExceptions;
            }
            if ((qopCacheSize = (Integer)env.get("QOP_CACHE_SIZE")) != null) {
                this.m_qopCacheSize = qopCacheSize;
            }
            this.m_zconnection.setProtocolDefaults(brokers);
            this.m_zconnection.setQOPCacheSize(this.m_qopCacheSize);
            Integer maxSendIOBufSize = (Integer)env.get("MAX_IO_SEND_BUFFER_SIZE");
            if (maxSendIOBufSize != null) {
                this.m_zconnection.setMaxSendBufferSize(maxSendIOBufSize);
            }
            if ((minSendIOBufSize = (Integer)env.get("MIN_IO_SEND_BUFFER_SIZE")) != null) {
                this.m_zconnection.setMinSendBufferSize(Math.min(minSendIOBufSize, this.m_zconnection.getMaxSendBufferSize()));
            }
            if ((initSendIOBufSize = (Integer)env.get("INITIAL_IO_SEND_BUFFER_SIZE")) != null) {
                this.m_zconnection.setInitialSendBufferSize(Math.max(initSendIOBufSize, this.m_zconnection.getMinSendBufferSize()));
            }
            if ((maxRcvIOBufSize = (Integer)env.get("MAX_IO_RCV_BUFFER_SIZE")) != null) {
                this.m_zconnection.setMaxRcvBufferSize(maxRcvIOBufSize);
            }
            if ((minRcvIOBufSize = (Integer)env.get("MIN_IO_RCV_BUFFER_SIZE")) != null) {
                this.m_zconnection.setMinRcvBufferSize(Math.min(minRcvIOBufSize, this.m_zconnection.getMaxRcvBufferSize()));
            }
            if ((initRcvIOBufSize = (Integer)env.get("INITIAL_IO_RCV_BUFFER_SIZE")) != null) {
                this.m_zconnection.setInitialRcvBufferSize(Math.max(initRcvIOBufSize, this.m_zconnection.getMinRcvBufferSize()));
            }
            Boolean isLGInstrumented = (Boolean)env.get("LG_ENABLED");
            Integer downStreamNodeType = (Integer)env.get("LG_DOWN_STREAM_NODE_TYPE");
            if (isLGInstrumented != null) {
                int nodeType = -1;
                if (downStreamNodeType != null) {
                    nodeType = downStreamNodeType;
                }
                this.m_zconnection.setLGSetting(isLGInstrumented, nodeType);
            }
            Boolean isCompressionEnabled = (Boolean)env.get("ENABLE_COMPRESSION");
            String compressionFactory = (String)env.get("COMPRESSION_FACTORY");
            if (isCompressionEnabled != null && isCompressionEnabled.booleanValue()) {
                this.m_zconnection.initCompressionFactory(compressionFactory);
            }
            try {
                this.m_zconnection.connect(brokers, enableLoadBalancing, enableRandomize, factors, clientData, null);
            }
            catch (EBrokerRedirected e) {
                this.m_zconnection.cleanUp();
                this.m_zconnection = this.m_zConnectionFactory.createZConnection(connectID, credentials, this.m_zmessageHandler, true, this.m_rejectionProc);
                this.m_zconnection.setMonitorInterval(monitorInterval);
                if (socketConnectTimeout != null) {
                    this.m_zconnection.setSocketConnectTimeout(socketConnectTimeout.intValue());
                }
                if (applet != null) {
                    this.m_zconnection.setApplet(applet);
                }
                this.m_zconnection.setEnableFaultTolerance(this.m_isFaultTolerant);
                this.m_zconnection.connect(e.getNewBrokerURL(), false);
            }
            if (!SessionConfig.isJmsClientSessionVersSupported(this.m_zconnection.getBrokerSessionVer()) && this.m_zconnection.getSecurityContext().getAppid().indexOf("SonicMQ/mf/") == -1) {
                throw new EBrokerVersionMismatchNoSSL(prAccessor.getString("VERSION_MISMATCH"), (int)this.m_zconnection.getBrokerSessionVer(), 32);
            }
            this.m_isFaultTolerant = this.m_zconnection.isFaultToleranceEnabled();
            this.m_zconnection.getDefaultSession().subscribe(SessionConfig.getClientPrefix() + "#");
            this.m_connectionState = 0;
            this.m_isSecure = this.m_zconnection.isSecure();
            this.setNewConnectionID();
            if (env != null && env.containsKey("selectorAtBroker")) {
                this.m_isSelectorAtBroker = (Boolean)env.get("selectorAtBroker");
            }
            if (env != null && env.containsKey("MAX_DELIVERY_COUNT")) {
                this.m_maxDeliveryCount = (Integer)env.get("MAX_DELIVERY_COUNT");
                if (this.m_zconnection.getBrokerSessionVer() < 29) {
                    this.m_maxDeliveryCount = 0;
                }
            }
            if (env != null) {
                String prefetchThresholdString;
                Integer prefetchThreshold;
                Integer prefetchCount;
                String prefetchCountString = (String)env.get("prefetchCount");
                Integer n = prefetchCount = prefetchCountString != null ? new Integer(prefetchCountString) : null;
                if (prefetchCount != null) {
                    this.setPrefetchCount(prefetchCount);
                }
                Integer n2 = prefetchThreshold = (prefetchThresholdString = (String)env.get("prefetchThreshold")) != null ? new Integer(prefetchThresholdString) : null;
                if (prefetchThreshold != null) {
                    this.setPrefetchThreshold(prefetchThreshold);
                }
                if (env.containsKey("MINIMIZE_SUBSCRIBER_TRAFFIC")) {
                    this.m_minimizeSubscriberTraffic = (Boolean)env.get("MINIMIZE_SUBSCRIBER_TRAFFIC");
                }
                if (env.containsKey("SEND_TIMEOUT")) {
                    this.m_sendTimeoutMs = (Integer)env.get("SEND_TIMEOUT");
                }
                this.m_sendTimeoutMs = this.m_sendTimeoutMs > 0 ? this.m_sendTimeoutMs : SessionConfig.JMS_SEND_TIMEOUT_DEFAULT;
                this.m_sendTimeoutMs = this.m_zConnectionFactory.isPersistenceEnabled() ? 0 : this.m_sendTimeoutMs;
            }
            this.m_rejectionProc.onConnected(this);
        }
        catch (JMSException jmse) {
            throw jmse;
        }
        catch (EDefaultHandlerNotSet edhns) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(edhns);
        }
        catch (EInvalidSubjectSyntax eiss) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(eiss);
        }
        catch (ESocketConnectTimeout esct) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(esct.toString(), "-5001", esct);
        }
        catch (ENetworkFailure enf) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(enf);
        }
        catch (EBrokerVersionMismatch ebvm) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(ebvm);
        }
        catch (EBrokerVersionMismatchNoSSL ebvm) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(ebvm);
        }
        catch (EParameterIsNull epis) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(epis);
        }
        catch (EConnectionLimitExceeded ecle) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(ecle.getMessage(), "-26", ecle);
        }
        catch (ECredentialInUse ecin) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            JMSExceptionUtil.createJMSSecurityException(ecin);
        }
        catch (EUnknownBrokerHost eubh) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(eubh);
        }
        catch (EAlreadyConnected eac) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(eac);
        }
        catch (EInauthenticBroker eib) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            JMSExceptionUtil.createJMSSecurityException(eib);
        }
        catch (EUserAlreadyConnected euac) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            String msgf = prAccessor.getString("CONN_ALREADY_EXISTS");
            Object[] obj = new Object[]{connectID, username};
            String result = prMessageFormat.format(msgf, obj);
            throw JMSExceptionUtil.createJMSException(result, euac);
        }
        catch (EAnonymousConnectionDisallowed eacd) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(eacd);
        }
        catch (EInvalidApplicationId eiad) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(eiad);
        }
        catch (EInvalidUserId eiad) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSSecurityException(prAccessor.getString("CONN_INVALID_USER"), eiad);
        }
        catch (EPasswordExpired epe) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSSecurityException(epe);
        }
        catch (EInvalidCompressionFactory eicf) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(eicf);
        }
        catch (EUnusableConnection euc) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(euc);
        }
        catch (EUnresolvedConnectionURLs eucu) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(eucu);
        }
        catch (ESecurityPolicyViolation espv) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSSecurityException(espv);
        }
        catch (ESecurityGeneralException esge) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSSecurityException(esge);
        }
        catch (EGeneralException ge) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(ge);
        }
        catch (IOException e) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public boolean isPersistenceEnabled() {
        if (this.m_zConnectionFactory != null) {
            return this.m_zConnectionFactory.isPersistenceEnabled();
        }
        return false;
    }

    public progress.message.zclient.Connection getZConnection() {
        return this.m_zconnection;
    }

    public void checkPersistence(String opname) throws JMSException {
        if (this.isPersistenceEnabled()) {
            throw new IllegalStateException(prMessageFormat.format(prAccessor.getString("SF_NOT_ALLOWED"), new Object[]{opname}));
        }
    }

    protected final String[] parseBrokerList(String brokerList) {
        String[] brokers = null;
        int numBrokers = 0;
        StringTokenizer st = new StringTokenizer(brokerList, ",");
        numBrokers = st.countTokens();
        if (numBrokers > 0) {
            brokers = new String[numBrokers];
            for (int i = 0; i < numBrokers; ++i) {
                brokers[i] = st.nextToken();
            }
        }
        return brokers;
    }

    final int[] parseFactorList(String factorList) {
        if (factorList != null) {
            StringTokenizer st = new StringTokenizer(factorList);
            int numFactors = st.countTokens();
            int[] factors = new int[numFactors];
            for (int i = 0; i < numFactors; ++i) {
                try {
                    factors[i] = Integer.parseInt(st.nextToken());
                    if (factors[i] >= 1) continue;
                    factors[i] = 1;
                    continue;
                }
                catch (NumberFormatException ex) {
                    factors[i] = 1;
                }
            }
            return factors;
        }
        return new int[0];
    }

    @Override
    public String getClientID() throws JMSException {
        this.checkClosed();
        return this.m_clientID;
    }

    @Override
    public void setClientID(String clientID) throws JMSException {
        this.checkClosed();
        if (this.m_clientID != null || !this.m_jmsSessions.isEmpty()) {
            throw new IllegalStateException(prAccessor.getString("CLIENT_ID_ALREADY_SET"));
        }
        if (clientID != null && (clientID.indexOf("#") != -1 || clientID.indexOf("*") != -1 || clientID.indexOf("$") != -1 || clientID.indexOf(".") != -1)) {
            throw new InvalidClientIDException(prAccessor.getString("CONN_INVALID_CLIENT_ID") + clientID);
        }
        this.m_clientID = clientID;
    }

    @Override
    public javax.jms.ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        return new ConnectionMetaData();
    }

    @Override
    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosed();
        this.exceptionListener = listener;
    }

    @Override
    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        return this.exceptionListener;
    }

    @Override
    public void setRejectionListener(RejectionListener listener) throws JMSException {
        this.checkClosed();
        this.m_rejectionProc.setRejectionListener(listener);
        this.m_zConnectionFactory.setRejectionListener(listener);
    }

    final RejectionProcessor getRejectionProcessor() {
        return this.m_rejectionProc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws JMSException {
        this.m_startStopLock.lock();
        try {
            JMSException exc;
            block24: {
                block23: {
                    Vector<Session> sessionsClone;
                    this.checkClosing();
                    if (this.m_deliveryStarted) {
                        return;
                    }
                    exc = null;
                    Vector<Session> vector = this.m_jmsSessions;
                    synchronized (vector) {
                        sessionsClone = new Vector<Session>(this.m_jmsSessions);
                    }
                    for (Session session : sessionsClone) {
                        try {
                            session.start();
                        }
                        catch (JMSException e) {
                            if (exc != null) continue;
                            exc = e;
                        }
                    }
                    if (this.hasConnectionConsumer()) {
                        try {
                            this.ccStartStopClose(1);
                        }
                        catch (JMSException e) {
                            if (exc != null) break block23;
                            exc = e;
                        }
                    }
                }
                try {
                    this.m_zconnection.startDelivery();
                    this.m_deliveryStarted = true;
                }
                catch (EUnusableConnection e) {
                    if (exc == null) {
                        exc = JMSExceptionUtil.createJMSException(e);
                    }
                }
                catch (ENetworkFailure e) {
                    if (exc == null) {
                        exc = JMSExceptionUtil.createJMSException(e);
                    }
                }
                catch (ESecurityPolicyViolation e) {
                    if (exc == null) {
                        exc = JMSExceptionUtil.createJMSException(e);
                    }
                }
                catch (EGeneralException e) {
                    if (exc != null) break block24;
                    exc = JMSExceptionUtil.createJMSException(e);
                }
            }
            if (exc != null) {
                throw exc;
            }
        }
        finally {
            this.m_startStopLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws JMSException {
        this.beginWaitForConnection();
        this.m_startStopLock.lock();
        try {
            this.checkClosing();
            this.stopImpl();
        }
        finally {
            this.m_startStopLock.unlock();
            this.endWaitForConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopImpl() throws JMSException {
        if (!this.m_deliveryStarted) {
            return;
        }
        this.m_stopping = true;
        try {
            JMSException exc;
            block24: {
                block23: {
                    exc = null;
                    if (this.m_jmsSessions != null) {
                        Vector<Session> sessionsClone;
                        Vector<Session> vector = this.m_jmsSessions;
                        synchronized (vector) {
                            sessionsClone = new Vector<Session>(this.m_jmsSessions);
                        }
                        for (Session session : sessionsClone) {
                            try {
                                session.stop();
                            }
                            catch (JMSException e) {
                                if (exc != null) continue;
                                exc = e;
                            }
                        }
                    }
                    if (this.hasConnectionConsumer()) {
                        try {
                            this.ccStartStopClose(2);
                        }
                        catch (JMSException e) {
                            if (exc != null) break block23;
                            exc = e;
                        }
                    }
                }
                try {
                    this.m_zconnection.stopDelivery();
                    this.m_deliveryStarted = false;
                }
                catch (EUnusableConnection e) {
                    if (exc == null) {
                        exc = JMSExceptionUtil.createJMSException(e);
                    }
                }
                catch (ENetworkFailure e) {
                    if (exc == null) {
                        exc = JMSExceptionUtil.createJMSException(e);
                    }
                }
                catch (ESecurityPolicyViolation e) {
                    if (exc == null) {
                        exc = JMSExceptionUtil.createJMSException(e);
                    }
                }
                catch (EGeneralException e) {
                    if (exc != null) break block24;
                    exc = JMSExceptionUtil.createJMSException(e);
                }
            }
            if (exc != null) {
                throw exc;
            }
        }
        finally {
            this.m_stopping = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JMSException {
        boolean close = false;
        this.beginWaitForConnection();
        this.m_startStopLock.lock();
        try {
            this.m_closeLock.lock();
            if (!this.m_closing && !this.m_closed) {
                this.m_closing = true;
                close = true;
                this.closeImpl();
            }
        }
        finally {
            this.m_startStopLock.unlock();
            try {
                if (close) {
                    this.m_rejectionProc.shutdown();
                }
            }
            finally {
                this.m_closeLock.unlock();
                this.endWaitForConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeImpl() throws JMSException {
        JMSException exc;
        block22: {
            block21: {
                exc = null;
                this.getZConnection().preemptFTReconnect();
                try {
                    this.stopImpl();
                }
                catch (JMSException e) {
                    exc = e;
                }
                if (this.m_jmsSessions != null) {
                    Vector<Session> sessionsClone;
                    Vector<Session> vector = this.m_jmsSessions;
                    synchronized (vector) {
                        sessionsClone = new Vector<Session>(this.m_jmsSessions);
                    }
                    for (Session session : sessionsClone) {
                        try {
                            session.closeInternal();
                        }
                        catch (JMSException e) {
                            if (exc != null) continue;
                            exc = e;
                        }
                    }
                }
                if (this.hasConnectionConsumer()) {
                    try {
                        this.ccStartStopClose(3);
                    }
                    catch (JMSException e) {
                        if (exc != null) break block21;
                        exc = e;
                    }
                }
            }
            this.closeAndRemoveTemporaryQueues();
            this.closeAndRemoveTemporaryTopics();
            try {
                this.removeZConnection(this.m_zconnection);
                try {
                    this.m_zconnection.disconnect(true);
                }
                catch (ENotConnected e) {
                }
                catch (ENetworkFailure e) {
                    throw JMSExceptionUtil.createJMSException(e);
                }
                catch (ESecurityPolicyViolation e) {
                    throw JMSExceptionUtil.createJMSException(e);
                }
                catch (EGeneralException e) {
                    throw JMSExceptionUtil.createJMSException(e);
                }
                this.m_closed = true;
                this.changeConnectionState(3);
            }
            catch (JMSException e) {
                if (exc != null) break block22;
                exc = e;
            }
        }
        this.m_closed = true;
        if (exc != null) {
            Exception linked = exc.getLinkedException();
            if (linked != null && linked instanceof EGeneralException) {
                return;
            }
            throw exc;
        }
    }

    @Override
    public String getUsername() {
        return this.m_zconnection.getEffectiveUid();
    }

    @Override
    public String getConnectID() {
        return this.m_zconnection.getApplicationId();
    }

    @Override
    public final void setPingInterval(long interval) {
        if (this.m_isFaultTolerant && !SessionConfig.FT_SYNC_PING) {
            this.m_zconnection.setAsyncPingInterval(interval);
        } else {
            this.m_zconnection.setSyncPingInterval(interval);
        }
    }

    @Override
    public String getBrokerURL() {
        return this.m_zconnection.getBrokerURL();
    }

    @Override
    public String[] getStandbyBrokerReconnectURLs() {
        String[] urls;
        if (this.isFaultTolerant() && (urls = this.m_zconnection.getStandbyBrokerURLs()) != null && urls.length > 0) {
            return urls;
        }
        return null;
    }

    @Override
    public String[] getBrokerReconnectURLs() {
        if (this.isFaultTolerant()) {
            return this.m_zconnection.getLocalBrokerURLs();
        }
        return null;
    }

    @Override
    public String getRoutingNodeName() {
        if (this.m_zconnection != null) {
            return this.m_zconnection.getRoutingNodeName();
        }
        return null;
    }

    @Override
    public int getConnectionState() {
        return this.m_connectionState;
    }

    @Override
    public void setConnectionStateChangeListener(ConnectionStateChangeListener listener) {
        this.connectionStateChangeListener = listener;
    }

    @Override
    public ConnectionStateChangeListener getConnectionStateChangeListener() {
        return this.connectionStateChangeListener;
    }

    final void addZConnection(progress.message.zclient.Connection zconn) throws ENotConnected {
        if (this.isClosing()) {
            throw new ENotConnected();
        }
        if (!this.m_zconnections.contains(zconn)) {
            this.m_zconnections.add(zconn);
        }
    }

    void removeZConnection(progress.message.zclient.Connection zconn) {
        this.m_zconnections.remove(zconn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAllZConnections() {
        Vector<progress.message.zclient.Connection> zconnsClone;
        Vector<progress.message.zclient.Connection> vector = this.m_zconnections;
        synchronized (vector) {
            zconnsClone = new Vector<progress.message.zclient.Connection>(this.m_zconnections);
        }
        for (progress.message.zclient.Connection zconn : zconnsClone) {
            try {
                if (zconn == null) continue;
                this.removeZConnection(zconn);
                zconn.disconnect(false);
            }
            catch (Exception e) {}
        }
    }

    public final boolean contains(Session session) {
        return this.m_jmsSessions.contains(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addJMSSession(Session session) throws JMSException {
        Vector<Session> vector = this.m_jmsSessions;
        synchronized (vector) {
            if (!this.m_jmsSessions.contains(session)) {
                this.m_jmsSessions.add(session);
            }
        }
        boolean locked = false;
        while (!locked && !this.m_stopping) {
            try {
                locked = this.m_startStopLock.tryLock(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (locked) {
            try {
                if (this.m_deliveryStarted) {
                    session.start();
                }
            }
            finally {
                this.m_startStopLock.unlock();
            }
        }
    }

    final void removeJMSSession(Session session) {
        this.m_jmsSessions.remove(session);
    }

    void onException(JMSException e) {
        if (this.exceptionListener != null) {
            try {
                this.exceptionListener.onException(e);
            }
            catch (RuntimeException exc) {
                exc.printStackTrace();
            }
        }
    }

    public long getBrokerID() {
        return this.m_brokerID;
    }

    long getConnectionID() {
        return this.m_connID;
    }

    ZConnectionFactory getZConnectionFactory() {
        return this.m_zConnectionFactory;
    }

    public String getLocalStoreDirectory() {
        return this.m_storeDir;
    }

    final boolean getNPReplUpgrade() {
        return this.m_zconnection.getNPReplUpgrade();
    }

    @Override
    public boolean isFaultTolerant() {
        return this.m_isFaultTolerant;
    }

    protected String getBrokerMIDPrefix() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNextMessageID() throws EGeneralException, IOException {
        Object object = this.m_lastLocalIdObject;
        synchronized (object) {
            if (++this.m_lastLocalID > 65535L) {
                this.setNewConnectionID();
            }
            return this.m_lastLocalID & 0xFFFFFFFFFFFFFFFFL | (this.m_connID & 0xFFFFFFFFL) << 16;
        }
    }

    public long getNewConnectionID() throws EGeneralException {
        Message idRequest = new Message(SessionConfig.getAdminPrefix(this.m_zconnection.getEffectiveUid(), this.m_zconnection.getApplicationId()) + ".getConnectionID");
        progress.message.zclient.Connection getConnectionIDResolver = this.m_zconnection;
        Message reply = this.m_zconnection.getDefaultSession().request(idRequest, -1, (IJobResolver)getConnectionIDResolver);
        long result = 0L;
        try {
            reply.readLong();
            result = reply.readLong();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void setNewConnectionID() throws EGeneralException, IOException {
        Message idRequest = new Message(SessionConfig.getAdminPrefix(this.m_zconnection.getEffectiveUid(), this.m_zconnection.getApplicationId()) + ".getConnectionID");
        progress.message.zclient.Connection getConnectionIDResolver = this.m_zconnection;
        Message reply = this.m_zconnection.getDefaultSession().request(idRequest, -1, (IJobResolver)getConnectionIDResolver);
        this.m_brokerID = reply.readLong();
        if (this.m_connID != 0L) {
            this.saveOldConnectionID(this.m_connID);
        }
        this.m_connID = reply.readLong();
        this.m_lastLocalID = 0L;
    }

    public boolean isClosing() {
        return this.m_closing;
    }

    public boolean isClosed() {
        return this.m_closed;
    }

    protected void checkClosing() throws JMSException {
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
    }

    protected void checkClosed() throws JMSException {
        if (this.isClosed()) {
            throw this.getJMSObjectClosedException();
        }
    }

    protected JMSException getJMSObjectClosedException() {
        return new IllegalStateException(prAccessor.getString("CONNECTION_CLOSED"), new Integer(-22).toString());
    }

    progress.message.zclient.Session getAckSession() {
        return this.m_ackSession;
    }

    public byte getBrokerSessionVer() {
        return this.m_zconnection == null ? (byte)32 : this.m_zconnection.getBrokerSessionVer();
    }

    boolean isSelectorAtBroker() {
        return this.m_isSelectorAtBroker;
    }

    boolean isDurableMessageOrderEnabled() {
        return this.m_defaultDurableMessageOrder;
    }

    public boolean isDefaultToPersistentDelivery() {
        return this.m_defaultToPersistentDelivery;
    }

    public int getFlowToDisk() {
        return this.m_flowToDisk;
    }

    public boolean getSplitMultiTopicDelivery() {
        return this.m_splitMultiTopicDelivery;
    }

    boolean getRethrowCCRuntimeExceptions() {
        return this.m_rethrowCCRuntimeExceptions;
    }

    public int getQopCacheSize() {
        return this.m_qopCacheSize;
    }

    public int getMaxDeliveryCount() {
        return this.m_maxDeliveryCount;
    }

    final int getAsyncDeliveryMode() {
        return this.m_asyncDeliveryMode;
    }

    final int getDeliveryDoubtWindow() {
        return this.m_deliveryDoubtWindow;
    }

    final long getDeliveryCloseTimeout() {
        return this.m_deliveryCloseTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Enumeration<Session> getSessions() {
        Vector<Session> vector = this.m_jmsSessions;
        synchronized (vector) {
            Vector v = (Vector)this.m_jmsSessions.clone();
            return v.elements();
        }
    }

    public javax.jms.Session getDefaultJSession() {
        return this.m_defaultJSession;
    }

    public void setDefaultJSession(javax.jms.Session session) {
        this.m_defaultJSession = session;
    }

    void changeConnectionState(int newState) {
        if (this.m_connectionState != 3 && this.m_connectionState != newState) {
            this.m_connectionState = newState;
            if (this.connectionStateChangeListener != null) {
                this.connectionStateChangeListener.connectionStateChanged(newState);
            }
        }
    }

    @Override
    public void setCompletionListener(IDoubtResolverCompletionListener listener) {
        this.m_doubtlistener = listener;
    }

    @Override
    public void initiateResolution() throws EGeneralException {
        if (this.isClosing() || this.isClosed()) {
            if (this.m_doubtlistener != null) {
                this.m_doubtlistener.completed(this, 0);
            }
            return;
        }
        if (this.m_doubtlistener != null) {
            this.m_doubtlistener.completed(this, 0);
        }
    }

    @Override
    public void onDisconnectDuringResolution() {
    }

    int getDefaultTxnBatchSize() {
        return this.m_defaultTxnBatchSize;
    }

    final void setPrefetchCount(int count) {
        this.m_prefetchCount = count;
    }

    final int getPrefetchCount() {
        return this.m_prefetchCount;
    }

    final void setPrefetchThreshold(int val) {
        this.m_prefetchThreshold = val;
    }

    final int getPrefetchThreshold() {
        return this.m_prefetchThreshold;
    }

    void setMinimizeSubscriberTraffic(boolean b) {
        this.m_minimizeSubscriberTraffic = b;
    }

    boolean getMinimizeSubscriberTraffic() {
        return this.m_minimizeSubscriberTraffic;
    }

    private void addNondurableCC(MessageConsumer consumer) {
        if (!this.m_NonDurConnConsumers.contains(consumer)) {
            this.m_NonDurConnConsumers.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addQueueReceiver(QueueReceiver receiver) throws JMSException {
        this.addNondurableCC(receiver);
        this.m_startStopLock.lock();
        try {
            if (this.m_deliveryStarted) {
                receiver.start(false);
            }
        }
        finally {
            this.m_startStopLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTopicSubscriber(TopicSubscriber subscriber) throws JMSException {
        this.addNondurableCC(subscriber);
        this.m_startStopLock.lock();
        try {
            if (this.m_deliveryStarted) {
                subscriber.start();
            }
        }
        finally {
            this.m_startStopLock.unlock();
        }
    }

    final void removeNondurableCC(MessageConsumer consumer) {
        this.m_NonDurConnConsumers.remove(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addDurableCC(String name, DurableSubscriber subscriber) throws JMSException {
        DurableSubscriber previousSubscriber = this.m_DurableConnConsumers.put(name, subscriber);
        if (previousSubscriber != null) {
            this.unsubscribe(previousSubscriber);
        }
        this.m_startStopLock.lock();
        try {
            if (this.m_deliveryStarted) {
                subscriber.start();
            }
        }
        finally {
            this.m_startStopLock.unlock();
        }
    }

    final void removeDurableCC(String name) {
        this.m_DurableConnConsumers.remove(name);
    }

    private final boolean hasConnectionConsumer() {
        return this.m_NonDurConnConsumers != null && !this.m_NonDurConnConsumers.isEmpty() || this.m_DurableConnConsumers != null && !this.m_DurableConnConsumers.isEmpty();
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Destination dest, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosing();
        ICCFactory factory = null;
        try {
            Class<?> c = Class.forName(CONNECTION_CONSUMER_FACTORY_CLASS);
            factory = (ICCFactory)c.newInstance();
        }
        catch (Exception e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("LOAD_CLASS_FAILED") + CONNECTION_CONSUMER_FACTORY_CLASS, e);
        }
        if (factory == null) {
            return null;
        }
        return factory.createConnectionConsumer(this, dest, messageSelector, sessionPool, maxMessages);
    }

    @Override
    public final ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosing();
        ICCFactory factory = null;
        try {
            Class<?> c = Class.forName(CONNECTION_CONSUMER_FACTORY_CLASS);
            factory = (ICCFactory)c.newInstance();
        }
        catch (Exception e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("LOAD_CLASS_FAILED") + CONNECTION_CONSUMER_FACTORY_CLASS, e);
        }
        if (factory == null) {
            return null;
        }
        return factory.createDurableConnectionConsumer(this, topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ccStartStopClose(int opCode) throws JMSException {
        if (this.m_NonDurConnConsumers != null) {
            Vector<MessageConsumer> ccs;
            Vector<MessageConsumer> vector = this.m_NonDurConnConsumers;
            synchronized (vector) {
                ccs = new Vector<MessageConsumer>(this.m_NonDurConnConsumers);
            }
            for (MessageConsumer cc : ccs) {
                switch (opCode) {
                    case 1: {
                        cc.start();
                        break;
                    }
                    case 2: {
                        cc.stop();
                        break;
                    }
                    case 3: {
                        cc.close();
                        break;
                    }
                }
            }
        }
        if (this.m_DurableConnConsumers != null) {
            ArrayList<DurableSubscriber> dccs;
            Iterator i$ = this.m_DurableConnConsumers;
            synchronized (i$) {
                dccs = new ArrayList<DurableSubscriber>(this.m_DurableConnConsumers.values());
            }
            for (DurableSubscriber dcc : dccs) {
                switch (opCode) {
                    case 1: {
                        dcc.start();
                        break;
                    }
                    case 2: {
                        dcc.stop();
                        break;
                    }
                    case 3: {
                        dcc.close();
                        break;
                    }
                }
            }
        }
    }

    private void unsubscribe(DurableSubscriber sub) throws JMSException {
        try {
            sub.unsubscribe();
        }
        catch (ENotConnected e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ENetworkFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ESecurityPolicyViolation e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    @Override
    public final Enumeration getUnfinishedChannels() throws JMSException, IOException {
        try {
            ChannelAdmin ca = ChannelAdminFactory.getChannelAdminFactory().createChannelAdmin();
            return ca.getUnfinishedChannels(this);
        }
        catch (ClassNotFoundException e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_NOT_FOUND"), "-2000", e);
        }
        catch (IllegalAccessException e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_PERMISSION_DENIED"), "-2003", e);
        }
        catch (InstantiationException e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_LOAD_EXCEPTION"), "-2002", e);
        }
    }

    @Override
    public final Enumeration getUnfinishedChannelIDs() throws JMSException, IOException {
        try {
            ChannelAdmin ca = ChannelAdminFactory.getChannelAdminFactory().createChannelAdmin();
            return ca.getUnfinishedChannelIDs(this);
        }
        catch (ClassNotFoundException e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_NOT_FOUND"), "-2000", e);
        }
        catch (IllegalAccessException e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_PERMISSION_DENIED"), "-2003", e);
        }
        catch (InstantiationException e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_LOAD_EXCEPTION"), "-2002", e);
        }
    }

    @Override
    public final Channel getChannel(String channelID) throws JMSException, IOException {
        try {
            ChannelAdmin ca = ChannelAdminFactory.getChannelAdminFactory().createChannelAdmin();
            if (ca.hasUnfinishedChannel(channelID, this)) {
                Channel channel = ca.restoreChannel(channelID, this);
                return channel;
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_NOT_FOUND"), "-2000", e);
        }
        catch (IllegalAccessException e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_PERMISSION_DENIED"), "-2003", e);
        }
        catch (InstantiationException e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_LOAD_EXCEPTION"), "-2002", e);
        }
    }

    @Override
    public final boolean hasUnfinishedChannel(String channelID) throws JMSException {
        boolean result = false;
        try {
            ChannelAdmin ca = ChannelAdminFactory.getChannelAdminFactory().createChannelAdmin();
            result = ca.hasUnfinishedChannel(channelID, this);
        }
        catch (ClassNotFoundException e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_NOT_FOUND"), "-2000", e);
        }
        catch (IllegalAccessException e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_PERMISSION_DENIED"), "-2003", e);
        }
        catch (InstantiationException e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_LOAD_EXCEPTION"), "-2002", e);
        }
        return result;
    }

    @Override
    public final boolean hasUnfinishedChannels() throws JMSException {
        boolean result = false;
        try {
            ChannelAdmin ca = ChannelAdminFactory.getChannelAdminFactory().createChannelAdmin();
            result = ca.hasUnfinishedChannels(this);
        }
        catch (ClassNotFoundException e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_NOT_FOUND"), "-2000", e);
        }
        catch (IllegalAccessException e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_PERMISSION_DENIED"), "-2003", e);
        }
        catch (InstantiationException e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_LOAD_EXCEPTION"), "-2002", e);
        }
        return result;
    }

    void addTemporaryQueue(String tempQueueName, TemporaryQueue queue) throws JMSException {
        this.addTemporaryQueue(tempQueueName, queue, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTemporaryQueue(String tempQueueName, TemporaryQueue queue, int maxSize) throws JMSException {
        Object object = this.m_tempQueuesSync;
        synchronized (object) {
            if (this.m_tempQueues == null) {
                this.m_tempQueues = new Hashtable();
            }
            if (null != this.getTemporaryQueue(tempQueueName)) {
                throw JMSExceptionUtil.createJMSException("QUEUE_NAME_ALREADY_EXISTS", null);
            }
            Message req = null;
            Message rep = null;
            try {
                String prefix = SessionConfig.getAdminPrefix(this.m_zconnection.getEffectiveUid(), this.m_zconnection.getApplicationId());
                req = new Message(prefix + ".setTempQueue");
                try {
                    req.writeUTF(tempQueueName);
                    int numAttrs = (queue.isGlobal() ? 1 : 0) + (maxSize != -1 ? 1 : 0);
                    req.writeInt(numAttrs);
                    if (queue.isGlobal()) {
                        req.writeUTF("global");
                        req.writeBoolean(true);
                    }
                    if (maxSize != -1) {
                        req.writeUTF("maxQueueSize");
                        req.writeInt(maxSize);
                    }
                }
                catch (Exception e) {
                    throw JMSExceptionUtil.createJMSException(e);
                }
                finally {
                    req.close();
                }
                progress.message.zclient.Connection setTempQueueResolver = this.m_zconnection;
                rep = this.m_zconnection.getInternalSession().request(req, -1, (IJobResolver)setTempQueueResolver);
            }
            catch (Exception e) {
                throw JMSExceptionUtil.createJMSException(e);
            }
            boolean b = false;
            try {
                b = rep.readBoolean();
            }
            catch (Exception e) {
                throw JMSExceptionUtil.createJMSException(e);
            }
            if (!b) {
                try {
                    String errmsg = rep.readUTF();
                    int errcode = rep.readInt();
                    if (errcode == -42) {
                        throw new ETemporaryQueueLimitExceeded(errmsg);
                    }
                    throw JMSExceptionUtil.createJMSException(errmsg, null);
                }
                catch (Exception ee) {
                    throw JMSExceptionUtil.createJMSException(ee);
                }
            }
            this.m_tempQueues.put(tempQueueName, queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTemporaryQueue(String tempQueueName) throws JMSException {
        Object object = this.m_tempQueuesSync;
        synchronized (object) {
            if (this.m_tempQueues == null || this.m_tempQueues.isEmpty()) {
                return;
            }
            Destination dest = this.m_tempQueues.get(tempQueueName);
            if (dest != null) {
                Enumeration<Session> sessions = this.getSessions();
                while (sessions.hasMoreElements()) {
                    Session sess = sessions.nextElement();
                    sess.assertTempDestIsDeletable(dest);
                }
            }
            Message req = null;
            Message rep = null;
            try {
                String prefix = SessionConfig.getAdminPrefix(this.m_zconnection.getEffectiveUid(), this.m_zconnection.getApplicationId());
                req = new Message(prefix + ".delTempQueue");
                try {
                    req.writeUTF(tempQueueName);
                }
                catch (Exception e) {
                    throw JMSExceptionUtil.createJMSException(e);
                }
                finally {
                    req.close();
                }
                progress.message.zclient.Connection delTempQueueResolver = this.m_zconnection;
                rep = this.m_zconnection.getInternalSession().request(req, -1, (IJobResolver)delTempQueueResolver);
            }
            catch (Exception e) {
                throw JMSExceptionUtil.createJMSException(e);
            }
            boolean b = false;
            try {
                b = rep.readBoolean();
            }
            catch (Exception e) {
                throw JMSExceptionUtil.createJMSException(e);
            }
            if (!b) {
                try {
                    String errmsg = rep.readUTF();
                    rep.readInt();
                    throw JMSExceptionUtil.createJMSException(errmsg, null);
                }
                catch (Exception ee) {
                    throw JMSExceptionUtil.createJMSException(ee);
                }
            }
            this.m_tempQueues.remove(tempQueueName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TemporaryQueue getTemporaryQueue(String tempQueueName) {
        Object object = this.m_tempQueuesSync;
        synchronized (object) {
            if (this.m_tempQueues == null || this.m_tempQueues.isEmpty()) {
                return null;
            }
            return this.m_tempQueues.get(tempQueueName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndRemoveTemporaryQueues() {
        Object object = this.m_tempQueuesSync;
        synchronized (object) {
            if (this.m_tempQueues != null && !this.m_tempQueues.isEmpty()) {
                ArrayList<TemporaryQueue> tempQueuesClone;
                Hashtable<String, TemporaryQueue> hashtable = this.m_tempQueues;
                synchronized (hashtable) {
                    tempQueuesClone = new ArrayList<TemporaryQueue>(this.m_tempQueues.values());
                }
                for (TemporaryQueue tempQueue : tempQueuesClone) {
                    try {
                        tempQueue.delete();
                    }
                    catch (Exception e) {}
                }
                this.m_tempQueues.clear();
            }
            this.m_tempQueues = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTemporaryTopic(String tempTopicName, TemporaryTopic topic) throws JMSException {
        Object object = this.m_tempTopicsSync;
        synchronized (object) {
            if (this.m_tempTopics == null) {
                this.m_tempTopics = new Hashtable();
            }
            if (null != this.getTemporaryTopic(tempTopicName)) {
                throw JMSExceptionUtil.createJMSException("TOPIC_NAME_ALREADY_EXISTS", null);
            }
            this.m_tempTopics.put(tempTopicName, topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTemporaryTopic(String tempTopicName) throws JMSException {
        Object object = this.m_tempTopicsSync;
        synchronized (object) {
            if (this.m_tempTopics == null || this.m_tempTopics.isEmpty()) {
                return;
            }
            Destination dest = this.m_tempTopics.get(tempTopicName);
            if (dest != null) {
                Enumeration<Session> sessions = this.getSessions();
                while (sessions.hasMoreElements()) {
                    Session sess = sessions.nextElement();
                    sess.assertTempDestIsDeletable(dest);
                }
            }
            this.m_tempTopics.remove(tempTopicName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TemporaryTopic getTemporaryTopic(String tempTopicName) {
        Object object = this.m_tempTopicsSync;
        synchronized (object) {
            if (this.m_tempTopics == null || this.m_tempTopics.isEmpty()) {
                return null;
            }
            return this.m_tempTopics.get(tempTopicName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndRemoveTemporaryTopics() {
        Object object = this.m_tempTopicsSync;
        synchronized (object) {
            if (this.m_tempTopics != null && !this.m_tempTopics.isEmpty()) {
                ArrayList<TemporaryTopic> tempTopicsClone;
                Hashtable<String, TemporaryTopic> hashtable = this.m_tempTopics;
                synchronized (hashtable) {
                    tempTopicsClone = new ArrayList<TemporaryTopic>(this.m_tempTopics.values());
                }
                for (TemporaryTopic tempTopic : tempTopicsClone) {
                    try {
                        tempTopic.delete();
                    }
                    catch (Exception e) {}
                }
                this.m_tempTopics.clear();
            }
            this.m_tempTopics = null;
        }
    }

    @Override
    public javax.jms.Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.createSession(transacted, acknowledgeMode, null);
    }

    @Override
    public javax.jms.Session createSession(boolean transacted, int acknowledgeMode, String sessionName) throws JMSException {
        this.checkClosed();
        Session sess = new Session(this, transacted, acknowledgeMode, sessionName);
        if (!transacted) {
            sess.setSendTimeout(this.m_sendTimeoutMs);
        }
        return sess;
    }

    protected void saveOldConnectionID(long connID) {
    }

    protected boolean wasOldConnID(long connID) {
        return false;
    }

    public void setEnableActionalInstrumentation(boolean isInstrumented, boolean isJmsNodeRequired) throws JMSException {
        int nodeType = -1;
        if (isJmsNodeRequired) {
            nodeType = 1;
        }
        try {
            this.m_zconnection.notifyNewLGSetting(isInstrumented, nodeType);
        }
        catch (Exception e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    private void beginWaitForConnection() {
        this.m_invocationMap.push(Thread.currentThread(), this);
    }

    private void endWaitForConnection() {
        this.m_invocationMap.pop(Thread.currentThread());
    }

    void beginWaitForSession(Session session) {
        this.m_invocationMap.push(Thread.currentThread(), session);
    }

    void endWaitForSession(Session session) {
        this.m_invocationMap.pop(Thread.currentThread());
    }

    boolean isWaitingForSession(Thread thread, Session session) {
        return this.m_invocationGraph.isPath(thread, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDispatcher(Thread dispatcher, Session session) {
        BiDirMap biDirMap = this.m_sessionMap;
        synchronized (biDirMap) {
            this.m_sessionMap.put(dispatcher, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDispatcher(Thread dispatcher) {
        BiDirMap biDirMap = this.m_sessionMap;
        synchronized (biDirMap) {
            this.m_sessionMap.removeKey(dispatcher);
        }
    }

    public void setMetricsListener(IMetricsListener listener) {
        this.m_zconnection.setMetricsListener(listener);
    }

    public IMetricsListener getMetricsListener() {
        return this.m_zconnection.getMetricsListener();
    }

    public boolean isCompressionEnabled() {
        return this.m_zconnection.getCompressionFactory() != null;
    }

    @Override
    public int getMonitorInterval() {
        return this.m_zconnection.getMonitorInterval();
    }

    @Override
    public boolean isEnterpriseEnabled() {
        return this.m_zconnection.isEnterpriseEdition();
    }

    static {
        Class<Session> clazz = Session.class;
    }

    class DefaultMessageHandler
    extends MessageHandler
    implements IMessageHandler {
        public DefaultMessageHandler() throws JMSException {
            super(null, true, true);
            try {
                this.replaceHandler(this);
            }
            catch (EInvalidSubjectSyntax eiss) {
                throw JMSExceptionUtil.createJMSException(eiss);
            }
            catch (EGeneralException ge) {
                throw JMSExceptionUtil.createJMSException(ge);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(progress.message.zclient.Session session, Envelope envelope) {
            if ("$SYS.client.brokerConnectionReconnected".equals(envelope.getMessage().getSubject().getSubjectString())) {
                Connection.this.changeConnectionState(0);
            }
            if ("$SYS.client.brokerConnectionReconnecting".equals(envelope.getMessage().getSubject().getSubjectString())) {
                Connection.this.changeConnectionState(1);
            }
            if ("$SYS.client.brokerConnectionDropped".equals(envelope.getMessage().getSubject().getSubjectString())) {
                Connection.this.changeConnectionState(2);
                JMSException jmse = null;
                ExceptionListener el = Connection.this.exceptionListener;
                if (el != null) {
                    Throwable cause;
                    int errcode = -5;
                    int errinfo = 0;
                    String errdesc = "Connection dropped";
                    try {
                        errcode = envelope.getMessage().readByte();
                        errinfo = envelope.getMessage().readInt();
                        errdesc = envelope.getMessage().readUTF();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Exception e = null;
                    switch (errcode) {
                        case -39: {
                            errcode = -5;
                            if (errinfo == 129) {
                                String msgf = prAccessor.getString("CONN_ALREADY_EXISTS");
                                Object[] obj = new Object[]{Connection.this.getConnectID(), Connection.this.getUsername()};
                                String result = prMessageFormat.format(msgf, obj);
                                e = new EUserAlreadyConnected(result);
                                break;
                            }
                            if (errinfo == 126) {
                                e = new EBrokerStateDiscarded(prAccessor.getString("CONNECTION_STATE_DISCARDED"));
                                break;
                            }
                            if (errinfo == 124) {
                                e = new EExclusiveQueueOpen(prAccessor.getString("EXCLUSIVE_Q_ALREADY_OPEN"));
                                break;
                            }
                            e = new EConnectionNotResumable("Unresumable because of error:" + Integer.toString(errinfo), null);
                            break;
                        }
                        case -3: {
                            e = new EIntegrityCompromised();
                            break;
                        }
                        case -20: {
                            e = new EUnexpectedMgram(null);
                            break;
                        }
                        default: {
                            e = new IOException("" + errcode);
                        }
                    }
                    progress.message.zclient.Connection zConn = Connection.this.m_zconnection;
                    if (zConn != null && (cause = zConn.getSocketDropCause()) != null) {
                        e.initCause(cause);
                    }
                    jmse = JMSExceptionUtil.createJMSException(errdesc, new Integer(errcode).toString(), e);
                }
                try {
                    if (!Connection.this.m_closing && !Connection.this.m_closed) {
                        Connection.this.close();
                    }
                }
                catch (JMSException ignored) {
                }
                finally {
                    Connection.this.closeAllZConnections();
                }
                if (jmse != null) {
                    el.onException(jmse);
                }
            }
            envelope.handlerDone(Connection.this.m_zmessageHandler.isGuaranteed(), false);
        }
    }

    static class InvocationGraph {
        private final BiDirMap sessionMap;
        private final InvocationMap invocationMap;

        public InvocationGraph(BiDirMap sessionMap, InvocationMap invocationMap) {
            this.sessionMap = sessionMap;
            this.invocationMap = invocationMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPath(Thread thread, Object session) {
            InvocationMap invocationMap = this.invocationMap;
            synchronized (invocationMap) {
                return this.isPath(thread, session, new HashSet<Thread>());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isPath(Thread thread, Object obj, Set<Thread> visited) {
            if (visited.contains(thread)) {
                return false;
            }
            visited.add(thread);
            for (Object o : this.invocationMap.getInvocationStack(thread)) {
                if (o instanceof Connection || o == obj) {
                    return true;
                }
                Thread otherThread = null;
                BiDirMap biDirMap = this.sessionMap;
                synchronized (biDirMap) {
                    otherThread = (Thread)this.sessionMap.getKey(o);
                }
                if (otherThread == null || !this.isPath(otherThread, obj, visited)) continue;
                return true;
            }
            return false;
        }
    }

    static class StopCloseInvocationMap
    extends InvocationMap {
        private final BiDirMap sessionMap;

        public StopCloseInvocationMap(BiDirMap sessionMap) {
            this.sessionMap = sessionMap;
        }

        @Override
        public void push(Thread thread, Object obj) {
            super.push(thread, obj);
            this.notifyCloseLock(thread);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyCloseLock(Thread thread) {
            Session session;
            BiDirMap biDirMap = this.sessionMap;
            synchronized (biDirMap) {
                session = (Session)this.sessionMap.getValue(thread);
            }
            if (session != null) {
                Object lock;
                Object object = lock = session.getCloseLock();
                synchronized (object) {
                    lock.notifyAll();
                }
            }
        }
    }

    static class InvocationMap {
        private final Map<Thread, List<Object>> threads = new HashMap<Thread, List<Object>>();

        public synchronized void push(Thread thread, Object obj) {
            List<Object> stack = this.threads.get(thread);
            if (stack == null) {
                stack = new ArrayList<Object>();
                this.threads.put(thread, stack);
            }
            stack.add(obj);
        }

        public synchronized Object pop(Thread thread) {
            List<Object> stack = this.threads.get(thread);
            Object obj = null;
            if (stack != null) {
                obj = stack.remove(stack.size() - 1);
                if (stack.isEmpty()) {
                    this.threads.remove(thread);
                }
            }
            return obj;
        }

        List<Object> getInvocationStack(Thread thread) {
            List<Object> stack = this.threads.get(thread);
            if (stack == null) {
                stack = Collections.emptyList();
            }
            return stack;
        }
    }
}

