/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.io.IOException;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import progress.message.client.EGeneralException;
import progress.message.client.prAccessor;
import progress.message.jclient.Constants;
import progress.message.jclient.DeliveryMode;
import progress.message.jclient.DestinationFactory;
import progress.message.jclient.MultipartMessage;
import progress.message.jimpl.ChannelAdmin;
import progress.message.jimpl.ChannelAdminFactory;
import progress.message.jimpl.DestUtil;
import progress.message.jimpl.Destination;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Message;
import progress.message.jimpl.MultiTopic;
import progress.message.jimpl.Session;
import progress.message.util.DraDestUtil;
import progress.message.util.jclient.MessageUtil;
import progress.message.zclient.Connection;
import progress.message.zclient.Envelope;
import progress.message.zclient.IJobResolver;
import progress.message.zclient.SessionConfig;

public class MessageProducer
implements progress.message.jclient.MessageProducer {
    static final int DEFAULT_PRIORITY = 4;
    Session m_jsession = null;
    javax.jms.Destination m_appDest = null;
    Destination m_dest = null;
    long m_timeToLive = 0L;
    long m_deliveryDelay = 0L;
    int m_deliveryMode = 1;
    int m_priority = 4;
    boolean m_disableMessageID = false;
    boolean m_disableTimestamp = false;
    protected boolean m_isSecure = false;
    boolean m_closing = false;
    private long m_brokerID;
    private String m_brokerMIDPrefix;
    private boolean m_isBound = true;
    protected final boolean m_NPReplUpgrade;

    public MessageProducer(Session session, javax.jms.Destination dest) throws JMSException {
        this.m_jsession = session;
        this.m_isSecure = this.m_jsession.m_jconnection.isSecure();
        this.m_NPReplUpgrade = this.m_jsession.m_jconnection.getNPReplUpgrade() && this.m_jsession.m_jconnection.isFaultTolerant();
        this.m_appDest = dest;
        if (this.m_appDest != null) {
            this.m_dest = (Destination)DestinationFactory.createSonicDestination(this.m_appDest);
            if (this.m_dest instanceof MultiTopic) {
                this.m_dest = ((MultiTopic)this.m_dest).protectedClone();
                this.m_appDest = this.m_dest;
            }
            this.m_isBound = true;
        } else {
            this.m_isBound = false;
        }
        this.m_brokerID = this.m_jsession.m_jconnection.getBrokerID();
        this.m_brokerMIDPrefix = this.m_jsession.m_jconnection.getBrokerMIDPrefix();
        if (this.m_dest instanceof Queue) {
            this.makeOpenRequest();
        }
        session.addProducer(this);
    }

    @Override
    public void setDisableMessageID(boolean value) throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        this.m_disableMessageID = value;
    }

    @Override
    public boolean getDisableMessageID() throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        return this.m_disableMessageID;
    }

    @Override
    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        this.m_disableTimestamp = value;
    }

    @Override
    public boolean getDisableMessageTimestamp() throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        return this.m_disableTimestamp;
    }

    @Override
    public final void setDeliveryMode(int deliveryMode) throws JMSException {
        if (this.m_isBound && deliveryMode == DeliveryMode.DISCARDABLE) {
            if (this.m_appDest instanceof Queue) {
                throw new IllegalStateException(prAccessor.getString("DISCARDABLE_INVALID"));
            }
            if (this.m_appDest instanceof Topic && this.m_jsession.getTransactedFlag()) {
                throw new IllegalStateException(prAccessor.getString("DISCARDABLE_INVALID"));
            }
        }
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        this.m_deliveryMode = deliveryMode;
    }

    @Override
    public int getDeliveryMode() throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        return this.m_deliveryMode;
    }

    @Override
    public int getPriority() throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        return this.m_priority;
    }

    @Override
    public void setTimeToLive(long timeToLive) throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        this.validateDeliveryDelay(this.m_deliveryDelay, timeToLive);
        this.m_timeToLive = timeToLive;
    }

    @Override
    public long getTimeToLive() throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        return this.m_timeToLive;
    }

    @Override
    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        this.validateDeliveryDelay(deliveryDelay, this.m_timeToLive);
        this.m_deliveryDelay = deliveryDelay;
    }

    @Override
    public long getDeliveryDelay() throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        return this.m_deliveryDelay;
    }

    @Override
    public void close() throws JMSException {
        this.m_closing = true;
        this.m_jsession.removeProducer(this);
    }

    boolean isClosing() {
        return this.m_closing;
    }

    public final void internalSend(Queue queue, javax.jms.Message message, int deliveryMode, int priority, long timeToLive, long deliveryDelay) throws JMSException {
        Message jmessage = null;
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        if (queue == null) {
            throw new UnsupportedOperationException(prAccessor.getString("DEST_Q_NULL"));
        }
        Destination jDest = (Destination)DestinationFactory.createSonicDestination(queue);
        jDest.validateForSend(message);
        if (message instanceof Message) {
            Message m = (Message)message;
            jmessage = (Message)m.protectedClone();
        } else {
            jmessage = MessageUtil.copyMessage(message, this.m_jsession);
        }
        if (priority == 4) {
            priority = 4;
        }
        if (priority < 0 || priority > 9) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("PRI_OUT_RANGE"), null);
        }
        jmessage.m_zenvelope.setPtp((byte)12);
        javax.jms.Destination replyTo = jmessage.getReplyTo(true, true);
        jmessage.setJMSDestination(queue);
        jmessage.setDefaultRoutingForURLDestination(queue);
        jmessage.validateUndeliveredDestination(queue, this.m_jsession.getJconnection().getRoutingNodeName());
        jmessage.adjustJMSReplyTo(queue, this.m_jsession, replyTo);
        if (!this.m_disableMessageID) {
            try {
                jmessage.setJMSMessageID(null);
                jmessage.setMessageID(this.m_brokerID, this.m_jsession.m_jconnection.getNextMessageID(), this.m_brokerMIDPrefix);
            }
            catch (EGeneralException ge) {
                throw JMSExceptionUtil.createJMSException(ge);
            }
            catch (IOException e) {
                throw JMSExceptionUtil.createJMSException(e);
            }
        }
        jmessage.setJMSRedelivered(false);
        if (this.m_NPReplUpgrade && (deliveryMode == 1 || deliveryMode == DeliveryMode.NON_PERSISTENT_ASYNC || deliveryMode == DeliveryMode.NON_PERSISTENT_SYNC)) {
            deliveryMode = DeliveryMode.NON_PERSISTENT_REPLICATED;
        }
        jmessage.setJMSDeliveryMode(deliveryMode);
        jmessage.setJMSPriority(priority);
        if (jmessage instanceof MultipartMessage) {
            jmessage.setExtendedType("x-sonicmq-multipart");
        } else {
            jmessage.setExtendedType(null);
        }
        jmessage.m_zenvelope.getMgram().getRoutingHandle().setGSAPublication(false);
        jmessage.m_zenvelope.getProperties().remove("JMSXDeliveryCount");
        jmessage.marshal();
        ChannelAdmin ca = null;
        if (jmessage.hasChannelReference()) {
            try {
                if (this.m_jsession.getTransactedFlag()) {
                    throw new IllegalStateException(prAccessor.getString("CHANNEL_SEND_ON_TXN_SESSION"));
                }
                ca = ChannelAdminFactory.getChannelAdminFactory().createChannelAdmin(jmessage.getChannel());
                ca.connect(jmessage, this.m_jsession.getJconnection());
                ca.preSend();
            }
            catch (ClassNotFoundException e) {
                throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_NOT_FOUND"), "-2000", e);
            }
            catch (IllegalAccessException e) {
                throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_PERMISSION_DENIED"), "-2003", e);
            }
            catch (InstantiationException e) {
                throw JMSExceptionUtil.createJMSException(prAccessor.getString("CHANNEL_CLASS_LOAD_EXCEPTION"), "-2002", e);
            }
        }
        long currentTime = System.currentTimeMillis();
        long expiration = timeToLive > 0L ? currentTime + timeToLive : 0L;
        jmessage.setJMSExpiration(expiration);
        this.doJMSDeliveryDelaySupport(currentTime, timeToLive, deliveryDelay, jmessage.getEnvelope());
        boolean sync = false;
        sync = this.m_jsession.getTransactedFlag() ? true : (this.m_jsession.getAsyncDeliveryMode() == Constants.ASYNC_DELIVERY_MODE_ENABLED.intValue() ? (deliveryMode == DeliveryMode.NON_PERSISTENT_SYNC ? true : (deliveryMode == DeliveryMode.NON_PERSISTENT_REPLICATED || deliveryMode == 2 ? false : false)) : (this.m_jsession.getAsyncDeliveryMode() == Constants.ASYNC_DELIVERY_MODE_DISABLED.intValue() ? deliveryMode != DeliveryMode.NON_PERSISTENT_ASYNC : (deliveryMode == DeliveryMode.NON_PERSISTENT_ASYNC ? false : (deliveryMode == 1 ? true : (deliveryMode == 2 ? true : (deliveryMode == DeliveryMode.NON_PERSISTENT_REPLICATED ? true : (deliveryMode == DeliveryMode.NON_PERSISTENT_SYNC ? true : true)))))));
        this.m_jsession.send(queue, jmessage, sync, true);
        if (jmessage.hasChannelReference()) {
            ca.internalCompleteConnection();
            ca.connectionMade();
        }
        message.setJMSDeliveryMode(jmessage.getJMSDeliveryMode());
        message.setJMSMessageID(jmessage.getJMSMessageID());
        message.setJMSTimestamp(jmessage.getJMSTimestamp());
        message.setJMSExpiration(jmessage.getJMSExpiration());
        message.setJMSPriority(jmessage.getJMSPriority());
        message.setJMSDestination(jmessage.getJMSDestination());
        if (jmessage.getEnvelope().getDeliveryTime() > 0L) {
            message.setLongProperty("JMSDeliveryTime", jmessage.getEnvelope().getDeliveryTime());
        }
    }

    public final void internalPublish(Topic topic, javax.jms.Message message, int deliveryMode, int priority, long timeToLive, long deliveryDelay) throws JMSException {
        Message jmessage;
        boolean isSonic;
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        if (topic == null) {
            throw new InvalidDestinationException(prAccessor.getString("TOP_PUB_UNIDENT_TOPIC"));
        }
        Destination jDest = (Destination)DestinationFactory.createSonicDestination(topic);
        jDest.validateForSend(message);
        if (message instanceof Message) {
            isSonic = true;
            Message m = (Message)message;
            if (m.hasChannel()) {
                throw new IllegalStateException(prAccessor.getString("CHANNEL_PUSUB_UNSUPPORTED"));
            }
            jmessage = (Message)m.protectedClone();
        } else {
            isSonic = false;
            jmessage = MessageUtil.copyMessage(message, this.m_jsession);
        }
        Envelope jmessageEnv = jmessage.getEnvelope();
        try {
            javax.jms.Destination replyTo = jmessage.getReplyTo(true, true);
            jmessage.setJMSDestination(topic);
            jmessage.setDefaultRoutingForURLDestination(topic);
            jmessage.validateUndeliveredDestination(topic, this.m_jsession.getJconnection().getRoutingNodeName());
            if (jmessageEnv.getRouting() != null && this.m_jsession.m_jconnection.getBrokerSessionVer() < 25) {
                throw new InvalidDestinationException(prAccessor.getString("REMOTE_PUBSUB_NOT_SUPPORTED"));
            }
            jmessage.adjustJMSReplyTo(topic, this.m_jsession, replyTo);
            jmessage.setJMSMessageID(null);
            jmessage.setMessageID(this.m_brokerID, this.m_jsession.m_jconnection.getNextMessageID(), null);
            jmessage.setJMSRedelivered(false);
        }
        catch (EGeneralException ge) {
            throw JMSExceptionUtil.createJMSException(ge);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        if (this.m_NPReplUpgrade && (deliveryMode == 1 || deliveryMode == DeliveryMode.NON_PERSISTENT_ASYNC || deliveryMode == DeliveryMode.NON_PERSISTENT_SYNC)) {
            deliveryMode = DeliveryMode.NON_PERSISTENT_REPLICATED;
        }
        jmessageEnv.setDeliveryMode(deliveryMode);
        jmessageEnv.setPriority((byte)(priority & 0xFF));
        if (jmessage instanceof MultipartMessage) {
            jmessage.setExtendedType("x-sonicmq-multipart");
        } else {
            jmessage.setExtendedType(null);
        }
        jmessageEnv.getMgram().getRoutingHandle().setGSAPublication(false);
        jmessage.marshal();
        jmessageEnv.ptpToPubsub();
        long currentTime = System.currentTimeMillis();
        if (timeToLive > 0L) {
            jmessageEnv.setExpirationTime(currentTime + timeToLive);
        } else {
            jmessageEnv.setExpirationTime(0L);
        }
        this.doJMSDeliveryDelaySupport(currentTime, timeToLive, deliveryDelay, jmessageEnv);
        boolean sync = false;
        boolean acked = false;
        if (this.m_jsession.m_jconnection.getBrokerSessionVer() >= 25 && this.m_jsession.getTransactedFlag()) {
            sync = true;
        } else if (this.m_jsession.getAsyncDeliveryMode() == Constants.ASYNC_DELIVERY_MODE_ENABLED.intValue()) {
            if (deliveryMode == DeliveryMode.NON_PERSISTENT_SYNC) {
                sync = true;
            } else if (deliveryMode == DeliveryMode.NON_PERSISTENT_REPLICATED || deliveryMode == 2) {
                sync = false;
                acked = true;
            } else {
                sync = false;
            }
        } else if (this.m_jsession.getAsyncDeliveryMode() == Constants.ASYNC_DELIVERY_MODE_DISABLED.intValue()) {
            sync = deliveryMode != DeliveryMode.NON_PERSISTENT_ASYNC && deliveryMode != DeliveryMode.DISCARDABLE;
        } else if (deliveryMode == DeliveryMode.NON_PERSISTENT_ASYNC || deliveryMode == DeliveryMode.DISCARDABLE) {
            sync = false;
        } else if (deliveryMode == 1) {
            sync = this.m_isSecure;
        } else if (deliveryMode == 2) {
            acked = true;
            if (this.m_isSecure) {
                sync = true;
            } else if (this.m_jsession.getTransactedFlag()) {
                sync = false;
                acked = false;
            } else {
                sync = true;
            }
        } else if (deliveryMode == DeliveryMode.NON_PERSISTENT_REPLICATED) {
            sync = true;
            acked = true;
        } else {
            sync = deliveryMode == DeliveryMode.NON_PERSISTENT_SYNC ? true : true;
        }
        this.m_jsession.send(topic, jmessage, sync, acked);
        if (isSonic) {
            Envelope messageEnv = ((Message)message).getEnvelope();
            messageEnv.setDeliveryMode(jmessage.getJMSDeliveryMode());
            messageEnv.setTimestamp(jmessageEnv.getTimestamp());
            message.setJMSMessageID(null);
            messageEnv.setMessageID(jmessageEnv.getBrokerID(), jmessageEnv.getConnectionAndLocalID(), null);
            messageEnv.setExpirationTime(jmessageEnv.getExpirationTime());
            if (jmessage.getEnvelope().getDeliveryTime() > 0L) {
                messageEnv.setDeliveryTime(jmessageEnv.getDeliveryTime());
            }
            messageEnv.setPriority(jmessageEnv.getPriority());
            messageEnv.getMessage().setSubject(jmessageEnv.getMessage().getSubject());
            messageEnv.setRouting(jmessageEnv.getRouting());
        } else {
            message.setJMSDeliveryMode(jmessage.getJMSDeliveryMode());
            message.setJMSTimestamp(jmessage.getJMSTimestamp());
            message.setJMSMessageID(jmessage.getJMSMessageID());
            message.setJMSExpiration(jmessage.getJMSExpiration());
            message.setJMSPriority(jmessage.getJMSPriority());
            message.setJMSDestination(jmessage.getJMSDestination());
            if (jmessage.getEnvelope().getDeliveryTime() > 0L) {
                message.setLongProperty("JMSDeliveryTime", jmessage.getEnvelope().getDeliveryTime());
            }
        }
    }

    private void doJMSDeliveryDelaySupport(long currentTime, long sendTimeToLive, long producerDeliveryDelay, Envelope message) throws JMSException {
        long currentDeliveryDelay = producerDeliveryDelay;
        Long sonicDeliveryDelay = (Long)message.getProperty("JMS_SonicMQ_deliveryDelay");
        if (sonicDeliveryDelay != null) {
            currentDeliveryDelay = sonicDeliveryDelay;
        }
        if (currentDeliveryDelay != 0L) {
            this.validateDeliveryDelay(currentDeliveryDelay, sendTimeToLive);
            long deliveryTime = currentTime + currentDeliveryDelay;
            message.setDeliveryTime(deliveryTime);
        }
    }

    private void validateDeliveryDelay(long deliveryDelay, long timeToLive) throws JMSException {
        if (deliveryDelay != 0L) {
            if (deliveryDelay < 0L) {
                throw JMSExceptionUtil.createJMSException(prAccessor.getString("NEGATIVE_DELAY"), null);
            }
            if (timeToLive > 0L && deliveryDelay > timeToLive) {
                throw JMSExceptionUtil.createJMSException(prAccessor.getString("INVALID_DELAY"), null);
            }
        }
    }

    private void makeOpenRequest() throws JMSException {
        try {
            String userid = this.m_jsession.m_zconnection.getEffectiveUid();
            String appid = this.m_jsession.m_zconnection.getApplicationId();
            progress.message.zclient.Message openReq = new progress.message.zclient.Message(SessionConfig.getAdminPrefix(userid, appid) + ".openSender");
            String destination = DestUtil.getDestinationName(this.m_appDest);
            String routing = DestUtil.getRoutingName(this.m_appDest);
            openReq.writeUTF(destination);
            if (routing == null) {
                if (DraDestUtil.isHttpOrHttps(destination)) {
                    routing = DraDestUtil.SONIC_HTTP;
                } else {
                    openReq.writeBoolean(false);
                }
            }
            if (routing != null) {
                openReq.writeBoolean(true);
                openReq.writeUTF(routing);
            }
            Envelope openEnvelope = new Envelope(openReq);
            Connection openSenderResolver = this.m_jsession.getAckSession().getConnection();
            progress.message.zclient.Message reply = this.m_jsession.getAckSession().request(openEnvelope, -1, (IJobResolver)openSenderResolver);
            boolean success = reply.readBoolean();
            if (!success) {
                String errmsg = reply.readUTF();
                int errcode = reply.readInt();
                if (errcode == 3005) {
                    throw new InvalidDestinationException(errmsg);
                }
                throw JMSExceptionUtil.createJMSException(errmsg, null);
            }
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    @Override
    public final void setPriority(int priority) throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        if (priority == 4) {
            priority = 4;
        }
        if (priority < 0 || priority > 9) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("PRI_OUT_RANGE"), null);
        }
        this.m_priority = priority;
    }

    @Override
    public void send(javax.jms.Message message) throws JMSException, UnsupportedOperationException {
        if (this.m_appDest == null) {
            throw new UnsupportedOperationException(prAccessor.getString("DEST_D_NULL"));
        }
        if (this.m_appDest instanceof Topic) {
            this.internalPublish((Topic)this.m_appDest, message, this.m_deliveryMode, this.m_priority, this.m_timeToLive, this.m_deliveryDelay);
        } else {
            this.internalSend((Queue)this.m_appDest, message, this.m_deliveryMode, this.m_priority, this.m_timeToLive, this.m_deliveryDelay);
        }
    }

    @Override
    public void send(javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException, UnsupportedOperationException {
        if (this.m_appDest == null) {
            throw new UnsupportedOperationException(prAccessor.getString("DEST_D_NULL"));
        }
        if (this.m_appDest instanceof Topic) {
            if (deliveryMode == DeliveryMode.DISCARDABLE && this.m_jsession.getTransactedFlag()) {
                throw new IllegalStateException(prAccessor.getString("DISCARDABLE_INVALID"));
            }
            this.internalPublish((Topic)this.m_appDest, message, deliveryMode, priority, timeToLive, this.m_deliveryDelay);
        } else {
            if (deliveryMode == DeliveryMode.DISCARDABLE) {
                throw new IllegalStateException(prAccessor.getString("DISCARDABLE_INVALID"));
            }
            this.internalSend((Queue)this.m_appDest, message, deliveryMode, priority, timeToLive, this.m_deliveryDelay);
        }
    }

    @Override
    public final void send(javax.jms.Destination destination, javax.jms.Message message) throws JMSException, UnsupportedOperationException {
        if (this.m_appDest != null) {
            throw new UnsupportedOperationException(prAccessor.getString("DEST_D_ALREADY_SET"));
        }
        if (destination instanceof Topic) {
            this.internalPublish((Topic)destination, message, this.m_deliveryMode, this.m_priority, this.m_timeToLive, this.m_deliveryDelay);
        } else {
            this.internalSend((Queue)destination, message, this.m_deliveryMode, this.m_priority, this.m_timeToLive, this.m_deliveryDelay);
        }
    }

    @Override
    public final void send(javax.jms.Destination destination, javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException, UnsupportedOperationException {
        if (this.m_appDest != null) {
            throw new UnsupportedOperationException(prAccessor.getString("DEST_D_ALREADY_SET"));
        }
        if (destination instanceof Topic) {
            if (deliveryMode == DeliveryMode.DISCARDABLE && this.m_jsession.getTransactedFlag()) {
                throw new IllegalStateException(prAccessor.getString("DISCARDABLE_INVALID"));
            }
            this.internalPublish((Topic)destination, message, deliveryMode, priority, timeToLive, this.m_deliveryDelay);
        } else {
            if (deliveryMode == DeliveryMode.DISCARDABLE) {
                throw new IllegalStateException(prAccessor.getString("DISCARDABLE_INVALID"));
            }
            this.internalSend((Queue)destination, message, deliveryMode, priority, timeToLive, this.m_deliveryDelay);
        }
    }

    @Override
    public javax.jms.Destination getDestination() throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        return this.m_appDest;
    }

    static final boolean isAmbiguousURLDestination(String dest, javax.jms.Message msg) {
        if (dest != null && DraDestUtil.isHttpOrHttps(dest)) {
            try {
                if (msg.getStringProperty("X-HTTP-DestinationURL") != null) {
                    return true;
                }
            }
            catch (JMSException e) {
                return false;
            }
        }
        return false;
    }
}

