/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import progress.message.client.EGeneralException;
import progress.message.client.ENetworkFailure;
import progress.message.client.EParameterIsNull;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.ESubjectNotSet;
import progress.message.client.ETransactionFailure;
import progress.message.client.EUnauthorizedUndeliveredDestination;
import progress.message.client.prAccessor;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Message;
import progress.message.jimpl.MessageProducer;
import progress.message.jimpl.Session;

public class QueueSender
extends MessageProducer
implements javax.jms.QueueSender {
    public QueueSender(Session session, Queue queue) throws JMSException {
        super(session, queue);
    }

    @Override
    public Queue getQueue() throws JMSException {
        return (Queue)super.getDestination();
    }

    @Override
    public void send(javax.jms.Message message) throws JMSException {
        super.send(message);
    }

    @Override
    public void send(javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        super.send(message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void send(Queue queue, javax.jms.Message message) throws JMSException {
        super.send(queue, message);
    }

    @Override
    public void send(Queue queue, javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        super.send(queue, message, deliveryMode, priority, timeToLive);
    }

    static void sendAckForward(Session jsession, Queue queue, long receiverClientID, long tracking, boolean origPersistent, Destination replyTo, int deliveryMode, int priority, long expiration) throws JMSException {
        if (jsession == null || jsession.m_zmessageHandler == null || jsession.getAckSession() == null) {
            throw new IllegalStateException(prAccessor.getString("SESSION_CLOSED"));
        }
        Message jmessage = new Message();
        if (priority == 4) {
            priority = 4;
        }
        if (priority < 0 || priority > 9) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("PRI_OUT_RANGE"), null);
        }
        try {
            jmessage.m_zenvelope.setPtp((byte)11);
            jmessage.setJMSDestination(queue);
            jmessage.setDefaultRoutingForURLDestination(queue);
            jmessage.validateUndeliveredDestination(queue, jsession.getJconnection().getRoutingNodeName());
            jmessage.setJMSReplyTo(replyTo);
            jmessage.adjustJMSReplyTo(queue, jsession, replyTo);
            jmessage.setJMSDeliveryMode(deliveryMode);
            jmessage.setJMSPriority(priority);
            jmessage.setJMSExpiration(expiration);
            jmessage.setLongProperty("tracking", tracking);
            jmessage.setLongProperty("receiverClientID", receiverClientID);
            jmessage.setBooleanProperty("origPersistent", origPersistent);
            jsession.getAckSession().publish(jmessage.m_zenvelope);
        }
        catch (EUnauthorizedUndeliveredDestination eud) {
            throw JMSExceptionUtil.createJMSSecurityException(eud);
        }
        catch (ESecurityPolicyViolation espv) {
            throw JMSExceptionUtil.createJMSSecurityException(prAccessor.getString("NOT_AUTH_SEND") + queue.getQueueName(), espv);
        }
        catch (EParameterIsNull epis) {
            throw JMSExceptionUtil.createJMSException(epis);
        }
        catch (ESubjectNotSet esns) {
            throw new InvalidDestinationException(esns.getMessage());
        }
        catch (ETransactionFailure etf) {
            throw JMSExceptionUtil.createJMSException(etf);
        }
        catch (ENetworkFailure enf) {
            throw JMSExceptionUtil.createJMSException(enf);
        }
        catch (EGeneralException ege) {
            if (ege.getErrorId() == 3004) {
                throw JMSExceptionUtil.createJMSException(ege.getMessage(), new Integer(-17).toString(), ege);
            }
            throw JMSExceptionUtil.createJMSException(ege);
        }
    }
}

