/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import progress.message.msg.IConnectionSyncHandle;
import progress.message.msg.IExtendedTXNRequestHandle;
import progress.message.msg.IFailoverStatusNotificationHandle;
import progress.message.msg.IIDRHandle;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverter;
import progress.message.msg.IMgramConverterHandle;
import progress.message.msg.IMgramStatusListener;
import progress.message.msg.IOperationHandle;
import progress.message.msg.ITXNRequestHandle;
import progress.message.msg.MgramConstants;
import progress.message.msg.MgramDeliveryContext;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.AckListPayload;
import progress.message.msg.v26.AckPayload;
import progress.message.msg.v26.BatchPayload;
import progress.message.msg.v26.ConnectionSyncPayload;
import progress.message.msg.v26.DefaultDynamicHeader;
import progress.message.msg.v26.DefaultPayload;
import progress.message.msg.v26.DynamicHeader;
import progress.message.msg.v26.ErrorPayload;
import progress.message.msg.v26.ExtendedTXNRequestPayload;
import progress.message.msg.v26.FailoverStatusNotificationPayload;
import progress.message.msg.v26.FlowControlPayload;
import progress.message.msg.v26.IBrokerMgramCreator;
import progress.message.msg.v26.IDRPayload;
import progress.message.msg.v26.Mgram;
import progress.message.msg.v26.NackPayload;
import progress.message.msg.v26.PTPFlowControlPayload;
import progress.message.msg.v26.Payload;
import progress.message.msg.v26.QueueFlowControlPayload;
import progress.message.msg.v26.SidebandData;
import progress.message.msg.v26.StaticHeader;
import progress.message.msg.v26.TXNRequestPayload;
import progress.message.util.ArrayUtil;
import progress.message.util.AutoVec;
import progress.message.util.EAssertFailure;
import progress.message.util.StreamUtil;
import progress.message.xa.XidImpl;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EMgramVersionMismatch;
import progress.message.zclient.ESecurityInvalidLogistics;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISaverOp;
import progress.message.zclient.ISecureInputStream;
import progress.message.zclient.ISecureOutputStream;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.IStateEvent;
import progress.message.zclient.ISubject;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.SessionConfig;

public class MgramCreator
extends DebugObject
implements IMgramConverter {
    private static Mgram m_guarAckMgram = null;
    private static byte[] m_ackStaticHeader;
    private static byte[] m_ackDynamicHeader;
    private static byte[] m_windowAckStaticHeader;
    private static byte[] m_splitDeliveryAckStaticHeader;
    private static byte[] m_flowControlStaticHeader;
    private static byte[] m_flowControlDynamicHeader;
    private static byte[] m_flowControlPayload;
    private static Mgram m_pingRequest;
    private static Mgram m_pingReply;
    private static Mgram m_flowControl;
    private static int TXN_REPLY_BODY_LENGTH;
    private static int TXN_ACTIVE_REPLY_BODY_LENGTH;
    private static IBrokerMgramCreator m_brokerMgramCreator;
    private ISecureInputStream m_sis = null;
    private ISecureOutputStream m_sos = null;
    private ClientSecurityContext m_csc = null;
    private IMessageProtection m_mp = null;
    private IMgramStatusListener m_listener = null;
    private boolean m_isTTEttlConvert = false;
    private StreamUtilCounter m_counter = null;
    private byte[] m_encryptedMessageKey = null;
    private boolean m_ignoreEncryption = false;

    public MgramCreator() {
        super("MgramCreator");
    }

    @Override
    public void initializeConverter(Hashtable properties) {
        Boolean ignoreEncryption;
        this.m_csc = (ClientSecurityContext)properties.get(MgramConstants.CLIENT_SECURITY_CONTEXT);
        this.m_sis = (ISecureInputStream)properties.get(MgramConstants.SECURE_INPUT_STREAM);
        this.m_sos = (ISecureOutputStream)properties.get(MgramConstants.SECURE_OUTPUT_STREAM);
        this.m_mp = (IMessageProtection)properties.get(MgramConstants.MESSAGE_PROTECTION);
        this.m_listener = (IMgramStatusListener)properties.get(MgramConstants.MGRAM_STATUS_LISTENER);
        Boolean tteTTL = (Boolean)properties.get(MgramConstants.TTE_TTL_CONVERT);
        if (tteTTL != null) {
            this.m_isTTEttlConvert = tteTTL;
        }
        if ((ignoreEncryption = (Boolean)properties.get(MgramConstants.IGNORE_SECURITY)) != null) {
            this.m_ignoreEncryption = ignoreEncryption;
        }
        this.m_counter = new StreamUtilCounter(true);
    }

    @Override
    public final IMgram createMgram(InputStream is) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return this.createMgram(is, false);
    }

    private final IMgram createMgram(InputStream is, boolean ignoreSecurity) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        if (this.m_counter != null) {
            this.m_counter.resetCounter();
        }
        Mgram m = null;
        m = !ignoreSecurity ? Mgram.createMgram(is, this.m_sis, this.m_mp, this.m_csc, this.m_listener, this.m_counter, this.m_isTTEttlConvert) : Mgram.createMgramNonSecure(is, this.m_listener, this.m_counter, this.m_isTTEttlConvert);
        m.setStatusListener(null);
        if (m.supportsOperationHandle()) {
            int size = StreamUtil.readInt(is);
            for (int count = 0; count < size; ++count) {
                IMgram payload = this.createMgram(is, false);
                m.getOperationHandle().addMgram(payload);
            }
        }
        return m;
    }

    @Override
    public IMgram createMgram(byte version, InputStream is) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return this.createMgram(version, is, this.m_ignoreEncryption);
    }

    private IMgram createMgram(byte version, InputStream is, boolean ignoreSecurity) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        if (this.m_counter != null) {
            this.m_counter.resetCounter();
        }
        Mgram m = null;
        m = !ignoreSecurity ? Mgram.createMgram(version, is, this.m_sis, this.m_mp, this.m_csc, this.m_listener, this.m_counter, this.m_isTTEttlConvert) : Mgram.createMgramNonSecure(version, is, this.m_listener, this.m_counter, this.m_isTTEttlConvert);
        m.setStatusListener(null);
        if (m.supportsOperationHandle()) {
            int size = StreamUtil.readInt(is);
            for (int count = 0; count < size; ++count) {
                IMgram payload = this.createMgram((byte)-1, is, this.m_ignoreEncryption);
                m.getOperationHandle().addMgram(payload);
            }
        }
        return m;
    }

    private void writeMgramToNetworkStream(IMgram m, OutputStream os, MgramDeliveryContext ctx) throws IOException {
        m.writeMgramToNetworkStream(os, this.m_csc, this.m_sos, this.m_mp, ctx);
    }

    @Override
    public void deliver(IMgram m, OutputStream os) throws IOException {
        this.deliver(m, -1, os, null);
    }

    @Override
    public void deliver(IMgram m, int channel, OutputStream os, MgramDeliveryContext ctx) throws IOException {
        if (m == null) {
            return;
        }
        if (ctx != null && ctx.protocolAdapter != null && ctx.protocolAdapter.makeProtocolCorrections(m, ctx)) {
            while (ctx.protocolAdapter.hasCorrected()) {
                this.deliver(ctx.protocolAdapter.getNextCorrected(), channel, os, null);
            }
            return;
        }
        if (m.getBrokerHandle().isGuarFormatIncorrect() && ctx != null && !ctx.guarFormatCorrected) {
            m = MgramCreator.buildGuarFormatMgram(m);
            ctx.guarFormatCorrected = true;
        }
        m.writeMgramToNetworkStream(os, channel, this.m_csc, this.m_sos, this.m_mp, ctx);
        if (m.supportsOperationHandle()) {
            LinkedList ll = m.getOperationHandle().getMgramList();
            if (ll != null) {
                StreamUtil.writeInt(ll.size(), os);
                for (int count = 0; count < ll.size(); ++count) {
                    m = (IMgram)ll.get(count);
                    this.deliver(m, channel, os, ctx);
                }
            } else {
                StreamUtil.writeInt(0, os);
            }
        }
    }

    @Override
    public void secureDeliver(IMgram m, int channel, ClientSecurityContext csc, OutputStream os, MgramDeliveryContext ctx) throws IOException {
        this.secureDeliver(m, channel, csc, os, false, ctx);
    }

    private void secureDeliver(IMgram m, int channel, ClientSecurityContext csc, OutputStream os, boolean ignoreSecurity, MgramDeliveryContext ctx) throws IOException {
        if (m == null) {
            return;
        }
        if (ctx != null && ctx.protocolAdapter != null && ctx.protocolAdapter.makeProtocolCorrections(m, ctx)) {
            while (ctx.protocolAdapter.hasCorrected()) {
                this.secureDeliver(ctx.protocolAdapter.getNextCorrected(), channel, csc, os, ignoreSecurity, null);
            }
            return;
        }
        if (m.getBrokerHandle().isGuarFormatIncorrect() && ctx != null && !ctx.guarFormatCorrected) {
            m = MgramCreator.buildGuarFormatMgram(m);
            ctx.guarFormatCorrected = true;
        }
        if (m.isSecure() && (SecurityLogic.isMKeyMacHeader(m.getSecurity()) || SecurityLogic.isMKeyDigest(m.getSecurity())) && !ignoreSecurity) {
            this.messageKeySlicedDelivery(m, channel, csc, os, ctx);
        } else if (m.isSecure() && (SecurityLogic.isSKeyDigest(m.getSecurity()) || SecurityLogic.isSKeyEncryption(m.getSecurity())) && !ignoreSecurity) {
            this.sessionKeySlicedDelivery(m, channel, csc, os, ctx);
        } else {
            if (ignoreSecurity) {
                m.writeMgramToNetworkStreamNonSecure(os, channel, true, ctx);
            } else {
                m.writeMgramToNetworkStream(os, channel, csc, this.m_sos, this.m_mp, ctx);
            }
            this.deliverSecureOperationPayloads(m, channel, csc, os, false, ctx);
        }
    }

    private void messageKeySlicedDelivery(IMgram m, int channel, ClientSecurityContext csc, OutputStream os, MgramDeliveryContext ctx) throws IOException {
        IMgramConverterHandle mch = m.getMgramConverterHandle();
        mch.recalculatePad(this.m_mp);
        if (this.m_encryptedMessageKey == null) {
            this.m_encryptedMessageKey = new byte[this.m_mp.getOutputSize(this.m_mp.getSecretKeyLength())];
        }
        m.getBrokerHandle().encryptMessageKey(this.m_encryptedMessageKey, this.m_mp);
        StaticHeader.writeToStream(os, mch.getInternalStaticHeader(), channel, true);
        mch.getInternalDynamicHeader().writeToStream(os, this.m_mp, this.m_encryptedMessageKey, null, ctx);
        m.writePayloadToStream(os, null);
        this.deliverSecureOperationPayloads(m, channel, csc, os, false, ctx);
    }

    private void deliverSecureOperationPayloads(IMgram m, int channel, ClientSecurityContext csc, OutputStream os, boolean ignoreSecurity, MgramDeliveryContext ctx) throws IOException {
        if (m.supportsOperationHandle()) {
            LinkedList ll = m.getOperationHandle().getMgramList();
            if (ll != null) {
                StreamUtil.writeInt(ll.size(), os);
                for (int count = 0; count < ll.size(); ++count) {
                    m = (IMgram)ll.get(count);
                    this.secureDeliver(m, channel, csc, os, ignoreSecurity, ctx);
                }
            } else {
                StreamUtil.writeInt(0, os);
            }
        }
    }

    private void sessionKeySlicedDelivery(IMgram m, int channel, ClientSecurityContext csc, OutputStream os, MgramDeliveryContext ctx) throws IOException {
        IMgramConverterHandle mch = m.getMgramConverterHandle();
        mch.recalculatePad(this.m_mp);
        byte[] mac = null;
        if (SecurityLogic.isSKeyDigest(m.getSecurity())) {
            mac = mch.calculateMac(csc.getDigestKey(), this.m_mp);
        }
        StaticHeader.writeToStream(os, mch.getInternalStaticHeader(), channel, true);
        mch.getInternalDynamicHeader().writeToStream(os, this.m_mp, null, mac, ctx);
        m.writePayloadToStream(os, this.m_sos);
        this.deliverSecureOperationPayloads(m, channel, csc, os, false, ctx);
    }

    public IMgram unserialize(InputStream is) throws IOException, EMgramFormatError {
        return this.unserialize(is, false);
    }

    @Override
    public IMgram unserialize(InputStream is, boolean tteTTLConvert) throws IOException, EMgramFormatError {
        IMgram m = Mgram.unserialize(is, tteTTLConvert);
        if (m.supportsOperationHandle()) {
            int size = StreamUtil.readInt(is);
            for (int count = 0; count < size; ++count) {
                StreamUtil.readByte(is);
                IMgram payload = this.unserialize(is, tteTTLConvert);
                m.getOperationHandle().addMgram(payload);
            }
        }
        return m;
    }

    public void serialize(OutputStream os, IMgram m) throws IOException {
        this.serialize(os, m, false);
    }

    @Override
    public void serialize(OutputStream os, IMgram m, boolean tteTTLConvert) throws IOException {
        IOperationHandle ioh;
        LinkedList ll;
        m.getBrokerHandle().serialize(os, tteTTLConvert);
        if (m.supportsOperationHandle() && (ll = (ioh = m.getOperationHandle()).getMgramList()) != null) {
            int size = ll.size();
            StreamUtil.writeInt(size, os);
            for (IMgram payload : ll) {
                this.serialize(os, payload, tteTTLConvert);
            }
        }
    }

    public IMgram createMgram(byte[] data) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return new Mgram(data);
    }

    public IMgram createMgram(boolean initialize) {
        return new Mgram(initialize);
    }

    public static IMgram buildAck(long tracking, long clientID, short err, int channel) {
        return MgramCreator.buildAck(tracking, clientID, err, false, 0L, false, 0, channel);
    }

    public static IMgram buildAck(long msgTracking, long clientID, short err, boolean guaranteed, long ackTracking, boolean txn, int tid, int channel) {
        Mgram ack = null;
        ack = new Mgram(false);
        byte[] staticHeader = new byte[m_ackStaticHeader.length];
        System.arraycopy(m_ackStaticHeader, 0, staticHeader, 0, m_ackStaticHeader.length);
        byte[] dynamicHeader = new byte[m_ackDynamicHeader.length];
        System.arraycopy(m_ackDynamicHeader, 0, dynamicHeader, 0, m_ackDynamicHeader.length);
        StaticHeader.setChannel(channel, staticHeader);
        ack.setStaticHeader(staticHeader);
        ack.setDynamicHeaderCache(dynamicHeader);
        byte[] payload = AckPayload.createPayload(msgTracking, clientID, err, guaranteed, ackTracking, txn, tid);
        DefaultDynamicHeader.setMessageLength(payload.length, dynamicHeader);
        if (guaranteed) {
            StaticHeader.setGuarenteed(guaranteed, staticHeader);
        }
        if (txn) {
            StaticHeader.setTxn(txn, staticHeader);
        }
        ack.setPayloadCache(payload);
        return ack;
    }

    public static IMgram buildSplitDeliveryAck(long tracking, long clientID, short err, int channel, short subjectTracking) {
        return MgramCreator.buildSplitDeliveryAck(tracking, clientID, err, false, 0L, false, 0, channel, subjectTracking);
    }

    public static IMgram buildSplitDeliveryAck(long msgTracking, long clientID, short err, boolean guaranteed, long ackTracking, boolean txn, int tid, int channel, short subjectTracking) {
        Mgram ack = null;
        ack = new Mgram(false);
        byte[] staticHeader = new byte[m_splitDeliveryAckStaticHeader.length];
        System.arraycopy(m_splitDeliveryAckStaticHeader, 0, staticHeader, 0, m_splitDeliveryAckStaticHeader.length);
        byte[] dynamicHeader = new byte[m_ackDynamicHeader.length];
        System.arraycopy(m_ackDynamicHeader, 0, dynamicHeader, 0, m_ackDynamicHeader.length);
        StaticHeader.setChannel(channel, staticHeader);
        ack.setStaticHeader(staticHeader);
        ack.setDynamicHeaderCache(dynamicHeader);
        byte[] payload = AckPayload.createSplitDeliveryPayload(msgTracking, clientID, err, guaranteed, ackTracking, txn, tid, subjectTracking);
        DefaultDynamicHeader.setMessageLength(payload.length, dynamicHeader);
        if (guaranteed) {
            StaticHeader.setGuarenteed(guaranteed, staticHeader);
        }
        if (txn) {
            StaticHeader.setTxn(txn, staticHeader);
        }
        ack.setPayloadCache(payload);
        return ack;
    }

    public static IMgram buildQAck(long msgTracking, long clientID, short err, boolean guaranteed, long ackTracking, boolean txn, int tid, int channel) {
        IMgram ack = null;
        ack = MgramCreator.buildAck(msgTracking, clientID, err, guaranteed, ackTracking, txn, tid, channel);
        ack.setType((byte)14);
        return ack;
    }

    public static IMgram buildWindowAck(long receiptTracking, long storageTracking, short err, boolean guaranteed, long ackTracking, boolean txn, int tid, int channel) {
        Mgram ack = new Mgram(false);
        byte[] staticHeader = new byte[m_windowAckStaticHeader.length];
        System.arraycopy(m_windowAckStaticHeader, 0, staticHeader, 0, m_windowAckStaticHeader.length);
        byte[] dynamicHeader = new byte[m_ackDynamicHeader.length];
        System.arraycopy(m_ackDynamicHeader, 0, dynamicHeader, 0, m_ackDynamicHeader.length);
        StaticHeader.setChannel(channel, staticHeader);
        ack.setStaticHeader(staticHeader);
        ack.setDynamicHeaderCache(dynamicHeader);
        byte[] payload = AckPayload.createWindowAckPayload(receiptTracking, storageTracking, err, guaranteed, ackTracking, txn, tid);
        DefaultDynamicHeader.setMessageLength(payload.length, dynamicHeader);
        if (guaranteed) {
            StaticHeader.setGuarenteed(guaranteed, staticHeader);
        }
        if (txn) {
            StaticHeader.setTxn(txn, staticHeader);
        }
        ack.setPayloadCache(payload);
        return ack;
    }

    public static IMgram buildAckList() {
        Mgram result = new Mgram(false);
        result.setStaticHeader(StaticHeader.getDefaultByteArray());
        result.setDynamicHeader(new DefaultDynamicHeader(result));
        result.setPayload(new AckListPayload(result));
        result.setType((byte)28);
        result.setPriority((byte)11);
        return result;
    }

    public static IMgram buildQueueGetRequestMgram(boolean secure, int channel, short receiveType, int prefetchCount, ISubject subject, boolean remoteGet) {
        Mgram qGetRequestMgram = new Mgram(true);
        qGetRequestMgram.setType((byte)13);
        qGetRequestMgram.setChannel(channel);
        qGetRequestMgram.setSubject(subject, 5);
        if (remoteGet) {
            qGetRequestMgram.setPriority((byte)10);
        }
        byte[] body = new byte[6];
        int p = 0;
        ArrayUtil.writeShort(body, p, receiveType);
        ArrayUtil.writeInt(body, p += 2, prefetchCount);
        qGetRequestMgram.setBody(body);
        if (secure) {
            qGetRequestMgram.setMgramSecure(null);
            qGetRequestMgram.setSecurityAttribute((byte)0);
        }
        qGetRequestMgram.sync();
        return qGetRequestMgram;
    }

    public static IMgram buildQueueOpenRemoteReceiverMgram(boolean secure, int channel, ISubject subject, String msgSelector) {
        Mgram qOpenRemoteReceiverMgram = new Mgram(true);
        qOpenRemoteReceiverMgram.setType((byte)30);
        qOpenRemoteReceiverMgram.setChannel(channel);
        qOpenRemoteReceiverMgram.setSubject(subject, 5);
        qOpenRemoteReceiverMgram.setRouteLimit(1);
        qOpenRemoteReceiverMgram.setPriority((byte)10);
        byte[] body = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            StreamUtil.writeUTF(msgSelector == null ? "" : msgSelector, baos);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        body = baos.toByteArray();
        qOpenRemoteReceiverMgram.setBody(body);
        if (secure) {
            qOpenRemoteReceiverMgram.setMgramSecure(null);
            qOpenRemoteReceiverMgram.setSecurityAttribute((byte)0);
        }
        qOpenRemoteReceiverMgram.sync();
        return qOpenRemoteReceiverMgram;
    }

    public static IMgram buildQueueCloseRemoteReceiverMgram(boolean secure, int channel, ISubject subject, String msgSelector) {
        Mgram qCloseRemoteReceiverMgram = new Mgram(true);
        qCloseRemoteReceiverMgram.setType((byte)31);
        qCloseRemoteReceiverMgram.setChannel(channel);
        qCloseRemoteReceiverMgram.setSubject(subject, 5);
        qCloseRemoteReceiverMgram.setRouteLimit(1);
        qCloseRemoteReceiverMgram.setPriority((byte)10);
        byte[] body = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            StreamUtil.writeUTF(msgSelector == null ? "" : msgSelector, baos);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        body = baos.toByteArray();
        qCloseRemoteReceiverMgram.setBody(body);
        if (secure) {
            qCloseRemoteReceiverMgram.setMgramSecure(null);
            qCloseRemoteReceiverMgram.setSecurityAttribute((byte)0);
        }
        qCloseRemoteReceiverMgram.sync();
        return qCloseRemoteReceiverMgram;
    }

    public static IMgram buildPingRequest(byte[] payload, int channel) {
        IMgram ping = null;
        try {
            ping = (IMgram)m_pingRequest.unprotectedClone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        ping.setChannel(channel);
        ping.setBody(payload);
        return ping;
    }

    public static IMgram buildPingReply(IMgram m) {
        IMgram ping = null;
        try {
            ping = (IMgram)m_pingReply.unprotectedClone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        ping.setChannel(m.getChannel());
        ping.setBody(m.getRawBody());
        return ping;
    }

    public static IMgram buildDisconnectRequest(int channel, boolean forceDisconnect) {
        Mgram disconnect = new Mgram(true);
        disconnect.setType((byte)7);
        disconnect.setPriority((byte)0);
        disconnect.setRequestReplyType(2);
        disconnect.setChannel(channel);
        disconnect.setReplyFormat(0);
        byte[] body = new byte[]{(byte)(forceDisconnect ? 1 : 0)};
        disconnect.setBody(body);
        return disconnect;
    }

    public static IMgram buildFlowControlMgram(byte minPriority, int channel) {
        Mgram flowControl = new Mgram(false);
        byte[] flowControlPayload = new byte[m_flowControlPayload.length];
        System.arraycopy(m_flowControlPayload, 0, flowControlPayload, 0, m_flowControlPayload.length);
        byte[] flowControlDynamicHeader = new byte[m_flowControlDynamicHeader.length];
        System.arraycopy(m_flowControlDynamicHeader, 0, flowControlDynamicHeader, 0, m_flowControlDynamicHeader.length);
        byte[] flowControlStaticHeader = new byte[m_flowControlStaticHeader.length];
        System.arraycopy(m_flowControlStaticHeader, 0, flowControlStaticHeader, 0, m_flowControlStaticHeader.length);
        FlowControlPayload.setMinPriority(minPriority, flowControlPayload);
        StaticHeader.setChannel(channel, flowControlStaticHeader);
        flowControl.setStaticHeader(flowControlStaticHeader);
        flowControl.setDynamicHeaderCache(flowControlDynamicHeader);
        flowControl.setPayloadCache(flowControlPayload);
        return flowControl;
    }

    public static IMgram buildVersionMgram(int channel, byte version) {
        Mgram versionMgram = new Mgram(true);
        versionMgram.setType((byte)4);
        versionMgram.setVersion(version);
        versionMgram.setChannel(channel);
        versionMgram.setPostV22();
        return versionMgram;
    }

    public static IMgram buildVersionMgram(int channel, byte version, byte sessionVer) {
        Mgram versionMgram = new Mgram(true);
        versionMgram.setType((byte)4);
        versionMgram.setVersion(version);
        versionMgram.setChannel(channel);
        versionMgram.setPostV22();
        versionMgram.setSessionVer(sessionVer);
        return versionMgram;
    }

    public static IMgram buildVersionMgram(int channel, byte version, byte sessionVer, byte streamVersion, byte streamFlags) {
        Mgram versionMgram = new Mgram(true);
        versionMgram.setType((byte)4);
        versionMgram.setVersion(version);
        versionMgram.setChannel(channel);
        versionMgram.setPostV22();
        versionMgram.setSessionVer(sessionVer);
        versionMgram.setStreamVersion(streamVersion);
        versionMgram.setStreamFlags(streamFlags);
        return versionMgram;
    }

    public static IMgram buildConnectMgram(byte[] payload, int channel) {
        Mgram connectMgram = new Mgram(true);
        connectMgram.setType((byte)1);
        connectMgram.setRequestReplyType(0);
        connectMgram.setChannel(channel);
        connectMgram.setBody(payload);
        return connectMgram;
    }

    public static IMgram buildErrorMgram(int errcode, int errinfo, IMgram m, int channel) {
        Mgram error = new Mgram(false);
        error.setStaticHeader(StaticHeader.getDefaultByteArray());
        error.setDynamicHeader(new DefaultDynamicHeader(error));
        error.setPayload(new ErrorPayload(error));
        if (m != null && m.hasID()) {
            error.setID(m.getID());
        }
        error.setType((byte)-1);
        error.setChannel(channel);
        error.getErrorHandle().setErrCode(errcode);
        error.getErrorHandle().setErrInfo(errinfo);
        return error;
    }

    public static IMgram buildTxnRequest(boolean chained, int tid, int tracking, long clientId, int channel) {
        return MgramCreator.buildGenericTxnRequest(MgramConstants.TX_REQUEST_COMMIT_SUBTYPE, false, chained, tid, tracking, clientId, channel, null, -1L, false, -1, null);
    }

    public static IMgram buildCommitTxnRequest(boolean xo, boolean chained, int tid, int tracking, long clientId, int channel) {
        return MgramCreator.buildGenericTxnRequest(MgramConstants.TX_REQUEST_COMMIT_SUBTYPE, xo, chained, tid, tracking, clientId, channel, null, -1L, false, -1, null);
    }

    public static IMgram buildNoDupCommitTxnRequest(boolean xo, boolean chained, int tid, int tracking, long clientId, int channel, String transactionId, long lifespan) {
        return MgramCreator.buildGenericTxnRequest(MgramConstants.TX_REQUEST_COMMIT_NO_DUP_SUBTYPE, xo, chained, tid, tracking, clientId, channel, transactionId, lifespan, false, -1, null);
    }

    public static IMgram buildNoDupChannelCommitTxnRequest(boolean xo, boolean chained, int tid, int tracking, long clientId, int channel, String transactionId, long lifespan, int channelStatus, String channelID) {
        return MgramCreator.buildGenericTxnRequest(MgramConstants.TX_REQUEST_COMMIT_CHANNEL_NO_DUP_SUBTYPE, xo, chained, tid, tracking, clientId, channel, transactionId, lifespan, true, channelStatus, channelID);
    }

    public IMgram buildNoDupChannelDeleteTxnRequest(boolean xo, int tracking, long clientId, int channel, String transactionId, String channelID) {
        return MgramCreator.buildGenericTxnRequest(MgramConstants.TX_REQUEST_DELETE_CHANNEL_NO_DUP_SUBTYPE, xo, false, -1, tracking, clientId, channel, transactionId, 0L, true, -1, channelID);
    }

    public IMgram buildNoDupChannelUpdateTxnRequest(boolean xo, int tracking, long clientId, int channel, String transactionId, long lifespan, int channelStatus, String channelID) {
        return MgramCreator.buildGenericTxnRequest(MgramConstants.TX_REQUEST_UPDATE_CHANNEL_NO_DUP_SUBTYPE, xo, false, -1, tracking, clientId, channel, transactionId, lifespan, true, channelStatus, channelID);
    }

    public static IMgram buildBeginTxnRequest(boolean xo, int tracking, long clientId, int channel) {
        return MgramCreator.buildGenericTxnRequest(MgramConstants.TX_REQUEST_BEGIN_SUBTYPE, xo, false, -1, tracking, clientId, channel, null, -1L, false, -1, null);
    }

    public static IMgram buildAbortTxnRequest(boolean xo, boolean chained, int tid, int tracking, long clientId, int channel) {
        return MgramCreator.buildGenericTxnRequest(MgramConstants.TX_REQUEST_ABORT_SUBTYPE, xo, chained, tid, tracking, clientId, channel, null, -1L, false, -1, null);
    }

    public static IMgram buildGenericTxnRequest(short typ, boolean xo, boolean chained, int tid, int tracking, long clientId, int channel, String transactionId, long lifespan, boolean isChannel, int channelStatus, String channelID) {
        Mgram txnRequest = new Mgram(true);
        txnRequest.setType((byte)8);
        txnRequest.setRequestReplyType(0);
        txnRequest.setPriority((byte)0);
        txnRequest.setChannel(channel);
        txnRequest.setPayload(new TXNRequestPayload(txnRequest));
        ITXNRequestHandle handle = txnRequest.getTXNRequestHandle();
        handle.setType(typ);
        handle.setXonce(xo);
        handle.setChained(chained);
        handle.setTID(tid);
        handle.setReplyTracking(tracking);
        handle.setClientId(clientId);
        handle.setTransactionId(transactionId);
        handle.setLifespan(lifespan);
        handle.setChannelState(channelStatus);
        handle.setChannelID(channelID);
        txnRequest.sync();
        return txnRequest;
    }

    public static IMgram buildTxnReply(short status, int nextTid, int tracking, int channel) {
        Mgram txnReply = new Mgram(true);
        txnReply.setType((byte)8);
        txnReply.setRequestReplyType(3);
        txnReply.setPriority((byte)10);
        txnReply.setChannel(channel);
        byte[] body = new byte[TXN_REPLY_BODY_LENGTH];
        int p = 0;
        ArrayUtil.writeShort(body, p, status);
        ArrayUtil.writeInt(body, p += 2, tracking);
        ArrayUtil.writeInt(body, p += 4, nextTid);
        p += 4;
        txnReply.setBody(body);
        return txnReply;
    }

    public static IMgram buildTxnActiveReply(long ttl, int nextTid, int tracking, int channel) {
        Mgram txnReply = new Mgram(true);
        txnReply.setType((byte)8);
        txnReply.setRequestReplyType(3);
        txnReply.setPriority((byte)10);
        txnReply.setChannel(channel);
        byte[] body = new byte[TXN_ACTIVE_REPLY_BODY_LENGTH];
        int p = 0;
        ArrayUtil.writeShort(body, p, (short)13);
        ArrayUtil.writeInt(body, p += 2, tracking);
        ArrayUtil.writeLong(body, p += 4, ttl);
        ArrayUtil.writeInt(body, p += 8, nextTid);
        p += 4;
        txnReply.setBody(body);
        return txnReply;
    }

    public IMgram buildExtendedTxnRequest(boolean xo, boolean chained, int tid, int tracking, long clientId, int channel, XidImpl xid, int op) {
        Mgram txnRequest = new Mgram(true);
        txnRequest.setType((byte)26);
        txnRequest.setRequestReplyType(0);
        txnRequest.setPriority((byte)0);
        txnRequest.setChannel(channel);
        txnRequest.setPayload(new ExtendedTXNRequestPayload(txnRequest));
        IExtendedTXNRequestHandle handle = txnRequest.getExtendedTXNRequestHandle();
        handle.setOp(op);
        handle.setXonce(xo);
        handle.setChained(chained);
        handle.setTID(tid);
        handle.setReplyTracking(tracking);
        handle.setClientId(clientId);
        handle.setXid(xid);
        txnRequest.sync();
        return txnRequest;
    }

    public static IMgram buildGRConvertMgram(long code, long clientid, int channel, long token) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildGRConvertMgram(code, clientid, channel, token);
        }
        throw new EAssertFailure("Cannot create GR convert mgram without broker");
    }

    public IMgram buildFailoverStatusNotification(int state, String[] localURLs, String[] standbyURLs) {
        Mgram status = new Mgram(true);
        status.setType((byte)21);
        status.setPriority((byte)10);
        status.setChannel(0);
        status.setRouteLimit(1);
        status.setMgramNonSecure();
        status.setPayload(new FailoverStatusNotificationPayload(status));
        IFailoverStatusNotificationHandle handle = status.getFailoverStatusNotificationHandle();
        handle.setState(state);
        handle.setLocalURLs(localURLs);
        handle.setStandbyURLs(standbyURLs);
        status.sync();
        return status;
    }

    public static IMgram buildBatchMgram(IMgram firstMgram) {
        Mgram result = new Mgram(false);
        result.setStaticHeader(StaticHeader.getDefaultByteArray());
        result.setDynamicHeader(new DefaultDynamicHeader(result));
        BatchPayload bp = new BatchPayload(result);
        result.setPayload(bp);
        result.setType((byte)27);
        bp.setFirstMgram(firstMgram);
        return result;
    }

    public static IMgram buildTxnBatchMgram(IMgram firstMgram, int tid) {
        Mgram result = new Mgram(false);
        result.setStaticHeader(StaticHeader.getDefaultByteArray());
        result.setDynamicHeader(new DefaultDynamicHeader(result));
        BatchPayload bp = new BatchPayload(result);
        result.setPayload(bp);
        result.setType((byte)27);
        bp.setFirstMgram(firstMgram);
        bp.setTid(tid);
        return result;
    }

    public static IMgram buildOperationMgram(int operationType) {
        Mgram operation = new Mgram(true);
        operation.setType((byte)25);
        operation.getOperationHandle().setOperationType(operationType);
        return operation;
    }

    public static IMgram buildIDRAckMgram() {
        Mgram m = new Mgram(true);
        m.setType((byte)23);
        m.setPriority((byte)12);
        m.setRouteLimit(1);
        m.setMgramNonSecure();
        m.setPayload(new IDRPayload(m));
        IIDRHandle handle = m.getIDRHandle();
        handle.setSubType((byte)3);
        m.sync();
        return m;
    }

    public static List buildIDRMgramList(boolean isRequest, boolean needsResponseOnLast, boolean senderHasDoubt, List dnrPubSub, List dnrPTP, List ugaPubSub, List ugaPTP, List preq, List prep) {
        Vector<Mgram> l = new Vector<Mgram>();
        byte subType = isRequest ? (byte)1 : 2;
        Mgram m = new Mgram(true);
        m.setType((byte)23);
        m.setPriority((byte)12);
        m.setRouteLimit(1);
        m.setMgramNonSecure();
        m.setPayload(new IDRPayload(m));
        IIDRHandle handle = m.getIDRHandle();
        handle.setSubType(subType);
        handle.setMore(false);
        handle.setSenderHasDoubt(senderHasDoubt);
        handle.setResponseRequired(needsResponseOnLast);
        handle.setDNRPTP(dnrPTP);
        handle.setDNRPubSub(dnrPubSub);
        handle.setUGAPTP(ugaPTP);
        handle.setUGAPubSub(ugaPubSub);
        handle.setPREP(prep);
        handle.setPREQ(preq);
        m.sync();
        l.add(m);
        return l;
    }

    public static IMgram buildConnectionSyncMgram(AutoVec v) {
        Mgram m = new Mgram(true);
        m.setType((byte)32);
        m.setPriority((byte)12);
        m.setRouteLimit(1);
        m.setMgramNonSecure();
        m.setPayload(new ConnectionSyncPayload(m));
        IConnectionSyncHandle handle = m.getConnectionSyncHandle();
        handle.setConnectionSyncData(v);
        m.sync();
        return m;
    }

    public static IMgram buildFirstMessageNotification(long clientID) {
        IMgram m = MgramCreator.buildOperationMgram(1);
        try {
            m.getPayloadOutputStreamHandle().writeLong(clientID);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return m;
    }

    public static IMgram buildDeliveryFinished(long clientID) {
        IMgram m = MgramCreator.buildOperationMgram(21);
        try {
            m.getPayloadOutputStreamHandle().writeLong(clientID);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return m;
    }

    public static IMgram buildLastMessageNotification(long clientID) {
        IMgram m = MgramCreator.buildOperationMgram(2);
        try {
            m.getPayloadOutputStreamHandle().writeLong(clientID);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return m;
    }

    public static IMgram buildSingleTargetMessage(long clientID, IMgram msg) {
        IMgram m = MgramCreator.buildOperationMgram(3);
        try {
            m.getPayloadOutputStreamHandle().writeLong(clientID);
            m.getOperationHandle().addMgram(msg);
            m.setPriority(msg.getPriority());
            m.setDiscardable(msg.isDiscardable());
            m.setTTE(msg.getTTE());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return m;
    }

    public static IMgram buildRejectionAck(IMgram rejected, int errorCode, String errorMsg, int channel) {
        IMgram m = MgramCreator.buildOperationMgram(30);
        m.setChannel(channel);
        m.setPriority((byte)11);
        ObjectOutput oo = m.getPayloadOutputStreamHandle();
        try {
            if (errorMsg != null) {
                oo.writeBoolean(true);
                oo.writeUTF(errorMsg);
            } else {
                oo.writeBoolean(false);
            }
            oo.writeInt(errorCode);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        m.getOperationHandle().addMgram(rejected);
        if (rejected.isSecure()) {
            m.setMgramSecure(rejected.getMessageProtection());
            try {
                m.setSecurityAttribute(SecurityLogic.AttribsFromPublic((byte)4, SecurityLogic.getPubAttr(rejected.getSecurity())));
            }
            catch (ESecurityInvalidLogistics il) {
                throw new EAssertFailure(il.getMessage(), il);
            }
        }
        return m;
    }

    public static IMgram buildDiagnosticOpMgram(short diagOp, int channel) {
        IMgram m = MgramCreator.buildOperationMgram(31);
        m.setChannel(channel);
        m.setPriority((byte)11);
        ObjectOutput oo = m.getPayloadOutputStreamHandle();
        try {
            oo.writeInt(diagOp);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return m;
    }

    public static IMgram buildLBSTargetMessage(IMgram m, boolean withLookup) {
        IMgram wrapper = MgramCreator.buildOperationMgram(withLookup ? 13 : 14);
        ObjectOutput out = wrapper.getPayloadOutputStreamHandle();
        wrapper.setRouteLimit(m.getRouteLimit());
        wrapper.setPriority(m.getPriority());
        wrapper.setDiscardable(m.isDiscardable());
        wrapper.setTTE(m.getTTE());
        wrapper.getBrokerHandle().setProxyRecipsTable(m.getBrokerHandle().getProxyRecipsTable());
        if (m.isGuarenteed()) {
            wrapper.setGuarenteed(m.getGuarenteedTrackingNum());
        }
        if (m.isSecure()) {
            wrapper.setMgramSecure(m.getMessageProtection());
            try {
                wrapper.setSecurityAttribute(SecurityLogic.AttribsFromPublic((byte)4, SecurityLogic.getPubAttr(m.getSecurity())));
            }
            catch (ESecurityInvalidLogistics il) {
                throw new EAssertFailure(il.getMessage(), il);
            }
        }
        wrapper.getOperationHandle().addMgram(m);
        return wrapper;
    }

    public static IMgram buildGuarFormatMgram(IMgram mgram) {
        IMgram wrapper = MgramCreator.buildOperationMgram(25);
        if (!mgram.isGuarenteed()) {
            wrapper.setReliable();
        } else {
            wrapper.setGuarenteed(mgram.getGuarenteedTrackingNum());
        }
        wrapper.getOperationHandle().addMgram(mgram);
        return wrapper;
    }

    public static IMgram buildLBSTargetMessage(IMgram m, int type, byte[] body, int bodyLength) {
        IMgram wrapper = MgramCreator.buildOperationMgram(type);
        ObjectOutput out = wrapper.getPayloadOutputStreamHandle();
        wrapper.setRouteLimit(m.getRouteLimit());
        wrapper.setPriority(m.getPriority());
        wrapper.setDiscardable(m.isDiscardable());
        wrapper.setTTE(m.getTTE());
        wrapper.getBrokerHandle().setProxyRecipsTable(m.getBrokerHandle().getProxyRecipsTable());
        if (m.isGuarenteed()) {
            wrapper.setGuarenteed(m.getGuarenteedTrackingNum());
        }
        if (m.isSecure()) {
            wrapper.setMgramSecure(m.getMessageProtection());
            try {
                wrapper.setSecurityAttribute(SecurityLogic.AttribsFromPublic((byte)4, SecurityLogic.getPubAttr(m.getSecurity())));
            }
            catch (ESecurityInvalidLogistics il) {
                throw new EAssertFailure(il.getMessage(), il);
            }
        }
        try {
            out.write(body, 0, bodyLength);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        wrapper.getOperationHandle().addMgram(m);
        return wrapper;
    }

    public static IMgram buildDisconnectReply(int channel, boolean reject) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildDisconnectReply(channel, reject);
        }
        throw new EAssertFailure("Cannot create DisconnectReply without broker");
    }

    public static IMgram buildTxnEOFMarker() {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildTxnEOFMarker();
        }
        throw new EAssertFailure("Cannot create TxnEOFMarker without broker");
    }

    public static IMgram buildTxnSavePointMarker() {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildTxnSavePointMarker();
        }
        throw new EAssertFailure("Cannot create TxnSavePointMarker without broker");
    }

    public static IMgram buildRemoteRestorePhasesDoneMgram(long clientID) {
        IMgram m = MgramCreator.buildOperationMgram(20);
        try {
            m.getPayloadOutputStreamHandle().writeLong(clientID);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return m;
    }

    public static IMgram buildResumeMgram(int channel, byte[] utfDestination, int utfLength, boolean routing) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildResumeMgram(channel, utfDestination, utfLength, routing);
        }
        throw new EAssertFailure("Cannot create Resume without broker");
    }

    public static IMgram buildBlockMgram(int channel, byte[] utfDestination, int utfLength, boolean routing) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildBlockMgram(channel, utfDestination, utfLength, routing);
        }
        throw new EAssertFailure("Cannot create Block without broker");
    }

    public static final IMgram buildPTPFlowControlMgram(int channel, String routing, ISubject subject, boolean isPubSub, byte subType) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildPTPFlowControlMgram(channel, routing, subject, isPubSub, subType);
        }
        throw new EAssertFailure("Cannot create PTPFLowControl without broker");
    }

    public static IMgram buildNack(long tracking, int channel) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildNack(tracking, channel);
        }
        throw new EAssertFailure("Cannot create Nack without broker");
    }

    public static IMgram buildRouteRequest(int channel, int requestType, long requestTime, int infoCount, byte[] routeInfo) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildRouteRequest(channel, requestType, requestTime, infoCount, routeInfo);
        }
        throw new EAssertFailure("Cannot create Route Request without broker");
    }

    public static IMgram buildIBConvertMgram(long token, int channel) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildIBConvertMgram(token, channel);
        }
        throw new EAssertFailure("Cannot create IB Convert without broker");
    }

    public static IMgram buildStateEventMgram(IStateEvent event, boolean tteTTLConvert) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildStateEventMgram(event, tteTTLConvert);
        }
        throw new EAssertFailure("Cannot create StateEvent without broker");
    }

    public static IMgram buildDatabaseMgram(ISaverOp op) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildDatabaseMgram(op);
        }
        throw new EAssertFailure("Cannot create DatabaseMgram without broker");
    }

    public static IMgram buildReplicatedMgram(IMgram replicatedMgram, boolean tteTTLConvert) {
        if (m_brokerMgramCreator != null) {
            return m_brokerMgramCreator.buildReplicatedMgram(replicatedMgram, tteTTLConvert);
        }
        throw new EAssertFailure("Cannot create ReplicatedMgram without broker");
    }

    public static ISidebandData buildSidebandData() {
        return new SidebandData();
    }

    public static Payload getPayloadObject(byte type, Mgram m) {
        Payload result;
        switch (type) {
            case 4: {
                return null;
            }
            case 18: 
            case 19: {
                result = new QueueFlowControlPayload(m);
                break;
            }
            case 6: {
                result = new FlowControlPayload(m);
                break;
            }
            case 37: {
                result = new PTPFlowControlPayload(m);
                break;
            }
            case 3: 
            case 14: 
            case 33: 
            case 36: {
                result = new AckPayload(m);
                break;
            }
            case 20: {
                result = new NackPayload(m);
                break;
            }
            case -1: {
                result = new ErrorPayload(m);
                break;
            }
            case 21: {
                result = new FailoverStatusNotificationPayload(m);
                break;
            }
            case 23: {
                result = new IDRPayload(m);
                break;
            }
            case 27: {
                result = new BatchPayload(m);
                break;
            }
            case 32: {
                result = new ConnectionSyncPayload(m);
                break;
            }
            case 28: {
                result = new AckListPayload(m);
                break;
            }
            case 8: {
                if (!m.isReply()) {
                    result = new TXNRequestPayload(m);
                    break;
                }
                result = null;
                break;
            }
            case 26: {
                if (!m.isReply()) {
                    result = new ExtendedTXNRequestPayload(m);
                    break;
                }
                result = null;
                break;
            }
            default: {
                result = null;
            }
        }
        if (result == null && m_brokerMgramCreator != null) {
            result = m_brokerMgramCreator.getPayloadObject(type, m);
        }
        if (result == null) {
            result = new DefaultPayload(m);
        }
        return result;
    }

    @Override
    public byte getVersion() {
        return 26;
    }

    static {
        TXN_REPLY_BODY_LENGTH = 10;
        TXN_ACTIVE_REPLY_BODY_LENGTH = 18;
        m_brokerMgramCreator = null;
        m_ackStaticHeader = StaticHeader.getDefaultByteArray();
        DefaultDynamicHeader dh = new DefaultDynamicHeader(null);
        ((DynamicHeader)dh).setMessageLength(16);
        m_ackDynamicHeader = ((DynamicHeader)dh).toByteArray();
        StaticHeader.setType((byte)3, m_ackStaticHeader);
        StaticHeader.setPriority((byte)11, m_ackStaticHeader);
        m_guarAckMgram = new Mgram(false);
        m_guarAckMgram.setStaticHeader(StaticHeader.getDefaultByteArray());
        m_guarAckMgram.setDynamicHeader(new DefaultDynamicHeader(m_guarAckMgram));
        m_guarAckMgram.setPayload(new AckPayload(m_guarAckMgram));
        m_guarAckMgram.setGuarenteed(0L);
        m_guarAckMgram.setType((byte)3);
        m_guarAckMgram.setPriority((byte)11);
        m_guarAckMgram.sync();
        m_windowAckStaticHeader = StaticHeader.getDefaultByteArray();
        StaticHeader.setType((byte)33, m_windowAckStaticHeader);
        StaticHeader.setPriority((byte)11, m_windowAckStaticHeader);
        m_splitDeliveryAckStaticHeader = StaticHeader.getDefaultByteArray();
        StaticHeader.setType((byte)36, m_splitDeliveryAckStaticHeader);
        StaticHeader.setPriority((byte)11, m_splitDeliveryAckStaticHeader);
        m_pingRequest = new Mgram(false);
        m_pingRequest.setStaticHeader(StaticHeader.getDefaultByteArray());
        dh = new DefaultDynamicHeader(m_pingRequest);
        m_pingRequest.setDynamicHeader(dh);
        DefaultPayload payload = new DefaultPayload(m_pingRequest);
        payload.setReplyFormat(0);
        m_pingRequest.setPayload(payload);
        m_pingRequest.setType((byte)0);
        m_pingRequest.setPriority((byte)12);
        m_pingRequest.setRequestReplyType(2);
        m_pingRequest.sync();
        m_pingReply = new Mgram(false);
        m_pingReply.setStaticHeader(StaticHeader.getDefaultByteArray());
        m_pingReply.setDynamicHeader(new DefaultDynamicHeader(m_pingReply));
        DefaultPayload payload2 = new DefaultPayload(m_pingReply);
        payload2.setReplyFormat(0);
        m_pingReply.setPayload(payload2);
        m_pingReply.setType((byte)0);
        m_pingReply.setPriority((byte)12);
        m_pingReply.setRequestReplyType(3);
        m_pingReply.sync();
        m_flowControl = new Mgram(false);
        m_flowControlStaticHeader = StaticHeader.getDefaultByteArray();
        dh = new DefaultDynamicHeader(null);
        ((DynamicHeader)dh).setMessageLength(1);
        m_flowControlDynamicHeader = ((DynamicHeader)dh).toByteArray();
        StaticHeader.setType((byte)6, m_flowControlStaticHeader);
        StaticHeader.setPriority((byte)12, m_flowControlStaticHeader);
        StaticHeader.setRequestReplyType(0, m_flowControlStaticHeader);
        m_flowControlPayload = new FlowControlPayload(null).toByteArray();
        if (SessionConfig.IN_BROKER) {
            try {
                Class<?> brokerCreator = Class.forName("progress.message.msg.v26.broker.MgramCreator");
                m_brokerMgramCreator = (IBrokerMgramCreator)brokerCreator.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

