/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.tcp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Properties;
import progress.message.net.ProgressInetAddress;
import progress.message.net.ProgressServerSocket;
import progress.message.net.ProgressSocket;

public abstract class AbstractTcpServerSocket
extends ProgressServerSocket {
    Hashtable conn_properties = null;

    public AbstractTcpServerSocket(Principal principal, int port, int backlog, ProgressInetAddress bindAddr, Properties properties) throws IOException {
        this.conn_properties = properties;
        this.m_impl = this.openSocket(port, backlog, bindAddr);
    }

    private ServerSocket openSocket(int port, int backlog, ProgressInetAddress bindAddr) throws IOException {
        return this.openServerSocket(port, backlog, bindAddr);
    }

    @Override
    public final ProgressSocket accept() throws IOException {
        Socket s = this.m_impl.accept();
        ProgressInetAddress.showAcceptedSocketDiagnostic("AbstractTcpServerSocket", s);
        if (this.conn_properties != null) {
            Boolean nodelay = null;
            Integer sendBufSize = null;
            Integer receiveBufSize = null;
            nodelay = (Boolean)this.conn_properties.get("TCP_NODELAY");
            sendBufSize = (Integer)this.conn_properties.get("SOCKET_MAX_SEND_BUFFER_SIZE");
            receiveBufSize = (Integer)this.conn_properties.get("SOCKET_MAX_RCV_BUFFER_SIZE");
            try {
                int sz;
                if (nodelay != null) {
                    s.setTcpNoDelay(nodelay);
                } else {
                    s.setTcpNoDelay(true);
                }
                if (sendBufSize != null && (sz = sendBufSize.intValue()) > 0) {
                    s.setSendBufferSize(sz);
                }
                if (receiveBufSize != null && (sz = receiveBufSize.intValue()) > 0) {
                    s.setReceiveBufferSize(sz);
                }
            }
            catch (SocketException e) {
                // empty catch block
            }
        }
        return this.createProgressSocket(s);
    }

    public abstract ServerSocket openServerSocket(int var1, int var2, ProgressInetAddress var3) throws IOException;

    protected abstract ProgressSocket createProgressSocket(Socket var1) throws IOException;
}

