/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import progress.message.util.BiDirMap;

public class BiDirHashMap
implements BiDirMap {
    private final Map forward = new HashMap();
    private final Map reverse = new HashMap();

    @Override
    public BiDirMap.Entry[] put(Object key, Object value) {
        Object old;
        ArrayList<EntryImpl> entries = new ArrayList<EntryImpl>(2);
        if (this.forward.containsKey(key)) {
            old = this.forward.remove(key);
            this.reverse.remove(old);
            entries.add(new EntryImpl(key, old));
        }
        if (this.reverse.containsKey(value)) {
            old = this.reverse.remove(value);
            this.forward.remove(old);
            entries.add(new EntryImpl(old, value));
        }
        this.forward.put(key, value);
        this.reverse.put(value, key);
        return entries.toArray(new EntryImpl[entries.size()]);
    }

    @Override
    public Object removeKey(Object key) {
        Object old = null;
        if (this.forward.containsKey(key)) {
            old = this.forward.remove(key);
            this.reverse.remove(old);
        }
        return old;
    }

    @Override
    public Object removeValue(Object value) {
        Object old = null;
        if (this.reverse.containsKey(value)) {
            old = this.reverse.remove(value);
            this.forward.remove(old);
        }
        return old;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.forward.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.reverse.containsKey(value);
    }

    @Override
    public Object getValue(Object key) {
        return this.forward.get(key);
    }

    @Override
    public Object getKey(Object value) {
        return this.reverse.get(value);
    }

    @Override
    public int size() {
        return this.forward.size();
    }

    @Override
    public void clear() {
        this.forward.clear();
        this.reverse.clear();
    }

    public boolean equals(Object o) {
        if (o != null && this.getClass() == o.getClass()) {
            return this.forward.equals(((BiDirHashMap)o).forward);
        }
        return false;
    }

    public int hashCode() {
        return this.forward.hashCode();
    }

    public String toString() {
        return this.forward.toString();
    }

    private static class EntryImpl
    implements BiDirMap.Entry {
        private final Object key;
        private final Object value;

        public EntryImpl(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o != null && this.getClass() == o.getClass()) {
                EntryImpl other = (EntryImpl)o;
                return (this.key == null ? other.key == null : this.key.equals(other.key)) && (this.value == null ? other.value == null : this.value.equals(other.value));
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            sb.append(this.key);
            sb.append(", ");
            sb.append(this.value);
            sb.append('}');
            return sb.toString();
        }
    }
}

