/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.util.Hashtable;
import progress.message.util.FilterTypeEnumeration;
import progress.message.zclient.SessionConfig;

public class DebugFilterData {
    private String className;
    private State state;
    private final Hashtable<String, String> dataTable = new Hashtable();

    public DebugFilterData(String name) {
        if (null == name || name.length() == 0) {
            SessionConfig.logln("Invalid classname");
        }
        this.className = name;
        this.state = State.CHANGED;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String name) {
        this.className = name;
    }

    public void add(FilterTypeEnumeration name, String value) {
        this.dataTable.put(name.getName(), value);
        this.state = State.CHANGED;
    }

    public void add(FilterTypeEnumeration name, boolean value) {
        this.add(name, Boolean.toString(value));
    }

    public String get(FilterTypeEnumeration name) {
        return this.dataTable.get(name.getName());
    }

    public String get(String name) {
        return this.get(FilterTypeEnumeration.fromString(name));
    }

    public State getState() {
        return this.state;
    }

    public void setState(State value) {
        this.state = value;
    }

    public static enum State {
        CHANGED,
        FILTERED_OUT,
        FILTERED_IN;

    }
}

