/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import com.sonicsw.security.pcs.AbstractCipherSuite;
import com.sonicsw.security.pcs.CipherSuiteInfo;
import com.sonicsw.security.pcs.EInvalidCipherSuiteException;
import com.sonicsw.security.pcs.IPluggableCipherSuite;
import com.sonicsw.security.pcs.SonicCipherSuite;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import progress.message.client.Credentials;
import progress.message.client.EBrokerVersionMismatch;
import progress.message.client.EInauthenticBroker;
import progress.message.client.EInauthenticClient;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.resources.prMessageFormat;
import progress.message.zclient.BaseConnection;
import progress.message.zclient.BrokerConnectParms;
import progress.message.zclient.ClientConnectParms;
import progress.message.zclient.ConnectData;
import progress.message.zclient.ConnectHandshaker;
import progress.message.zclient.Connection;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EUnexpectedMgram;
import progress.message.zclient.ExtendedClientData;
import progress.message.zclient.IDES;
import progress.message.zclient.ISHA;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.prAccessor;

final class ClientConnectHandshaker
extends ConnectHandshaker {
    private boolean m_isAuthenticationSPIEnabled;

    ClientConnectHandshaker(BaseConnection con) {
        super(con);
    }

    static final boolean isBrokerHello(IMgram m) throws EBrokerVersionMismatch {
        if (ClientConnectHandshaker.compareSubtype(m, 2)) {
            try {
                if (m.getRawBody()[1] != 32) {
                    throw new EBrokerVersionMismatch((int)m.getRawBody()[1], 32);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new EBrokerVersionMismatch(23, 32);
            }
            return true;
        }
        return false;
    }

    static final boolean isConnectSuccessMgram(IMgram m) {
        return ClientConnectHandshaker.compareSubtype(m, 7);
    }

    @Override
    public final void handleConnectMgram(IMgram m) throws EInauthenticClient, EInauthenticBroker, EUnexpectedMgram, EMgramFormatError, EInvalidCipherSuiteException {
        switch (this.m_state) {
            case 2: {
                if (ClientConnectHandshaker.compareSubtype(m, 10)) {
                    this.m_state = 7;
                    this.m_sender.send(this.buildPasswordPayload());
                    break;
                }
                super.handleConnectMgram(m);
                break;
            }
            case 7: {
                if (ClientConnectHandshaker.compareSubtype(m, 12)) {
                    this.verifyResponse(m, this.m_transformedPassword);
                    this.m_state = 5;
                    break;
                }
                this.m_state = 8;
                break;
            }
            default: {
                super.handleConnectMgram(m);
            }
        }
    }

    static final IMgram buildClientHello(byte sessionVer) {
        byte[] payload = new byte[]{1, sessionVer};
        return MgramFactory.getMgramFactory().buildConnectMgram(payload, 0);
    }

    static final IMgram buildClientHello(byte sessionVer, boolean faultTolerant, boolean loadBalancing, boolean resume, String clientData, String jmsClientID, String connectID, String localClientHost, ClientConnectParms connectParms) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.write(1);
        dos.write(sessionVer);
        short flags = 0;
        if (loadBalancing) {
            flags = (short)(flags | 1);
        }
        if (faultTolerant) {
            flags = (short)(flags | 2);
        }
        if (resume) {
            flags = (short)(flags | 4);
        }
        if (connectParms != null) {
            flags = (short)(flags | 0x10);
        }
        if (loadBalancing && clientData != null) {
            flags = (short)(flags | 8);
        }
        if (loadBalancing && (jmsClientID != null || connectID != null || localClientHost != null)) {
            flags = (short)(flags | 0x20);
        }
        dos.writeShort(flags);
        if (loadBalancing && clientData != null) {
            dos.writeUTF(clientData);
        }
        if (connectParms != null) {
            connectParms.serialize(dos);
        }
        if ((flags & 0x20) > 0) {
            try {
                ExtendedClientData extendedClientData = new ExtendedClientData();
                extendedClientData.setJMSClientID(jmsClientID);
                extendedClientData.setConnectID(connectID);
                extendedClientData.setLocalClientHost(localClientHost);
                extendedClientData.serialize(dos);
            }
            catch (Exception e) {
                SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
            }
        }
        dos.flush();
        return MgramFactory.getMgramFactory().buildConnectMgram(bos.toByteArray(), 0);
    }

    final void connectClient(boolean active, boolean securityEnabled) throws IOException {
        Connection con = (Connection)this.m_connection;
        Credentials creds = con.getCredentials();
        this.m_uid = creds.getName();
        this.m_transformedPassword = creds.getTransformedPassword();
        byte[] hash = null;
        if (this.m_transformedPassword != null) {
            hash = new byte[20 + this.m_transformedPassword.length];
            System.arraycopy(ProgressPasswordUser.doSHA(this.m_transformedPassword), 0, hash, 0, 20);
            System.arraycopy(this.m_transformedPassword, 0, hash, 20, this.m_transformedPassword.length);
            this.m_transformedPassword = hash;
        }
        this.m_user = this.m_peerCert != null && this.m_uid.equals("AUTHENTICATED") ? new ProgressPasswordUser(this.m_uid, "") : (this.m_transformedPassword != null && this.m_uid != null ? new ProgressPasswordUser(this.m_uid, this.m_transformedPassword) : new ProgressPasswordUser(this.m_uid, creds.getPassword(), true));
        this.m_appid = con.getApplicationId();
        this.m_active = active;
        this.m_sender = con.getSender();
        this.m_client = true;
        this.m_securityEnabled = securityEnabled;
        this.m_cert = con.getSocket().getCertificate();
        this.m_pwKey = new byte[8];
        this.m_sender.send(this.buildClientIdMgram());
        if (active) {
            this.m_state = this.m_peerCert != null && this.m_uid.equals("AUTHENTICATED") ? 4 : 2;
        } else if (securityEnabled) {
            this.m_state = 3;
            this.m_sender.send(this.buildChallenge1());
        } else {
            this.m_state = 5;
            this.m_sender.send(this.buildSecDisabledMgram());
        }
    }

    private IMgram buildClientIdMgram() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeByte(3);
        dos.writeUTF(this.m_user.getName());
        dos.writeUTF(this.m_appid);
        return MgramFactory.getMgramFactory().buildConnectMgram(baos.toByteArray(), 0);
    }

    private final IMgram buildPasswordPayload() throws EInauthenticClient {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String errorMsg = "";
        if (!this.m_isAuthenticationSPIEnabled && this.m_transformedPassword == null) {
            errorMsg = !this.m_isAuthenticationSPIEnabled ? prAccessor.getString("STR121") : prAccessor.getString("STR122");
            try {
                bos.write(13);
                DataOutputStream dos = new DataOutputStream(bos);
                dos.writeUTF(errorMsg);
                dos.flush();
                dos.close();
            }
            catch (IOException e) {
                SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
            }
        } else {
            try {
                bos.write(11);
                DataOutputStream dos = new DataOutputStream(bos);
                dos.writeInt(this.m_transformedPassword.length);
                dos.write(this.m_transformedPassword);
                dos.flush();
                dos.close();
            }
            catch (IOException e) {
                SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
            }
        }
        return MgramFactory.getMgramFactory().buildConnectMgram(bos.toByteArray(), 0);
    }

    private void verifyResponse(IMgram response, byte[] key) throws EInauthenticClient, EInauthenticBroker, EMgramFormatError, EInvalidCipherSuiteException {
        if (this.m_user == null) {
            throw new EInauthenticClient();
        }
        byte[] paddedKey = new byte[key.length + ClientConnectHandshaker.computePad(key.length)];
        System.arraycopy(key, 0, paddedKey, 0, key.length);
        try {
            this.m_responseData = new byte[response.getBodyLength() - 1];
            if (this.m_responseData.length % 8 != 0) {
                throw new EMgramFormatError(prAccessor.getString("STR016"));
            }
            this.DESDecrypt(response.getRawBody(), 1, this.m_responseData, 0, this.m_responseData.length, paddedKey);
            paddedKey = new byte[key.length + ClientConnectHandshaker.computePad(key.length)];
            System.arraycopy(key, 0, paddedKey, 0, key.length);
            this.m_masterSecret = new byte[48];
            System.arraycopy(this.m_responseData, 0, this.m_masterSecret, 0, 48);
            byte[] hash = new byte[20];
            try {
                Class<?> c = Class.forName("progress.message.crypto.SHA");
                ISHA sha = (ISHA)c.newInstance();
                sha.add(this.m_masterSecret);
                sha.add(paddedKey);
                hash = sha.digest();
            }
            catch (Exception e) {
                SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
            }
            if (!this.arrayCompare(hash, 0, this.m_responseData, 48, hash.length)) {
                throw new EInauthenticBroker();
            }
            CipherSuiteInfo cipherInfo = null;
            try {
                if (this.m_responseData.length > 48 + PADDED_HASH_LENGTH) {
                    cipherInfo = new CipherSuiteInfo();
                    int srcPos = 48 + PADDED_HASH_LENGTH;
                    int length = this.m_responseData.length - srcPos;
                    byte[] rawData = new byte[length];
                    int destPos = 0;
                    System.arraycopy(this.m_responseData, srcPos, rawData, destPos, length);
                    cipherInfo.readBytes(rawData);
                }
                if (cipherInfo == null) {
                    this.m_clientCipherSuite = SonicCipherSuite.getInstance();
                } else {
                    String[] cipherDetails = null;
                    String[] digestDetails = null;
                    cipherDetails = cipherInfo.getTransformation(0);
                    if (cipherDetails == null || cipherDetails.length < 3 || cipherDetails[2] == null || cipherDetails[2].trim().length() == 0) {
                        throw new EInvalidCipherSuiteException("Invalid cipher transformation. Default not found");
                    }
                    String[] cipherAndKeySize = AbstractCipherSuite.getTransformationAndKeySize(cipherDetails[2]);
                    if (cipherAndKeySize == null || cipherAndKeySize.length == 0 || cipherAndKeySize[0] == null) {
                        throw new EInvalidCipherSuiteException("Invalid transformation " + cipherDetails[2]);
                    }
                    String transformation = cipherAndKeySize[0];
                    String s = cipherAndKeySize[1];
                    int keySize = 0;
                    if (s != null) {
                        keySize = Integer.parseInt(s);
                    }
                    if ((digestDetails = cipherInfo.getDigest(0)) == null || digestDetails.length < 3 || digestDetails[2] == null || digestDetails[2].trim().length() == 0) {
                        throw new EInvalidCipherSuiteException("Invalid digest. Default not found");
                    }
                    this.m_clientCipherSuite = AbstractCipherSuite.getCipherSuiteInstance(cipherDetails[0], cipherDetails[1], transformation, keySize, digestDetails[0], digestDetails[1], digestDetails[2]);
                    AbstractCipherSuite.m_isKeySizeSupplied = keySize > 0;
                }
            }
            catch (IOException ex) {
                SessionConfig.logMessage(ex, SessionConfig.getLevelWarning());
                throw new EInvalidCipherSuiteException("Unable to read cipher suite information received. " + ex.getMessage());
            }
            catch (IndexOutOfBoundsException ex) {
                SessionConfig.logMessage(ex, SessionConfig.getLevelWarning());
                throw new EInvalidCipherSuiteException("Unable to read cipher suite information received. " + ex.getMessage());
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new EMgramFormatError(prAccessor.getString("STR016"));
        }
    }

    public IPluggableCipherSuite getClientSideCipherSuiteInfo() {
        return this.m_clientCipherSuite;
    }

    public BrokerConnectParms getBrokerConnectParms() {
        return this.m_brokerParameters;
    }

    public void setClientConnectParms(ClientConnectParms parms) {
        this.m_clientParameters = parms;
    }

    final void setAuthenticationSPIEnabled(boolean flag) {
        this.m_isAuthenticationSPIEnabled = flag;
    }

    final ConnectData decodeSuccessMgram(IMgram m, byte incomingVer) throws EMgramFormatError {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(m.getRawBody(), 1, m.getBodyLength() - 1));
            this.m_keyBits = dis.readInt();
            ConnectData cd = ConnectData.getConnectData(dis, (short)-1);
            if (incomingVer >= 27) {
                this.m_brokerParameters = BrokerConnectParms.unserialize(dis);
            }
            return cd;
        }
        catch (Exception e) {
            throw new EMgramFormatError(prMessageFormat.format(prAccessor.getString("STR008"), new Object[]{e.toString()}));
        }
    }

    private final void DESDecrypt(byte[] src, int srcOffset, byte[] dest, int destOffset, int length, byte[] key) throws EInauthenticClient {
        IDES des = (IDES)this.newInstance("progress.message.crypto.DES");
        des.init(2, key);
        des.doFinal(src, srcOffset, length, dest, destOffset);
    }
}

