/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import progress.message.client.EInterrupted;
import progress.message.client.EInterruptedByFailover;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENotConnected;
import progress.message.client.ETimeout;
import progress.message.msg.IExtendedTXNRequestHandle;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.zclient.ClientSender;
import progress.message.zclient.ClientSenderQueue;
import progress.message.zclient.Connection;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EConnectionClosing;
import progress.message.zclient.EFlowControlException;
import progress.message.zclient.Envelope;
import progress.message.zclient.IAckCommitListener;
import progress.message.zclient.IDispatchable;
import progress.message.zclient.IFlowControllableOutputQueue;
import progress.message.zclient.IMgramEnqueuedToSendListener;
import progress.message.zclient.IPTPFlowControlHandler;
import progress.message.zclient.IQuencher;
import progress.message.zclient.ISubject;
import progress.message.zclient.Job;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.MessageSorter;
import progress.message.zclient.PayloadWrapper;
import progress.message.zclient.Publication;
import progress.message.zclient.RejectionTracker;
import progress.message.zclient.Request;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.SynchronousAck;
import progress.message.zclient.prAccessor;
import progress.message.zclient.xonce.IInboundContext;
import progress.message.zclient.xonce.IMsgTracker;
import progress.message.zclient.xonce.IOutboundContext;
import progress.message.zclient.xonce.IRecoveryMutex;
import progress.message.zclient.xonce.MgramTrace;

public class ConnectionInfo
extends DebugObject
implements IQuencher,
IInboundContext,
IOutboundContext,
IRecoveryMutex,
IAckCommitListener,
IDispatchable {
    private final Connection m_connection;
    private final ClientSenderQueue m_senderQueue;
    private final ArrayList m_cancelledMsgQueue = new ArrayList();
    private int m_minReceivePriority;
    private int m_minGuarReceivePriority;
    private int m_minSendPriority;
    private boolean m_blocked = false;
    private boolean m_reportedBlocked = false;
    private long m_blockedTime;
    private int m_blockedAtPriority;
    private Hashtable m_previousBlocked = new Hashtable();
    private Hashtable m_reportedBlockedDests = new Hashtable();
    private long m_inDoubtTime = -1L;
    private volatile boolean m_isClosed = false;
    private boolean m_isClosing = false;
    private boolean m_connDropped = false;
    private Vector m_rcvdGuarMsgs;
    private Vector m_rcvdGuarQMsgs;
    private boolean m_waitingForFCRelease;
    private final IPTPFlowControlHandler m_ptpFlowControlHandler;
    private final boolean DEBUG0 = this.checkDebugFlags(32);
    private boolean m_recovering = false;

    ConnectionInfo(Connection connection) {
        super(DebugState.GLOBAL_DEBUG_ON ? "ConnectionInfo" : null);
        this.m_connection = connection;
        IQuencher pendingQuencher = new IQuencher(){

            @Override
            public void setMinEnqueuePriority(int prio) {
                ConnectionInfo.this.setMinGuarEnqueuePriority(prio);
            }
        };
        this.m_senderQueue = new ClientSenderQueue(this, this, pendingQuencher, connection.getRoutingNodeName());
        this.m_ptpFlowControlHandler = SessionConfig.createPTPFlowControlHandler(this);
        this.m_senderQueue.setFlowControlHandler(this.m_ptpFlowControlHandler);
        this.m_rcvdGuarMsgs = new Vector();
        this.m_rcvdGuarQMsgs = new Vector();
    }

    public Connection getConnection() {
        return this.m_connection;
    }

    @Override
    public String getUid() {
        return this.m_connection.getEffectiveUid();
    }

    @Override
    public String getAppid() {
        return this.m_connection.getApplicationId();
    }

    synchronized IMgram ack(long trkNum, IMgram m) {
        if (this.handleGuarAckAck(trkNum)) {
            return null;
        }
        IMgram result = null;
        PayloadWrapper pw = this.m_senderQueue.removePendingMsg(trkNum);
        if (pw != null) {
            result = pw.getPayload();
        }
        if (m != null && m.isGuarenteed()) {
            switch (m.getType()) {
                case 3: 
                case 14: {
                    this.sendAckAck(m);
                    break;
                }
            }
        }
        return result;
    }

    synchronized void notifyStartOfRecovery() {
        this.notifyAll();
        this.m_senderQueue.dumpOutQueue();
        this.setMinSendPriority(0);
        MessageSorter sorter = null;
        if (this.m_connection != null && (sorter = this.m_connection.getMsgSorter()) != null) {
            sorter.notifyStartOfRecovery();
        }
    }

    public synchronized void dumpOutQueue() {
        this.m_senderQueue.dumpOutQueue();
    }

    public synchronized void onDisconnectDuringResolution() {
        this.m_senderQueue.dumpOutQueue();
        this.setMinSendPriority(0);
        MessageSorter sorter = null;
        if (this.m_connection != null && (sorter = this.m_connection.getMsgSorter()) != null) {
            sorter.resetMinEnqueuePriority();
        }
    }

    synchronized void notifyEndOfRecovery() {
        MessageSorter sorter = null;
        if (this.m_connection != null && (sorter = this.m_connection.getMsgSorter()) != null) {
            sorter.notifyEndOfRecovery();
        }
    }

    @Override
    public final synchronized void notifyPTPResumed(String dest) {
        if (this.m_reportedBlockedDests.get(dest) != null) {
            this.m_previousBlocked.remove(dest);
            this.m_reportedBlockedDests.clear();
            this.sendQueueUnblockedEvent();
        }
    }

    synchronized boolean isAsyncDelivery(long trkNum) {
        return this.m_senderQueue.isAsyncDelivery(trkNum);
    }

    synchronized void notifyBlockedSenders() {
        this.notifyAll();
    }

    synchronized void notifyConnectionDropped() {
        this.m_connDropped = true;
        this.notifyAll();
    }

    @Override
    public void notifyMsgEnqueued() {
        this.getSender().notifyMsgEnqueued(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPTPFlowControlRelease() {
        ClientSender sender = this.getSender();
        if (sender != null) {
            sender.notifyMsgEnqueued(this);
        }
        if (this.m_waitingForFCRelease) {
            ConnectionInfo connectionInfo = this;
            synchronized (connectionInfo) {
                this.notifyAll();
            }
        }
    }

    public void notifyMsgEnqueued(boolean okToDelay) {
        this.getSender().notifyMsgEnqueued(this, okToDelay);
    }

    synchronized PayloadWrapper removeNackedMsg(long trkNum) {
        return this.m_senderQueue.removePendingMsg(trkNum);
    }

    @Override
    public synchronized void setMinEnqueuePriority(int prio) {
        this.m_minReceivePriority = prio;
        this.notifyAll();
    }

    final synchronized void setMinGuarEnqueuePriority(int prio) {
        this.m_minGuarReceivePriority = prio;
        this.notifyAll();
    }

    synchronized void setMinSendPriority(int prio) {
        this.m_minSendPriority = prio;
        if (this.CALLBACK) {
            this.callback("", 200, new Object[]{this.getUid(), this.getAppid(), new Integer(prio)});
        }
        if (this.m_blocked && prio <= this.m_blockedAtPriority) {
            this.m_blocked = false;
            this.m_blockedAtPriority = -1;
            if (this.m_reportedBlocked) {
                this.m_reportedBlocked = false;
                this.sendTopicUnblockedEvent();
            }
        }
    }

    synchronized void checkTopicFlowControl() {
        int blockedCount = this.m_senderQueue.getEnqueuedBelow(this.m_minSendPriority);
        if (blockedCount > 0) {
            if (!this.m_blocked) {
                this.m_blocked = true;
                this.m_blockedAtPriority = this.m_senderQueue.getMaxNonEmptyPriorityBelow(this.m_minSendPriority);
                this.m_blockedTime = System.currentTimeMillis();
                return;
            }
            long elapsed = System.currentTimeMillis() - this.m_blockedTime;
            this.m_reportedBlocked = true;
            this.sendTopicBlockedEvent(elapsed);
        }
    }

    private synchronized void sendTopicBlockedEvent(long elapsed) {
        String uid = this.m_connection.getPrincipal().getName();
        String appid = this.m_connection.getApplicationId();
        String subject = SessionConfig.getAdminPrefix(uid, appid) + ".pubblocked";
        try {
            Message event = new Message(subject);
            event.writeLong(this.m_connection.getClientId());
            event.writeInt(this.m_minSendPriority);
            event.writeLong(elapsed);
            Label lbl = new Label();
            lbl.setPriority((byte)12);
            lbl.setRouteLimit(1);
            Envelope env = new Envelope(event, lbl);
            this.internalSend(env, null, event.getSubject(), null);
        }
        catch (ENetworkFailure e) {
            // empty catch block
        }
    }

    private synchronized void sendTopicUnblockedEvent() {
        String uid = this.m_connection.getPrincipal().getName();
        String appid = this.m_connection.getApplicationId();
        String subject = SessionConfig.getAdminPrefix(uid, appid) + ".pubresumed";
        try {
            Message event = new Message(subject);
            event.writeLong(this.m_connection.getClientId());
            Label lbl = new Label();
            lbl.setPriority((byte)12);
            lbl.setRouteLimit(1);
            Envelope env = new Envelope(event, lbl);
            this.internalSend(env, null, event.getSubject(), null);
        }
        catch (ENetworkFailure e) {
            // empty catch block
        }
    }

    synchronized void checkQueueFlowControl() {
        if (this.m_ptpFlowControlHandler.hasBlocked()) {
            int i;
            String[] blockedNow = this.m_ptpFlowControlHandler.getBlockedDestinations();
            Vector<String> reportList = new Vector<String>();
            for (i = 0; i < blockedNow.length; ++i) {
                if (!this.m_previousBlocked.containsKey(blockedNow[i])) continue;
                reportList.addElement(blockedNow[i]);
                this.m_reportedBlockedDests.put(blockedNow[i], blockedNow[i]);
            }
            this.m_previousBlocked.clear();
            for (i = 0; i < blockedNow.length; ++i) {
                this.m_previousBlocked.put(blockedNow[i], blockedNow[i]);
            }
            if (!reportList.isEmpty()) {
                Object[] destArray = new String[reportList.size()];
                reportList.copyInto(destArray);
                this.sendQueueBlockedEvent((String[])destArray);
            }
        } else {
            this.m_previousBlocked.clear();
        }
    }

    private synchronized void sendQueueBlockedEvent(String[] destinations) {
        String uid = this.m_connection.getPrincipal().getName();
        String appid = this.m_connection.getApplicationId();
        String subject = SessionConfig.getAdminPrefix(uid, appid) + ".sendblocked";
        try {
            Message event = new Message(subject);
            event.writeInt(destinations.length);
            for (int i = 0; i < destinations.length; ++i) {
                if (destinations[i].startsWith("$Q.")) {
                    event.writeUTF(destinations[i].substring("$Q.".length()));
                    continue;
                }
                event.writeUTF(destinations[i]);
            }
            Label lbl = new Label();
            lbl.setPriority((byte)12);
            lbl.setRouteLimit(1);
            Envelope env = new Envelope(event, lbl);
            this.internalSend(env, null, event.getSubject(), null);
        }
        catch (ENetworkFailure e) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private synchronized void sendQueueUnblockedEvent() {
        String uid = this.m_connection.getPrincipal().getName();
        String appid = this.m_connection.getApplicationId();
        String subject = SessionConfig.getAdminPrefix(uid, appid) + ".sendresumed";
        try {
            Message event = new Message(subject);
            Label lbl = new Label();
            lbl.setPriority((byte)12);
            lbl.setRouteLimit(1);
            Envelope env = new Envelope(event, lbl);
            this.internalSend(env, null, event.getSubject(), null);
        }
        catch (ENetworkFailure e) {
            // empty catch block
        }
    }

    synchronized void monitor() {
        this.checkQueueFlowControl();
        this.checkTopicFlowControl();
    }

    private final boolean waitForEnqueueClearance(byte prio, boolean isRecoveryThread) throws ENotConnected, EInterruptedByFailover, InterruptedException, EConnectionClosing {
        return this.waitForEnqueueClearance(prio, false, false, null, null, true, isRecoveryThread);
    }

    private final synchronized boolean waitForEnqueueClearance(byte prio, boolean guar, boolean fcDisabled, String routing, ISubject subject, boolean isPubSub, boolean isRecoveryThread) throws ENotConnected, EInterruptedByFailover, InterruptedException, EConnectionClosing {
        if (isRecoveryThread) {
            return true;
        }
        if (prio > 9) {
            return true;
        }
        this.checkForClosedConnection();
        if (!(prio < this.m_minReceivePriority || guar && prio < this.m_minGuarReceivePriority)) {
            return true;
        }
        do {
            if (fcDisabled && subject != null && subject.isSubjectSet() && this.m_ptpFlowControlHandler.isDestinationBlocked(routing, subject, isPubSub)) {
                return false;
            }
            this.wait();
            this.checkForClosedConnection();
        } while (prio < this.m_minReceivePriority || guar && prio < this.m_minGuarReceivePriority);
        return true;
    }

    synchronized boolean waitForEnqueueClearance(byte prio, long timeoutMillis, boolean isRecoveryThread) throws ENotConnected, ETimeout, EInterruptedByFailover, InterruptedException, EConnectionClosing {
        if (isRecoveryThread) {
            return true;
        }
        if (prio > 9) {
            return true;
        }
        this.checkForClosedConnection();
        if (prio >= this.m_minReceivePriority) {
            return true;
        }
        long curtime = System.currentTimeMillis();
        long endtime = curtime + timeoutMillis;
        while (curtime < endtime) {
            this.wait(endtime - curtime);
            this.checkForClosedConnection();
            if (prio >= this.m_minReceivePriority) {
                return true;
            }
            curtime = System.currentTimeMillis();
        }
        throw new ETimeout("Timeout while waiting to enqueue message");
    }

    public final synchronized boolean waitForMessageDelivery(long timeout) {
        long start = 0L;
        boolean interrupted = false;
        boolean firstWait = true;
        boolean unlimited = timeout == -1L;
        this.m_waitingForFCRelease = true;
        boolean timedOut = false;
        while (this.hasUnsentMessages() && !this.m_connDropped && !this.m_isClosed) {
            if (firstWait) {
                start = System.currentTimeMillis();
            } else if (!unlimited && timeout - (System.currentTimeMillis() - start) < 0L) {
                timedOut = true;
                break;
            }
            try {
                if (unlimited) {
                    this.wait();
                } else {
                    this.wait(timeout);
                }
            }
            catch (InterruptedException e) {
                if (this.checkDebugFlags(8192)) {
                    this.debug("Interrupted waiting for message delivery");
                }
                interrupted = true;
                break;
            }
            firstWait = false;
        }
        this.m_waitingForFCRelease = false;
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (this.DEBUG0) {
            long wait = start > 0L ? System.currentTimeMillis() - start : 0L;
            this.debug(this.getAppid() + ": Waited " + wait + "ms for message delivery, interrupted= " + interrupted + ", Has unsent: " + this.hasUnsentMessages());
        }
        return timedOut && this.hasUnsentMessages();
    }

    private final boolean hasUnsentMessages() {
        if (this.DEBUG0) {
            this.debug("Unsent messages: OQ Empty=" + !this.m_senderQueue.hasOutgoingMsgs() + ", PQ Empty=" + !this.m_senderQueue.hasPendingMsgs() + " FC empty " + !this.m_ptpFlowControlHandler.hasBlocked());
        }
        return this.m_senderQueue.hasOutgoingMsgs() || this.m_senderQueue.hasPendingMsgs() || this.m_ptpFlowControlHandler.hasBlocked();
    }

    public synchronized void cancelUnsentMessages() {
        this.m_ptpFlowControlHandler.releaseAll();
        while (this.m_senderQueue.hasOutgoingMsgs()) {
            this.m_cancelledMsgQueue.add(this.m_senderQueue.dequeueAtOrAbove(0));
        }
    }

    public synchronized void rejectUndeliveredMessages(int reason) {
        RejectionTracker tracker;
        this.m_ptpFlowControlHandler.releaseAll();
        Enumeration pending = this.m_senderQueue.getPendingMsgs();
        while (pending.hasMoreElements()) {
            PayloadWrapper pw = (PayloadWrapper)pending.nextElement();
            if (this.DEBUG0) {
                this.debug("Cancelling pending delivery of: " + MgramTrace.diagnosticString("", this.m_connection, pw.m_payload));
            }
            this.m_connection.terminateJob(pw.m_trackingNum, reason);
            RejectionTracker tracker2 = pw.m_payload.getJMSClientHandle().getRejectionTracker();
            if (tracker2 == null) continue;
            tracker2.processRejection(Publication.buildException(reason, pw.getSubject(), null));
        }
        this.m_senderQueue.clearPendingMsgs();
        for (IMgram m : this.m_cancelledMsgQueue) {
            tracker = m.getJMSClientHandle().getRejectionTracker();
            if (this.DEBUG0) {
                this.debug("Cancelling pending delivery of: " + MgramTrace.diagnosticString("", this.m_connection, m));
            }
            if (tracker == null) continue;
            tracker.processRejection(Publication.buildException(reason, m.getSubject(), null));
        }
        this.m_cancelledMsgQueue.clear();
        while (this.m_senderQueue.hasOutgoingMsgs()) {
            IMgram m;
            m = this.m_senderQueue.dequeueAtOrAbove(0);
            tracker = m.getJMSClientHandle().getRejectionTracker();
            if (this.DEBUG0) {
                this.debug("Cancelling pending delivery of: " + MgramTrace.diagnosticString("", this.m_connection, m));
            }
            if (tracker == null) continue;
            tracker.processRejection(Publication.buildException(reason, m.getSubject(), null));
        }
    }

    private final void checkForClosedConnection() throws EInterruptedByFailover, ENotConnected {
        if (!this.isFaultTolerant()) {
            if (this.m_isClosed || this.m_connDropped) {
                throw new ENotConnected();
            }
        } else {
            if (this.m_connection.inRecoveryState()) {
                throw new EInterruptedByFailover();
            }
            if (this.m_connection.getState() == 1 || this.m_connection.getState() == 2) {
                throw new ENotConnected();
            }
            if (this.m_isClosed) {
                throw new ENotConnected();
            }
        }
        if (this.m_isClosing) {
            throw new ENotConnected();
        }
    }

    private ClientSender getSender() {
        return (ClientSender)this.m_connection.getSender();
    }

    public synchronized void send(Envelope env, IMgramEnqueuedToSendListener listener, boolean isRecoveryThread) throws ENetworkFailure, EInterrupted, EFlowControlException {
        try {
            byte prio = env.getPriority();
            boolean guar = env.isGuaranteed() && (!env.isDiscardable() || env.isQueueMessage());
            ISubject subject = env.getMessage() == null ? null : env.getMessage().getSubject();
            String routing = env.getRouting();
            boolean async = false;
            if (subject != null && this.m_connection.isFlowControlDisabled() && !subject.isSystem()) {
                if (prio < this.m_minSendPriority) {
                    throw new EFlowControlException(301, prAccessor.getString("STR183"));
                }
                if (env.isQueueMessage() || !env.isDiscardable()) {
                    boolean blocked = this.m_ptpFlowControlHandler.isDestinationBlocked(routing, subject, !env.isQueueMessage());
                    if (blocked) {
                        if (env.isQueueMessage()) {
                            throw new EFlowControlException(311, prAccessor.getString("QUEUE_DEST_BLOCKED"));
                        }
                        throw new EFlowControlException(311, prAccessor.getString("TOPIC_DEST_BLOCKED"));
                    }
                    async = env.isAsyncDelivery();
                }
            }
            boolean status = this.waitForEnqueueClearance(prio, guar, async, routing, subject, !env.isQueueMessage(), isRecoveryThread);
            if (async && !status) {
                if (env.isQueueMessage()) {
                    throw new EFlowControlException(311, prAccessor.getString("QUEUE_DEST_BLOCKED"));
                }
                throw new EFlowControlException(311, prAccessor.getString("TOPIC_DEST_BLOCKED"));
            }
            this.internalSend(env, routing, subject, listener);
        }
        catch (InterruptedException e) {
            throw new EInterrupted();
        }
    }

    public synchronized void send(Envelope env, long timeoutMillis, IMgramEnqueuedToSendListener listener, boolean isRecoveryThread) throws ENetworkFailure, ETimeout, EInterrupted, EFlowControlException {
        try {
            byte prio = env.getPriority();
            ISubject subject = env.getMessage() == null ? null : env.getMessage().getSubject();
            String routing = env.getRouting();
            if (subject != null && this.m_connection.isFlowControlDisabled() && !subject.isSystem() && prio < this.m_minSendPriority) {
                throw new EFlowControlException(301, prAccessor.getString("STR183"));
            }
            this.waitForEnqueueClearance(prio, timeoutMillis, isRecoveryThread);
            this.internalSend(env, routing, subject, listener);
        }
        catch (InterruptedException e) {
            throw new EInterrupted();
        }
    }

    public synchronized void send(IMgram mg) {
        try {
            this.send(mg, null, this.isFaultTolerant() && this.m_connection.isRecoveryThread());
        }
        catch (EFlowControlException fcE) {
            fcE.printStackTrace();
        }
    }

    public synchronized void send(IMgram mg, IMgramEnqueuedToSendListener listener, boolean isRecoveryThread) throws EFlowControlException {
        try {
            IExtendedTXNRequestHandle handle;
            if (this.DEBUG && this.checkDebugFlags(128)) {
                this.debug("got mgram type " + mg.getType() + ", size " + mg.networkLength());
            }
            byte prio = mg.getPriority();
            if (this.m_connection.isFlowControlDisabled() && prio < this.m_minSendPriority && mg.getType() == 26 && (handle = mg.getExtendedTXNRequestHandle()).getOp() == 0) {
                throw new EFlowControlException(301, prAccessor.getString("STR183"));
            }
            try {
                this.waitForEnqueueClearance(prio, isRecoveryThread);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                if (listener != null) {
                    listener.enqueuedToSend(mg);
                }
                this.m_senderQueue.enqueue(mg, prio);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.notifyMsgEnqueued();
        }
        catch (ENotConnected e) {
        }
        catch (EConnectionClosing ecc) {
        }
        catch (EInterruptedByFailover eif) {
            // empty catch block
        }
    }

    @Override
    public synchronized void sendThrough(IMgram m) {
        if (this.DEBUG && this.checkDebugFlags(128)) {
            this.debug("got mgram type " + m.getType() + ", size " + m.networkLength());
        }
        byte prio = m.getPriority();
        try {
            this.m_senderQueue.enqueue(m, prio);
            this.notifyMsgEnqueued();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void internalSend(Envelope env, String routing, ISubject subject, IMgramEnqueuedToSendListener listener) throws ENetworkFailure {
        byte prio = env.getPriority();
        long trackingNum = env.getGuarTracking();
        long expTm = env.getExpirationTime();
        boolean okToDelay = false;
        boolean asyncDelivery = env.isAsyncDelivery();
        if (!env.isGuaranteed() && prio <= 9 && asyncDelivery && !env.isReply() && !env.isRequest()) {
            okToDelay = true;
        }
        try {
            env.syncAll(this.m_connection, this.getSender().getMessageProtection());
        }
        catch (IOException e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
        if (listener != null) {
            listener.enqueuedToSend(env.getMgram());
        }
        this.m_senderQueue.enqueue(env.getMgram(), prio, trackingNum, expTm, routing, subject, asyncDelivery);
        this.notifyMsgEnqueued(okToDelay);
    }

    public synchronized IMgram getNextMgram() {
        if (this.m_connection.isFlowControlDisabled()) {
            return this.m_senderQueue.dequeueAtOrAbove(0);
        }
        return this.m_senderQueue.dequeueAtOrAbove(this.m_minSendPriority);
    }

    synchronized String getPendingDebugInfo() {
        return this.m_senderQueue.getPendingDebugInfo();
    }

    @Override
    public boolean needsGuarAck() {
        return this.m_connection.isFaultToleranceEnabled();
    }

    @Override
    public void rcvdGuarQMsg(long back_tracking, IMsgTracker tracker) {
        if (this.isXOnce()) {
            this.m_rcvdGuarQMsgs.addElement(new Long(back_tracking));
        }
    }

    @Override
    public void rcvdGuarMsg(long back_tracking, IMsgTracker tracker) {
        if (this.isXOnce()) {
            this.m_rcvdGuarMsgs.addElement(new Long(back_tracking));
        }
    }

    @Override
    public List getGuarQMsgTrkNums() {
        return (List)this.m_rcvdGuarQMsgs.clone();
    }

    @Override
    public List getGuarMsgTrkNums() {
        return (List)this.m_rcvdGuarMsgs.clone();
    }

    @Override
    public final void sendQAck(long tracking, IMgram m) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void setQAckPendingConfirm(long acktracking, long tracking) {
        throw new UnsupportedOperationException("Acknowldement tracking not supported for client");
    }

    @Override
    public List getUnconfirmedGuarQAcks() {
        return new Vector();
    }

    @Override
    public final void sendAck(IMgram m) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public final void sendAck(long tracking, IMgram m) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public final void sendAck(long backTracking, IMgram m, long redirectClient) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void sendAckAck(IMgram ack) {
        if (ack != null && ack.isGuarenteed()) {
            switch (ack.getType()) {
                case 14: {
                    this.m_connection.sendQAck(ack.getGuarenteedTrackingNum(), false, 0, this.m_connection.getClientId());
                    break;
                }
                case 3: {
                    this.m_connection.sendAck(ack.getGuarenteedTrackingNum(), false, 0, this.m_connection.getClientId());
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    @Override
    public void setGuarAckPendingConfirm(long acktracking, long tracking) {
        throw new UnsupportedOperationException("Acknowldement tracking not supported for client");
    }

    @Override
    public List getUnconfirmedGuarAcks() {
        return new Vector();
    }

    @Override
    public boolean handleGuarQAckAck(long ackTracking) {
        return this.handleGuarAckAck(ackTracking);
    }

    @Override
    public boolean handleGuarAckAck(long ackTracking) {
        Job job = this.m_connection.getJob(ackTracking);
        if (job == null || !(job instanceof SynchronousAck)) {
            return false;
        }
        SynchronousAck ackJob = (SynchronousAck)this.m_connection.removeJob(ackTracking);
        IMgram ack = ackJob.getAck();
        ackJob.setStatus(0);
        Connection receivingConn = ack.getJMSClientHandle().getConnection();
        if (receivingConn != null) {
            receivingConn.getConnectionInfo().guarMsgAcked(ack);
        }
        return true;
    }

    void guarMsgAcked(IMgram ack) {
        if (this.isFaultTolerant()) {
            if (ack.getType() == 14) {
                this.m_rcvdGuarQMsgs.remove(new Long(ack.getAckHandle().getTrackingNumber()));
            } else if (ack.getType() == 3) {
                this.m_rcvdGuarMsgs.remove(new Long(ack.getAckHandle().getTrackingNumber()));
            } else if (ack.getType() == 28) {
                this.guarMsgsAcked(ack.getAckListHandle().getPtpList());
                this.guarMsgsAcked(ack.getAckListHandle().getPubSubList());
            }
        }
    }

    private void guarMsgsAcked(Collection c) {
        if (c != null && !c.isEmpty()) {
            for (IMgram ackMgram : c) {
                this.guarMsgAcked(ackMgram);
            }
        }
    }

    @Override
    public void guarQAcksDone(List confirmed) {
        this.m_rcvdGuarQMsgs.removeAll(confirmed);
    }

    @Override
    public void ackCommitted(long tracking) {
        Long LTrk = new Long(tracking);
        this.m_rcvdGuarQMsgs.remove(LTrk);
        this.m_rcvdGuarMsgs.remove(LTrk);
    }

    @Override
    public void guarAcksDone(List confirmed) {
        this.m_rcvdGuarMsgs.removeAll(confirmed);
    }

    @Override
    public void rcvdXORequest(long reqId, IMgram mgram) {
    }

    @Override
    public void prepareXOReply(long reqId, IMgram mgram) {
    }

    @Override
    public void sendReply(int reqId, IMgram mgram) {
    }

    @Override
    public boolean handleXOReplyAck(long replyAckTracking) {
        return false;
    }

    @Override
    public List getPendingReplies() {
        return new Vector();
    }

    public boolean isFaultTolerant() {
        return this.m_connection.isFaultToleranceEnabled();
    }

    @Override
    public boolean isXOnce() {
        return this.m_connection.isFaultToleranceEnabled();
    }

    @Override
    public IMgram removeQMsgPendingAck(long tracking) {
        return this.removeMsgPendingAck(tracking);
    }

    @Override
    public synchronized IMgram removeMsgPendingAck(long tracking) {
        return this.removeMsgPendingAck(tracking, true);
    }

    synchronized IMgram removeMsgPendingAck(long tracking, boolean terminateJob) {
        PayloadWrapper pw = this.m_senderQueue.removePendingMsg(tracking);
        if (terminateJob) {
            this.m_connection.terminateJob(tracking, 0);
        }
        if (pw != null) {
            return pw.getPayload();
        }
        return null;
    }

    Session getTxSession(int tid) {
        return this.getConnection().getSessionByTid(tid);
    }

    @Override
    public void inDoubtQMsgAcked(long tracking) {
        if (this.handleDoubtTransactedMsgAcked(tracking)) {
            return;
        }
        this.removeQMsgPendingAck(tracking);
    }

    @Override
    public void inDoubtMsgAcked(long tracking) {
        if (this.handleDoubtTransactedMsgAcked(tracking)) {
            return;
        }
        this.removeMsgPendingAck(tracking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleDoubtTransactedMsgAcked(long tracking) {
        PayloadWrapper pw = null;
        ConnectionInfo connectionInfo = this;
        synchronized (connectionInfo) {
            pw = this.m_senderQueue.getPendingMsg(tracking);
        }
        if (pw != null && pw.isTransacted()) {
            IMgram m = pw.getPayload();
            Session s = this.getTxSession(m.getTxnId());
            if (s != null) {
                s.receivedStorageAck(tracking);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void allInDoubtMsgsAcked(List leavePendingQ, List leavePendingGuar, List leavePendingRsp) {
        PayloadWrapper pw;
        Enumeration pending = this.m_senderQueue.getPendingMsgs();
        while (pending.hasMoreElements()) {
            boolean isAckAndForward;
            pw = (PayloadWrapper)pending.nextElement();
            boolean bl = isAckAndForward = pw.getType() == 11;
            if ((pw.isPersistent() || pw.isTransacted()) && !isAckAndForward) {
                if (leavePendingQ.contains(new Long(pw.getGuarenteedTrackingNum())) || leavePendingGuar.contains(new Long(pw.getGuarenteedTrackingNum()))) continue;
                this.m_senderQueue.enqueueDirect(pw);
                continue;
            }
            this.removeMsgPendingAck(pw.getGuarenteedTrackingNum(), !isAckAndForward);
        }
        for (Long l : leavePendingGuar) {
            pw = this.m_senderQueue.getPendingMsg(l);
            if (pw == null || !pw.isTransacted()) continue;
            this.m_connection.terminateJob(pw.getGuarenteedTrackingNum(), 0);
        }
        for (Long l : leavePendingQ) {
            pw = this.m_senderQueue.getPendingMsg(l);
            if (pw == null || !pw.isTransacted()) continue;
            this.m_connection.terminateJob(pw.getGuarenteedTrackingNum(), 0);
        }
        for (Long l : leavePendingRsp) {
            Request req = this.m_connection.getRequest(l);
            if (req == null) continue;
            req.setPendingResponse(true);
        }
        this.notifyMsgEnqueued();
    }

    @Override
    public List getPendingRequests() {
        return this.m_connection.getPendingXONCERequests();
    }

    @Override
    public void notifyRequestsPendingReply(List pending) {
    }

    @Override
    public void expireInDoubt() {
    }

    @Override
    public synchronized boolean hasInDoubtState() {
        return this.m_senderQueue.hasPendingMsgs();
    }

    @Override
    public void setInDoubtTime() {
        this.m_inDoubtTime = System.currentTimeMillis();
    }

    @Override
    public long getInDoubtTime() {
        return this.m_inDoubtTime;
    }

    public synchronized void setClosing() {
        this.m_isClosing = true;
        this.notifyAll();
    }

    public synchronized void setClosed() {
        this.m_isClosed = true;
        this.notifyAll();
    }

    @Override
    public IPTPFlowControlHandler getPTPFlowControlHandler() {
        return this.m_ptpFlowControlHandler;
    }

    @Override
    public IFlowControllableOutputQueue getFlowControllableOutputQueue() {
        return this.m_senderQueue;
    }

    @Override
    public Object getSyncObj() {
        return this;
    }

    @Override
    public byte getPeerSessionVer() {
        return this.m_connection.getBrokerSessionVer();
    }

    @Override
    public boolean isRecovering() {
        return this.m_recovering;
    }

    @Override
    public void setRecovering(boolean b) {
        this.m_recovering = b;
    }
}

