/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.PrintWriter;
import java.io.StringWriter;
import progress.message.util.DebugFormatter;
import progress.message.util.DebugState;
import progress.message.zclient.IDebugCallback;
import progress.message.zclient.SessionConfig;

public class DebugObject {
    protected boolean updateDebugFlags = false;
    protected boolean DEBUG = false;
    protected boolean CALLBACK = false;
    protected boolean DEBUG_UNEXPECTED = false;
    protected String m_name;
    public int debugFlags = 0;
    private IDebugCallback m_callbackClass = null;
    private static final DebugFormatter FORMATTER = DebugFormatter.MULTI_THREAD;

    public DebugObject(String name) {
        this.m_name = name;
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.setFlags();
        }
    }

    protected DebugObject() {
    }

    public final void debug(boolean d) {
        this.DEBUG = d;
    }

    public final void debug(String s) {
        this.debug(s, true);
    }

    public final void debug(String s, boolean logTimestamp) {
        if (this.debugFlags > 0) {
            String debugMessagePrefix = this.getDebugMessagePrefix();
            if (debugMessagePrefix != null && !debugMessagePrefix.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append(debugMessagePrefix);
                sb.append(s);
                s = sb.toString();
            }
            SessionConfig.logln(FORMATTER.format(this.m_name, s, logTimestamp));
        }
    }

    public final void debug(String msg, Throwable th) {
        this.debug(msg, th, true);
    }

    public final void debug(String msg, Throwable th, boolean logTimestamp) {
        StringBuilder sb = new StringBuilder();
        if (msg != null) {
            sb.append(msg).append("\n");
        }
        if (th != null) {
            sb.append(DebugObject.getStackTrace(th));
        }
        this.debug(sb.toString(), logTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final String getStackTrace(Throwable th) {
        if (th == null) {
            return "";
        }
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            th.printStackTrace(pw);
        }
        catch (Exception ignore) {
            String string = th.toString() + "\n  -- unable to display Exception stack due to [" + ignore + "]";
            return string;
        }
        finally {
            if (sw != null) {
                try {
                    sw.close();
                }
                catch (Exception ignore) {}
            }
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Exception ignore) {}
            }
        }
        return sw.toString();
    }

    protected void callback(String text, int method, Object params) {
        if (this.m_callbackClass != null) {
            this.m_callbackClass.callback(text, method, params);
        } else {
            this.debug(text);
        }
    }

    public static final void class_debug(String class_name, String s) {
        DebugObject.class_debug(class_name, 128, s);
    }

    public static final void class_debug(String class_name, int debugItems, String s) {
        if (DebugState.GLOBAL_DEBUG_ON && (DebugState.getDiagnosticFlags(class_name) & debugItems) > 0) {
            SessionConfig.logln(FORMATTER.format(class_name, s));
        }
    }

    public String toString() {
        if (this.m_name == null) {
            return "";
        }
        return this.m_name;
    }

    public final void debugName(String name) {
        this.m_name = name;
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.setFlags();
        }
    }

    public final boolean checkDebugFlags(int debugItems) {
        this.updateDebugFlagsIfNeeded();
        return (this.debugFlags & debugItems) > 0;
    }

    public final boolean getDebug() {
        this.updateDebugFlagsIfNeeded();
        return this.DEBUG;
    }

    private final void updateDebugFlagsIfNeeded() {
        int debugFlags2;
        if (this.updateDebugFlags && this.m_name != null && this.debugFlags != (debugFlags2 = DebugState.getDiagnosticFlags(this.m_name))) {
            this.setFlags();
        }
    }

    private final void setFlags() {
        block7: {
            this.DEBUG = false;
            if (this.m_name != null) {
                this.debugFlags = DebugState.getDiagnosticFlags(this.m_name);
                this.DEBUG = (this.debugFlags & 0x80) > 0;
                this.CALLBACK = (this.debugFlags & 0x400) > 0;
                this.DEBUG_UNEXPECTED = (this.debugFlags & 0x2000) > 0;
                try {
                    if (!this.CALLBACK) break block7;
                    String className = DebugState.getCallback(this.m_name);
                    if (className != null) {
                        this.m_callbackClass = (IDebugCallback)Class.forName(className).newInstance();
                        break block7;
                    }
                    String name = DebugState.getFirstToken(this.m_name);
                    try {
                        className = (String)System.getProperties().get(name + ".debugClassName");
                        if (className != null) {
                            this.m_callbackClass = (IDebugCallback)Class.forName(className).newInstance();
                        }
                    }
                    catch (SecurityException securityException) {}
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        }
    }

    protected String getDebugMessagePrefix() {
        return null;
    }
}

