/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.client.EEnvelopeIsNotRequest;
import progress.message.client.EGeneralException;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.EMessageNotSent;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENotImplemented;
import progress.message.client.ESecurityGeneralException;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.jclient.DeliveryMode;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;
import progress.message.util.Hex;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.Connection;
import progress.message.zclient.ENoTrackingNum;
import progress.message.zclient.IAckCommitListener;
import progress.message.zclient.IMessage;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.ISubject;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.MessageSorter;
import progress.message.zclient.RejectionTracker;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.SessionConfig;

public final class Envelope
implements Cloneable {
    private static final boolean DEBUG_SECURITY = false;
    private static final String SEP = ":";
    private IMessage m_message;
    private byte m_Protection;
    private byte m_RequestProtection;
    boolean DEBUG1 = false;
    private Label m_label;
    private boolean m_trackHandlers;
    private MessageSorter m_msgSorter;
    private int m_handlerCount;
    private int m_guarHandlerCount;
    private boolean m_noMoreHandlers;
    private boolean m_acked;
    private boolean m_releasedQueueMemory;
    private boolean m_acknowledgeAndForward;
    private boolean m_pubSubMsgAckedAsQMsg;
    private boolean m_explicitAck;
    private Envelope m_parentEnv;
    private boolean m_splitDeliveryPart = false;
    private int m_unackedSplitDeliveryCount = 0;
    private boolean m_splitDelivery = false;
    public boolean m_subject_ok = true;
    private IMgram m_mgram = null;
    private boolean m_labelProtected = false;
    private IAckCommitListener m_ackCommitListener;
    private boolean m_isUserAcked = false;
    private long m_timestamp = -1L;
    private boolean m_timestampDirty = false;
    private boolean m_timestampCached = false;
    private int m_cachedLength = -1;

    public boolean isAsyncDelivery() {
        return this.m_mgram.getJMSClientHandle().isJMSAsynchronous();
    }

    public void setAsyncDelivery(boolean asyncDelivery) {
        this.m_mgram.getJMSClientHandle().setJMSAsynchronous(asyncDelivery);
    }

    public final void setRejectionTracker(RejectionTracker tracker) {
        this.m_mgram.getJMSClientHandle().setRejectionTracker(tracker);
    }

    public final RejectionTracker getRejectionTracker() {
        return this.m_mgram.getJMSClientHandle().getRejectionTracker();
    }

    public final void setRejectable(boolean rejectable) {
        this.m_mgram.setRejectable(true);
    }

    public IAckCommitListener getAckCommitListener() {
        return this.m_ackCommitListener;
    }

    public void setAckCommitListener(IAckCommitListener l) {
        this.m_ackCommitListener = l;
    }

    public void setPtp(byte type) {
        if (type != 12 && type != 13 && type != 11) {
            throw new EAssertFailure("Illegal set of a non-PTP type");
        }
        this.m_mgram.setType(type);
    }

    public void ptpToPubsub() {
        if (this.isQueueMessage()) {
            this.m_mgram.setType((byte)2);
        }
    }

    public boolean isQueueMessage() {
        return this.m_mgram.isPTP() || this.m_mgram.getType() == 11;
    }

    public Envelope(IMessage msg) {
        this.m_message = msg;
        this.m_mgram = MgramFactory.getMgramFactory().createMgram(true);
        this.m_Protection = 0;
    }

    public Envelope(IMessage msg, Label label) {
        this.m_message = msg;
        this.m_label = label;
        this.m_mgram = MgramFactory.getMgramFactory().createMgram(true);
        this.m_Protection = 0;
    }

    public Message getMessage() {
        return (Message)this.m_message;
    }

    public boolean isRequest() {
        return this.m_mgram.isRequest();
    }

    public long getId() throws EGeneralException, EMessageNotSent {
        throw new ENotImplemented("getId()");
    }

    public Label getLabel() {
        this.unprotectLabel();
        if (this.m_label == null) {
            this.m_label = new Label();
            this.m_labelProtected = false;
        }
        return this.m_label;
    }

    public void setLabel(Label label) {
        this.m_labelProtected = false;
        this.m_label = label;
    }

    public void setMessage(IMessage msg) {
        this.m_message = msg;
    }

    Envelope() {
        this.m_mgram = MgramFactory.getMgramFactory().createMgram(true);
    }

    private Envelope(Envelope env) {
        this.m_message = env.m_message;
        this.m_Protection = env.m_Protection;
        this.m_RequestProtection = env.m_RequestProtection;
        this.DEBUG1 = env.DEBUG1;
        this.m_label = env.m_label;
        this.m_trackHandlers = env.m_trackHandlers;
        this.m_msgSorter = env.m_msgSorter;
        this.m_handlerCount = env.m_handlerCount;
        this.m_guarHandlerCount = env.m_guarHandlerCount;
        this.m_noMoreHandlers = env.m_noMoreHandlers;
        this.m_acked = env.m_acked;
        this.m_releasedQueueMemory = env.m_releasedQueueMemory;
        this.m_acknowledgeAndForward = env.m_acknowledgeAndForward;
        this.m_pubSubMsgAckedAsQMsg = env.m_pubSubMsgAckedAsQMsg;
        this.m_explicitAck = env.m_explicitAck;
        this.m_parentEnv = env.m_parentEnv;
        this.m_subject_ok = env.m_subject_ok;
        this.m_mgram = env.m_mgram;
        this.m_labelProtected = env.m_labelProtected;
        this.m_isUserAcked = env.m_isUserAcked;
        this.m_timestamp = env.m_timestamp;
        this.m_timestampCached = env.m_timestampCached;
        this.m_timestampDirty = env.m_timestampDirty;
    }

    public Envelope(IMgram nm, boolean authenticate, Connection conn, IMessageProtection mp) throws UTFDataFormatException, ESecurityGeneralException {
        this(nm, authenticate, conn, mp, -1);
    }

    public Envelope(IMgram nm, boolean authenticate, Connection conn, IMessageProtection mp, int size) throws ESecurityGeneralException {
        this.m_mgram = nm;
        Label lab = this.getLabel();
        if (authenticate) {
            if (conn == null) {
                throw new EAssertFailure("conn == null");
            }
            ClientSecurityContext csc = conn.getSecurityContext();
            if (csc.isQopSecurityEnabled() && !this.m_mgram.isSecure()) {
                throw new EIntegrityCompromised();
            }
        }
        lab.setRouteLimit(this.m_mgram.getRouteLimit());
        lab.setPersistent(this.m_mgram.isJMSPersistent() && !this.m_mgram.isNonPersistentReplicated());
        if (this.m_mgram.isRequest()) {
            lab.setReplyPriority((byte)this.m_mgram.getReplyPriority());
        }
        if (this.m_mgram.isTTE()) {
            lab.setExpirationTime(this.m_mgram.getTTE());
        }
        lab.setPriority(this.m_mgram.getPriority());
        Message msg = new Message();
        if (this.m_mgram.hasSubject()) {
            msg.setSubject(this.m_mgram.getSubject());
        }
        if (this.m_mgram.hasBody()) {
            msg.setBody(this.m_mgram.getRawBody());
        }
        this.m_message = msg;
        if (size != -1) {
            this.m_cachedLength = size;
        }
    }

    public void syncAll(Connection connection, IMessageProtection mp) throws IOException {
        this.syncEnvelopeData();
        this.syncConnection(connection);
        this.syncSecurity(connection, mp);
        this.m_mgram.sync();
    }

    public void syncConnection(Connection connection) {
        this.m_mgram.setChannel(connection.getChannel());
    }

    public void syncSecurity(Connection connection, IMessageProtection mp) throws IOException {
        ClientSecurityContext SecCtx = connection.getSecurityContext();
        if (SecCtx.isQopSecurityEnabled()) {
            this.m_mgram.setMgramSecure(mp);
            if (this.m_mgram.isReply()) {
                this.m_Protection = SecurityLogic.AttribsFromPrivate((byte)3, this.m_RequestProtection);
                this.m_mgram.setSecurityAttribute(this.m_Protection);
            } else {
                this.m_Protection = this.m_mgram.getJMSClientHandle().isPerMsgEncrypted() ? SecurityLogic.AttribsFromPublic((byte)1, (byte)2) : connection.getInternalQop(this.m_message.getSubject());
                this.m_mgram.setSecurityAttribute(this.m_Protection);
                if (this.m_mgram.getType() == 27) {
                    this.m_mgram.getBatchHandle().syncBatchSecurity();
                    this.m_mgram.getBatchHandle().syncPerMsgEnc(SecCtx, mp);
                }
            }
        } else {
            this.setNonSecure();
        }
    }

    public void setNonSecure() throws IOException {
        this.m_mgram.setMgramNonSecure();
        this.m_Protection = 0;
    }

    public void syncEnvelopeData() {
        if (this.m_mgram.getType() != 27) {
            boolean jmsPersistent;
            boolean hasTTE;
            boolean bl = hasTTE = this.m_label != null && this.m_label.getExpirationTime() >= 0L;
            if (hasTTE) {
                this.m_mgram.setTTE(this.m_label.getExpirationTime());
            } else {
                this.m_mgram.removeTTE();
            }
            boolean bl2 = jmsPersistent = this.m_label != null && this.m_label.isPersistent();
            if (jmsPersistent) {
                this.m_mgram.setJMSPersistent(true);
            } else if (!this.m_mgram.isNonPersistentReplicated()) {
                this.m_mgram.setJMSPersistent(false);
            }
            if (this.m_label == null) {
                this.m_mgram.setPriority((byte)0);
                this.m_mgram.setRouteLimit(7);
            } else {
                this.m_mgram.setPriority(this.m_label.getPriority());
                this.m_mgram.setRouteLimit(this.m_label.getRouteLimit());
            }
            if (this.m_mgram.isRequest()) {
                if (this.m_label == null) {
                    throw new NullPointerException("'Label m_label' in " + this.getClass().getName() + " cannot be null.");
                }
                this.m_mgram.setReplyPriority(this.m_label.getReplyPriority());
            }
            if (this.m_timestampDirty) {
                this.m_mgram.createSidebandDataIfNeeded();
                this.m_mgram.getSidebandData().setTimestamp(this.m_timestamp);
                this.m_timestampDirty = false;
            }
            this.m_mgram.setBody(this.m_message.getRawBody(), this.m_message.getRawBodyLength());
        }
        this.m_mgram.setSubject(this.m_message.getSubject().protectedClone(), 5);
    }

    public void syncEnvelopeBatch() {
        boolean jmsPersistent;
        boolean hasTTE;
        boolean bl = hasTTE = this.m_label != null && this.m_label.getExpirationTime() >= 0L;
        if (hasTTE) {
            this.m_mgram.setTTE(this.m_label.getExpirationTime());
        } else {
            this.m_mgram.removeTTE();
        }
        boolean bl2 = jmsPersistent = this.m_label != null && this.m_label.isPersistent();
        if (jmsPersistent) {
            this.m_mgram.setJMSPersistent(true);
        } else if (!this.m_mgram.isNonPersistentReplicated()) {
            this.m_mgram.setJMSPersistent(false);
        }
        if (this.m_label != null) {
            this.m_mgram.setPriority(this.m_label.getPriority());
            this.m_mgram.setRouteLimit(this.m_label.getRouteLimit());
        }
        this.m_mgram.setBody(this.m_message.getRawBody(), this.m_message.getRawBodyLength());
        this.m_mgram.setSubject(this.m_message.getSubject(), 5);
        long currentTime = System.currentTimeMillis();
        this.m_mgram.getSidebandData().setTimestamp(currentTime);
        this.setTimestamp(currentTime);
    }

    public void setTxnBatchable(int tid) {
        this.m_mgram = MgramFactory.getMgramFactory().buildTxnBatchMgram(this.m_mgram, tid);
    }

    public void setPerMsgEncrypted(boolean perMsgEnc) {
        this.m_mgram.getJMSClientHandle().setPerMsgEncrypted(perMsgEnc);
    }

    public void addToBatch(Envelope env) {
        this.m_mgram.getOperationHandle().addMgram(env.getMgram());
    }

    void clearSysFields() {
        this.m_mgram.clearID();
        this.m_mgram.setRequestReplySend();
        this.m_parentEnv = null;
    }

    void setGuaranteed(long tracking) {
        this.m_mgram.setGuarenteed(tracking);
    }

    public void setDiscardable(boolean value) {
        this.m_mgram.setDiscardable(value);
    }

    public void setDeliveryMode(int deliveryMode) {
        boolean isNonPersistentReplicated;
        boolean isPersistent = deliveryMode == 2;
        boolean isDiscardable = deliveryMode == DeliveryMode.DISCARDABLE;
        boolean bl = isNonPersistentReplicated = deliveryMode == DeliveryMode.NON_PERSISTENT_REPLICATED;
        if (this.m_label == null) {
            this.m_label = new Label();
        }
        this.m_label.setPersistent(isPersistent);
        this.setDiscardable(isDiscardable);
        this.m_mgram.setNonPersistentReplicated(isNonPersistentReplicated);
    }

    public void setUndeliveredDestination(boolean value) {
        this.m_mgram.setUndeliveredDestination(value);
    }

    public void setPriority(byte priority) {
        if (this.m_label == null) {
            this.m_label = new Label();
        }
        this.m_label.setPriority(priority);
    }

    public byte getPriority() {
        if (this.m_label == null) {
            this.m_label = new Label();
        }
        return this.m_label.getPriority();
    }

    public long getExpirationTime() {
        if (this.m_label == null) {
            return 0L;
        }
        long expTime = this.m_label.getExpirationTime();
        return expTime < 0L ? 0L : expTime;
    }

    public void setExpirationTime(long time) {
        if (this.m_label == null) {
            this.m_label = new Label();
        }
        this.m_label.setExpirationTime(time > 0L ? time : -1L);
    }

    public long getDeliveryTime() {
        Long deliveryTime = (Long)this.getProperty("JMSDeliveryTime");
        if (deliveryTime == null) {
            return 0L;
        }
        return deliveryTime;
    }

    public void setDeliveryTime(long deliveryTime) {
        this.getProperties().put("JMSDeliveryTime", deliveryTime);
    }

    public boolean isPersistent() {
        if (this.m_label == null) {
            this.m_label = new Label();
        }
        return this.m_label.isPersistent();
    }

    public boolean isNonPersistentReplicated() {
        return this.m_mgram.isNonPersistentReplicated();
    }

    public boolean isDiscardable() {
        return this.m_mgram.isDiscardable();
    }

    void setTxn(int tid) {
        this.m_mgram.setTxn(tid);
    }

    public void removeTxn() {
        this.m_mgram.removeTxn();
    }

    public void setRequest(int tracking, String subject) {
        this.m_mgram.setRequest(tracking, subject);
    }

    public IMgram getMgram() {
        return this.m_mgram;
    }

    public void setReply(Envelope req) throws EEnvelopeIsNotRequest {
        if (!req.isRequest()) {
            throw new EEnvelopeIsNotRequest();
        }
        this.m_mgram.setReply(req.getMgram());
        this.getMessage().setSubject(this.m_mgram.getSubject());
        this.m_RequestProtection = req.m_RequestProtection;
        this.getLabel().setPriority(req.getLabel().getReplyPriority());
    }

    public int getReplyTracking() throws ENoTrackingNum {
        return this.m_mgram.getReplyTracking();
    }

    public ISubject getReplySubject() {
        return this.m_mgram.getReplySubject();
    }

    public ISubject getSubject() {
        return this.m_mgram.getSubject();
    }

    public boolean isReply() {
        return this.m_mgram.isReply();
    }

    public boolean isGuaranteed() {
        return this.m_mgram.isGuarenteed();
    }

    public boolean isSuccessor() {
        return this.m_mgram.isSuccessor();
    }

    public long getGuarTracking() {
        return this.m_mgram.getGuarenteedTrackingNum();
    }

    public void setSuccessor(boolean s) {
        this.m_mgram.setSuccessor(s);
    }

    public void unprotectSuccessor() {
        this.m_mgram.unprotectSuccessor();
    }

    public void setSubject(ISubject s, int msf) {
        if (this.m_mgram != null) {
            this.m_mgram.setSubject(s, msf);
        }
        if (this.m_message != null) {
            ((Message)this.m_message).setSubject(s);
        }
    }

    void setTrackHandlers(MessageSorter sorter) {
        this.m_trackHandlers = true;
        this.m_msgSorter = sorter;
    }

    synchronized void clearTrackHandlers() {
        this.m_trackHandlers = false;
        this.m_parentEnv = null;
    }

    public void clearInternalBodyData() {
        this.getMgram().setBody(null);
        this.getMessage().setBody(null);
    }

    synchronized void addHandler(boolean guaranteed) {
        if (this.m_trackHandlers) {
            ++this.m_handlerCount;
            if (guaranteed && this.m_mgram.isGuarenteed()) {
                ++this.m_guarHandlerCount;
            }
        }
    }

    public void handlerDone(boolean guaranteed) {
        this.handlerDone(guaranteed, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlerDone(boolean guaranteed, boolean explicitAck) {
        if (this.m_parentEnv != null) {
            if (this.DEBUG1 && this.m_splitDeliveryPart) {
                System.out.println("Handler Done for split delivery:  Subject: " + this.m_mgram.getSubject().getSubjectString() + " Guar: " + this.m_mgram.isGuarenteed() + ", explicitAck: " + explicitAck + ", parent Acked: " + this.m_parentEnv.isAcked() + ", trk: " + this.m_mgram.getGuarenteedTrackingNum() + ", s trk: " + this.m_mgram.getSubject().getSubjectTracking() + ", handlerCount: " + this.m_parentEnv.m_handlerCount);
            }
            this.m_parentEnv.handlerDone(guaranteed, explicitAck);
            boolean sendSplitAck = false;
            if (this.m_splitDeliveryPart && this.m_mgram.isGuarenteed()) {
                Envelope envelope = this;
                synchronized (envelope) {
                    if (explicitAck) {
                        this.m_explicitAck = true;
                    }
                    if (!this.m_parentEnv.isAcked() && !this.m_acked && !this.m_explicitAck && this.m_mgram.isGuarenteed()) {
                        if (this.DEBUG1) {
                            System.out.println("Sending handler done split delivery ack for:  Subject: " + this.m_mgram.getSubject().getSubjectString() + " Guar: " + this.m_mgram.isGuarenteed() + ", explicitAck: " + explicitAck + ", parent Acked: " + this.m_parentEnv.isAcked() + ", trk: " + this.m_mgram.getGuarenteedTrackingNum() + ", s trk: " + this.m_mgram.getSubject().getSubjectTracking());
                        }
                        sendSplitAck = true;
                        this.m_acked = true;
                    }
                }
                if (sendSplitAck) {
                    this.m_msgSorter.sendSyncSplitDeliveryAck(this.m_mgram.getGuarenteedTrackingNum(), (short)this.getSubject().getSubjectTracking());
                }
            }
            return;
        }
        if (this.m_trackHandlers) {
            boolean freeMem;
            boolean sendAck = false;
            Envelope envelope = this;
            synchronized (envelope) {
                if (explicitAck) {
                    this.m_explicitAck = true;
                }
                --this.m_handlerCount;
                if (this.m_handlerCount < 0 && SessionConfig.IN_BROKER) {
                    SessionConfig.logMessage("Negative Handler Count: len= " + this.length(), SessionConfig.getLevelWarning());
                }
                if (guaranteed && this.m_mgram.isGuarenteed()) {
                    --this.m_guarHandlerCount;
                    if (this.m_guarHandlerCount < 0 && SessionConfig.IN_BROKER) {
                        SessionConfig.logMessage("Negative guarHandler Count: len= " + this.length(), SessionConfig.getLevelWarning());
                    }
                    sendAck = this.checkSendAck();
                }
                freeMem = this.checkFreeQueueMemory();
            }
            if (sendAck) {
                this.m_msgSorter.sendAck(this.m_mgram.getGuarenteedTrackingNum());
            }
            if (freeMem) {
                this.m_msgSorter.freeQueueMemory(this.length(), this.getLabel().getPriority());
            }
            if (this.DEBUG1 && (sendAck || freeMem)) {
                System.out.println("handlerDone " + this.length() + " m_handlerCount " + this.m_handlerCount + " sendAck= " + sendAck + " m_guarHandlerCount " + this.m_guarHandlerCount + " freemem= " + freeMem + " m_explicitAck= " + this.m_explicitAck);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noMoreHandlers() {
        if (this.m_parentEnv != null) {
            this.m_parentEnv.noMoreHandlers();
            return;
        }
        if (this.m_trackHandlers) {
            boolean freeMem;
            boolean sendAck;
            Envelope envelope = this;
            synchronized (envelope) {
                this.m_noMoreHandlers = true;
                sendAck = this.checkSendAck();
                freeMem = this.checkFreeQueueMemory();
            }
            if (sendAck) {
                this.m_msgSorter.sendAck(this.m_mgram.getGuarenteedTrackingNum());
            }
            if (freeMem) {
                this.m_msgSorter.freeQueueMemory(this.length(), this.getLabel().getPriority());
            }
            if (this.DEBUG1 && (sendAck || freeMem)) {
                System.out.println("noMoreHandlers " + this.length() + " m_handlerCount " + this.m_handlerCount + " m_guarHandlerCount " + this.m_guarHandlerCount + " sendAck= " + sendAck + " freemem= " + freeMem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void acknowledge(Connection con, boolean dupsOk, boolean skipAckSend) throws ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        if (this.m_splitDeliveryPart) {
            boolean sendAck = false;
            if (this.DEBUG1) {
                System.out.println("Acknowledge for split delivery:  Subject: " + this.m_mgram.getSubject().getSubjectString() + " Guar: " + this.m_mgram.isGuarenteed() + ", explicitAck: " + this.m_explicitAck + ", skipAckSend: " + skipAckSend + ", parent Acked: " + this.m_parentEnv.isAcked() + ", trk: " + this.m_mgram.getGuarenteedTrackingNum() + ", s trk: " + this.m_mgram.getSubject().getSubjectTracking() + ", handlerCount: " + this.m_parentEnv.m_handlerCount);
            }
            Envelope envelope = this;
            synchronized (envelope) {
                if (!this.m_acked) {
                    sendAck = true;
                }
            }
            if (sendAck) {
                this.m_parentEnv.decrementSplitDeliveryAckCount();
                this.m_parentEnv.acknowledge(con, dupsOk, skipAckSend);
            }
            if (this.m_mgram.isGuarenteed()) {
                envelope = this;
                synchronized (envelope) {
                    if (!this.m_parentEnv.isAcked() && !this.m_acked) {
                        sendAck = true;
                        this.m_acked = true;
                    } else {
                        sendAck = false;
                    }
                }
                if (sendAck && !skipAckSend) {
                    if (this.DEBUG1) {
                        System.out.println("Split delivery ack being sent for:  trk " + this.m_mgram.getGuarenteedTrackingNum() + " s trk " + this.m_mgram.getSubject().getSubjectTracking());
                    }
                    if (dupsOk) {
                        con.sendSplitDeliveryAck(this.m_mgram.getGuarenteedTrackingNum(), (short)this.getSubject().getSubjectTracking());
                    } else {
                        con.sendSyncSplitDeliveryAck(this.m_mgram.getGuarenteedTrackingNum(), false, 0, con, (short)this.getSubject().getSubjectTracking());
                    }
                }
            }
            return;
        }
        if (this.m_parentEnv != null) {
            this.m_parentEnv.acknowledge(con, dupsOk, skipAckSend);
            return;
        }
        if (this.m_trackHandlers && con.getMsgSorter() == this.m_msgSorter) {
            boolean sendAck;
            if (this.DEBUG1 && this.m_splitDelivery) {
                System.out.println("Split Delivery parent ack for trk: " + this.m_mgram.getGuarenteedTrackingNum() + "m_unackedSplitDeliveryCount: " + this.m_unackedSplitDeliveryCount + "m_acked: " + this.m_acked);
            }
            Envelope envelope = this;
            synchronized (envelope) {
                boolean bl = sendAck = this.m_mgram.isGuarenteed() && !this.m_acked && this.m_unackedSplitDeliveryCount == 0;
                if (sendAck) {
                    this.m_acked = true;
                }
            }
            if (sendAck && !skipAckSend) {
                if (dupsOk) {
                    IMgram ack = con.sendAck(this.m_mgram.getGuarenteedTrackingNum());
                    con.getConnectionInfo().guarMsgAcked(ack);
                } else {
                    con.sendSynchronousAck(this.m_mgram.getGuarenteedTrackingNum(), false, 0, con);
                }
            }
        }
    }

    private boolean checkFreeQueueMemory() {
        boolean freeMem;
        boolean bl = freeMem = this.m_handlerCount == 0 && this.m_noMoreHandlers && !this.m_releasedQueueMemory;
        if (!this.m_explicitAck) {
            boolean bl2 = freeMem = freeMem && (!this.m_mgram.isGuarenteed() || this.m_acked);
        }
        if (freeMem) {
            this.m_releasedQueueMemory = true;
        }
        if (this.DEBUG1 && (this.m_splitDelivery || this.m_splitDeliveryPart) && freeMem) {
            System.out.println("Free q memory for: " + this.m_mgram.getSubject().getSubjectString() + " trk: " + this.m_mgram.getGuarenteedTrackingNum());
        }
        return freeMem;
    }

    private boolean checkSendAck() {
        boolean sendAck;
        boolean bl = sendAck = !this.m_explicitAck && this.m_mgram.isGuarenteed() && this.m_guarHandlerCount == 0 && this.m_noMoreHandlers && !this.m_acked;
        if (sendAck) {
            this.m_acked = true;
        }
        return sendAck;
    }

    boolean isAcked() {
        if (this.m_parentEnv != null) {
            return this.m_parentEnv.isAcked() && (!this.m_splitDeliveryPart || this.m_acked);
        }
        return this.m_acked;
    }

    public boolean isUserAcked() {
        if (this.m_parentEnv != null) {
            return this.m_parentEnv.isUserAcked();
        }
        return this.m_isUserAcked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserAcked() {
        if (this.m_parentEnv != null) {
            if (this.m_splitDeliveryPart) {
                boolean ackParent = false;
                Envelope envelope = this;
                synchronized (envelope) {
                    if (!this.m_isUserAcked) {
                        ackParent = true;
                    }
                    this.m_isUserAcked = true;
                }
                if (ackParent) {
                    this.m_parentEnv.setUserAcked();
                }
            } else {
                this.m_parentEnv.setUserAcked();
            }
        } else {
            if (this.m_splitDelivery) {
                Envelope envelope = this;
                synchronized (envelope) {
                    if (this.m_unackedSplitDeliveryCount <= 0) {
                        this.m_isUserAcked = true;
                    }
                }
            } else {
                this.m_isUserAcked = true;
            }
            if (this.m_ackCommitListener != null && this.m_isUserAcked) {
                this.m_ackCommitListener.ackCommitted(this.getGuarTracking());
            }
        }
    }

    int getUnackedSplitDeliveryCount() {
        if (this.m_parentEnv != null) {
            return this.m_parentEnv.getUnackedSplitDeliveryCount();
        }
        return this.m_unackedSplitDeliveryCount;
    }

    Envelope getSplitDeliveryParent() {
        if (this.m_splitDeliveryPart) {
            return this.m_parentEnv;
        }
        if (this.m_parentEnv != null) {
            return this.m_parentEnv.getSplitDeliveryParent();
        }
        return null;
    }

    public Object clone() {
        Envelope env = new Envelope(this);
        try {
            env.m_mgram = (IMgram)env.m_mgram.shallowClone();
            if (env.m_parentEnv == null) {
                env.m_parentEnv = this;
            }
            return env;
        }
        catch (CloneNotSupportedException e) {
            throw new EAssertFailure(e.toString(), e);
        }
    }

    public Object protectedClone() {
        this.m_labelProtected = true;
        Envelope env = new Envelope(this);
        try {
            env.m_message = (IMessage)((Message)this.m_message).protectedClone();
            if (env.m_parentEnv == null) {
                env.m_parentEnv = this;
            }
            env.m_mgram = (IMgram)this.m_mgram.protectedClone();
        }
        catch (CloneNotSupportedException e) {
            throw new EAssertFailure(e.toString(), e);
        }
        return env;
    }

    public final void setSplitDeliveryPart() {
        this.m_splitDeliveryPart = true;
        this.m_parentEnv.addHandler(this.m_mgram.isGuarenteed());
    }

    final boolean isSplitDeliveryPart() {
        return this.m_splitDeliveryPart || this.m_parentEnv != null && this.m_parentEnv.isSplitDeliveryPart();
    }

    public final void setSplitDelivery(int count) {
        this.m_splitDelivery = true;
        this.m_unackedSplitDeliveryCount = count;
    }

    private final synchronized void decrementSplitDeliveryAckCount() {
        --this.m_unackedSplitDeliveryCount;
    }

    private void unprotectLabel() {
        if (this.m_labelProtected && this.m_label != null) {
            this.m_label = (Label)this.m_label.clone();
            this.m_labelProtected = false;
        }
    }

    public Object deepClone() {
        Envelope env = new Envelope(this);
        try {
            env.m_message = (IMessage)((Message)this.m_message).clone();
            if (this.m_label != null) {
                env.m_label = (Label)this.m_label.clone();
            }
            if (env.m_parentEnv == null) {
                env.m_parentEnv = this;
            }
            env.m_mgram = (IMgram)this.m_mgram.shallowClone();
            this.m_labelProtected = false;
            return env;
        }
        catch (CloneNotSupportedException e) {
            throw new EAssertFailure(e.toString(), e);
        }
    }

    public String getOriginalMessageID() {
        if (this.m_parentEnv == null) {
            return this.getMessageID("");
        }
        return this.m_parentEnv.getOriginalMessageID();
    }

    public int length() {
        if (this.m_cachedLength == -1) {
            this.m_cachedLength = this.trueLength();
        }
        return this.m_cachedLength;
    }

    public int trueLength() {
        int result = (this.m_message == null ? 0 : this.m_message.length()) + (this.m_label == null ? 0 : Label.length()) + 4 + 1;
        return result;
    }

    public void overrideLength(int length) {
        this.m_cachedLength = length;
    }

    public short getBodyType() {
        this.m_mgram.createSidebandDataIfNeeded();
        return this.m_mgram.getSidebandDataReadOnly().getBodyType();
    }

    public void setBodyType(short bodyType) {
        this.m_mgram.createSidebandDataIfNeeded();
        this.m_mgram.getSidebandData().setBodyType(bodyType);
    }

    public String getType() {
        this.m_mgram.createSidebandDataIfNeeded();
        return this.m_mgram.getSidebandDataReadOnly().getType();
    }

    public void setType(String type) {
        this.m_mgram.createSidebandDataIfNeeded();
        this.m_mgram.getSidebandData().setType(type);
    }

    public void setMessageID(long brokerID, long messageID, String prefix) {
        this.m_mgram.createSidebandDataIfNeeded();
        this.m_mgram.getSidebandData().setMessageID(brokerID, messageID, prefix);
    }

    public String getMessageID(String prefix) {
        return Envelope.buildMessageID(prefix, this.getBrokerID(), this.getConnectionAndLocalID(), this.getTimestamp());
    }

    private static String buildMessageID(String prefix, long brokerID, long messageID, long timestamp) {
        StringBuffer id = new StringBuffer(256);
        if (prefix != null && prefix.length() > 0) {
            id.append(prefix);
        }
        Hex.longToHexString(brokerID, id, false);
        id.append(SEP);
        Hex.longToHexString(messageID, id, false);
        id.append(SEP);
        Hex.longToHexString(timestamp, id, true);
        return id.toString();
    }

    public static String getMessageID(IMgram mgram) {
        ISidebandData sd = mgram.getSidebandDataReadOnly();
        if (sd != null) {
            return Envelope.buildMessageID(null, sd.getBrokerID(), sd.getConnectionAndLocalID(), sd.getTimestamp());
        }
        return null;
    }

    public String getCorrelationID() {
        this.m_mgram.createSidebandDataIfNeeded();
        return this.m_mgram.getSidebandDataReadOnly().getCorrelationID();
    }

    public void setCorrelationID(String id) {
        this.m_mgram.createSidebandDataIfNeeded();
        this.m_mgram.getSidebandData().setCorrelationID(id);
    }

    public String getReplyTo() {
        this.m_mgram.createSidebandDataIfNeeded();
        return this.m_mgram.getSidebandDataReadOnly().getReplyTo();
    }

    public void setReplyTo(String replyTo) {
        this.m_mgram.createSidebandDataIfNeeded();
        this.m_mgram.getSidebandData().setReplyTo(replyTo);
    }

    public String getRouting() {
        return this.m_mgram.getRoutingHandle().getRouting();
    }

    public Vector getAllRouting() {
        return this.m_mgram.getRoutingHandle().getAllRouting();
    }

    public String getAllRoutingString() {
        return this.m_mgram.getRoutingHandle().getAllRoutingString();
    }

    public void setRouting(String routing) {
        this.m_mgram.getRoutingHandle().setRouting(routing);
    }

    public long getTimestamp() {
        if (!this.m_timestampCached) {
            this.m_mgram.createSidebandDataIfNeeded();
            this.m_timestamp = this.m_mgram.getSidebandDataReadOnly().getTimestamp();
            this.m_timestampCached = true;
        }
        return this.m_timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.m_timestamp = timestamp;
        this.m_timestampDirty = true;
        this.m_timestampCached = true;
    }

    public Hashtable getProperties() {
        this.m_mgram.createSidebandDataIfNeeded();
        return this.m_mgram.getSidebandData().getProperties();
    }

    public Object getProperty(String property) {
        this.m_mgram.createSidebandDataIfNeeded();
        return this.m_mgram.getSidebandDataReadOnly().getProperty(property);
    }

    public void setProperties(Hashtable properties) {
        this.m_mgram.createSidebandDataIfNeeded();
        this.m_mgram.getSidebandData().setProperties(properties);
    }

    public long getBrokerID() {
        this.m_mgram.createSidebandDataIfNeeded();
        return this.m_mgram.getSidebandDataReadOnly().getBrokerID();
    }

    public long getConnectionAndLocalID() {
        this.m_mgram.createSidebandDataIfNeeded();
        return this.m_mgram.getSidebandDataReadOnly().getConnectionAndLocalID();
    }

    public void setAcknowledgeAndForward() {
        this.m_acknowledgeAndForward = true;
    }

    public boolean forwardAcknowledged() {
        return this.m_acknowledgeAndForward;
    }

    public void setPubSubMsgAckedAsQMsg() {
        this.m_pubSubMsgAckedAsQMsg = true;
    }

    public boolean pubSubMsgAckedAsQMsg() {
        return this.m_pubSubMsgAckedAsQMsg;
    }

    public String getExtendedType() {
        return (String)this.getProperty("JMS_SonicMQ_ExtendedType");
    }

    public void setExtendedType(String type) {
        this.getProperties().put("JMS_SonicMQ_ExtendedType", type);
    }
}

