/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import progress.message.util.StreamUtil;

public final class ExtendedClientData
implements Cloneable {
    static final byte CURRENT_VERSION = 1;
    private short m_version = 1;
    private String m_jmsClientID;
    private String m_connectID;
    private String m_localClientHost;

    public String getJMSClientID() {
        return this.m_jmsClientID;
    }

    public String getConnectID() {
        return this.m_connectID;
    }

    public String getLocalClientHost() {
        return this.m_localClientHost;
    }

    public void setJMSClientID(String jmsClientID) {
        this.m_jmsClientID = jmsClientID;
    }

    public void setConnectID(String connectID) {
        this.m_connectID = connectID;
    }

    public void setLocalClientHost(String localClientHost) {
        this.m_localClientHost = localClientHost;
    }

    public void serialize(OutputStream os) throws IOException {
        StreamUtil.writeShort(this.m_version, os);
        ExtendedClientData.writeString(this.m_jmsClientID, os);
        ExtendedClientData.writeString(this.m_connectID, os);
        ExtendedClientData.writeString(this.m_localClientHost, os);
    }

    public static ExtendedClientData unserialize(DataInput stream) throws IOException {
        ExtendedClientData extendedClientData = new ExtendedClientData();
        extendedClientData.m_version = stream.readShort();
        if (extendedClientData.m_version == 1) {
            extendedClientData.m_jmsClientID = ExtendedClientData.readString(stream);
            extendedClientData.m_connectID = ExtendedClientData.readString(stream);
            extendedClientData.m_localClientHost = ExtendedClientData.readString(stream);
        }
        return extendedClientData;
    }

    private static void writeString(String value, OutputStream stream) throws IOException {
        StreamUtil.writeUTF(value != null ? value : "", stream);
    }

    private static String readString(DataInput stream) throws IOException {
        String readed = stream.readUTF();
        return readed == null || readed.isEmpty() ? null : readed;
    }
}

