/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.UTFDataFormatException;
import progress.message.client.EGeneralException;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.ENonrepudiationFailed;
import progress.message.client.ENotImplemented;
import progress.message.client.EPrivacyCompromised;
import progress.message.resources.prMessageFormat;
import progress.message.util.CCLObjectInputStream;
import progress.message.util.WrappedDataOutputStream;
import progress.message.zclient.IMessage;
import progress.message.zclient.ISubject;
import progress.message.zclient.Subject;
import progress.message.zclient.prAccessor;

public class Message
implements ObjectInput,
ObjectOutput,
Cloneable,
IMessage {
    private ISubject m_subject;
    protected byte[] m_data;
    protected int m_capInc;
    protected int m_count;
    protected int m_cRead;
    private static int INITIAL_CAPACITANCE = 256;
    private transient ObjectOutputStream oostream;
    private transient ByteArrayInputStream bistream;
    private transient ObjectInputStream oistream;
    private boolean m_dataProtected = false;

    private Message(Message msg) {
        this.m_subject = msg.m_subject;
        this.m_data = msg.m_data;
        this.m_capInc = msg.m_capInc;
        this.m_count = msg.m_count;
        this.m_cRead = msg.m_cRead;
        this.m_dataProtected = msg.m_dataProtected;
        this.oostream = msg.oostream;
        this.oistream = msg.oistream;
    }

    public Message() {
        this.m_capInc = 0;
        this.m_count = 0;
        this.m_cRead = 0;
    }

    public Message(String subject) {
        this.m_capInc = 0;
        this.m_count = 0;
        this.m_cRead = 0;
        this.m_subject = new Subject(subject);
    }

    public Message(String subject, byte[] body) {
        this(body);
        this.m_subject = new Subject(subject);
    }

    public Message(byte[] body) {
        this.m_data = body;
        this.m_capInc = 0;
        this.m_count = body == null ? 0 : body.length;
        this.m_cRead = 0;
    }

    public Message(byte[] body, int index, int length) {
        if (body == null) {
            this.setBody(null);
        } else if (body == null || length == 0 || index + length > body.length) {
            this.m_data = new byte[INITIAL_CAPACITANCE];
            this.m_capInc = 0;
            this.m_count = 0;
            this.m_cRead = 0;
        } else {
            this.m_data = new byte[INITIAL_CAPACITANCE];
            System.arraycopy(body, index, this.m_data, 0, length);
            this.m_capInc = 0;
            this.m_count = length;
            this.m_cRead = index;
        }
    }

    public String[] getPublishers() {
        throw new ENotImplemented(prAccessor.getString("STR061"));
    }

    @Override
    public ISubject getSubject() {
        return this.m_subject;
    }

    public Message setSubject(ISubject subject) {
        this.m_subject = subject;
        return this;
    }

    public Message setSubject(String subject) {
        this.m_subject = new Subject(subject);
        return this;
    }

    @Override
    public byte[] getBody() throws EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        if (this.m_data == null) {
            return null;
        }
        byte[] dataTrimed = new byte[this.m_count];
        System.arraycopy(this.m_data, 0, dataTrimed, 0, this.m_count);
        return dataTrimed;
    }

    @Override
    public byte[] getRawBody() {
        return this.m_data;
    }

    @Override
    public int getRawBodyLength() {
        return this.m_count;
    }

    @Override
    public void protect() {
        this.m_dataProtected = true;
    }

    public final Message setBody(byte[] body) {
        this.m_data = body;
        this.m_dataProtected = false;
        this.m_capInc = 0;
        this.m_count = body == null ? 0 : body.length;
        this.m_cRead = 0;
        return this;
    }

    public Message setBody(byte[] body, int index, int length) {
        this.m_dataProtected = false;
        if (body == null || body.length == 0 || length == 0 || index + length > body.length) {
            this.m_data = new byte[INITIAL_CAPACITANCE];
            this.m_capInc = 0;
            this.m_count = 0;
            this.m_cRead = 0;
        } else {
            this.m_data = new byte[INITIAL_CAPACITANCE];
            System.arraycopy(body, index, this.m_data, 0, length);
            this.m_capInc = 0;
            this.m_count = length;
            this.m_cRead = index;
        }
        return this;
    }

    @Override
    public boolean isSubjectSet() {
        return this.m_subject != null && this.m_subject.isSubjectSet();
    }

    public String toString() {
        return super.toString() + " Subject: " + this.m_subject.getSubjectString();
    }

    @Override
    public void readFully(byte[] b) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        this.readFullyAt(this.m_cRead, b);
        this.m_cRead += b.length;
    }

    public void readFullyAt(int pos, byte[] b) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        this.ensureReadAt(pos, b.length);
        System.arraycopy(this.m_data, pos, b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        this.readFullyAt(this.m_cRead, b, off, len);
        this.m_cRead += len;
    }

    public void readFullyAt(int pos, byte[] b, int off, int len) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureReadAt(pos, len);
        System.arraycopy(this.m_data, pos, b, off, len);
    }

    @Override
    public int skipBytes(int amount) throws IOException, EGeneralException {
        return (int)this.skip(amount);
    }

    public void gotoByte(int offset) throws IOException, EGeneralException {
        if (offset < 0 || offset >= this.cap()) {
            throw new EOFException("" + this.cap());
        }
        this.m_cRead = offset;
    }

    @Override
    public boolean readBoolean() throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        boolean b = this.readBooleanAt(this.m_cRead);
        ++this.m_cRead;
        return b;
    }

    public boolean readBooleanAt(int pos) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        this.ensureReadAt(pos, 1);
        byte b = this.m_data[pos];
        return b == 1;
    }

    @Override
    public byte readByte() throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        this.ensureRead(1);
        return this.m_data[this.m_cRead++];
    }

    public byte readByteAt(int pos) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        this.ensureReadAt(pos, 1);
        return this.m_data[pos];
    }

    @Override
    public int readUnsignedByte() throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        return this.readByte() & 0xFF;
    }

    public int readUnsignedByteAt(int pos) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        return this.readByteAt(pos) & 0xFF;
    }

    @Override
    public short readShort() throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        short s = this.readShortAt(this.m_cRead);
        this.m_cRead += 2;
        return s;
    }

    public short readShortAt(int pos) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        this.ensureReadAt(pos, 2);
        return (short)(this.m_data[pos++] << 8 | this.m_data[pos++] & 0xFF);
    }

    @Override
    public int readUnsignedShort() throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        return this.readShort() & 0xFFFF;
    }

    public int readUnsignedShortAt(int pos) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        return this.readShortAt(pos) & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        char c = this.readCharAt(this.m_cRead);
        this.m_cRead += 2;
        return c;
    }

    public char readCharAt(int pos) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        this.ensureReadAt(pos, 2);
        return (char)(this.m_data[pos++] << 8 | this.m_data[pos++] & 0xFF);
    }

    @Override
    public int readInt() throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        int i = this.readIntAt(this.m_cRead);
        this.m_cRead += 4;
        return i;
    }

    public int readIntAt(int pos) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        this.ensureReadAt(pos, 4);
        return this.m_data[pos++] << 24 | (this.m_data[pos++] & 0xFF) << 16 | (this.m_data[pos++] & 0xFF) << 8 | this.m_data[pos++] & 0xFF;
    }

    @Override
    public long readLong() throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        long x = this.readLongAt(this.m_cRead);
        this.m_cRead += 8;
        return x;
    }

    public long readLongAt(int pos) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        this.ensureReadAt(pos, 8);
        long temp = ((long)this.m_data[pos++] & 0xFFL) << 56 | ((long)this.m_data[pos++] & 0xFFL) << 48 | ((long)this.m_data[pos++] & 0xFFL) << 40 | ((long)this.m_data[pos++] & 0xFFL) << 32 | ((long)this.m_data[pos++] & 0xFFL) << 24 | ((long)this.m_data[pos++] & 0xFFL) << 16 | ((long)this.m_data[pos++] & 0xFFL) << 8 | (long)this.m_data[pos++] & 0xFFL;
        return temp;
    }

    @Override
    public float readFloat() throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        return Float.intBitsToFloat(this.readInt());
    }

    public float readFloatAt(int pos) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        return Float.intBitsToFloat(this.readIntAt(pos));
    }

    @Override
    public double readDouble() throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        return Double.longBitsToDouble(this.readLong());
    }

    public double readDoubleAt(int pos) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        return Double.longBitsToDouble(this.readLongAt(pos));
    }

    @Override
    public String readLine() throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        String s = this.readLineAt(this.m_cRead);
        this.m_cRead += s.length() + 1;
        if (this.m_cRead > this.m_count) {
            this.m_cRead = this.m_count;
        }
        return s;
    }

    public String readLineAt(int pos) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        int c;
        StringBuffer input = new StringBuffer();
        while ((c = this.readAt(pos++)) != -1 && c != 10) {
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public String readUTF() throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        String s = this.readUTFAt(this.m_cRead);
        this.m_cRead += this.lengthUTFAt(this.m_cRead) + 4;
        return s;
    }

    public String readShortUTF() throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        String s = this.readShortUTFAt(this.m_cRead);
        this.m_cRead += this.lengthUTFAt(this.m_cRead) + 2;
        return s;
    }

    public byte readUTFToByte() throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        byte b = Byte.valueOf(this.readUTFAt(this.m_cRead));
        this.m_cRead += this.lengthUTFAt(this.m_cRead) + 4;
        return b;
    }

    public String readUTFAt(int pos) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        return this.readUTFAt(pos, false);
    }

    private String readShortUTFAt(int pos) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        return this.readUTFAt(pos, true);
    }

    private String readUTFAt(int pos, boolean shortString) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        int utflen = 0;
        utflen = shortString ? this.readShortAt(pos) : this.readIntAt(pos);
        pos += shortString ? 2 : 4;
        char[] str = new char[utflen];
        int count = 0;
        int strlen = 0;
        block5: while (count < utflen) {
            int c = this.readByteAt(pos++) & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    int char2;
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    if (((char2 = this.readByteAt(pos++) & 0xFF) & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = this.readByteAt(pos++) & 0xFF;
                    int char3 = this.readByteAt(pos++) & 0xFF;
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(str, 0, strlen);
    }

    public int lengthUTF() throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        return this.lengthUTFAt(this.m_cRead);
    }

    public int lengthUTFAt(int pos) throws IOException, EIntegrityCompromised, EPrivacyCompromised, ENonrepudiationFailed, EGeneralException {
        return this.readIntAt(pos);
    }

    private int readAt(int pos) {
        if (this.m_data == null || pos >= this.m_count) {
            return -1;
        }
        return this.m_data[pos];
    }

    @Override
    public void write(int data) {
        this.ensureWrite(4);
        this.m_data[this.m_count++] = (byte)(data >>> 24 & 0xFF);
        this.m_data[this.m_count++] = (byte)(data >>> 16 & 0xFF);
        this.m_data[this.m_count++] = (byte)(data >>> 8 & 0xFF);
        this.m_data[this.m_count++] = (byte)(data & 0xFF);
    }

    @Override
    public void write(byte[] data) {
        this.ensureWrite(data.length);
        System.arraycopy(data, 0, this.m_data, this.m_count, data.length);
        this.m_count += data.length;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureWrite(len);
        System.arraycopy(b, off, this.m_data, this.m_count, len);
        this.m_count += len;
    }

    @Override
    public void writeBoolean(boolean v) {
        if (v) {
            this.write((byte)1);
        } else {
            this.write((byte)0);
        }
    }

    @Override
    public void writeByte(int v) {
        this.write((byte)v);
    }

    @Override
    public void writeShort(int v) {
        this.write((short)v);
    }

    @Override
    public void writeChar(int v) {
        this.write((char)v);
    }

    @Override
    public void writeInt(int v) {
        this.write(v);
    }

    @Override
    public void writeLong(long v) {
        this.write(v);
    }

    @Override
    public void writeFloat(float v) {
        this.write(v);
    }

    @Override
    public void writeDouble(double v) {
        this.write(v);
    }

    @Override
    public void writeBytes(String s) {
        char[] cc;
        for (char c : cc = s.toCharArray()) {
            this.write((byte)c);
        }
    }

    @Override
    public void writeChars(String s) {
        this.write(s);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        char[] cc;
        int utflen = 0;
        for (char c : cc = str.toCharArray()) {
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > Integer.MAX_VALUE) {
            throw new UTFDataFormatException(prMessageFormat.format(prAccessor.getString("STR062"), new Object[]{str}));
        }
        this.ensureWrite(utflen + 4);
        this.m_data[this.m_count++] = (byte)(0xFF & utflen >> 24);
        this.m_data[this.m_count++] = (byte)(0xFF & utflen >> 16);
        this.m_data[this.m_count++] = (byte)(0xFF & utflen >> 8);
        this.m_data[this.m_count++] = (byte)(0xFF & utflen >> 0);
        for (char c : cc) {
            if (c >= '\u0001' && c <= '\u007f') {
                this.m_data[this.m_count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.m_data[this.m_count++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.m_data[this.m_count++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.m_data[this.m_count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.m_data[this.m_count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.m_data[this.m_count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
    }

    public void write(byte data) {
        this.ensureWrite(1);
        this.m_data[this.m_count++] = data;
    }

    public void write(char data) {
        this.ensureWrite(2);
        this.m_data[this.m_count++] = (byte)(data >>> 8 & 0xFF);
        this.m_data[this.m_count++] = (byte)(data & 0xFF);
    }

    public void write(char[] data) {
        this.ensureWrite(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            this.m_data[this.m_count++] = (byte)(data[i] >>> 8 & 0xFF);
            this.m_data[this.m_count++] = (byte)(data[i] & 0xFF);
        }
    }

    public void write(short data) {
        this.ensureWrite(2);
        this.m_data[this.m_count++] = (byte)(data >>> 8 & 0xFF);
        this.m_data[this.m_count++] = (byte)(data & 0xFF);
    }

    public void write(short[] data) {
        this.ensureWrite(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            this.m_data[this.m_count++] = (byte)(data[i] >>> 8 & 0xFF);
            this.m_data[this.m_count++] = (byte)(data[i] & 0xFF);
        }
    }

    public void write(int[] data) {
        this.ensureWrite(data.length * 4);
        for (int i = 0; i < data.length; ++i) {
            this.m_data[this.m_count++] = (byte)(data[i] >>> 24 & 0xFF);
            this.m_data[this.m_count++] = (byte)(data[i] >>> 16 & 0xFF);
            this.m_data[this.m_count++] = (byte)(data[i] >>> 8 & 0xFF);
            this.m_data[this.m_count++] = (byte)(data[i] & 0xFF);
        }
    }

    public void write(long data) {
        this.ensureWrite(8);
        this.m_data[this.m_count++] = (byte)(data >>> 56 & 0xFFL);
        this.m_data[this.m_count++] = (byte)(data >>> 48 & 0xFFL);
        this.m_data[this.m_count++] = (byte)(data >>> 40 & 0xFFL);
        this.m_data[this.m_count++] = (byte)(data >>> 32 & 0xFFL);
        this.m_data[this.m_count++] = (byte)(data >>> 24 & 0xFFL);
        this.m_data[this.m_count++] = (byte)(data >>> 16 & 0xFFL);
        this.m_data[this.m_count++] = (byte)(data >>> 8 & 0xFFL);
        this.m_data[this.m_count++] = (byte)(data & 0xFFL);
    }

    public void write(long[] data) {
        this.ensureWrite(data.length * 8);
        for (int i = 0; i < data.length; ++i) {
            this.m_data[this.m_count++] = (byte)(data[i] >>> 56 & 0xFFL);
            this.m_data[this.m_count++] = (byte)(data[i] >>> 48 & 0xFFL);
            this.m_data[this.m_count++] = (byte)(data[i] >>> 40 & 0xFFL);
            this.m_data[this.m_count++] = (byte)(data[i] >>> 32 & 0xFFL);
            this.m_data[this.m_count++] = (byte)(data[i] >>> 24 & 0xFFL);
            this.m_data[this.m_count++] = (byte)(data[i] >>> 16 & 0xFFL);
            this.m_data[this.m_count++] = (byte)(data[i] >>> 8 & 0xFFL);
            this.m_data[this.m_count++] = (byte)(data[i] & 0xFFL);
        }
    }

    public void write(float data) {
        this.write(Float.floatToIntBits(data));
    }

    public void write(float[] data) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            this.write(data[i]);
        }
    }

    public void write(double data) {
        this.write(Double.doubleToLongBits(data));
    }

    public void write(double[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.write(data[i]);
        }
    }

    public void write(String data) {
        int len = data.length();
        this.ensureWrite(len * 2);
        for (int i = 0; i < len; ++i) {
            char ch = data.charAt(i);
            this.m_data[this.m_count++] = (byte)(ch >>> 8 & 0xFF);
            this.m_data[this.m_count++] = (byte)(ch & 0xFF);
        }
    }

    protected void ensureWrite(int len) {
        int reqCap;
        int curCap;
        this.unprotectData();
        if (this.m_data == null) {
            this.m_data = new byte[INITIAL_CAPACITANCE];
        }
        if ((curCap = this.m_data.length) < (reqCap = this.m_count + len)) {
            byte[] curData = this.m_data;
            int newCap = this.m_capInc > 0 ? curCap + this.m_capInc : curCap * 2;
            if (newCap < reqCap) {
                newCap = reqCap;
            }
            this.m_data = new byte[newCap];
            System.arraycopy(curData, 0, this.m_data, 0, this.m_count);
        }
    }

    protected void ensureRead(int len) throws EOFException {
        if (this.countUnread() < len) {
            throw new EOFException();
        }
    }

    protected void ensureReadAt(int pos, int len) throws EOFException {
        if (pos + len > this.m_count) {
            throw new EOFException();
        }
    }

    public int countUnread() {
        return this.m_count - this.m_cRead;
    }

    public int cap() {
        if (this.m_data == null) {
            return 0;
        }
        return this.m_data.length;
    }

    public int capInc() {
        return this.m_capInc;
    }

    public int count() {
        return this.m_count;
    }

    @Override
    public final int read(byte[] data) throws EOFException {
        this.ensureRead(data.length);
        System.arraycopy(this.m_data, this.m_cRead, data, 0, data.length);
        this.m_cRead += data.length;
        return data.length;
    }

    public final void read(char[] data) throws EOFException {
        this.ensureRead(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            data[i] = (char)(this.m_data[this.m_cRead++] << 8 | this.m_data[this.m_cRead++] & 0xFF);
        }
    }

    public final void read(short[] data) throws EOFException {
        this.ensureRead(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            data[i] = (short)(this.m_data[this.m_cRead++] << 8 | this.m_data[this.m_cRead++] & 0xFF);
        }
    }

    public final void read(int[] data) throws EOFException {
        this.ensureRead(data.length * 4);
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.m_data[this.m_cRead++] << 24 | (this.m_data[this.m_cRead++] & 0xFF) << 16 | (this.m_data[this.m_cRead++] & 0xFF) << 8 | this.m_data[this.m_cRead++] & 0xFF;
        }
    }

    public final void read(long[] data) throws EOFException {
        this.ensureRead(data.length * 8);
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.m_data[this.m_cRead++] << 56 | (this.m_data[this.m_cRead++] & 0xFF) << 48 | (this.m_data[this.m_cRead++] & 0xFF) << 40 | (this.m_data[this.m_cRead++] & 0xFF) << 32 | (this.m_data[this.m_cRead++] & 0xFF) << 24 | (this.m_data[this.m_cRead++] & 0xFF) << 16 | (this.m_data[this.m_cRead++] & 0xFF) << 8 | this.m_data[this.m_cRead++] & 0xFF;
        }
    }

    public Object clone() {
        Message copy = new Message(this);
        if (this.m_data != null) {
            copy.m_data = (byte[])this.m_data.clone();
        }
        this.m_dataProtected = true;
        return copy;
    }

    public Object shallowClone() {
        Message copy = new Message(this);
        return copy;
    }

    public Object protectedClone() {
        this.m_dataProtected = true;
        Message copy = new Message(this);
        return copy;
    }

    private void unprotectData() {
        if (this.m_dataProtected) {
            if (this.m_data != null) {
                this.m_data = (byte[])this.m_data.clone();
            }
            this.m_dataProtected = false;
        }
    }

    @Override
    public int length() {
        return (this.m_data != null ? this.m_data.length : 0) + (this.m_subject != null ? this.m_subject.memoryLength() : 0);
    }

    @Override
    public int available() {
        return this.countUnread();
    }

    @Override
    public void close() {
    }

    @Override
    public int read() throws IOException {
        if (this.countUnread() < 1) {
            return -1;
        }
        return this.readByte();
    }

    @Override
    public int read(byte[] b, int offset, int len) {
        int delta = this.readAt(this.m_cRead, b, offset, len);
        this.m_cRead += delta;
        return delta;
    }

    public int readAt(int pos, byte[] b, int offset, int len) {
        int count = this.m_count - pos;
        if (count > b.length) {
            count = b.length;
        }
        if (count > len) {
            count = len;
        }
        System.arraycopy(this.m_data, pos, b, offset, count);
        return count;
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        int start;
        if (this.bistream == null) {
            this.bistream = new ByteArrayInputStream(this.m_data);
            this.bistream.reset();
            this.bistream.skip(this.m_cRead);
            start = this.bistream.available();
            this.oistream = new ObjectInputStream(this.bistream);
        } else {
            this.bistream.reset();
            this.bistream.skip(this.m_cRead);
            start = this.bistream.available();
        }
        Object o = this.oistream.readObject();
        this.m_cRead += start - this.bistream.available();
        return o;
    }

    public Object readObjectMessage() throws ClassNotFoundException, IOException {
        int start;
        if (this.bistream == null) {
            this.bistream = new ByteArrayInputStream(this.m_data);
        }
        Object o = null;
        try {
            this.bistream.reset();
            this.bistream.skip(this.m_cRead);
            start = this.bistream.available();
            this.oistream = new ObjectInputStream(this.bistream);
            o = this.oistream.readObject();
        }
        catch (ClassNotFoundException e) {
            String JVMver = System.getProperty("java.version");
            if (JVMver == null || JVMver.startsWith("1.1.") || JVMver.startsWith("1.0.")) {
                throw e;
            }
            this.bistream.reset();
            this.bistream.skip(this.m_cRead);
            start = this.bistream.available();
            this.oistream = new CCLObjectInputStream(this.bistream);
            o = this.oistream.readObject();
        }
        this.m_cRead += start - this.bistream.available();
        return o;
    }

    @Override
    public long skip(long amount) {
        if ((long)this.m_cRead + amount <= (long)this.m_count && (long)this.m_cRead + amount >= 0L) {
            this.m_cRead = (int)((long)this.m_cRead + amount);
        } else if (amount != 0L) {
            amount = this.m_count - this.m_cRead;
            this.m_cRead = this.m_count;
        }
        return amount;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        if (this.oostream == null) {
            this.oostream = new ObjectOutputStream(new WrappedDataOutputStream(this));
        }
        this.oostream.writeObject(obj);
    }
}

