/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import progress.message.msg.IAckHandle;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.Mgram;
import progress.message.msg.v26.Payload;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.prAccessor;

public final class NackPayload
extends Payload
implements IAckHandle {
    public static final int NACK_PAYLOAD_LENGTH = 6;
    private long m_trackingNum;
    private byte[] m_payload = new byte[6];
    static final int s_nackMemSize = MemoryUtil.estimateBaseSize(NackPayload.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.println("Nacked Tracking Number: " + this.getTrackingNumber());
        }
    }

    public NackPayload(Mgram m) {
        super(m);
    }

    @Override
    public int length() {
        return 6;
    }

    @Override
    protected int memoryLength() {
        this.sync();
        return s_nackMemSize + 6;
    }

    @Override
    protected boolean isDirty() {
        return false;
    }

    @Override
    protected void initPayloadFromStream(InputStream is, StreamUtilCounter sc) throws IOException, EMgramFormatError {
        StreamUtil.readBytes(is, this.m_payload, 0, 6);
        this.m_trackingNum = ArrayUtil.read6ByteLong(this.m_payload, 0);
    }

    @Override
    public byte[] toByteArray() {
        this.sync();
        byte[] result = new byte[6];
        System.arraycopy(this.m_payload, 0, result, 0, 6);
        return result;
    }

    @Override
    public Object clone(Mgram m) throws CloneNotSupportedException {
        NackPayload ap = (NackPayload)super.clone();
        ap.m_mgram = m;
        if (this.m_payload != null) {
            ap.m_payload = new byte[this.m_payload.length];
            System.arraycopy(this.m_payload, 0, ap.m_payload, 0, this.m_payload.length);
        }
        return ap;
    }

    @Override
    protected void syncPayload() {
    }

    byte[] getRawPayload() {
        this.sync();
        return this.m_payload;
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        this.sync();
        os.write(this.m_payload);
    }

    @Override
    public void setClientID(long id) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public long getClientID() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setErr(short err) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public short getErr() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean isSubjectAck() {
        return false;
    }

    @Override
    public short getSubjectTracking() {
        return -1;
    }

    @Override
    public long getTrackingNumber() {
        return this.m_trackingNum;
    }

    @Override
    public void setSubjectTracking(short subjectTracking) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setTrackingNumber(long number) {
        this.m_trackingNum = number;
        NackPayload.setTrackingNumber(number, this.m_payload);
    }

    public static void setTrackingNumber(long number, byte[] buffer) {
        ArrayUtil.write6ByteLong(buffer, 0, number);
    }

    @Override
    public IAckHandle getAckHandle() {
        return this;
    }

    @Override
    public HashMap getPayloadProperties() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        result.put("ACK_TRACKING_NUMBER", new Long(this.m_trackingNum));
        return result;
    }

    @Override
    public void setPayloadProperties(HashMap map) {
        this.m_trackingNum = (Long)map.get("ACK_TRACKING_NUMBER");
        NackPayload.setTrackingNumber(this.m_trackingNum, this.m_payload);
    }
}

