/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sdf;

import com.sonicsw.sdf.DiagnosticsManagerAccess;
import com.sonicsw.sdf.IDiagnosticsConstants;
import com.sonicsw.sdf.IDiagnosticsProvider;
import com.sonicsw.sdf.IStateWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class WriterUtil {
    private static final String FILE_PERMISSIONS_REGEX = "([r-][w-][x-]){3}";
    private static final String NO_FILE_PERMISSIONS_REGEX = "(---){3}";
    private static final String TEXT_DUMP_SEPARATOR = "========================================================================";
    private static final String TEXT_SECTION_SEPARATOR = "------------------------------------------------------------------------";
    private static final RuntimeMXBean s_runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private static final OperatingSystemMXBean s_opsysMXBean = ManagementFactory.getOperatingSystemMXBean();
    private static DecimalFormat s_doubleFormat = new DecimalFormat("###0.00");
    private static Method getSystemLoadAverage_METHOD = null;

    public static void writeHeader(IStateWriter writer, String instruction, Map<String, String> additionalHeaders) throws IOException {
        writer.writeln(TEXT_DUMP_SEPARATOR + IDiagnosticsConstants.NEWLINE);
        WriterUtil.writeProperty(writer, "Instruction", instruction);
        Map<String, String> headers = WriterUtil.getEnvironmentProperties();
        if (additionalHeaders != null) {
            headers.putAll(additionalHeaders);
        }
        WriterUtil.writeProperties(headers, writer);
        writer.writeln();
        WriterUtil.writeProperty(writer, "Dump start time", new Date().toString());
        writer.writeln(IDiagnosticsConstants.NEWLINE + TEXT_SECTION_SEPARATOR + IDiagnosticsConstants.NEWLINE);
    }

    public static void writeFooter(IStateWriter writer, Map<String, String> additionalFooters) throws IOException {
        writer.writeln(IDiagnosticsConstants.NEWLINE + TEXT_SECTION_SEPARATOR + IDiagnosticsConstants.NEWLINE);
        WriterUtil.writeProperty(writer, "Dump end time", new Date().toString());
        if (additionalFooters != null) {
            WriterUtil.writeProperties(additionalFooters, writer);
        }
        writer.writeln(IDiagnosticsConstants.NEWLINE);
    }

    private static void writeProperties(Map<String, String> additionalFooters, IStateWriter writer) throws IOException {
        for (Map.Entry<String, String> envProp : additionalFooters.entrySet()) {
            WriterUtil.writeProperty(writer, envProp.getKey(), envProp.getValue());
        }
    }

    private static void writeProperty(IStateWriter writer, String name, String value) throws IOException {
        writer.writeln(name + ": " + value);
    }

    public static String rebuildInstruction(IDiagnosticsProvider provider, String operation, Map<?, ?> parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append(provider.getSubsystemName()).append(' ').append(operation);
        for (Map.Entry<?, ?> param : parameters.entrySet()) {
            sb.append(' ').append(param.getKey()).append('=').append(param.getValue());
        }
        return sb.toString();
    }

    private static Map<String, String> getEnvironmentProperties() {
        long startTime;
        String containerName = DiagnosticsManagerAccess.getManager().getContainerName();
        String hostname = "<unknown>";
        String opsys = "<unknown>";
        String jvmVersion = "<unknown>";
        String jvmStartTime = "<unknown>";
        String processorCount = "<unknown>";
        String systemLoad = null;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        jvmVersion = System.getProperty("java.vm.name") + " (" + System.getProperty("java.vendor") + ", " + System.getProperty("java.version") + ")";
        if (s_runtimeMXBean != null && (startTime = s_runtimeMXBean.getStartTime()) > 0L) {
            jvmStartTime = new Date(startTime).toString();
        }
        if (s_opsysMXBean != null) {
            opsys = s_opsysMXBean.getName() + ", " + s_opsysMXBean.getVersion() + " (" + s_opsysMXBean.getArch() + ")";
            processorCount = Integer.toString(s_opsysMXBean.getAvailableProcessors());
            if (getSystemLoadAverage_METHOD != null) {
                try {
                    double load = (Double)getSystemLoadAverage_METHOD.invoke((Object)s_opsysMXBean, new Object[0]);
                    if (load >= 0.0) {
                        systemLoad = s_doubleFormat.format(load) + "%";
                    }
                }
                catch (Exception e) {
                    System.err.println("Error getting value for system load:");
                    e.printStackTrace();
                }
            }
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (containerName != null) {
            result.put("Container", containerName);
        }
        result.put("Host", hostname);
        result.put("Operating System", opsys);
        result.put("Java VM", jvmVersion);
        result.put("Started", jvmStartTime);
        result.put("Available Processors", processorCount);
        if (systemLoad != null) {
            result.put("Average load (over last minute)", systemLoad);
        }
        return result;
    }

    public static String getExceptionAsString(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public static void ensureParentFoldersExists(Path path) throws IOException {
        Path parent = path.getParent();
        Iterator<Path> it = parent.iterator();
        Path base = path.getRoot();
        while (it.hasNext()) {
            if (Files.exists(base = base.resolve(it.next()), new LinkOption[0])) continue;
            Files.createDirectory(base, new FileAttribute[0]);
        }
    }

    public static void setFileAccessPermissions(Path filePath, String permissions) throws IOException {
        if (!permissions.matches(FILE_PERMISSIONS_REGEX) || permissions.matches(NO_FILE_PERMISSIONS_REGEX)) {
            throw new IllegalArgumentException("The file permission mask is not valid, please check and/or use the 'describe' operation for help.");
        }
        if (FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
            Set<PosixFilePermission> permissionSet = PosixFilePermissions.fromString(permissions);
            Files.setPosixFilePermissions(filePath, permissionSet);
        }
    }

    static {
        try {
            getSystemLoadAverage_METHOD = OperatingSystemMXBean.class.getMethod("getSystemLoadAverage", new Class[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

