/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sdf.impl;

import com.sonicsw.sdf.IDiagnosticsConstants;
import com.sonicsw.sdf.IDiagnosticsContext;
import com.sonicsw.sdf.WriterUtil;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class HotSpotHeapDump
implements IDiagnosticsConstants {
    private static final String HOTSPOT_HEAP_FILE_POSTFIX = ".hprof";
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static boolean m_heapDumpSupported = true;
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static Class HotSpotDiagnosticMXBean_CLASS;
    private static Class ManagementFactory_CLASS;
    private static Class MBeanServer_CLASS;
    private static Class MBeanServerConnection_CLASS;
    static Class[] NEW_PLATFORM_PROXY_SIGNATURE;
    private static Method newPlatformMXBeanProxy_METHOD;
    private static Method getPlatformMBeanServer_METHOD;
    static Class[] DUMP_HEAP_SIGNATURE;
    private static Method dumpHeap_METHOD;

    private static void doDumpHeap(String fileName) throws Exception {
        Object server = getPlatformMBeanServer_METHOD.invoke(null, EMPTY_OBJECT_ARRAY);
        Object hotspotMBean = newPlatformMXBeanProxy_METHOD.invoke(null, server, HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean_CLASS);
        dumpHeap_METHOD.invoke(hotspotMBean, fileName, Boolean.TRUE);
    }

    static String describe() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("This HotSpot JVM generates binary JVM heap dumps; 'jhat' or other third-party utilities can be used to browse the dump file");
        return tmp.toString();
    }

    static boolean heapDumpSupported() {
        return m_heapDumpSupported;
    }

    static void dumpHeap(StringBuffer buffer, IDiagnosticsContext context) {
        try {
            String dumpFileName = context.generateFileNameBase(true) + HOTSPOT_HEAP_FILE_POSTFIX;
            HotSpotHeapDump.doDumpHeap(dumpFileName);
            buffer.append("Binary heap dump was written to file ").append(dumpFileName);
        }
        catch (Throwable t) {
            buffer.append("jvm.heap").append(" failed to generate a heap dump for a HostSpot JVM:");
            buffer.append(NEWLINE).append(WriterUtil.getExceptionAsString(t));
        }
    }

    static void dumpHeap(StringBuffer buffer, IDiagnosticsContext context, Map<String, String> parameters) {
        try {
            boolean overwrite = Boolean.parseBoolean(parameters.get("overwrite"));
            String outputFolder = parameters.get("output");
            String permissions = parameters.get("output_access");
            String dumpFileName = context.generateFileNameBase(!overwrite) + HOTSPOT_HEAP_FILE_POSTFIX;
            Path filePath = Paths.get(dumpFileName, new String[0]);
            if (outputFolder != null) {
                filePath = Paths.get(outputFolder, new String[0]).resolve(filePath);
                WriterUtil.ensureParentFoldersExists(filePath);
            }
            if (overwrite) {
                Files.deleteIfExists(filePath);
            }
            HotSpotHeapDump.doDumpHeap(filePath.toString());
            if (permissions != null) {
                WriterUtil.setFileAccessPermissions(filePath, permissions);
            }
            buffer.append("Binary heap dump was written to file ").append(filePath.toString());
        }
        catch (IllegalArgumentException e) {
            buffer.append("jvm.heap").append(" failed to generate a heap dump for a HostSpot JVM:");
            buffer.append(NEWLINE).append(e.getMessage());
        }
        catch (Throwable t) {
            buffer.append("jvm.heap").append(" failed to generate a heap dump for a HostSpot JVM:");
            buffer.append(NEWLINE).append(WriterUtil.getExceptionAsString(t));
        }
    }

    static {
        try {
            HotSpotDiagnosticMXBean_CLASS = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            ManagementFactory_CLASS = Class.forName("java.lang.management.ManagementFactory");
            MBeanServer_CLASS = Class.forName("javax.management.MBeanServer");
            MBeanServerConnection_CLASS = Class.forName("javax.management.MBeanServerConnection");
        }
        catch (Throwable t) {
            m_heapDumpSupported = false;
        }
        NEW_PLATFORM_PROXY_SIGNATURE = new Class[]{MBeanServerConnection_CLASS, String.class, Class.class};
        DUMP_HEAP_SIGNATURE = new Class[]{String.class, Boolean.TYPE};
        try {
            newPlatformMXBeanProxy_METHOD = ManagementFactory_CLASS.getMethod("newPlatformMXBeanProxy", NEW_PLATFORM_PROXY_SIGNATURE);
            getPlatformMBeanServer_METHOD = ManagementFactory_CLASS.getMethod("getPlatformMBeanServer", EMPTY_CLASS_ARRAY);
            dumpHeap_METHOD = HotSpotDiagnosticMXBean_CLASS.getMethod("dumpHeap", DUMP_HEAP_SIGNATURE);
        }
        catch (Throwable t) {
            m_heapDumpSupported = false;
        }
    }
}

