/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.util.Iterator;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import progress.message.client.EGeneralException;
import progress.message.client.ENetworkFailure;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.ETransactionFailure;
import progress.message.client.EUnusableConnection;
import progress.message.client.prAccessor;
import progress.message.jimpl.Connection;
import progress.message.jimpl.IMessageSelector;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Message;
import progress.message.jimpl.Session;
import progress.message.util.Queue;
import progress.message.zclient.Envelope;
import progress.message.zclient.ISubject;
import progress.message.zclient.MessageHandler;

public abstract class MessageConsumer
implements progress.message.jclient.MessageConsumer,
Cloneable {
    private static final boolean DEBUG = false;
    Connection m_jconnection = null;
    Session m_jsession = null;
    MessageListener m_jlistener = null;
    IMessageSelector m_selector = null;
    String m_selectorString = null;
    ReceivedMessagesQueue m_rxQueue = new ReceivedMessagesQueue();
    int m_ackMode = 1;
    boolean m_started = false;
    boolean m_closing = false;
    protected Object m_closeSyncObject;
    progress.message.zclient.Connection m_zconnection = null;
    MessageHandler m_zmessageHandler = null;
    boolean m_isCC = false;
    boolean m_pendingClose;
    protected boolean m_splitMultiTopicDelivery = false;

    public MessageConsumer(Session session) {
        this.m_jsession = session;
        if (this.m_jsession != null) {
            this.m_closeSyncObject = session.getCloseLock();
            this.m_ackMode = this.m_jsession.getAcknowledgeMode();
            this.m_splitMultiTopicDelivery = this.m_jsession.getSplitMultiTopicDelivery();
        }
    }

    @Override
    public String getMessageSelector() throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        return this.m_selectorString;
    }

    @Override
    public MessageListener getMessageListener() throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        return this.m_jlistener;
    }

    @Override
    public void setMessageListener(MessageListener listener) throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        this.m_jsession.checkDeliveryMode(2);
        if (this.m_jlistener == null && listener != null) {
            this.m_rxQueue.addToSessionMessageCount();
        } else if (this.m_jlistener != null && listener == null) {
            this.m_rxQueue.removeFromSessionMessageCount();
        }
        this.m_jlistener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public javax.jms.Message receive() throws JMSException {
        this.checkIsClosingUpdateDeliveryModeAndAck();
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            while (!(this.m_started || this.isClosing() || this.m_jsession.isClosing())) {
                try {
                    this.m_closeSyncObject.wait();
                }
                catch (InterruptedException ie) {
                    throw JMSExceptionUtil.createJMSException(prAccessor.getString("STR006"), "-24", ie);
                }
            }
            if (this.isClosing() || this.m_jsession.isClosing()) {
                return null;
            }
        }
        Message msg = null;
        while ((msg = this.getReceivedMessagesQueue().nextMessage()) != null && (msg = this.checkUndeliverable(msg)) == null) {
            Object object2 = this.m_closeSyncObject;
            synchronized (object2) {
                if (this.isClosing() || this.m_jsession.isClosing()) {
                    return null;
                }
            }
        }
        return this.receiveInternal(msg);
    }

    javax.jms.Message receiveInternal(Message msg) throws JMSException {
        if (this.isClosing() || msg == null) {
            return null;
        }
        msg.setConsumer(this);
        Message returnedMsg = (Message)msg.protectedClone();
        returnedMsg.setConsumer(this);
        if (this.m_ackMode == 2 || this.m_ackMode == 1004 || this.m_jsession.getTransactedFlag()) {
            returnedMsg.unprotectSuccessor();
            this.m_jsession.getUnacknowledgedMessagesQueue().addMessage(msg);
        }
        if (this.m_jsession.isGetFromXASession() && this.m_jsession.isDeferredAckInXATxn()) {
            this.m_jsession.setDelayedAcknowledgeMessage(msg);
        } else if (this.m_jsession.getTransactedFlag()) {
            this.acknowledge(msg.getEnvelope());
        } else if (this.m_ackMode != 2 && this.m_ackMode != 1004) {
            this.m_jsession.setDelayedAcknowledgeMessage(msg);
        }
        this.release(msg);
        return returnedMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public javax.jms.Message receive(long timeout) throws JMSException {
        this.checkIsClosingUpdateDeliveryModeAndAck();
        long epoc = 0L;
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            while (!(this.m_started || this.isClosing() || this.m_jsession.isClosing())) {
                if (epoc == 0L) {
                    epoc = System.currentTimeMillis();
                }
                try {
                    this.m_closeSyncObject.wait(timeout);
                    if (System.currentTimeMillis() - epoc <= timeout) continue;
                    return null;
                }
                catch (InterruptedException ie) {
                    throw JMSExceptionUtil.createJMSException(prAccessor.getString("STR006"), "-24", ie);
                }
            }
            if (this.isClosing() || this.m_jsession.isClosing()) {
                return null;
            }
        }
        if (epoc > 0L && timeout > 0L && (timeout -= System.currentTimeMillis() - epoc) <= 0L) {
            return null;
        }
        Message msg = null;
        epoc = System.currentTimeMillis();
        while (true) {
            if ((msg = this.getReceivedMessagesQueue().nextMessage(timeout)) == null) {
                return null;
            }
            if ((msg = this.checkUndeliverable(msg)) != null) break;
            Object object2 = this.m_closeSyncObject;
            synchronized (object2) {
                if (this.isClosing() || this.m_jsession.isClosing()) {
                    return null;
                }
            }
            if ((timeout -= System.currentTimeMillis() - epoc) <= 0L) {
                return null;
            }
            epoc = System.currentTimeMillis();
        }
        return this.receiveInternal(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public javax.jms.Message receiveNoWait() throws JMSException {
        this.checkIsClosingUpdateDeliveryModeAndAck();
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            if (!this.m_started || this.isClosing() || this.m_jsession.isClosing()) {
                return null;
            }
        }
        Message msg = null;
        while ((msg = this.getReceivedMessagesQueue().nextMessageIfAny()) != null && (msg = this.checkUndeliverable(msg)) == null) {
            Object object2 = this.m_closeSyncObject;
            synchronized (object2) {
                if (!this.m_started || this.isClosing() || this.m_jsession.isClosing()) {
                    return null;
                }
            }
        }
        return this.receiveInternal(msg);
    }

    private void checkIsClosingUpdateDeliveryModeAndAck() throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        this.m_jsession.checkDeliveryMode(1);
        this.m_jsession.setDelayedAcknowledgeMessage(null);
    }

    @Override
    public void close() throws JMSException {
        this.m_jsession.beginWaitForSession();
        try {
            this.closeImpl();
        }
        finally {
            this.m_jsession.endWaitForSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeImpl() throws JMSException {
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            if (this.isClosing() && !this.isClosePending()) {
                this.m_jsession.waitForDeliveringMessage();
                return;
            }
            try {
                if (this.m_jsession.m_transacted && this.m_jsession.getAckListEnabled()) {
                    this.sendBatch(false, true);
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            this.m_closing = true;
            this.m_jsession.waitForDeliveringMessage();
            this.m_closeSyncObject.notifyAll();
            this.closeInternalConsumer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeInternal() throws JMSException {
        if (this.isClosing() && !this.isClosePending()) {
            return;
        }
        this.m_closing = true;
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            this.m_closeSyncObject.notifyAll();
        }
        this.closeInternalConsumer();
    }

    abstract void closeInternalConsumer() throws JMSException;

    public Session getSession() {
        return this.m_jsession;
    }

    public Connection getConnection() {
        return this.m_jconnection;
    }

    abstract void acknowledge(Envelope var1) throws JMSException;

    abstract void batchAck(Envelope var1) throws JMSException;

    void sendBatch(boolean dupsOk) throws JMSException {
        this.sendBatch(dupsOk, false);
    }

    void sendBatch(boolean dupsOk, boolean txnSync) throws JMSException {
        progress.message.zclient.Session session = null;
        session = this.m_jsession.getTransactedFlag() ? this.m_jsession.getAckSession() : this.m_zmessageHandler.getSession();
        try {
            session.sendBatchedAcks(dupsOk, txnSync);
        }
        catch (ESecurityPolicyViolation e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ENetworkFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ETransactionFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    abstract void processUndeliverable(Envelope var1, int var2) throws JMSException;

    public synchronized void acknowledge(Envelope env, long clientID) throws JMSException {
        try {
            switch (this.m_ackMode) {
                case 1: 
                case 2: 
                case 1004: {
                    this.m_jsession.getAckSession().acknowledge(env, false, clientID);
                    return;
                }
                case 3: {
                    this.m_jsession.getAckSession().acknowledge(env, true, clientID);
                    return;
                }
            }
        }
        catch (ESecurityPolicyViolation e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ENetworkFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ETransactionFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    protected void enqueueReceivedMessage(Envelope env, Message msg) throws JMSException {
        if (this.m_splitMultiTopicDelivery && env.getSubject().isMultiSubject()) {
            Iterator<ISubject> i = env.getSubject().getMultiSubjects();
            env.setSplitDelivery(env.getSubject().getMultiSubjectCount());
            int c = 0;
            while (i.hasNext()) {
                ++c;
                ISubject s = i.next();
                Envelope splitEnv = (Envelope)env.protectedClone();
                splitEnv.setSubject(s, splitEnv.getMgram().getSubjectFormat());
                splitEnv.setSplitDeliveryPart();
                Message splitMsg = this.extract(splitEnv);
                this.getReceivedMessagesQueue().receiveMessage(splitMsg);
            }
            env.handlerDone(this.m_zmessageHandler.isGuaranteed());
        } else {
            this.getReceivedMessagesQueue().receiveMessage(msg);
        }
    }

    public void acknowledge(Envelope env, progress.message.zclient.Session ackSession) throws JMSException {
        try {
            switch (this.m_ackMode) {
                case 1: 
                case 2: 
                case 1004: {
                    ackSession.acknowledge(env);
                    return;
                }
                case 3: {
                    ackSession.acknowledge(env, true);
                    return;
                }
            }
        }
        catch (ESecurityPolicyViolation e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ENetworkFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ETransactionFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public void release(Envelope env) {
        boolean clientAck = this.m_ackMode == 2 || this.m_ackMode == 1004;
        boolean transacted = this.m_jsession.getTransactedFlag();
        boolean nonPersistentReplicated = env.isNonPersistentReplicated();
        env.handlerDone(this.m_zmessageHandler.isGuaranteed(), clientAck || transacted || nonPersistentReplicated);
    }

    public void release(Message msg) {
        this.release(msg.getEnvelope());
    }

    public boolean isClosing() {
        return this.m_closing;
    }

    boolean isClosePending() {
        return this.m_pendingClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() throws JMSException {
        try {
            if (this.m_zconnection != null) {
                this.m_zconnection.startDelivery();
            }
        }
        catch (EUnusableConnection e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ENetworkFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ESecurityPolicyViolation e) {
            throw JMSExceptionUtil.createJMSSecurityException(e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            this.m_started = true;
            this.m_closeSyncObject.notifyAll();
        }
    }

    void stop() throws JMSException {
        try {
            if (this.m_zconnection != null) {
                this.m_zconnection.stopDelivery();
            }
        }
        catch (EUnusableConnection e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ENetworkFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ESecurityPolicyViolation e) {
            throw JMSExceptionUtil.createJMSSecurityException(e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        this.m_started = false;
    }

    public ReceivedMessagesQueue getReceivedMessagesQueue() {
        return this.m_rxQueue;
    }

    public void prependMsg(Message msg) {
        this.getReceivedMessagesQueue().prepend(msg);
    }

    Message extract(Envelope env) throws JMSException {
        Message message = Message.createMessage(env);
        message.setPropertiesReadOnly(true);
        message.setBodyReadOnly(true);
        return message;
    }

    public void bindSession(Session session) throws JMSException {
        if (this.isClosing() || session.isClosing()) {
            throw this.m_jconnection.getJMSObjectClosedException();
        }
        this.m_jsession = session;
        this.m_ackMode = this.m_jsession.getAcknowledgeMode();
        this.m_closeSyncObject = session.getCloseLock();
    }

    public IMessageSelector getSelector() {
        return this.m_selector;
    }

    public MessageHandler getZmessageHandler() {
        return this.m_zmessageHandler;
    }

    public progress.message.zclient.Connection getZconnection() {
        return this.m_zconnection;
    }

    public Object clone() {
        try {
            MessageConsumer consumer = (MessageConsumer)super.clone();
            return consumer;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public Message checkUndeliverable(Message msg) throws JMSException {
        int deliveryLimit = this.m_jconnection.getMaxDeliveryCount();
        if (deliveryLimit == 0 || msg.getReenqueued() <= deliveryLimit) {
            return msg;
        }
        msg.setConsumer(this);
        this.processUndeliverable(msg.getEnvelope(), -41);
        return null;
    }

    public class ReceivedMessagesQueue
    extends Queue {
        private synchronized void incrementReceivedMessageCount() {
            if (MessageConsumer.this.m_jlistener != null) {
                MessageConsumer.this.m_jsession.incrementReceivedMessageCount();
            }
        }

        private synchronized void decrementReceivedMessageCount() {
            if (MessageConsumer.this.m_jlistener != null) {
                MessageConsumer.this.m_jsession.decrementReceivedMessageCount();
            }
        }

        synchronized void addToSessionMessageCount() {
            int length = this.size();
            for (int i = 0; i < length; ++i) {
                MessageConsumer.this.m_jsession.incrementReceivedMessageCount();
            }
        }

        synchronized void removeFromSessionMessageCount() {
            int length = this.size();
            for (int i = 0; i < length; ++i) {
                MessageConsumer.this.m_jsession.decrementReceivedMessageCount();
            }
        }

        private boolean okToDequeueMessage() {
            if (MessageConsumer.this.m_jsession.getDeliveryMode() == 2) {
                return MessageConsumer.this.m_jlistener != null;
            }
            return true;
        }

        public synchronized void receiveMessage(Message msg) {
            this.enqueue(msg);
            this.incrementReceivedMessageCount();
            if (this.okToDequeueMessage()) {
                this.notifyAll();
            }
        }

        public synchronized Message nextMessage() throws JMSException {
            while (this.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw JMSExceptionUtil.createJMSException(prAccessor.getString("STR006"), "-24", e);
                }
                if (!MessageConsumer.this.isClosing()) continue;
                return null;
            }
            if (this.okToDequeueMessage()) {
                this.decrementReceivedMessageCount();
                return (Message)this.dequeue();
            }
            return null;
        }

        public synchronized Message nextMessage(long timeout) throws JMSException {
            if (this.isEmpty()) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    throw JMSExceptionUtil.createJMSException(prAccessor.getString("STR006"), "-24", e);
                }
            }
            if (this.isEmpty()) {
                return null;
            }
            if (this.okToDequeueMessage()) {
                this.decrementReceivedMessageCount();
                return (Message)this.dequeue();
            }
            return null;
        }

        public synchronized Message nextMessageIfAny() {
            if (this.isEmpty()) {
                return null;
            }
            if (this.okToDequeueMessage()) {
                this.decrementReceivedMessageCount();
                return (Message)this.dequeue();
            }
            return null;
        }

        synchronized void putMessageBack(Message msg) {
            this.prepend(msg);
        }

        public synchronized Message[] removeAllMessages() {
            int length = this.size();
            Message[] msgs = new Message[length];
            for (int i = 0; i < length; ++i) {
                this.decrementReceivedMessageCount();
                msgs[i] = (Message)this.dequeue();
            }
            return msgs;
        }
    }
}

