/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import progress.message.util.DebugFormatter;
import progress.message.util.DebugState;
import progress.message.zclient.SessionConfig;

public class DebugLogger {
    private final String name;
    private static final DebugFormatter FORMATTER = DebugFormatter.MULTI_THREAD;
    private static final String ENTERING_PREFIX = "entering ";
    private static final String EXITING_PREFIX = "exiting ";
    private static final String INSTANCE_PREFIX = "\n    instance:  ";
    private static final String ARGUMENTS_PREFIX = "\n    arguments: ";
    private static final String RETURN_PREFIX = "\n    return:    ";
    private static final String EXCEPTION_PREFIX = "\n    exception: ";

    public DebugLogger(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        int level = 0;
        if (DebugState.GLOBAL_DEBUG_ON && this.name != null) {
            level = DebugState.getDiagnosticFlags(this.name);
        }
        return level;
    }

    public boolean isLoggable(int level) {
        return (this.getLevel() & level) > 0;
    }

    public void log(int level, String message) {
        if (this.isLoggable(level)) {
            SessionConfig.logln(FORMATTER.format(this.getName(), message));
        }
    }

    public void logUnexpected(String message) {
        this.log(8192, message);
    }

    public void logLevel0(String message) {
        this.log(32, message);
    }

    public void logLevel1(String message) {
        this.log(64, message);
    }

    public void logLevel2(String message) {
        this.log(128, message);
    }

    public void entering(String signature, Object[] args) {
        this.entering(signature, null, args);
    }

    public void entering(String signature, Object instance, Object[] args) {
        if (this.isLoggable(64)) {
            StringBuilder builder = DebugLogger.getTraceBuilder(ENTERING_PREFIX, signature);
            if (this.isLoggable(128)) {
                if (instance != null) {
                    builder.append(INSTANCE_PREFIX).append(instance);
                }
                if (args != null && args.length > 0) {
                    builder.append(ARGUMENTS_PREFIX);
                    DebugLogger.appendArguments(builder, args);
                }
            }
            SessionConfig.logln(builder.toString());
        }
    }

    public void exiting(String signature) {
        if (this.isLoggable(128)) {
            StringBuilder builder = DebugLogger.getTraceBuilder(EXITING_PREFIX, signature);
            SessionConfig.logln(builder.toString());
        }
    }

    public void exiting(String signature, Object ret) {
        if (this.isLoggable(128)) {
            StringBuilder builder = DebugLogger.getTraceBuilder(EXITING_PREFIX, signature);
            builder.append(RETURN_PREFIX).append(ret);
            SessionConfig.logln(builder.toString());
        }
    }

    public void throwing(String signature, Throwable thrown) {
        if (this.isLoggable(32)) {
            StringBuilder builder = DebugLogger.getTraceBuilder(EXITING_PREFIX, signature);
            builder.append(EXCEPTION_PREFIX);
            DebugLogger.appendThrowable(builder, thrown);
            SessionConfig.logln(builder.toString());
        }
    }

    private static StringBuilder getTraceBuilder(String prefix, String signature) {
        return FORMATTER.getMessageBuilder(null, true).append(prefix).append(signature);
    }

    private static void appendArguments(StringBuilder builder, Object[] args) {
        if (args.length > 0) {
            builder.append(args[0]);
        }
        for (int i = 1; i < args.length; ++i) {
            builder.append(", ").append(args[i]);
        }
    }

    private static void appendThrowable(StringBuilder builder, Throwable thrown) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        thrown.printStackTrace(pw);
        pw.flush();
        sw.flush();
        builder.append(sw.getBuffer());
    }
}

