/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.evs.nio.nwlink.http;

import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.INetworkLinkConfig;
import com.sonicsw.blackbird.evs.nio.nwlink.http.EvsHTTPClientNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.http.EvsHTTPServerNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.http.prAccessor;
import com.sonicsw.blackbird.http.IHTTPMessage;
import com.sonicsw.blackbird.http.IHTTPRequest;
import com.sonicsw.blackbird.http.IHTTPResponse;
import java.net.URI;
import java.nio.channels.SelectableChannel;
import java.util.Properties;
import progress.message.resources.prMessageFormat;

public abstract class EvsHTTPNetworkLink
extends EvsNetworkLink {
    public static final boolean DEBUG_NEW_HTTP = new Boolean(EvsHTTPNetworkLink.getProperty("HTTP_DEBUG", "false"));
    public static final boolean DEBUG_UNEXPECTED = DEBUG_NEW_HTTP || new Boolean(EvsHTTPNetworkLink.getProperty("HTTP_DEBUG_UNEXPECTED", "false")) != false;
    public static final boolean DEBUG_PERFORMANCE = new Boolean(EvsHTTPNetworkLink.getProperty("HTTP_DEBUG_PERFORMANCE", "false"));
    public static final boolean DEBUG_LIFECYCLE = DEBUG_NEW_HTTP || new Boolean(EvsHTTPNetworkLink.getProperty("HTTP_DEBUG_LIFECYCLE", "false")) != false;
    public static int HTTP_MAX_HTTP_READ_REQUESTS = new Integer(EvsHTTPNetworkLink.getProperty("HTTP_MAX_READ_REQUESTS", "8"));
    public static final int HTTP_HEADER_RESERVE;
    public static final int HTTP_MAX_SERVER_THREADS;
    public static final int HTTP_PIPELINE_DETECT_TIMEOUT;
    public static final URI CONNECT_PATH;
    public static final URI WRITE_DATA_PATH;
    public static final URI CLOSE_PATH;
    public static final URI GET_DATA_PATH;
    public static final URI KEEP_ALIVE_PATH;
    public static final String CONTENT_TYPE = "application/octet-stream";
    public static final String SONIC_HEADER_CONNECTION_ID = "ConnectionId";
    public static final String SONIC_HEADER_CONNECTION = "SonicConnection";
    public static final String SONIC_HEADER_PING_ID = "SONIC_CLIENT_PING";
    public static final String SONIC_HEADER_SEQUENCE_NUMBER = "SequenceNumber";
    public static final String SONIC_HEADER_PING_INTERVAL = "SonicPingInterval";
    public static final String SONIC_HEADER_ACK_SEQUENCE_NUMBER = "SonicAckSeqNo";
    public static final String SONIC_HEADER_PIPELINE_TEST = "SonicPipelineTest";
    protected static final String SONIC_HEADER_TUNNELING_PROTOCOL = "SonicTunnelingProtocol";
    protected static final String SONIC_HEADER_TUNNELING_PARAMS = "SonicTunnelingParams";
    public static final int TUNNELING_PROTOCOL_7_0 = 0;
    public static final int TUNNELING_VERSION_7_5 = 1;
    protected static final String TOKEN_CLIENT_ID = "client-id";
    protected static final String TOKEN_CLIENT_VERSION = "client-version";
    protected static final String TOKEN_SERVER_ID = "server-id";
    protected static final String TOKEN_SERVER_VERSION = "server-version";
    protected static final String TOKEN_IDLE_TIMEOUT = "idle-timeout";
    protected static final String TOKEN_MAX_MSG_SIZE = "max-msg-size";
    protected static final String TOKEN_PIPELINE_ENABLED = "pipeline-enabled";
    protected static final String TOKEN_CONNECTION_CLOSED = "closed";
    protected static final String PARAM_ID_JAVA = "java";

    private static final String getProperty(String propName, String defValue) {
        try {
            return System.getProperty(propName, defValue);
        }
        catch (SecurityException se) {
            System.out.println("Unable to read property, permissions denied for: " + propName);
            return defValue;
        }
    }

    public EvsHTTPNetworkLink(INetworkLinkConfig config) {
        super(config);
    }

    protected final void debug(String str, Throwable thrown) {
        if (thrown != null) {
            System.out.println(str + ", Related Exception: " + thrown.getMessage() + " ( " + this + " ) ");
            thrown.printStackTrace();
        } else {
            System.out.println(str + " ( " + this + " )");
        }
    }

    protected final void debug(String str) {
        this.debug(str, null);
    }

    public static final String debugHTTPMsg(IHTTPRequest msg) {
        if (msg == null) {
            return null;
        }
        return EvsHTTPNetworkLink.debugHTTPMsg(msg, msg.getResponse());
    }

    public static final String debugHTTPMsg(IHTTPResponse msg) {
        if (msg == null) {
            return null;
        }
        return EvsHTTPNetworkLink.debugHTTPMsg(msg.getHTTPRequest(), msg);
    }

    private static final String debugHTTPMsg(IHTTPRequest req, IHTTPResponse resp) {
        String ret = "";
        if (req != null) {
            ret = ret + "Req: " + req.getMethod();
            ret = ret + " " + req.getRequestURI();
            ret = ret + " " + req.getHTTPVersion();
            ret = EvsHTTPNetworkLink.appendHeaders(ret, req);
            if (resp != null) {
                ret = ret + " -- Resp: ";
            }
        } else if (resp != null) {
            ret = ret + "Resp: ";
        }
        if (resp != null) {
            ret = ret + resp.getHTTPVersion();
            ret = ret + " " + resp.getStatusCode();
            ret = ret + " " + resp.getReasonPhrase();
            ret = EvsHTTPNetworkLink.appendHeaders(ret, resp);
        }
        return ret;
    }

    private static String appendHeaders(String retParam, IHTTPMessage ihttpMessage) {
        String ret = retParam;
        ret = ret + " [";
        String con = ihttpMessage.getHeaderValue(SONIC_HEADER_CONNECTION_ID);
        ret = EvsHTTPNetworkLink.retrieveRetCon(con, ret);
        String seq = ihttpMessage.getHeaderValue(SONIC_HEADER_SEQUENCE_NUMBER);
        ret = EvsHTTPNetworkLink.retrieveRetSeq(ret, seq);
        String ack = ihttpMessage.getHeaderValue(SONIC_HEADER_ACK_SEQUENCE_NUMBER);
        ret = EvsHTTPNetworkLink.retrieveRetAck(ack, ret);
        int length = ihttpMessage.getContentLength();
        ret = ret + ", length=" + length;
        ret = ret + "]";
        return ret;
    }

    private static String retrieveRetAck(String ack, String retParam) {
        String ret = retParam;
        if (ack != null) {
            ret = ret + ", ack=" + ack;
        }
        return ret;
    }

    private static String retrieveRetSeq(String retParam, String seq) {
        String ret = retParam;
        if (seq != null) {
            ret = ret + ", seq=" + seq;
        }
        return ret;
    }

    private static String retrieveRetCon(String con, String retParam) {
        String ret = retParam;
        if (con != null) {
            ret = ret + ", con=" + con;
        }
        return ret;
    }

    public static IEvsNetworkLink create(int type, SelectableChannel channel, INetworkLinkConfig config) throws EEvsIOException {
        if (type == 0) {
            return new EvsHTTPServerNetworkLink(type, channel, config);
        }
        return new EvsHTTPClientNetworkLink(type, channel, config);
    }

    protected final int getIntConnectionHeaderProperty(String propName, Properties props, int defValue, boolean required) throws EEvsIOException {
        String strValue = null;
        try {
            strValue = props.getProperty(propName);
            if (strValue == null) {
                if (required) {
                    throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Invalid connection parameter {0} - {1}"), new Object[]{propName, strValue}));
                }
                return defValue;
            }
            return Integer.parseInt(strValue);
        }
        catch (NumberFormatException ex) {
            throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Invalid connection parameter {0} - {1}"), new Object[]{propName, strValue}), (Exception)ex);
        }
    }

    protected final boolean getBooleanConnectionHeaderProperty(String propName, Properties props, boolean defValue, boolean required) throws EEvsIOException {
        String strValue = props.getProperty(propName);
        if (strValue == null) {
            if (required) {
                throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Invalid connection parameter {0} - {1}"), new Object[]{propName, strValue}));
            }
            return defValue;
        }
        return Boolean.valueOf(strValue);
    }

    @Override
    public int getRequestedHeaderReserve() {
        return 0;
    }

    @Override
    public int getRequestedTrailerReserve() {
        return 0;
    }

    static {
        HTTP_PIPELINE_DETECT_TIMEOUT = new Integer(EvsHTTPNetworkLink.getProperty("HTTP_PIPELINE_DETECT_TIMEOUT", "5000"));
        HTTP_HEADER_RESERVE = new Integer(EvsHTTPNetworkLink.getProperty("HTTP_HEADER_RESERVE", "512"));
        int httpServerThreads = new Integer(EvsHTTPNetworkLink.getProperty("HTTP_MAX_SERVER_THREADS", "-1"));
        HTTP_MAX_SERVER_THREADS = httpServerThreads == -1 ? Runtime.getRuntime().availableProcessors() : httpServerThreads;
        if (DEBUG_NEW_HTTP) {
            System.out.println("DEBUG_NEW_HTTP: " + DEBUG_NEW_HTTP);
            System.out.println("HTTP_MAX_HTTP_READ_REQUESTS: " + HTTP_MAX_HTTP_READ_REQUESTS);
            System.out.println("HTTP_HEADER_RESERVE: " + HTTP_HEADER_RESERVE);
            System.out.println("HTTP_MAX_SERVER_THREADS: " + HTTP_MAX_SERVER_THREADS);
        }
        CONNECT_PATH = URI.create("/SC/New");
        WRITE_DATA_PATH = URI.create("/SC/Exist");
        CLOSE_PATH = URI.create("/SC/Close");
        GET_DATA_PATH = URI.create("/SC/ReqData");
        KEEP_ALIVE_PATH = URI.create("/SC/KeepAlive");
    }
}

