/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.http.impl.client;

import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLink;
import com.sonicsw.blackbird.http.client.IHTTPCredentials;
import com.sonicsw.blackbird.http.client.IHTTPCredentialsProvider;
import com.sonicsw.blackbird.http.impl.client.HTTPClientCredentials;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;

public class AuthenticatorCredentialsProvider
implements IHTTPCredentialsProvider {
    private static final boolean DEBUG = true;

    @Override
    public IHTTPCredentials getCredentials(String protocol, String host, int port, String authScheme, String realm) {
        InetAddress inetAddr = null;
        try {
            inetAddr = EvsNetworkLink.LINK_INTERCEPTOR.getInetAddressByName(host);
        }
        catch (EEvsIOException ex) {
            this.debug("Unable to resolve host inet address: " + ex.getMessage());
        }
        PasswordAuthentication pa = Authenticator.requestPasswordAuthentication(host, inetAddr, port, "http", realm, authScheme);
        if (pa != null) {
            return new HTTPClientCredentials(pa.getUserName(), new String(pa.getPassword()));
        }
        this.debug("java.net.Authenticator Unabled to find credentials for: " + host + ":" + port);
        return null;
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    private final void debug(String debug) {
        System.out.println(this + debug);
    }
}

