/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.http.impl.client;

import com.sonicsw.blackbird.evs.nio.nwlink.INetworkLinkConfig;
import com.sonicsw.blackbird.http.IHTTPRequest;
import com.sonicsw.blackbird.http.IHTTPResponse;
import com.sonicsw.blackbird.http.client.HTTPAuthenticationException;
import com.sonicsw.blackbird.http.client.HTTPClientFactory;
import com.sonicsw.blackbird.http.client.IHTTPAuthenticator;
import com.sonicsw.blackbird.http.client.IHTTPCredentialsProvider;
import com.sonicsw.blackbird.http.impl.HTTPConstants;
import com.sonicsw.blackbird.http.impl.HTTPParseUtil;
import java.util.List;
import java.util.Map;

class HTTPAuthManager {
    private static final boolean DEBUG = HTTPConstants.DEBUG;
    private static final boolean DEBUG_UNEXPECTED = HTTPConstants.DEBUG_UNEXPECTED;
    private final IHTTPCredentialsProvider m_proxyCredentialsProvider;
    private final IHTTPCredentialsProvider m_wwwCredentialsProvider;
    private IHTTPAuthenticator m_proxyAuth;
    private IHTTPAuthenticator m_wwwAuth;
    private final INetworkLinkConfig m_config;
    private boolean m_challengeExpected = true;

    public HTTPAuthManager(INetworkLinkConfig config) {
        this.m_config = config;
        this.m_wwwCredentialsProvider = config.getHTTPCredentialsProvider();
        this.m_proxyCredentialsProvider = config.getHTTPProxyCredentialsProvider();
    }

    final boolean expectingAuthChallenge() {
        return this.m_challengeExpected;
    }

    final void prepareAuthHeaders(IHTTPRequest request) throws HTTPAuthenticationException {
        String auth;
        if (!(this.m_proxyAuth == null || this.m_proxyAuth.isConnectionBased() && this.m_proxyAuth.isComplete() && !this.m_challengeExpected)) {
            auth = null;
            try {
                auth = this.m_proxyAuth.authenticate(request);
            }
            catch (HTTPAuthenticationException hae) {
                this.m_proxyAuth = null;
                this.m_challengeExpected = true;
                if (DEBUG || DEBUG_UNEXPECTED) {
                    this.debug("Proxy auth error for request + " + request, hae);
                }
                throw hae;
            }
            request.setHeader("Proxy-Authorization", auth);
        }
        if (!(this.m_wwwAuth == null || this.m_wwwAuth.isConnectionBased() && this.m_wwwAuth.isComplete() && !this.m_challengeExpected)) {
            block7: {
                auth = null;
                try {
                    auth = this.m_wwwAuth.authenticate(request);
                }
                catch (HTTPAuthenticationException hae) {
                    this.m_wwwAuth = null;
                    this.m_challengeExpected = true;
                    if (!DEBUG && !DEBUG_UNEXPECTED) break block7;
                    this.debug("WWW auth error for request + " + request, hae);
                    throw hae;
                }
            }
            request.setHeader("Authorization", auth);
        }
    }

    final void onOkResponse(IHTTPRequest request) {
        if (this.m_challengeExpected) {
            if (DEBUG) {
                this.debug("Ok response Proxy Auth- " + this.m_proxyAuth + ", wwwAuth: " + this.m_wwwAuth);
            }
            this.m_challengeExpected = false;
        }
    }

    final void onNewConnect() {
        if (this.m_wwwAuth != null && this.m_wwwAuth.isConnectionBased() || this.m_proxyAuth != null && this.m_proxyAuth.isConnectionBased()) {
            this.m_challengeExpected = true;
        }
    }

    final boolean handleAuthResponse(IHTTPResponse response, IHTTPRequest request, boolean proxy) throws HTTPAuthenticationException {
        IHTTPAuthenticator authenticator;
        String rawChallenge = response.getHeaderValue(proxy ? "Proxy-Authenticate" : "WWW-Authenticate");
        Map schemes = HTTPParseUtil.parseAuthenticateHeader(rawChallenge);
        if (DEBUG) {
            this.debug("Received auth challenge " + (proxy ? "Proxy-Authenticate" : "WWW-Authenticate") + "-" + rawChallenge + " parsed" + schemes);
        }
        IHTTPAuthenticator iHTTPAuthenticator = authenticator = proxy ? this.m_proxyAuth : this.m_wwwAuth;
        if (authenticator == null) {
            authenticator = HTTPClientFactory.getAuthenticator(schemes, proxy ? this.m_proxyCredentialsProvider : this.m_wwwCredentialsProvider, proxy ? this.m_config.getHTTPProxyProtocol() : this.m_config.getLinkType(), proxy ? this.m_config.getHTTPProxyHost() : this.m_config.getRemoteInterfaceAddress(), proxy ? this.m_config.getHTTPProxyPort() : this.m_config.getRemotePort());
            if (proxy) {
                this.m_proxyAuth = authenticator;
            } else {
                this.m_wwwAuth = authenticator;
            }
        } else {
            List challenges = (List)schemes.get(authenticator.getSchemeName());
            Map parameters = (Map)challenges.get(0);
            try {
                authenticator.processChallenge(parameters);
            }
            catch (HTTPAuthenticationException hae) {
                if (proxy) {
                    this.m_proxyAuth = null;
                } else {
                    this.m_wwwAuth = null;
                }
                throw hae;
            }
        }
        return authenticator.isComplete();
    }

    private final void debug(String str, Throwable thrown) {
        if (thrown != null) {
            System.out.println(str + ", Related Exception: " + thrown.getMessage() + " ( " + this + " ) ");
            thrown.printStackTrace();
        } else {
            System.out.println(str + " ( " + this + " )");
        }
    }

    private final void debug(String str) {
        this.debug(str, null);
    }

    public String toString() {
        return "HTTPAuthManager";
    }
}

