/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.http.impl.client;

import com.sonicsw.blackbird.http.client.IHTTPCredentials;
import com.sonicsw.blackbird.http.impl.HTTPConstants;

class HTTPClientCredentials
implements IHTTPCredentials {
    private final String m_username;
    private final String m_password;
    private final String m_domain;

    HTTPClientCredentials(String usernameParam, String password) {
        String username = usernameParam;
        int bs = username.indexOf("\\");
        String domain = "";
        if (bs != -1) {
            if (bs > 0) {
                domain = username.substring(0, bs);
            }
            username = bs + 1 < username.length() ? username.substring(bs + 1) : "";
        } else {
            domain = HTTPConstants.HTTP_NTLM_AUTH_DOMAIN;
        }
        this.m_username = username;
        this.m_password = password;
        this.m_domain = domain;
    }

    @Override
    public String getNTLMDomain() {
        return this.m_domain;
    }

    @Override
    public String getUsername() {
        return this.m_username;
    }

    @Override
    public String getPassword() {
        return this.m_password;
    }

    @Override
    public String getNTLMWorkstation() {
        return HTTPConstants.HTTP_NTLM_AUTH_WORKSTATION;
    }

    @Override
    public String getCredentialsCharset() {
        return "US-ASCII";
    }
}

