/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.http.impl.client.auth;

import com.sonicsw.blackbird.http.IHTTPRequest;
import com.sonicsw.blackbird.http.client.HTTPAuthenticationException;
import com.sonicsw.blackbird.http.client.IHTTPAuthenticator;
import com.sonicsw.blackbird.http.impl.HTTPParseUtil;
import com.sonicsw.blackbird.http.impl.client.auth.RFC2617Authenticator;
import java.util.Map;

public class BasicAuthenticator
extends RFC2617Authenticator {
    private static final boolean DEBUG = false;
    private boolean complete = false;
    private String m_authString = null;

    @Override
    public final IHTTPAuthenticator createNew() {
        return new BasicAuthenticator();
    }

    @Override
    public String getSchemeName() {
        return "basic";
    }

    @Override
    public final void processChallenge(Map params) throws HTTPAuthenticationException {
        super.processChallenge(params);
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.m_credentials.getUsername());
        buffer.append(":");
        buffer.append(this.m_credentials.getPassword());
        byte[] ascii = HTTPParseUtil.encodeString(buffer.toString(), this.m_credentials.getCredentialsCharset());
        this.m_authString = "Basic " + HTTPParseUtil.bas64Encode(ascii, 0, ascii.length);
        this.complete = true;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    @Override
    public String authenticate(IHTTPRequest request) throws HTTPAuthenticationException {
        return this.m_authString;
    }

    private static final void debug(String str) {
        System.out.println("BasicAuthenticator: " + str);
    }
}

