/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.http.impl.client.auth;

import com.sonicsw.blackbird.http.IHTTPRequest;
import com.sonicsw.blackbird.http.client.HTTPAuthenticationException;
import com.sonicsw.blackbird.http.client.IHTTPAuthenticator;
import com.sonicsw.blackbird.http.client.IHTTPCredentials;
import com.sonicsw.blackbird.http.impl.HTTPConstants;
import com.sonicsw.blackbird.http.impl.client.auth.NTLM;
import java.util.Map;

public class NTLMAuthenticator
implements IHTTPAuthenticator {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_UNEXPECTED = HTTPConstants.DEBUG_UNEXPECTED;
    private String ntlmchallenge = null;
    private IHTTPCredentials m_credentials;
    private static final int UNINITIATED = 0;
    private static final int INITIATED = 1;
    private static final int TYPE1_MSG_GENERATED = 2;
    private static final int TYPE2_MSG_RECEIVED = 3;
    private static final int TYPE3_MSG_GENERATED = 4;
    private static final int FAILED = Integer.MAX_VALUE;
    private int state = 0;

    @Override
    public final IHTTPAuthenticator createNew() {
        return new NTLMAuthenticator();
    }

    @Override
    public void processChallenge(Map parameters) throws HTTPAuthenticationException {
        if (parameters.size() > 1) {
            throw new HTTPAuthenticationException("Invalid parameters in NTLM challenge: " + parameters);
        }
        if (parameters.size() == 1) {
            this.ntlmchallenge = ((String)parameters.keySet().iterator().next()).trim();
            this.state = 3;
        } else {
            this.ntlmchallenge = "";
            if (this.state == 0) {
                this.state = 1;
            } else {
                if (DEBUG_UNEXPECTED) {
                    NTLMAuthenticator.debug("NTLM authentication failure: challeng params " + parameters);
                }
                this.state = Integer.MAX_VALUE;
            }
        }
    }

    @Override
    public boolean isComplete() {
        return this.state == 4 || this.state == Integer.MAX_VALUE;
    }

    @Override
    public String getSchemeName() {
        return "ntlm";
    }

    @Override
    public String getRealm() {
        return null;
    }

    @Override
    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        return null;
    }

    @Override
    public boolean isConnectionBased() {
        return true;
    }

    @Override
    public String authenticate(IHTTPRequest request) throws HTTPAuthenticationException {
        String response = null;
        NTLM ntlm = new NTLM();
        ntlm.setCredentialCharset(this.m_credentials.getCredentialsCharset());
        switch (this.state) {
            case 0: {
                throw new HTTPAuthenticationException("NTLM authentication process has not been initiated");
            }
            case 1: {
                if (this.m_credentials == null) {
                    throw new HTTPAuthenticationException("NTLM authentication credentials not set!");
                }
                if (this.m_credentials.getNTLMDomain() == null) {
                    throw new HTTPAuthenticationException("Invalid credentials! NTLM domain must be supplied");
                }
                if (this.m_credentials.getNTLMWorkstation() == null) {
                    throw new HTTPAuthenticationException("Invalid credentials! NTLM workstation must be supplied");
                }
            }
            case 0x7FFFFFFF: {
                response = ntlm.getType1Message(this.m_credentials.getNTLMWorkstation(), this.m_credentials.getNTLMDomain());
                this.state = 2;
                break;
            }
            case 3: {
                response = ntlm.getType3Message(this.m_credentials.getUsername(), this.m_credentials.getPassword(), this.m_credentials.getNTLMWorkstation(), this.m_credentials.getNTLMDomain(), ntlm.parseType2Message(this.ntlmchallenge));
                this.state = 4;
                break;
            }
            case 4: {
                return null;
            }
        }
        return "NTLM " + response;
    }

    private static final void debug(String debug) {
        System.out.println("NTLMAuthenticator: " + debug);
    }

    @Override
    public void setCredentials(IHTTPCredentials credentials) {
        this.m_credentials = credentials;
    }
}

