/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.sys;

import java.util.Hashtable;
import java.util.Properties;

public class SysConfig {
    private static Hashtable checkedTable = new Hashtable();
    private static Hashtable threadedTable = new Hashtable();
    private static Hashtable traceLevelTable = new Hashtable();
    private static Hashtable testModeTable = new Hashtable();
    public static final int TESTMODE_NONE = 0;
    public static final int TESTMODE_REGULAR = 1;
    public static final int TESTMODE_LOAD = 2;
    public static final int TESTMODE_PERFORMANCE = 3;
    public static final int TESTMODE_RECOVERY = 4;
    public static final int TRACE_LEVEL_ALWAYS = -1;
    public static final int TRACE_LEVEL_NONE = 0;
    public static final int TRACE_LEVEL_ERROR = 1;
    public static final int TRACE_LEVEL_WARN = 2;
    public static final int TRACE_LEVEL_INFO = 3;
    public static final int TRACE_LEVEL_DEBUG = 9;
    public static final int TRACE_LEVEL_DEFAULT = 2;

    public static void setChecked(String pkg, boolean val) {
        SysConfig.checkPackageName(pkg);
        checkedTable.put(pkg, new Boolean(val));
    }

    public static boolean getChecked(String pkg) {
        SysConfig.checkPackageName3(pkg);
        Boolean val = (Boolean)checkedTable.get(pkg);
        return val == null ? false : val;
    }

    public static void setThreaded(String pkg, boolean val) {
        SysConfig.checkPackageName(pkg);
        threadedTable.put(pkg, new Boolean(val));
    }

    private static void checkPackageName(String pkg) {
        if (pkg == null) {
            throw new IllegalArgumentException("package name cannot be null");
        }
    }

    public static boolean getThreaded(String pkg) {
        SysConfig.checkPackageName3(pkg);
        Boolean val = (Boolean)threadedTable.get(pkg);
        return val == null ? false : val;
    }

    private static void checkPackageName3(String pkg) {
        if (pkg == null) {
            throw new IllegalArgumentException("package name cannot be null");
        }
    }

    public static void setTraceLevel(String pkg, int val) {
        SysConfig.checkPackage(pkg);
        traceLevelTable.put(pkg, new Integer(val));
    }

    public static int getTraceLevel(String pkg) {
        SysConfig.checkPackage2(pkg);
        Integer val = (Integer)traceLevelTable.get(pkg);
        return val == null ? 2 : val;
    }

    public static void setDebug(String pkg, boolean val) {
        SysConfig.setTraceLevel(pkg, val ? 9 : 2);
    }

    public static boolean getDebug(String pkg) {
        return SysConfig.getTraceLevel(pkg) >= 9;
    }

    public static void setTestMode(String pkg, int val) {
        SysConfig.checkPackage(pkg);
        testModeTable.put(pkg, new Integer(val));
    }

    private static void checkPackage(String pkg) {
        if (pkg == null) {
            throw new IllegalArgumentException("package name cannot be null");
        }
    }

    public static int getTestMode(String pkg) {
        SysConfig.checkPackage2(pkg);
        Integer val = (Integer)testModeTable.get(pkg);
        return val == null ? 0 : val;
    }

    private static void checkPackage2(String pkg) {
        if (pkg == null) {
            throw new IllegalArgumentException("package name cannot be null");
        }
    }

    public static String getConfigValue(Properties props, String name) {
        String val = null;
        try {
            val = props.getProperty(name).trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public static String getConfigValue(Properties props, String name, String defValue) {
        String value = defValue;
        String valueStr = null;
        try {
            valueStr = SysConfig.getConfigValue(props, name);
            if (valueStr != null) {
                value = valueStr;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static double getConfigValue(Properties props, String name, double defValue) {
        double value = defValue;
        String valueStr = null;
        try {
            valueStr = SysConfig.getConfigValue(props, name);
            if (valueStr != null) {
                value = new Double(valueStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static boolean getConfigValue(Properties props, String name, boolean defValue) {
        boolean value = defValue;
        String valueStr = null;
        try {
            valueStr = SysConfig.getConfigValue(props, name);
            if (valueStr != null) {
                value = new Boolean(valueStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static class PackageConfig {
        public boolean checked;
        public boolean threaded;
        public int traceLevel;
        public int testMode;

        private PackageConfig(String name) {
            this.checked = SysConfig.getChecked(name);
            this.threaded = SysConfig.getThreaded(name);
            this.traceLevel = SysConfig.getTraceLevel(name);
            this.testMode = SysConfig.getTestMode(name);
        }

        public static PackageConfig create(String name) {
            return new PackageConfig(name);
        }
    }
}

