/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sdf;

import com.sonicsw.sdf.AbstractDiagnosticsProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class AbstractMFComponentTracing
extends AbstractDiagnosticsProvider {
    private static final String NO_TRACING_TEXT = "no tracing";
    private String[] OPERATIONS;
    private HashMap DESCRIBE_PARAM_DESCIPTOR;
    private HashMap UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR;
    private HashMap SHOW_TRACE_LEVEL_PARAM_DESCIPTOR;
    private HashMap PARAM_DESCRIPTOR;
    private HashMap m_nameToIntMap;
    private String m_maskNameStringMap;
    private Integer m_currentMask;
    private String m_diagSubsysName;

    public AbstractMFComponentTracing(String diagSubsysName, String maskNameToIntMap0) {
        super(diagSubsysName);
        this.m_diagSubsysName = diagSubsysName;
        this.setMaskNamesMap(maskNameToIntMap0);
        this.m_currentMask = new Integer(0);
        this.DESCRIBE_PARAM_DESCIPTOR = new HashMap();
        this.UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR = new HashMap();
        this.SHOW_TRACE_LEVEL_PARAM_DESCIPTOR = new HashMap();
        this.PARAM_DESCRIPTOR = new HashMap();
        this.UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR.put("integerTraceLevel", "An integer mask. See the stringTraceLevel parameter for the optional values");
        this.UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR.put("stringTraceLevel", "A comma separated list of mask names from the following list: " + this.m_maskNameStringMap);
        this.PARAM_DESCRIPTOR.put("describe", this.DESCRIBE_PARAM_DESCIPTOR);
        this.PARAM_DESCRIPTOR.put("updateTraceLevel", this.UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR);
        this.PARAM_DESCRIPTOR.put("showTraceLevel", this.SHOW_TRACE_LEVEL_PARAM_DESCIPTOR);
        this.OPERATIONS = AbstractMFComponentTracing.toOpnameArray(this.PARAM_DESCRIPTOR);
    }

    public Integer getIntegerMask(String nameMask, StringBuffer buffer) {
        if (nameMask == null) {
            return new Integer(0);
        }
        int intMask = 0;
        StringTokenizer masks = new StringTokenizer(nameMask, ",");
        while (masks.hasMoreElements()) {
            String maskName = masks.nextToken();
            Integer maskIntValue = (Integer)this.m_nameToIntMap.get(maskName);
            if (maskIntValue == null) {
                buffer.append("'" + maskName + "' is invalid - ignored").append(NEWLINE);
                continue;
            }
            intMask += maskIntValue.intValue();
        }
        return new Integer(intMask);
    }

    @Override
    public String[] getOperations() {
        return this.OPERATIONS;
    }

    @Override
    public HashMap describeParameters(String operationName) {
        return (HashMap)this.PARAM_DESCRIPTOR.get(operationName);
    }

    @Override
    public String describe() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Provides trace level setup. Examples:").append(NEWLINE);
        buffer.append(this.m_diagSubsysName).append(" updateTraceLevel stringTraceLevel=verbose,operation_invoked").append(NEWLINE);
        buffer.append(this.m_diagSubsysName).append(" updateTraceLevel integerTraceLevel=5").append(NEWLINE);
        return buffer.toString();
    }

    @Override
    public void updateTraceLevel(String doiIDNotUsed, HashMap parameters, StringBuffer buffer) {
        String stringTraceLevel = (String)parameters.get("stringTraceLevel");
        String intTraceLevel = (String)parameters.get("integerTraceLevel");
        if (stringTraceLevel != null && intTraceLevel != null) {
            buffer.append("Cannot set both stringTraceLevel and integerTraceLevel");
            return;
        }
        if (stringTraceLevel == null && intTraceLevel == null) {
            buffer.append("Both stringTraceLevel and integerTraceLevel were not set; trace level is unchaged - ");
            buffer.append(this.getCurrentMaskNames());
            return;
        }
        if (stringTraceLevel != null) {
            this.setTraceMask(stringTraceLevel, buffer);
        } else {
            Integer mask = null;
            try {
                mask = new Integer(Integer.parseInt(intTraceLevel));
            }
            catch (Exception e) {
                buffer.append("Bad value of integerTraceLevel");
                buffer.append(": " + e.toString());
                buffer.append(" - trace level is unchanged");
                return;
            }
            this.setTraceMask(mask);
        }
        buffer.append("The new trace level is: " + this.getCurrentMaskNames());
    }

    @Override
    public void showTraceLevel(String doiID, HashMap parameters, StringBuffer buffer) {
        buffer.append("The trace level is: " + this.getCurrentMaskNames());
    }

    public final void setTraceMask(Integer mask) {
        this.m_currentMask = mask;
    }

    private void setTraceMask(String maksNames, StringBuffer buffer) {
        this.setTraceMask(this.getIntegerMask(maksNames, buffer));
    }

    protected Integer getCurrentMask() {
        return this.m_currentMask;
    }

    protected String getCurrentMaskNames() {
        int mask = this.m_currentMask;
        ArrayList<String> nameList = new ArrayList<String>();
        for (Map.Entry entry : this.m_nameToIntMap.entrySet()) {
            String maskName = (String)entry.getKey();
            Integer maskInt = (Integer)entry.getValue();
            if ((mask & maskInt) == 0) continue;
            nameList.add(maskInt.toString() + "=" + maskName);
        }
        StringBuffer maskNames = new StringBuffer();
        int listSize = nameList.size();
        for (int i = 0; i < listSize; ++i) {
            maskNames.append((String)nameList.get(i));
            if (i + 1 >= listSize) continue;
            maskNames.append(",");
        }
        if (maskNames.length() == 0) {
            return NO_TRACING_TEXT;
        }
        return "'" + maskNames.toString() + "'";
    }

    private void setMaskNamesMap(String stringMap) {
        StringBuffer correctedStringMap = new StringBuffer();
        if (stringMap == null) {
            this.m_maskNameStringMap = "";
            this.m_nameToIntMap = new HashMap();
            return;
        }
        StringTokenizer maskItems = new StringTokenizer(stringMap, ",");
        HashMap<String, Integer> nameToIntMap = new HashMap<String, Integer>();
        while (maskItems.hasMoreElements()) {
            String maskItem = maskItems.nextToken();
            int valueIndex = maskItem.indexOf("=");
            if (valueIndex == -1) continue;
            Integer maskInt = null;
            try {
                maskInt = new Integer(maskItem.substring(0, valueIndex));
            }
            catch (Exception e) {
                continue;
            }
            String maskName = maskItem.substring(valueIndex + 1).replace(' ', '_');
            nameToIntMap.put(maskName, maskInt);
            if (correctedStringMap.length() > 0) {
                correctedStringMap.append(",");
            }
            correctedStringMap.append(maskInt.toString() + '=' + maskName);
        }
        this.m_maskNameStringMap = correctedStringMap.toString();
        this.m_nameToIntMap = nameToIntMap;
    }
}

