/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sdf.impl;

import com.sonicsw.sdf.DiagnosticsManagerAccess;
import com.sonicsw.sdf.IDiagnosticsConstants;
import com.sonicsw.sdf.IDiagnosticsContext;
import com.sonicsw.sdf.IDiagnosticsHistoryTracker;
import com.sonicsw.sdf.IStateWriter;
import com.sonicsw.sdf.ITracer;
import com.sonicsw.sdf.WriterUtil;
import com.sonicsw.sdf.impl.DiagnosticsHistoryTracker;
import com.sonicsw.sdf.impl.RolloverLogger;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public final class DiagnosticsContext
implements IDiagnosticsContext,
IDiagnosticsConstants {
    private static final String PSEUDO_CONTAINER_NAME = "sonic.diagnostics";
    private final SimpleDateFormat m_dateFormatterShort = new SimpleDateFormat("yyyyMMdd");
    private final SimpleDateFormat m_dateFormatterLong = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS");
    String m_subsystemName;
    String m_subsystemID;
    String m_name;

    public DiagnosticsContext(String subsystemName, String subsystemID) {
        this.m_subsystemName = subsystemName;
        this.m_subsystemID = subsystemID;
        this.m_name = this.m_subsystemName;
        if (subsystemID != null) {
            this.m_name = this.m_name + "." + this.m_subsystemID;
        }
    }

    @Override
    public ITracer getTracer(String tracerFilePath, long maxTracerFileLength) throws IOException {
        return new RolloverLogger(tracerFilePath, maxTracerFileLength);
    }

    @Override
    public ITracer getTracer(long maxTracerFileLength) throws IOException {
        String filename = this.generateFileNameBase(false) + ".trace";
        return new RolloverLogger(filename, maxTracerFileLength);
    }

    @Override
    public ITracer getTracer(String tracerFilePath) throws IOException {
        return new RolloverLogger(tracerFilePath, -1L);
    }

    @Override
    public ITracer getTracer() throws IOException {
        String filename = this.generateFileNameBase(false) + ".trace";
        return new RolloverLogger(filename, -1L);
    }

    @Override
    public IDiagnosticsHistoryTracker createHistoryTrackerObject(String label, Object[] providerObjects) {
        return new DiagnosticsHistoryTracker(label, providerObjects);
    }

    @Override
    public IStateWriter getStateWriter(String stateFilePath) throws IOException {
        return new RolloverLogger(stateFilePath, -1L);
    }

    @Override
    public IStateWriter getStateWriter() throws IOException {
        String filename = this.generateFileNameBase(false) + ".state";
        return new RolloverLogger(filename, -1L);
    }

    @Override
    public IStateWriter getStateWriter(Map<String, String> parameters) throws IOException {
        boolean overwrite = true;
        if (parameters.containsKey("overwrite")) {
            overwrite = Boolean.parseBoolean(parameters.get("overwrite"));
        }
        String filePath = parameters.get("output");
        String filename = this.generateFileNameBase(!overwrite) + ".state";
        Path outputFile = Paths.get(filename, new String[0]);
        if (filePath != null) {
            outputFile = Paths.get(filePath, new String[0]).resolve(outputFile);
            WriterUtil.ensureParentFoldersExists(outputFile);
        }
        return new RolloverLogger(outputFile.toString(), -1L);
    }

    @Override
    public String generateFileNameBase(boolean makeUnique) {
        StringBuilder filename = new StringBuilder();
        String containerName = DiagnosticsManagerAccess.getManager().getContainerName();
        if (containerName == null) {
            containerName = PSEUDO_CONTAINER_NAME;
        }
        filename.append(containerName).append('.');
        SimpleDateFormat dateFormat = makeUnique ? this.m_dateFormatterLong : this.m_dateFormatterShort;
        filename.append(dateFormat.format(new Date())).append('.');
        filename.append(this.m_name);
        for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '-' || c == '.' || c == '$') continue;
            filename.setCharAt(i, '_');
        }
        return filename.toString();
    }
}

