/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sdf.impl;

import com.sonicsw.sdf.IDiagnosticsConstants;
import com.sonicsw.sdf.IDiagnosticsHistoryTracker;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public final class DiagnosticsHistoryTracker
implements IDiagnosticsHistoryTracker,
IDiagnosticsConstants {
    private static final ThreadLocal<SimpleDateFormat> SIMPLE_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yy/MM/dd HH:mm:ss");
        }
    };
    private HistoryItem[] m_history;
    private int m_currentPointer;
    private String m_label;
    private long m_itemCounter;

    public static void main(String[] args) throws Exception {
        Object[] items = new TestItem[20];
        for (int i = 0; i < 20; ++i) {
            items[i] = new TestItem();
        }
        DiagnosticsHistoryTracker tracker = new DiagnosticsHistoryTracker("My Tracker", items);
        for (int i = 0; i < 59; ++i) {
            TestItem item = (TestItem)tracker.getHistoryItem();
            item.m_value = new Integer(i).toString();
        }
        StringBuffer buffer = new StringBuffer();
        tracker.appendHistory(buffer, true);
        System.out.println(buffer);
    }

    DiagnosticsHistoryTracker(String label, Object[] providerObjects) {
        this.m_label = label;
        this.m_itemCounter = 0L;
        this.m_currentPointer = 0;
        int numItems = providerObjects.length;
        this.m_history = new HistoryItem[numItems];
        for (int i = 0; i < numItems; ++i) {
            this.m_history[i] = new HistoryItem(providerObjects[i]);
        }
    }

    @Override
    public Object getHistoryItem() {
        Object providerObject = this.m_history[this.m_currentPointer].getProviderObject();
        this.m_history[this.m_currentPointer].setTimestamp();
        this.m_currentPointer = (this.m_currentPointer + 1) % this.m_history.length;
        ++this.m_itemCounter;
        return providerObject;
    }

    @Override
    public synchronized void appendHistory(StringBuffer buffer) {
        this.appendHistory(buffer, true);
    }

    public synchronized void appendHistory(StringBuffer buffer, boolean doFormatTime) {
        int numItems;
        int crntItem;
        buffer.append(NEWLINE + this.m_label);
        if (this.m_itemCounter == 0L) {
            buffer.append(" *** No items ***" + NEWLINE);
            return;
        }
        buffer.append(NEWLINE);
        if (this.m_itemCounter <= (long)this.m_history.length) {
            crntItem = 0;
            numItems = (int)this.m_itemCounter;
        } else {
            crntItem = this.m_currentPointer;
            numItems = this.m_history.length;
        }
        for (int i = 0; i < numItems; ++i) {
            long time = this.m_history[crntItem].getTimestamp();
            String timeString = doFormatTime ? DiagnosticsHistoryTracker.formatTime(time) + " " : time + "UTC ";
            buffer.append(timeString + this.m_history[crntItem].getProviderObject() + NEWLINE);
            crntItem = (crntItem + 1) % this.m_history.length;
        }
    }

    private static String formatTime(long timestamp) {
        return SIMPLE_DATE_FORMAT.get().format(new Date(timestamp));
    }

    public void appendMap(HashMap map, StringBuffer buffer) {
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            buffer.append(key).append(" ").append(value).append(NEWLINE);
        }
        buffer.append("------------------------------------------" + NEWLINE);
    }

    static class TestItem {
        String m_value;

        TestItem() {
        }

        public String toString() {
            return this.m_value;
        }
    }

    private class HistoryItem {
        private Object m_providerObject;
        private long m_timestamp;

        HistoryItem(Object providerObject) {
            this.m_providerObject = providerObject;
        }

        Object getProviderObject() {
            return this.m_providerObject;
        }

        long getTimestamp() {
            return this.m_timestamp;
        }

        void setTimestamp() {
            this.m_timestamp = System.currentTimeMillis();
        }
    }
}

