/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sdf.impl;

import com.sonicsw.sdf.AbstractDiagnosticsProvider;
import com.sonicsw.sdf.AbstractMFComponentTracing;
import com.sonicsw.sdf.DiagnosticsException;
import com.sonicsw.sdf.DiagnosticsManagerAccess;
import com.sonicsw.sdf.IDiagnosticsConstants;
import com.sonicsw.sdf.IDiagnosticsContext;
import com.sonicsw.sdf.IDiagnosticsManager;
import com.sonicsw.sdf.IDiagnosticsProvider;
import com.sonicsw.sdf.IShutdown;
import com.sonicsw.sdf.impl.DiagnosticsContext;
import com.sonicsw.sdf.impl.InstructionsFileParser;
import com.sonicsw.sdf.impl.JVMHeapDiagnostics;
import com.sonicsw.sdf.impl.JVMThreadDiagnostics;
import com.sonicsw.sdf.impl.RolloverLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public final class DiagnosticsManager
implements IDiagnosticsManager,
IDiagnosticsConstants {
    public static final String HELP_TEXT_PATH = "/com/sonicsw/sdf/text/sdf-help";
    private static final String NO_INSTRUCTIONS_TEXT = "    There are no instructions to execute";
    private static String[] OPERATIONS;
    private static HashMap DUMP_STATE_PARAM_DESCIPTOR;
    private static HashMap DESCRIBE_PARAM_DESCIPTOR;
    private static HashMap DESCRIBE_ALL_PARAM_DESCIPTOR;
    private static HashMap SETUP_PARAM_DESCIPTOR;
    private static HashMap LISTALL_PARAM_DESCIPTOR;
    private static HashMap HELP_PARAM_DESCIPTOR;
    private static HashMap PARAM_DESCRIPTOR;
    private static String DESCRIPTION_TEXT;
    private static String SYS_PROP_DESCRIPTION_TEXT;
    private HashMap m_subSystems;
    private File m_instructionsFile;
    private File m_shutdownFile = new File("shutdown_sonic_container");
    private DiagnosticsSubsystem m_diagnosticsSys;
    private HashMap m_delayedTraceRequests;
    private boolean m_enableTests = Boolean.getBoolean("SonicDiagnosticsEnableTests");
    private IShutdown m_shutdownInterface = null;
    private String m_containerName = null;

    public static void main(String[] args) {
        DiagnosticsManagerAccess.createManager();
        DiagnosticsManager.doSleep(1000000);
    }

    public DiagnosticsManager() {
        this.m_delayedTraceRequests = new HashMap();
        int tmp = Integer.getInteger("DiagnosticsInstructionsFileFrequency", 10);
        tmp = Integer.getInteger("SonicDiagnosticsFileFrequency", tmp);
        if (tmp > 0 && tmp < 3) {
            tmp = 3;
        }
        if (tmp > 10) {
            tmp = 10;
        }
        final int waitTimeBetweenFileSearch = tmp;
        boolean fileSystemPropertySet = false;
        String instructionsFilePath = System.getProperty("SonicDiagnosticsFile");
        if (instructionsFilePath != null) {
            fileSystemPropertySet = true;
        } else {
            instructionsFilePath = "SonicDiagnostics.txt";
        }
        this.m_instructionsFile = new File(instructionsFilePath);
        if (fileSystemPropertySet) {
            this.UnblockingPrintln("System property 'SonicDiagnosticsFile' was set to '" + this.m_instructionsFile.getAbsolutePath() + "' ");
        }
        this.m_subSystems = new HashMap();
        this.m_diagnosticsSys = new DiagnosticsSubsystem("sonic.diagnostics");
        IDiagnosticsContext diagContext = this.register(this.m_diagnosticsSys);
        this.m_diagnosticsSys.setContext(diagContext);
        JVMThreadDiagnostics jvmThreadDiag = new JVMThreadDiagnostics();
        IDiagnosticsContext jvmThreadContext = this.register(jvmThreadDiag);
        jvmThreadDiag.setContext(jvmThreadContext);
        JVMHeapDiagnostics jvmHeapDiag = new JVMHeapDiagnostics();
        IDiagnosticsContext jvmHeapContext = this.register(jvmHeapDiag);
        jvmHeapDiag.setContext(jvmHeapContext);
        if (waitTimeBetweenFileSearch > 0) {
            Thread diagnosticsThread = new Thread("DiagnosticsManager: Executes diagnostics requests submitted through an instructions file"){

                @Override
                public void run() {
                    long prevLastModified = 0L;
                    int numExecutions = 0;
                    while (true) {
                        if (DiagnosticsManager.this.m_shutdownFile.exists() && DiagnosticsManager.this.m_shutdownInterface != null) {
                            DiagnosticsManager.this.startShutdown(DiagnosticsManager.this.m_shutdownInterface);
                        }
                        if (DiagnosticsManager.this.m_instructionsFile.exists()) {
                            long lastModified = DiagnosticsManager.this.m_instructionsFile.lastModified();
                            if (lastModified != prevLastModified) {
                                DiagnosticsManager.this.m_diagnosticsSys.init();
                                prevLastModified = lastModified;
                                DiagnosticsManager.this.processInstructionsFile(DiagnosticsManager.this.m_instructionsFile);
                                numExecutions = DiagnosticsManager.this.m_diagnosticsSys.getNumExecutions();
                            } else if (numExecutions > 1) {
                                DiagnosticsManager.this.processInstructionsFile(DiagnosticsManager.this.m_instructionsFile);
                                --numExecutions;
                            }
                        }
                        DiagnosticsManager.doSleep(waitTimeBetweenFileSearch);
                    }
                }
            };
            diagnosticsThread.setDaemon(true);
            diagnosticsThread.start();
        }
    }

    @Override
    public void setShutdownInterface(IShutdown shutdownInterface) {
        this.m_shutdownInterface = shutdownInterface;
    }

    @Override
    public void setContainerName(String containerName) {
        this.m_containerName = containerName;
    }

    @Override
    public String getContainerName() {
        return this.m_containerName;
    }

    @Override
    public synchronized IDiagnosticsContext register(IDiagnosticsProvider diagnosedSystem) throws DiagnosticsException {
        String subsystemName = diagnosedSystem.getSubsystemName();
        String subsystemID = diagnosedSystem.getSubsystemID();
        if (subsystemName == null) {
            throw new DiagnosticsException("Cannot register IDiagnosticsProvider object " + diagnosedSystem + " its getName() method returns null ");
        }
        Object allreadyRegistered = this.m_subSystems.get(subsystemName);
        if (allreadyRegistered != null && subsystemID == null && allreadyRegistered instanceof HashMap) {
            throw new DiagnosticsException("Cannot register IDiagnosticsProvider object " + subsystemName + " getSubsystemID() is null ");
        }
        if (allreadyRegistered != null && subsystemID != null && allreadyRegistered instanceof IDiagnosticsProvider) {
            throw new DiagnosticsException("Cannot register IDiagnosticsProvider object " + subsystemName + " previous getSubsystemID() was null ");
        }
        if (allreadyRegistered == null) {
            if (subsystemID == null) {
                this.m_subSystems.put(subsystemName, diagnosedSystem);
            } else {
                HashMap<String, IDiagnosticsProvider> instances = new HashMap<String, IDiagnosticsProvider>();
                instances.put(subsystemID, diagnosedSystem);
                this.m_subSystems.put(subsystemName, instances);
            }
        } else if (subsystemID == null) {
            this.m_subSystems.put(subsystemName, diagnosedSystem);
        } else {
            ((HashMap)allreadyRegistered).put(subsystemID, diagnosedSystem);
        }
        String sysInstanceName = DiagnosticsManager.generateFullName(null, subsystemName, subsystemID);
        if (this.m_delayedTraceRequests.containsKey(sysInstanceName)) {
            ArrayList delayedRequests = (ArrayList)this.m_delayedTraceRequests.remove(sysInstanceName);
            int numRequests = delayedRequests.size();
            for (int i = 0; i < numRequests; ++i) {
                DelayedRequest request = (DelayedRequest)delayedRequests.remove(0);
                request.executeDelayedInProvider(diagnosedSystem);
            }
        }
        return new DiagnosticsContext(subsystemName, subsystemID);
    }

    public static IDiagnosticsContext createContext(IDiagnosticsProvider diagnosedSystem) {
        String subsystemName = diagnosedSystem.getSubsystemName();
        String subsystemID = diagnosedSystem.getSubsystemID();
        return new DiagnosticsContext(subsystemName, subsystemID);
    }

    @Override
    public void executeOperation(String opName, String subsystemName, String[] tags, String subsystemID, String doiID, StringBuffer buffer, HashMap parameters) {
        String namePrefix = null;
        try {
            namePrefix = DiagnosticsManager.getWildcardPrefix(subsystemName);
        }
        catch (Exception e) {
            buffer.append(e.getMessage());
            return;
        }
        if (namePrefix == null) {
            this.executeOperationInternal(doiID, subsystemName, subsystemID, opName, buffer, parameters);
            return;
        }
        if (doiID != null || subsystemID != null) {
            throw this.getUniquenessException(subsystemName);
        }
        IDiagnosticsProvider[] systems = this.findRegisteredSystems(namePrefix, opName.equalsIgnoreCase("describe"), tags);
        this.executeOperationInternal(systems, opName, buffer, parameters);
    }

    @Override
    public void executeOperation(String opName, String subsystemName, StringBuffer buffer, HashMap parameters) {
        String namePrefix = null;
        try {
            namePrefix = DiagnosticsManager.getWildcardPrefix(subsystemName);
        }
        catch (Exception e) {
            buffer.append(e.getMessage());
            return;
        }
        if (namePrefix == null) {
            this.executeOperationInternal(null, subsystemName, null, opName, buffer, parameters);
            return;
        }
        IDiagnosticsProvider[] systems = this.findRegisteredSystems(namePrefix, opName.equalsIgnoreCase("describe"), null);
        this.executeOperationInternal(systems, opName, buffer, parameters);
    }

    @Override
    public synchronized HashMap getRegistrationList() {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (String sysName : this.m_subSystems.keySet()) {
            Object tmp = this.m_subSystems.get(sysName);
            String[] instArray = new String[]{};
            if (tmp instanceof HashMap) {
                HashMap instaces = (HashMap)tmp;
                ArrayList intList = new ArrayList();
                Iterator instIter = instaces.keySet().iterator();
                while (instIter.hasNext()) {
                    intList.add(instIter.next());
                }
                instArray = new String[intList.size()];
                intList.toArray(instArray);
            }
            result.put(sysName, instArray);
        }
        return result;
    }

    @Override
    public String executeDiagnosticsInstructions(String diagnosticsInstructionsString) {
        return this.processInstructionsString(diagnosticsInstructionsString);
    }

    private void listInstances(String systemName, String subsystemID, IDiagnosticsProvider diagnosticsSystem, StringBuffer buffer) {
        boolean hasObjects;
        String sysName = DiagnosticsManager.generateFullName(null, systemName, subsystemID);
        String[] diagObjects = diagnosticsSystem.getDOInstances();
        boolean bl = hasObjects = diagObjects != null && diagObjects.length > 0;
        if (!hasObjects) {
            buffer.append("'").append(DiagnosticsManager.generateFullName(null, systemName, subsystemID)).append("' does not contain diagnostics object instances").append(NEWLINE);
            return;
        }
        buffer.append(NEWLINE).append("Diagnostics objects of '" + DiagnosticsManager.generateFullName(null, systemName, subsystemID)).append("':").append(NEWLINE);
        for (int i = 0; i < diagObjects.length; ++i) {
            buffer.append("  ").append(diagObjects[i]).append(NEWLINE);
        }
    }

    private void describe(String systemName, IDiagnosticsProvider subsysParam, StringBuffer buffer) {
        IDiagnosticsProvider subsys = subsysParam;
        if (subsys == null) {
            subsys = this.findRegisteredSystem(systemName, null, true);
        }
        buffer.append(NEWLINE).append(systemName).append(": ").append(subsys.describe()).append(NEWLINE);
        String[] operations = subsys.getOperations();
        for (int i = 0; i < operations.length; ++i) {
            buffer.append("  operation '").append(operations[i]);
            HashMap parameters = subsys.describeParameters(operations[i]);
            if (parameters.size() > 0) {
                buffer.append("' parameters: ").append(NEWLINE);
            } else {
                buffer.append("' no parameters ").append(NEWLINE);
            }
            for (String parameter : parameters.keySet()) {
                buffer.append("    '").append(parameter).append("' ").append(parameters.get(parameter)).append(NEWLINE);
            }
        }
        String[] tagArray = subsys.getTags();
        if (tagArray != null && tagArray.length > 0) {
            buffer.append("  Tags: ").append(DiagnosticsManager.tagArrayToList(tagArray)).append(NEWLINE);
        }
    }

    private synchronized void listAll(StringBuffer buffer) {
        buffer.append(NEWLINE).append(" * Registered subsystems:").append(NEWLINE).append(NEWLINE);
        HashMap regList = this.getRegistrationList();
        for (String sysName : regList.keySet()) {
            String[] instances = (String[])regList.get(sysName);
            if (instances.length == 0) {
                buffer.append(sysName).append(NEWLINE);
                continue;
            }
            for (int i = 0; i < instances.length; ++i) {
                buffer.append(sysName).append(" subsystemID=" + instances[i]).append(NEWLINE);
            }
        }
    }

    private synchronized void describeAll(StringBuffer buffer) {
        Iterator iter = this.m_subSystems.keySet().iterator();
        while (iter.hasNext()) {
            this.describe((String)iter.next(), null, buffer);
        }
    }

    private void executeInProvider(IDiagnosticsProvider provider, String doiID, String operation, HashMap parameters, StringBuffer buffer) {
        int beforeLength = this.retrieveLength(buffer);
        try {
            if (operation.equalsIgnoreCase("updateTraceLevel")) {
                provider.updateTraceLevel(doiID, parameters, buffer);
            } else if (operation.equalsIgnoreCase("showTraceLevel")) {
                provider.showTraceLevel(doiID, parameters, buffer);
            } else if (operation.equalsIgnoreCase("dumpState")) {
                provider.appendStateDump(doiID, parameters, buffer);
            } else if (operation.equalsIgnoreCase("test")) {
                if (this.m_enableTests) {
                    provider.test(parameters, buffer);
                } else {
                    buffer.append("The '").append("SonicDiagnosticsEnableTests").append("' system property must be set to 'true' to enable the execution of test() methods - ignored");
                }
            } else {
                provider.executeOperation(doiID, operation, parameters, buffer);
            }
            int afterLength = this.retrieveLength(buffer);
            if (afterLength > beforeLength && buffer.charAt(afterLength - 1) != '\n') {
                buffer.append(NEWLINE);
            }
        }
        catch (Throwable t) {
            buffer.append("Execution of '").append(operation).append("' in '").append(provider.getSubsystemName()).append("' caused: ").append(t);
        }
    }

    private int retrieveLength(StringBuffer buffer) {
        int afterLength = 0;
        if (buffer != null) {
            afterLength = buffer.length();
        }
        return afterLength;
    }

    private synchronized IDiagnosticsProvider findRegisteredSystem(String systemName, String subsystemID, boolean anyInstance) {
        Object instances = this.m_subSystems.get(systemName);
        if (instances == null) {
            return null;
        }
        if (instances instanceof HashMap) {
            if (subsystemID == null) {
                if (!anyInstance) {
                    throw new DiagnosticsException("*** Cannot find subsystem " + systemName + " instance ID is null");
                }
                Iterator it = ((HashMap)instances).keySet().iterator();
                if (!it.hasNext()) {
                    return null;
                }
                String id = (String)it.next();
                return (IDiagnosticsProvider)((HashMap)instances).get(id);
            }
            return (IDiagnosticsProvider)((HashMap)instances).get(subsystemID);
        }
        return (IDiagnosticsProvider)instances;
    }

    private synchronized IDiagnosticsProvider[] findRegisteredSystems(String systemNamePrefix, boolean singleInstancePerSystem, String[] filterTags) {
        IDiagnosticsProvider[] result = null;
        ArrayList resultList = new ArrayList();
        block0: for (String subsysName : this.m_subSystems.keySet()) {
            if (!subsysName.startsWith(systemNamePrefix)) continue;
            Object instancesObj = this.m_subSystems.get(subsysName);
            if (instancesObj instanceof HashMap) {
                HashMap instances = (HashMap)instancesObj;
                Iterator instIt = instances.keySet().iterator();
                while (instIt.hasNext()) {
                    resultList.add(instances.get(instIt.next()));
                    if (!singleInstancePerSystem) continue;
                    continue block0;
                }
                continue;
            }
            resultList.add(instancesObj);
        }
        if (filterTags != null && filterTags.length > 0) {
            for (int i = resultList.size() - 1; i >= 0; --i) {
                IDiagnosticsProvider provider = (IDiagnosticsProvider)resultList.get(i);
                if (DiagnosticsManager.tagFilter(provider.getTags(), filterTags)) continue;
                resultList.remove(i);
            }
        }
        result = new IDiagnosticsProvider[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    private static String getWildcardPrefix(String subsysName) {
        int wilcardIndex = subsysName.indexOf("*");
        if (wilcardIndex == -1) {
            return null;
        }
        if (subsysName.length() == 1 && wilcardIndex == 0) {
            return "";
        }
        if (wilcardIndex != subsysName.length() - 1) {
            throw new DiagnosticsException("Wildcard format is: 'a.b.c.*' or '*' - the '*' chracter must be the only or last component");
        }
        if (subsysName.charAt(wilcardIndex - 1) != '.') {
            throw new DiagnosticsException("Wildcard format is: 'a.b.c.*' or '*' - the '*' chracter must be the only or last component");
        }
        return subsysName.substring(0, wilcardIndex - 1);
    }

    private static boolean tagFilter(String[] subsystemTags, String[] filterTags) {
        if (filterTags == null || filterTags.length == 0) {
            return true;
        }
        if (subsystemTags == null || subsystemTags.length == 0) {
            return false;
        }
        for (int i = 0; i < filterTags.length; ++i) {
            for (int j = 0; j < subsystemTags.length; ++j) {
                if (!filterTags[i].equalsIgnoreCase(subsystemTags[j])) continue;
                return true;
            }
        }
        return false;
    }

    private static String[] tagListToArray(String list) {
        if (list == null || list.length() == 0) {
            return null;
        }
        ArrayList<String> tmpList = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, ",");
        while (tokens.hasMoreElements()) {
            String tag = tokens.nextToken();
            if (tag.length() <= 0) continue;
            tmpList.add(tag);
        }
        String[] result = new String[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    private static String tagArrayToList(String[] tagArray) {
        StringBuffer tagList = new StringBuffer();
        for (int i = 0; i < tagArray.length; ++i) {
            tagList.append(tagArray[i]);
            if (i + 1 >= tagArray.length) continue;
            tagList.append(",");
        }
        return tagList.toString();
    }

    private void executeOperationInternal(IDiagnosticsProvider[] providers, String operation, StringBuffer buffer, HashMap parameters) {
        for (int i = 0; i < providers.length; ++i) {
            buffer.append(NEWLINE).append("    - ").append(providers[i].getSubsystemName()).append(" -").append(NEWLINE);
            this.executeOperationInternal(null, providers[i].getSubsystemName(), providers[i].getSubsystemID(), operation, buffer, parameters);
        }
    }

    private void executeOperationInternal(String doiID, String systemName, String subsystemID, String operation, StringBuffer buffer, HashMap parameters) {
        boolean describeOp = operation.equalsIgnoreCase("describe");
        boolean listObjectsOp = operation.equalsIgnoreCase("listDiagnosticsInstances");
        boolean updateTraceLevelOp = operation.equalsIgnoreCase("updateTraceLevel");
        IDiagnosticsProvider diagnosticsSystem = null;
        try {
            diagnosticsSystem = this.findRegisteredSystem(systemName, subsystemID, describeOp);
        }
        catch (Exception e) {
            buffer.append(e.getMessage());
            return;
        }
        if (diagnosticsSystem == null) {
            String sysInstanceName = DiagnosticsManager.generateFullName(null, systemName, subsystemID);
            buffer.append("*** Subsystem '" + sysInstanceName + "' is not registered");
            if (updateTraceLevelOp) {
                buffer.append(NEWLINE + " The trace level will be updated when '" + sysInstanceName + "' registers");
                ArrayList<DelayedRequest> delayedRequests = (ArrayList<DelayedRequest>)this.m_delayedTraceRequests.get(sysInstanceName);
                if (delayedRequests == null) {
                    delayedRequests = new ArrayList<DelayedRequest>();
                    this.m_delayedTraceRequests.put(sysInstanceName, delayedRequests);
                }
                delayedRequests.add(new DelayedRequest(doiID, systemName, subsystemID, operation, parameters));
            }
        } else if (listObjectsOp) {
            this.listInstances(systemName, subsystemID, diagnosticsSystem, buffer);
        } else if (describeOp) {
            this.describe(systemName, diagnosticsSystem, buffer);
        } else {
            this.executeInProvider(diagnosticsSystem, doiID, operation, parameters, buffer);
        }
    }

    private static String generateFullName(String doiID, String systemName, String subsystemID) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(systemName);
        if (subsystemID != null) {
            buffer.append(".").append(subsystemID);
        }
        if (doiID != null) {
            buffer.append(".").append(doiID);
        }
        return buffer.toString();
    }

    private static void doSleep(int scnds) {
        try {
            Thread.sleep(scnds * 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInstructionsFile(File instructionsFile) {
        PrintWriter writer = null;
        try {
            ArrayList instructions = InstructionsFileParser.parse(instructionsFile);
            StringBuffer sonicDiagBuffer = new StringBuffer();
            ArrayList<InstructionsFileParser.Instruction> sonicDiagInstructions = this.extractInstructions(instructions, true);
            ArrayList<InstructionsFileParser.Instruction> regularInstructions = this.extractInstructions(instructions, false);
            this.processInstructions(sonicDiagInstructions, null, sonicDiagBuffer);
            String dateString = RolloverLogger.formatTime(System.currentTimeMillis());
            this.logDiagnosticsFromFileProcessingMessage(dateString, instructionsFile);
            writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.m_diagnosticsSys.getOutFile(), true)), true);
            StringBuffer titleBuffer = new StringBuffer();
            titleBuffer.append("    --- ").append(dateString).append(" Executing instruction file '");
            titleBuffer.append(instructionsFile.getAbsolutePath()).append("' ---");
            writer.println(titleBuffer);
            String sonicDiagInfo = sonicDiagBuffer.toString();
            if (sonicDiagInfo != null && sonicDiagInfo.length() > 0) {
                writer.print(sonicDiagInfo);
            }
            writer.flush();
            this.processInstructions(regularInstructions, writer, null);
            if (regularInstructions.size() + sonicDiagInstructions.size() == 0) {
                writer.println(NO_INSTRUCTIONS_TEXT);
                writer.flush();
            }
        }
        catch (Exception e) {
            this.UnblockingPrintln("Failed to process the '" + instructionsFile.getAbsolutePath() + "' instructions file. Caused by...");
            this.UnblockingPrintln(this.getThrowableStack(e));
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startShutdown(final IShutdown shutdownInterface) {
        long tmpID = 0L;
        boolean forcedShutdown = false;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.m_shutdownFile)));
            String line = reader.readLine();
            tmpID = new Long(line.trim());
            try {
                forcedShutdown = new Boolean(reader.readLine().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception line) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception line) {}
            }
        }
        if (tmpID == 0L) {
            return;
        }
        this.m_shutdownFile.delete();
        final long callerID = tmpID;
        String forcedMessage = forcedShutdown ? " - the forced flag is on - calling Runtime.getRuntime().halt(0)" : "";
        this.UnblockingPrintln("Detected file \"" + this.m_shutdownFile.getAbsolutePath() + "\" with ID " + callerID + forcedMessage);
        if (forcedShutdown) {
            this.forcedShutdown(callerID);
        }
        Thread shutdownThread = new Thread("com.sonicsw.sdf.impl.DiagnosticsManager shutdown Thread"){

            @Override
            public void run() {
                if (shutdownInterface != null) {
                    shutdownInterface.shutdownCallback(callerID);
                }
            }
        };
        shutdownThread.setDaemon(true);
        shutdownThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forcedShutdown(long callerID) {
        long startupTimestamp = 0L;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File("start_timestamp"))));
            startupTimestamp = new Long(reader.readLine().trim());
        }
        catch (Exception exception) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        if (startupTimestamp != 0L && callerID == startupTimestamp) {
            Runtime.getRuntime().halt(0);
        }
    }

    private void logDiagnosticsFromFileProcessingMessage(String dateString, File instructionsFile) {
        StringBuffer logEntry = new StringBuffer();
        logEntry.append('[').append(dateString).append("] (info) ");
        logEntry.append("Executing diagnostics instructions from '").append(instructionsFile.getAbsolutePath()).append("'; ");
        logEntry.append("status output is written to '").append(this.m_diagnosticsSys.getOutFile().getAbsolutePath()).append('\'');
        this.UnblockingPrintln(logEntry.toString());
    }

    private String processInstructionsString(String instructionsString) {
        StringBuffer statusBuffer = new StringBuffer();
        try {
            ArrayList instructions = InstructionsFileParser.parse(instructionsString);
            ArrayList<InstructionsFileParser.Instruction> sonicDiagInstructions = this.extractInstructions(instructions, true);
            ArrayList<InstructionsFileParser.Instruction> regularInstructions = this.extractInstructions(instructions, false);
            this.processInstructions(sonicDiagInstructions, null, statusBuffer);
            String dateString = RolloverLogger.formatTime(System.currentTimeMillis());
            this.logRemoteDiagnosticsProcessingMessage(dateString, instructions);
            statusBuffer.append("    --- ").append(dateString).append(" Executing remote diagnostics instructions ---").append(NEWLINE);
            this.warnAboutNoops(sonicDiagInstructions, statusBuffer);
            this.processInstructions(regularInstructions, null, statusBuffer);
            if (regularInstructions.size() + sonicDiagInstructions.size() == 0) {
                statusBuffer.append(NO_INSTRUCTIONS_TEXT + NEWLINE);
            }
        }
        catch (Throwable th) {
            statusBuffer.append("Failed to process remote diagnostics instructions. Caused by: ").append(th.toString()).append(NEWLINE);
            StringBuffer logEntry = new StringBuffer(statusBuffer);
            logEntry.append(this.getThrowableStack(th));
            this.UnblockingPrintln(logEntry.toString());
        }
        return statusBuffer.toString();
    }

    private void logRemoteDiagnosticsProcessingMessage(String dateString, ArrayList<InstructionsFileParser.Instruction> instructions) {
        StringBuffer logEntry = new StringBuffer();
        logEntry.append('[').append(dateString).append("] (info) ");
        logEntry.append("Executing remote diagnostics instructions: ");
        if (instructions.isEmpty()) {
            logEntry.append(NO_INSTRUCTIONS_TEXT);
        } else if (instructions.size() == 1) {
            logEntry.append(instructions.get(0).getInstructionLine().trim());
        } else {
            for (InstructionsFileParser.Instruction instruction : instructions) {
                logEntry.append(NEWLINE).append("  ");
                logEntry.append(instruction.getInstructionLine().trim());
            }
        }
        this.UnblockingPrintln(logEntry.toString());
    }

    private void warnAboutNoops(ArrayList<InstructionsFileParser.Instruction> sonicDiagInstructions, StringBuffer statusBuffer) {
        for (InstructionsFileParser.Instruction instruction : sonicDiagInstructions) {
            HashMap params;
            if (!instruction.getInstructionName().equals("setup") || (params = instruction.getParameters()) == null) continue;
            if (params.containsKey("processInstructionsFileCount")) {
                statusBuffer.append("*** '").append("processInstructionsFileCount").append("' is ignored in remote diagnostics").append(NEWLINE);
            }
            if (!params.containsKey("statusFilePath")) continue;
            statusBuffer.append("*** '").append("statusFilePath").append("' is ignored in remote diagnostics").append(NEWLINE);
        }
    }

    private ArrayList<InstructionsFileParser.Instruction> extractInstructions(ArrayList<InstructionsFileParser.Instruction> instructions, boolean sonicDiag) {
        ArrayList<InstructionsFileParser.Instruction> outList = new ArrayList<InstructionsFileParser.Instruction>();
        for (InstructionsFileParser.Instruction instruction : instructions) {
            if (!instruction.isSyntaxOK()) {
                if (sonicDiag) continue;
                outList.add(instruction);
                continue;
            }
            boolean sonicDiagInstruction = instruction.getSubsystemName().equals("sonic.diagnostics");
            if ((!sonicDiag || !sonicDiagInstruction) && (sonicDiag || sonicDiagInstruction)) continue;
            outList.add(instruction);
        }
        return outList;
    }

    private void processInstructions(ArrayList<InstructionsFileParser.Instruction> instructions, PrintWriter writer, StringBuffer buffer) throws Exception {
        for (InstructionsFileParser.Instruction instruction : instructions) {
            if (!instruction.isSyntaxOK()) {
                if (writer == null) continue;
                writer.println("*** Invalid syntax: " + instruction.getInstructionLine() + NEWLINE);
                continue;
            }
            HashMap parameters = instruction.getParameters();
            String subsystemID = null;
            String doiID = null;
            String[] tags = null;
            if (parameters != null) {
                subsystemID = (String)parameters.remove("subsystemID");
                doiID = (String)parameters.remove("doiID");
                tags = DiagnosticsManager.tagListToArray((String)parameters.remove("filterTags"));
            }
            StringBuffer opBuffer = buffer != null ? buffer : new StringBuffer();
            DiagnosticsManager.appendExecStatement(instruction.getInstructionName(), doiID, instruction.getSubsystemName(), subsystemID, opBuffer);
            this.executeOperation(instruction.getInstructionName(), instruction.getSubsystemName(), tags, subsystemID, doiID, opBuffer, parameters);
            opBuffer.append(NEWLINE + NEWLINE);
            if (writer == null) continue;
            writer.print(opBuffer);
            writer.flush();
        }
    }

    private static void appendExecStatement(String op, String doiID, String subsysName, String subsysID, StringBuffer buffer) {
        buffer.append(" - Executing ").append(op).append(" in ").append(DiagnosticsManager.generateFullName(doiID, subsysName, subsysID)).append(NEWLINE);
    }

    private DiagnosticsException getUniquenessException(String subsysName) {
        return new DiagnosticsException("A wild card is specified in the following subsystem '" + subsysName + "'; that requires that no " + "doiID" + " parameter and no " + "subsystemID" + " parameter are specified");
    }

    private void UnblockingPrintln(final String s) {
        Thread t = new Thread(){

            @Override
            public void run() {
                System.out.println(s);
            }
        };
        t.setDaemon(true);
        t.start();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getThrowableStack(Throwable t) {
        ByteArrayOutputStream bst = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bst);
        t.printStackTrace(pw);
        pw.close();
        return bst.toString();
    }

    static {
        DUMP_STATE_PARAM_DESCIPTOR = new HashMap();
        DESCRIBE_PARAM_DESCIPTOR = new HashMap();
        DESCRIBE_ALL_PARAM_DESCIPTOR = new HashMap();
        SETUP_PARAM_DESCIPTOR = new HashMap();
        LISTALL_PARAM_DESCIPTOR = new HashMap();
        HELP_PARAM_DESCIPTOR = new HashMap();
        PARAM_DESCRIPTOR = new HashMap();
        SETUP_PARAM_DESCIPTOR.put("processInstructionsFileCount", "The number of times the instructions file should get executed. Default is 1 (ignored in remote diagnostics)");
        SETUP_PARAM_DESCIPTOR.put("statusFilePath", "Status file path. Default is 'SonicDiagnostics.status' (ignored in remote diagnostics)");
        PARAM_DESCRIPTOR.put("dumpState", DUMP_STATE_PARAM_DESCIPTOR);
        PARAM_DESCRIPTOR.put("describe", DESCRIBE_PARAM_DESCIPTOR);
        PARAM_DESCRIPTOR.put("describeAll", DESCRIBE_ALL_PARAM_DESCIPTOR);
        PARAM_DESCRIPTOR.put("setup", SETUP_PARAM_DESCIPTOR);
        PARAM_DESCRIPTOR.put("listAll", LISTALL_PARAM_DESCIPTOR);
        PARAM_DESCRIPTOR.put("help", HELP_PARAM_DESCIPTOR);
        OPERATIONS = AbstractDiagnosticsProvider.toOpnameArray(PARAM_DESCRIPTOR);
        StringBuffer tmp = new StringBuffer();
        tmp.append("The ").append("SonicDiagnosticsFileFrequency").append(" system property can be used to change the default of ").append(10).append(" seconds frequency of processing the instructions file (minimum is ").append(3).append(" seconds)").append(NEWLINE);
        tmp.append("The ").append("SonicDiagnosticsFile").append(" system property can be used to change the '").append("SonicDiagnostics.txt").append("' instructions file name default");
        SYS_PROP_DESCRIPTION_TEXT = tmp.toString();
        tmp = new StringBuffer();
        tmp.append("Provides setup and shows the state of the diagnostics system").append(NEWLINE);
        tmp.append(SYS_PROP_DESCRIPTION_TEXT);
        DESCRIPTION_TEXT = tmp.toString();
    }

    class DiagnosticsSubsystem
    extends AbstractDiagnosticsProvider {
        private int m_numExecutions;
        private File m_statusFile;

        DiagnosticsSubsystem(String subsystemName) {
            super(subsystemName);
            this.init();
        }

        final void init() {
            this.m_statusFile = this.statusFileFromInstructionsFile();
            this.m_numExecutions = 1;
        }

        File getOutFile() {
            return this.m_statusFile;
        }

        int getNumExecutions() {
            return this.m_numExecutions;
        }

        void setContext(IDiagnosticsContext diagContext) {
            this.m_diagnosticsContext = diagContext;
        }

        @Override
        public void executeOperation(String doiID, String operation, HashMap parameters, StringBuffer buffer) {
            if (operation.equalsIgnoreCase("setup")) {
                this.setup(parameters, buffer);
            } else if (operation.equalsIgnoreCase("describeAll")) {
                DiagnosticsManager.this.describeAll(buffer);
            } else if (operation.equalsIgnoreCase("listAll")) {
                DiagnosticsManager.this.listAll(buffer);
            } else if (operation.equalsIgnoreCase("help")) {
                this.printFromFileToBuffer(DiagnosticsManager.HELP_TEXT_PATH, buffer);
            } else {
                buffer.append(operation).append(" not implemented").append(NEWLINE);
            }
        }

        @Override
        public String describe() {
            return DESCRIPTION_TEXT;
        }

        @Override
        public String[] getOperations() {
            return OPERATIONS;
        }

        @Override
        public HashMap describeParameters(String operationName) {
            return (HashMap)PARAM_DESCRIPTOR.get(operationName);
        }

        @Override
        public void appendStateDump(String doiIDNotUsed, HashMap Parameters2, StringBuffer buffer) {
            DiagnosticsManager.this.listAll(buffer);
            buffer.append(NEWLINE).append(" * Diagnostics subsystem descriptions").append(NEWLINE);
            DiagnosticsManager.this.describeAll(buffer);
        }

        private void setup(HashMap processParameters, StringBuffer buffer) {
            String tmp = (String)processParameters.get("statusFilePath");
            if (tmp != null) {
                this.m_statusFile = new File(tmp);
            }
            if ((tmp = (String)processParameters.get("processInstructionsFileCount")) != null) {
                this.m_numExecutions = new Integer(tmp);
            }
            buffer.append("statusFilePath").append(" is set to ").append(this.m_statusFile.getAbsolutePath()).append(NEWLINE);
            buffer.append("processInstructionsFileCount").append(" is set to ").append(new Integer(this.m_numExecutions).toString()).append(NEWLINE);
        }

        private File statusFileFromInstructionsFile() {
            String statFileDir = new File(DiagnosticsManager.this.m_instructionsFile.getAbsolutePath()).getParent();
            return new File(statFileDir, "SonicDiagnostics.status");
        }
    }

    class DelayedRequest {
        private String m_doiID;
        private String m_systemName;
        private String m_subsystemID;
        private String m_operation;
        private HashMap m_parameters;

        DelayedRequest(String doiID, String systemName, String subsystemID, String operation, HashMap parameters) {
            this.m_doiID = doiID;
            this.m_systemName = systemName;
            this.m_subsystemID = subsystemID;
            this.m_operation = operation;
            this.m_parameters = parameters;
        }

        void executeDelayedInProvider(IDiagnosticsProvider provider) {
            try {
                StringBuffer throwAwayBuffer = new StringBuffer();
                DiagnosticsManager.this.executeInProvider(provider, this.m_doiID, this.m_operation, this.m_parameters, throwAwayBuffer);
            }
            catch (Exception e) {
                throw new DiagnosticsException("Failed to execute " + this.m_operation + " in " + this.m_systemName + ": " + e.toString());
            }
        }
    }

    static class TestShutdown
    implements IShutdown {
        TestShutdown() {
        }

        @Override
        public void shutdownCallback(long callerID) {
            System.out.println("Shudown called with ID " + callerID);
        }
    }

    static class TestMFComponent
    extends AbstractMFComponentTracing {
        Integer m_traceLevel = this.getMFComponentCurrentMask();

        TestMFComponent(String diagSubsysName, String maskNameToIntMap) {
            super(diagSubsysName, maskNameToIntMap);
        }

        private Integer getMFComponentCurrentMask() {
            return this.getCurrentMask();
        }

        @Override
        public void updateTraceLevel(String doiIDNotUsed, HashMap parameters, StringBuffer buffer) {
            super.updateTraceLevel(doiIDNotUsed, parameters, buffer);
            this.m_traceLevel = this.getCurrentMask();
            System.out.println("The current mask is " + this.m_traceLevel);
        }
    }

    static class TestMultiInstSubsystem
    extends AbstractDiagnosticsProvider {
        TestMultiInstSubsystem(String subsystemName, String id) {
            super(subsystemName);
            this.m_subsystemID = id;
        }

        @Override
        public String describe() {
            return "Tests single instance diagnostics providers";
        }

        @Override
        public String[] getTags() {
            return new String[]{"ssl", "comm"};
        }

        @Override
        public void test(HashMap parameters, StringBuffer buffer) {
            buffer.append(this.m_subsystemName).append(" tested").append(parameters.toString());
        }
    }

    static class TestSubsystem
    extends AbstractDiagnosticsProvider {
        TestSubsystem(String subsystemName) {
            super(subsystemName);
        }

        @Override
        public void updateTraceLevel(String doiID, HashMap parameters, StringBuffer buffer) {
            System.out.println("updateTraceLevel doiID " + doiID + " param " + parameters);
        }

        @Override
        public String describe() {
            return "Tests single instance diagnostics providers";
        }

        @Override
        public String[] getTags() {
            return new String[]{"comm"};
        }

        @Override
        public String[] getDOInstances() {
            return new String[]{"listener-tcp://2370", "listener-tcp://2371", "sender-tcp://2370", "sender-tcp://2371"};
        }

        @Override
        public void test(HashMap parameters, StringBuffer buffer) {
            buffer.append(this.m_subsystemName).append(" tested").append(parameters.toString());
        }
    }
}

