/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sdf.impl;

import com.sonicsw.sdf.IDiagnosticsConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

final class InstructionsFileParser
implements IDiagnosticsConstants {
    InstructionsFileParser() {
    }

    public static void main(String[] argv) throws Exception {
        ArrayList instructions = InstructionsFileParser.parse(new File("inst.txt"));
        for (int i = 0; i < instructions.size(); ++i) {
            System.out.println(NEWLINE + (Instruction)instructions.get(i));
        }
    }

    static ArrayList parse(String instructions) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(instructions));
        return InstructionsFileParser.parse(reader);
    }

    static ArrayList parse(File instructionsFile) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(instructionsFile)));
        return InstructionsFileParser.parse(reader);
    }

    private static ArrayList parse(BufferedReader reader) throws IOException {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        while (true) {
            String line;
            if ((line = reader.readLine()) == null) {
                reader.close();
                return instructions;
            }
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            String subsystenName = null;
            String instructionName = null;
            StringTokenizer tokens = new StringTokenizer(line);
            if (!tokens.hasMoreElements()) continue;
            subsystenName = tokens.nextToken();
            if (!tokens.hasMoreElements()) {
                if (subsystenName.equalsIgnoreCase("help") || subsystenName.equalsIgnoreCase("h") || subsystenName.equalsIgnoreCase("?")) {
                    instructions.add(new Instruction(line, "sonic.diagnostics", "help", new HashMap()));
                    continue;
                }
                instructions.add(new Instruction(line));
                continue;
            }
            instructionName = tokens.nextToken();
            HashMap<String, String> parameters = new HashMap<String, String>();
            while (tokens.hasMoreElements()) {
                String value;
                String key;
                String parameterString = tokens.nextToken();
                int valueIndex = parameterString.indexOf("=");
                if (valueIndex == -1) {
                    key = parameterString;
                    value = "";
                    value = "";
                } else {
                    key = parameterString.substring(0, valueIndex);
                    value = parameterString.substring(valueIndex + 1);
                }
                parameters.put(key, value);
            }
            instructions.add(new Instruction(line, subsystenName, instructionName, parameters));
        }
    }

    static class Instruction {
        private boolean m_syntaxOK;
        private String m_instructionLine;
        private String m_subsystenName;
        private String m_instructionName;
        private HashMap m_parameters;

        Instruction(String instructionLine, String subsystenName, String instructionName, HashMap parameters) {
            this.m_subsystenName = subsystenName;
            this.m_instructionLine = instructionLine;
            this.m_instructionName = instructionName;
            this.m_parameters = parameters;
            this.m_syntaxOK = true;
        }

        Instruction(String instructionLine) {
            this.m_instructionLine = instructionLine;
            this.m_syntaxOK = false;
        }

        String getSubsystemName() {
            return this.m_subsystenName;
        }

        String getInstructionLine() {
            return this.m_instructionLine;
        }

        String getInstructionName() {
            return this.m_instructionName;
        }

        HashMap getParameters() {
            return this.m_parameters;
        }

        boolean isSyntaxOK() {
            return this.m_syntaxOK;
        }

        public String toString() {
            if (!this.m_syntaxOK) {
                return "Bad instruction line: " + this.m_instructionLine;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.m_subsystenName).append(" ").append(this.m_instructionName).append(IDiagnosticsConstants.NEWLINE).append(this.m_parameters.toString());
            return buffer.toString();
        }
    }
}

