/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.util.msgutil.impl;

import com.sonicsw.util.msgutil.ConverterException;
import com.sonicsw.util.msgutil.XmlToJMSMessageConverter;
import com.sonicsw.util.msgutil.impl.BuilderFactory;
import com.sonicsw.util.msgutil.impl.HeaderType;
import com.sonicsw.util.msgutil.impl.MessageType;
import com.sonicsw.util.msgutil.impl.Schema;
import com.sonicsw.util.msgutil.impl.SchemaFactory;
import com.sonicsw.util.msgutil.impl.SerializeUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.activation.MimeType;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import progress.message.jclient.DestinationFactory;
import progress.message.jclient.Header;
import progress.message.jclient.Part;
import progress.message.jimpl.Message;
import progress.message.jimpl.TextMessage;
import progress.message.jimpl.xmessage.MultipartMessage;
import progress.message.jimpl.xmessage.XMLMessage;

public class XmlToJMSMessageConverterImpl
implements XmlToJMSMessageConverter {
    private DocumentBuilder m_builder;
    private Map m_headerAdapterMap = new HashMap();
    JMSHeaderAdapter defaultAdapter = new PropertyAdapter();

    public XmlToJMSMessageConverterImpl() {
        try {
            this.m_builder = BuilderFactory.newBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.sethdrMap();
    }

    private void sethdrMap() {
        this.m_headerAdapterMap.put("JMSPriority", new JMSPriorityAdapter());
        this.m_headerAdapterMap.put("JMSDeliveryMode", new JMSDeliveryModeAdapter());
        this.m_headerAdapterMap.put("JMSReplyTo", new JMSReplyToAdapter());
        this.m_headerAdapterMap.put("JMSExpiration", new JMSExpirationAdapter());
        this.m_headerAdapterMap.put("JMSDestination", new JMSDestinationAdapter());
        this.m_headerAdapterMap.put("JMSRedelivered", new JMSRedeliveredAdapter());
        this.m_headerAdapterMap.put("JMSTimestamp", new JMSTimestampAdapter());
        this.m_headerAdapterMap.put("JMSType", new JMSTypeAdapter());
        this.m_headerAdapterMap.put("JMSCorrelationID", new JMSCorrelationIDAdapter());
        this.m_headerAdapterMap.put("JMSMessageID", new JMSMessageIDAdapter());
    }

    private static Destination toDestination(HeaderType headerType) throws Exception {
        String value = headerType.getValue();
        String destType = headerType.getDestType();
        if (destType == null) {
            throw new Exception("Unknown Destination Type: " + value);
        }
        if ("Topic".equalsIgnoreCase(destType)) {
            return DestinationFactory.createTopic(value);
        }
        if ("Queue".equalsIgnoreCase(destType)) {
            return DestinationFactory.createQueue(value);
        }
        return null;
    }

    @Override
    public boolean isMessage(Document document) {
        try {
            String nameSpace;
            Schema schema;
            boolean result = false;
            Element documentElement = document.getDocumentElement();
            if (documentElement != null && (schema = SchemaFactory.newSchema(nameSpace = documentElement.getNamespaceURI())) != null) {
                String localName = documentElement.getLocalName();
                if (schema.messageLocalName().equals(localName)) {
                    result = true;
                }
            }
            return result;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public javax.jms.Message createMessage(Document document) throws ConverterException {
        try {
            return this.createMessageInternal(document.getDocumentElement());
        }
        catch (Exception e) {
            throw new ConverterException("Not able to create Message from Document", e);
        }
    }

    @Override
    public javax.jms.Message createMessage(InputStream inputStream) throws ConverterException {
        try {
            Document doc = this.m_builder.parse(inputStream);
            return this.createMessageInternal(doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new ConverterException("Not able to create Message from InputStream", e);
        }
    }

    @Override
    public javax.jms.Message createMessage(String s) throws ConverterException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
            Document doc = this.m_builder.parse(is);
            return this.createMessageInternal(doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new ConverterException("Not able to create Message String", e);
        }
    }

    @Override
    public Part createMessagePart(Document document) throws ConverterException {
        try {
            return this.createPartInternal(document.getDocumentElement());
        }
        catch (Exception e) {
            throw new ConverterException("Not able to create Part Document", e);
        }
    }

    @Override
    public Part createMessagePart(InputStream inputStream) throws ConverterException {
        try {
            Document doc = this.m_builder.parse(inputStream);
            return this.createPartInternal(doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new ConverterException("Not able to create Part InputStream", e);
        }
    }

    @Override
    public Part createMessagePart(String s) throws ConverterException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
            Document doc = this.m_builder.parse(is);
            return this.createPartInternal(doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new ConverterException("Not able to create Part String", e);
        }
    }

    private javax.jms.Message createMessageInternal(Element documentElement) throws Exception {
        String messageTypeStr = documentElement.getAttribute("type");
        MessageType messageType = MessageType.lookup(messageTypeStr);
        if (messageType == null) {
            throw new ConverterException("Unsupported serialization message type: " + messageTypeStr);
        }
        javax.jms.Message msg = this.getEmptyMsg(messageType);
        this.setHeaders(documentElement, msg);
        return this.setParts(messageType, documentElement, msg);
    }

    private Part createPartInternal(Element documentElement) throws Exception {
        Object element = null;
        MultipartMessage msg = new MultipartMessage();
        return this.populatePart(documentElement, (javax.jms.Message)msg);
    }

    private Part populatePart(Element partElement, javax.jms.Message msg) throws Exception {
        Part part = this.getNewMsgPart(msg, partElement);
        this.setPartHeaders(part, partElement);
        if (part != null) {
            return part;
        }
        return null;
    }

    private void setPartHeaders(Part part, Element partElement) throws JMSException {
        Header newPartHeaders = part.getHeader();
        NamedNodeMap nnm = partElement.getAttributes();
        for (int j = 0; j < nnm.getLength(); ++j) {
            Attr at = (Attr)nnm.item(j);
            String headerName = at.getName();
            if ("content-type".equals(headerName) || "content-id".equals(headerName)) continue;
            String headerVal = at.getValue();
            newPartHeaders.setHeaderField(headerName, headerVal);
        }
    }

    private javax.jms.Message getEmptyMsg(MessageType mt) throws Exception {
        switch (mt) {
            case XML_MESSAGE: {
                return new XMLMessage();
            }
            case TEXT_MESSAGE: {
                return new TextMessage();
            }
            case MULTI_PART_MESSAGE: {
                return new MultipartMessage();
            }
            case MESSAGE: {
                return new Message();
            }
        }
        throw new Exception("Unsupported serialization message type: " + (Object)((Object)mt));
    }

    private static boolean isTextContent(String contentType) {
        try {
            MimeType mimeType = new MimeType(contentType);
            String type = mimeType.getPrimaryType();
            return "text".equals(type);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private javax.jms.Message setHeaders(Element msgElement, javax.jms.Message msg) throws Exception {
        ArrayList<HeaderType> headerTypes = HeaderType.parse(msgElement);
        int hdrCount = headerTypes.size();
        Object hdrName = null;
        for (int i = 0; i < hdrCount; ++i) {
            HeaderType hdr = headerTypes.get(i);
            Object jmsDestHeaderValue = null;
            JMSHeaderAdapter adapterHdr = (JMSHeaderAdapter)this.m_headerAdapterMap.get(hdr.getName());
            if (adapterHdr == null) {
                adapterHdr = this.defaultAdapter;
            }
            adapterHdr.setJMSProperty(msg, hdr);
        }
        return msg;
    }

    private javax.jms.Message setParts(MessageType messageType, Element msgElement, javax.jms.Message msg) throws Exception {
        NodeList children = msgElement.getChildNodes();
        ArrayList<Element> parts = new ArrayList<Element>();
        int childrenCount = children.getLength();
        for (int i = 0; i < childrenCount; ++i) {
            Element child;
            if (!(children.item(i) instanceof Element) || !"part".equals((child = (Element)children.item(i)).getLocalName()) && !"body".equals(child.getLocalName())) continue;
            parts.add(child);
        }
        int partCount = parts.size();
        switch (messageType) {
            case MULTI_PART_MESSAGE: {
                MultipartMessage mpm = (MultipartMessage)msg;
                for (int i = 0; i < partCount; ++i) {
                    Element partElement = (Element)parts.get(i);
                    Part newPart = this.getNewMsgPart((javax.jms.Message)mpm, partElement);
                    this.setPartHeaders(newPart, partElement);
                    mpm.addPart(newPart);
                }
                break;
            }
            case XML_MESSAGE: 
            case TEXT_MESSAGE: {
                if (partCount <= 0) break;
                Element bodyElement = (Element)parts.get(0);
                ((TextMessage)msg).setText((String)this.getPartContent(bodyElement));
                String contentId = bodyElement.getAttribute("content-id");
                String contentType = bodyElement.getAttribute("content-type");
                if (contentId != null) {
                    HeaderType contentIdHdr = new HeaderType("Content-ID", contentId, null, null);
                    this.defaultAdapter.setJMSProperty(msg, contentIdHdr);
                }
                if (contentType == null) break;
                HeaderType contentTypeHdr = new HeaderType("Content-Type", contentType, null, null);
                this.defaultAdapter.setJMSProperty(msg, contentTypeHdr);
                break;
            }
            default: {
                throw new Exception("Unsupported serialization message type: " + (Object)((Object)messageType));
            }
        }
        return msg;
    }

    private Part getNewMsgPart(javax.jms.Message msg, Element partType) throws Exception {
        String contentId = partType.getAttribute("content-id");
        String contentType = partType.getAttribute("content-type");
        Object partContents = this.populatePartContents(partType, contentType);
        Part newPart = ((MultipartMessage)msg).createPart(partContents, contentType);
        newPart.getHeader().setContentId(contentId);
        return newPart;
    }

    private Object getPartContent(Element partElement) throws Exception {
        String contentId = partElement.getAttribute("content-id");
        String contentType = partElement.getAttribute("content-type");
        Object partContents = this.populatePartContents(partElement, contentType);
        return partContents;
    }

    private Object populatePartContents(Element partElement, String contentType) throws Exception {
        String fileRef = partElement.getAttribute("file-ref");
        Object partContents = null;
        if (fileRef != null && !"".equals(fileRef.trim())) {
            partContents = this.getFileContents(fileRef, contentType);
        } else {
            Node childNode = partElement.getFirstChild();
            partContents = XmlToJMSMessageConverterImpl.retrievePartContents(childNode, partContents);
        }
        return XmlToJMSMessageConverterImpl.resetPartContents(contentType, partContents);
    }

    private static Object resetPartContents(String contentType, Object partContentsParam) {
        Object partContents = partContentsParam;
        if (partContents == null) {
            partContents = XmlToJMSMessageConverterImpl.isTextContent(contentType) ? new String("") : (Object)new byte[0];
        }
        return partContents;
    }

    private static Object retrievePartContents(Node childNode, Object partContentsParam) throws Exception {
        Object partContents = partContentsParam;
        if (childNode instanceof Text) {
            partContents = childNode.getNodeValue();
        } else if (childNode instanceof Element) {
            partContents = SerializeUtils.serializeNodeAsXml(childNode);
        }
        return partContents;
    }

    private Object getFileContents(String fileRef, String contentType) throws ConverterException {
        byte[] byArray;
        InputStream inputStream = null;
        try {
            URL url = new URL(fileRef);
            inputStream = url.openStream();
            if (XmlToJMSMessageConverterImpl.isTextContent(contentType)) {
                String string = SerializeUtils.getTextContent(inputStream, contentType);
                return string;
            }
            byArray = SerializeUtils.getBinaryContent(inputStream);
        }
        catch (Exception e) {
            throw new ConverterException("Not able to get part, file content", e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return byArray;
    }

    static class PropertyAdapter
    implements JMSHeaderAdapter {
        PropertyAdapter() {
        }

        @Override
        public void setJMSProperty(javax.jms.Message msg, HeaderType headerType) throws Exception {
            String jType = headerType.getJavaType();
            if (jType != null) {
                if ("java.lang.Boolean".equalsIgnoreCase(jType)) {
                    msg.setObjectProperty(headerType.getName(), Boolean.valueOf(headerType.getValue()));
                } else if ("java.lang.Byte".equalsIgnoreCase(jType)) {
                    msg.setObjectProperty(headerType.getName(), Byte.valueOf(headerType.getValue()));
                } else if ("java.lang.Short".equalsIgnoreCase(jType)) {
                    msg.setObjectProperty(headerType.getName(), Short.valueOf(headerType.getValue()));
                } else if ("java.lang.Long".equalsIgnoreCase(jType)) {
                    msg.setObjectProperty(headerType.getName(), Long.valueOf(headerType.getValue()));
                } else if ("java.lang.Float".equalsIgnoreCase(jType)) {
                    msg.setObjectProperty(headerType.getName(), Float.valueOf(headerType.getValue()));
                } else if ("java.lang.Double".equalsIgnoreCase(jType)) {
                    msg.setObjectProperty(headerType.getName(), Double.valueOf(headerType.getValue()));
                } else {
                    msg.setObjectProperty(headerType.getName(), headerType.getValue());
                }
            } else {
                msg.setObjectProperty(headerType.getName(), headerType.getValue());
            }
        }
    }

    static interface JMSHeaderAdapter {
        public void setJMSProperty(javax.jms.Message var1, HeaderType var2) throws Exception;
    }

    static class JMSPriorityAdapter
    implements JMSHeaderAdapter {
        JMSPriorityAdapter() {
        }

        @Override
        public void setJMSProperty(javax.jms.Message msg, HeaderType headerType) throws Exception {
            msg.setJMSPriority(Integer.parseInt(headerType.getValue()));
        }
    }

    static class JMSDeliveryModeAdapter
    implements JMSHeaderAdapter {
        JMSDeliveryModeAdapter() {
        }

        @Override
        public void setJMSProperty(javax.jms.Message msg, HeaderType headerType) throws Exception {
            msg.setJMSDeliveryMode(Integer.parseInt(headerType.getValue()));
        }
    }

    static class JMSReplyToAdapter
    implements JMSHeaderAdapter {
        JMSReplyToAdapter() {
        }

        @Override
        public void setJMSProperty(javax.jms.Message msg, HeaderType headerType) throws Exception {
            msg.setJMSReplyTo(XmlToJMSMessageConverterImpl.toDestination(headerType));
        }
    }

    static class JMSExpirationAdapter
    implements JMSHeaderAdapter {
        JMSExpirationAdapter() {
        }

        @Override
        public void setJMSProperty(javax.jms.Message msg, HeaderType headerType) throws Exception {
            msg.setJMSExpiration(Long.parseLong(headerType.getValue()));
        }
    }

    static class JMSDestinationAdapter
    implements JMSHeaderAdapter {
        JMSDestinationAdapter() {
        }

        @Override
        public void setJMSProperty(javax.jms.Message msg, HeaderType headerType) throws Exception {
            msg.setJMSDestination(XmlToJMSMessageConverterImpl.toDestination(headerType));
        }
    }

    static class JMSRedeliveredAdapter
    implements JMSHeaderAdapter {
        JMSRedeliveredAdapter() {
        }

        @Override
        public void setJMSProperty(javax.jms.Message msg, HeaderType headerType) throws Exception {
            msg.setJMSRedelivered(Boolean.parseBoolean(headerType.getValue()));
        }
    }

    static class JMSTimestampAdapter
    implements JMSHeaderAdapter {
        JMSTimestampAdapter() {
        }

        @Override
        public void setJMSProperty(javax.jms.Message msg, HeaderType headerType) throws Exception {
            msg.setJMSTimestamp(Long.parseLong(headerType.getValue()));
        }
    }

    static class JMSTypeAdapter
    implements JMSHeaderAdapter {
        JMSTypeAdapter() {
        }

        @Override
        public void setJMSProperty(javax.jms.Message msg, HeaderType headerType) throws Exception {
            msg.setJMSType(headerType.getValue());
        }
    }

    static class JMSCorrelationIDAdapter
    implements JMSHeaderAdapter {
        JMSCorrelationIDAdapter() {
        }

        @Override
        public void setJMSProperty(javax.jms.Message msg, HeaderType headerType) throws Exception {
            msg.setJMSCorrelationID(headerType.getValue());
        }
    }

    static class JMSMessageIDAdapter
    implements JMSHeaderAdapter {
        JMSMessageIDAdapter() {
        }

        @Override
        public void setJMSProperty(javax.jms.Message msg, HeaderType headerType) throws Exception {
            msg.setJMSMessageID(headerType.getValue());
        }
    }

    static class NullAdapter
    implements JMSHeaderAdapter {
        NullAdapter() {
        }

        @Override
        public void setJMSProperty(javax.jms.Message msg, HeaderType headerType) throws Exception {
        }
    }
}

