/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.api;

import com.sonicsw.ws.rm.api.RMSequence;
import java.util.HashMap;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;

public class RMSequenceHandler
extends BasicHandler {
    public static final String RM_SEQUENCE = "QA_SONICMQ_HTTP_WS_COMMON_RM_SEQUENCE";

    public void invoke(MessageContext msgContext) throws AxisFault {
        MessageContext mc = msgContext;
        if (mc.isClient()) {
            if (!mc.getPastPivot()) {
                this.handleClientRequest(mc);
            } else {
                this.handleClientResponse(mc);
            }
        } else if (!msgContext.getPastPivot()) {
            this.handleServerRequest(mc);
        } else {
            this.handleServerResponse(mc);
        }
    }

    public void init() {
        super.init();
    }

    public void handleClientRequest(MessageContext mc) throws AxisFault {
        RMSequence rms;
        HashMap<String, Object> props = (HashMap<String, Object>)mc.getProperty("transport.jms.msgProps");
        if (props == null) {
            props = new HashMap<String, Object>();
            mc.setProperty("transport.jms.msgProps", props);
        }
        if (mc.getSOAPActionURI() != null && props.get("SOAPAction") == null) {
            props.put("SOAPAction", mc.getSOAPActionURI());
        }
        if ((rms = (RMSequence)mc.getProperty(RM_SEQUENCE)) == null) {
            return;
        }
        props.put("JMSXGroupID", rms.getIdentifier());
        props.put("JMSXGroupSeq", new Integer(rms.getNextMessageNumber()));
        props.put("X-WS-MessagePolicy", rms.getJMSPolicyProperty());
        props.put("Content-Type", "text/xml");
        if (rms.getPreparedLast() && rms.getPreparedLast()) {
            props.put("JMS_SonicMQ_lastMessageInGroup", new Boolean(true));
        }
    }

    public void handleClientResponse(MessageContext mc) throws AxisFault {
    }

    public void handleServerRequest(MessageContext mc) throws AxisFault {
    }

    public void handleServerResponse(MessageContext mc) throws AxisFault {
        HashMap props = (HashMap)mc.getProperty("transport.jms.msgProps");
        if (props == null) {
            return;
        }
        Object inbound = props.get("JMSXGroupID");
        Object outbound = props.get("X-WS-ReturnGroupID");
        if (outbound != null) {
            props.put("JMSXGroupID", outbound);
            props.put("X-WS-ReturnGroupID", inbound);
        } else {
            props.remove("JMSXGroupID");
            props.remove("JMS_SonicMQ_lastMessageInGroup");
            props.remove("X-WS-MessagePolicy");
        }
    }
}

