/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.api;

import com.sonicsw.ws.rm.api.ReliableSequenceInteractorException;
import com.sonicsw.ws.rm.api.SoapVerifier;
import com.sonicsw.ws.rm.protocol.Constants;
import com.sonicsw.ws.rm.protocol.ElementCreator;
import com.sonicsw.ws.rm.protocol.ReliableHeaders;
import java.io.ByteArrayInputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.apache.axis.AxisEngine;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.soap.SOAP11Constants;
import org.apache.axis.soap.SOAP12Constants;
import org.apache.axis.soap.SOAPConstants;

public class ReliableSequenceEncodeHelperForJMS {
    public static void encodeCreateSequenceRequest(javax.jms.Message message, String url, long expires, long offerExpires, String offerIdentifier, String soapVers) throws ReliableSequenceInteractorException, JMSException {
        try {
            SOAPEnvelope se = ElementCreator.createCreateSequence(url, expires, offerExpires, offerIdentifier, ReliableSequenceEncodeHelperForJMS.getSoapConstants(soapVers), Constants.FEB2005_CONSTANTS);
            ElementCreator.addNamespaceDeclarations(se, Constants.FEB2005_CONSTANTS);
            ReliableSequenceEncodeHelperForJMS.setText(message, se.toString());
        }
        catch (JMSException jmse) {
            throw jmse;
        }
        catch (Exception e) {
            throw new ReliableSequenceInteractorException(e.toString(), e);
        }
    }

    public static void encodeCreateSequenceRequest(javax.jms.Message message, String url, String soapVers, String rmVers) throws ReliableSequenceInteractorException, JMSException {
        try {
            SOAPEnvelope se = ElementCreator.createCreateSequence(url, ReliableSequenceEncodeHelperForJMS.getSoapConstants(soapVers), ReliableSequenceEncodeHelperForJMS.getRMConstants(rmVers));
            ElementCreator.addNamespaceDeclarations(se, ReliableSequenceEncodeHelperForJMS.getRMConstants(rmVers));
            ReliableSequenceEncodeHelperForJMS.setText(message, se.toString());
        }
        catch (JMSException jmse) {
            throw jmse;
        }
        catch (Exception e) {
            throw new ReliableSequenceInteractorException(e.toString(), e);
        }
    }

    public static void encodeTerminateSequenceRequest(javax.jms.Message message, String id, String url, String soapVers, String rmVers) throws ReliableSequenceInteractorException, JMSException {
        try {
            SOAPEnvelope se = ElementCreator.createTerminateSequence(id, new EndpointReference(new Address(url)), ReliableSequenceEncodeHelperForJMS.getSoapConstants(soapVers), ReliableSequenceEncodeHelperForJMS.getRMConstants(rmVers));
            ElementCreator.addNamespaceDeclarations(se, ReliableSequenceEncodeHelperForJMS.getRMConstants(rmVers));
            ReliableSequenceEncodeHelperForJMS.setText(message, se.toString());
        }
        catch (JMSException jmse) {
            throw jmse;
        }
        catch (Exception e) {
            throw new ReliableSequenceInteractorException(e.toString(), e);
        }
    }

    public static void encodeEmptyBody(javax.jms.Message message, String soapVers, String rmVers) throws ReliableSequenceInteractorException, JMSException {
        try {
            SOAPEnvelope se = ElementCreator.createSimpleEnvelope(null, null, ReliableSequenceEncodeHelperForJMS.getSoapConstants(soapVers), ReliableSequenceEncodeHelperForJMS.getRMConstants(rmVers));
            ReliableSequenceEncodeHelperForJMS.setText(message, se.toString());
        }
        catch (JMSException jmse) {
            throw jmse;
        }
        catch (Exception e) {
            throw new ReliableSequenceInteractorException(e.toString(), e);
        }
    }

    public static String decodeCreateSequenceResponse(javax.jms.Message response) throws ReliableSequenceInteractorException {
        try {
            String contentType = ReliableSequenceEncodeHelperForJMS.validateResponseRetrieveContentType(response);
            String txt = null;
            if (response instanceof TextMessage) {
                TextMessage x = (TextMessage)response;
                txt = x.getText();
            } else if (response instanceof BytesMessage) {
                BytesMessage bm = (BytesMessage)response;
                byte[] b = new byte[(int)bm.getBodyLength()];
                bm.readBytes(b);
                txt = new String(b);
            } else {
                throw new ReliableSequenceInteractorException("Response is not an TextMessage, XMLMessage or BytesMessage");
            }
            ByteArrayInputStream inp = new ByteArrayInputStream(txt.getBytes());
            SoapVerifier verifier = new SoapVerifier(inp, contentType);
            Message axisMsg = new Message((Object)txt);
            MessageContext mc = new MessageContext((AxisEngine)new AxisClient());
            mc.setSOAPConstants(verifier.getSoapConstants());
            axisMsg.setMessageContext(mc);
            SOAPFault fault = (SOAPFault)axisMsg.getSOAPBody().getFault();
            if (fault != null) {
                throw fault.getFault();
            }
            ReliableHeaders rh = new ReliableHeaders();
            if (rh == null) {
                throw new ReliableSequenceInteractorException("WS-RM protocol headers missing.");
            }
            rh.fromSOAPEnvelope(axisMsg.getSOAPEnvelope());
            if (rh.getCreateSequenceResponse() == null) {
                throw new ReliableSequenceInteractorException("WS-RM create sequence response header missing.");
            }
            String id = rh.getCreateSequenceResponse().getIdentifier().getIdentifier();
            return id;
        }
        catch (Exception e) {
            ReliableSequenceInteractorException rsie = new ReliableSequenceInteractorException(e.toString(), e);
            throw rsie;
        }
    }

    public static void decodeTerminateSequenceResponse(javax.jms.Message response) throws ReliableSequenceInteractorException {
        try {
            String contentType = ReliableSequenceEncodeHelperForJMS.validateResponseRetrieveContentType(response);
            String txt = null;
            if (response instanceof TextMessage) {
                TextMessage x = (TextMessage)response;
                txt = x.getText();
            } else if (response instanceof BytesMessage) {
                BytesMessage bm = (BytesMessage)response;
                byte[] b = new byte[(int)bm.getBodyLength()];
                bm.readBytes(b);
                txt = new String(b);
            } else {
                throw new ReliableSequenceInteractorException("Response is not an XMLMessage or BytesMessage");
            }
            ByteArrayInputStream inp = new ByteArrayInputStream(txt.getBytes());
            SoapVerifier verifier = new SoapVerifier(inp, contentType);
            Message axisMsg = new Message((Object)txt);
            MessageContext mc = new MessageContext((AxisEngine)new AxisClient());
            mc.setSOAPConstants(verifier.getSoapConstants());
            axisMsg.setMessageContext(mc);
            SOAPFault fault = (SOAPFault)axisMsg.getSOAPBody().getFault();
            if (fault != null) {
                throw fault.getFault();
            }
        }
        catch (Exception e) {
            ReliableSequenceInteractorException rsie = new ReliableSequenceInteractorException(e.toString(), e);
            throw rsie;
        }
    }

    private static String validateResponseRetrieveContentType(javax.jms.Message response) throws ReliableSequenceInteractorException {
        if (response == null) {
            throw new ReliableSequenceInteractorException("Response is null.");
        }
        String contentType = "text/xml";
        return contentType;
    }

    private static Constants getRMConstants(String ver) {
        if (ver.equalsIgnoreCase("WSRMVersionMAR2004")) {
            return Constants.MAR2004_CONSTANTS;
        }
        return Constants.FEB2005_CONSTANTS;
    }

    private static SOAPConstants getSoapConstants(String ver) {
        if (ver.equalsIgnoreCase("SOAP 1.2")) {
            return new SOAP12Constants();
        }
        return new SOAP11Constants();
    }

    private static void setText(javax.jms.Message m, String s) throws JMSException {
        if (m instanceof TextMessage) {
            ((TextMessage)m).setText(s);
        } else if (m instanceof BytesMessage) {
            ((BytesMessage)m).writeBytes(s.getBytes());
        }
    }
}

