/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.api;

import com.sonicsw.ws.rm.api.ReliableSequenceInteractorException;
import java.util.Properties;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.Session;

public class ReliableSequenceInteractorConfiguration {
    public static final String REQUEST_SYSTEM_ASSIGNED = "REQUEST_SYSTEM_ASSIGNED";
    public static final String SOAP_VERSION_11 = "SOAP 1.1";
    public static final String SOAP_VERSION_12 = "SOAP 1.2";
    public static final String RM_VERSION_MAR2004 = "WSRMVersionMAR2004";
    public static final String RM_VERSION_FEB2005 = "WSRMVersionFEB2005";
    private Session m_senderSession = null;
    private QueueSender m_sender = null;
    private QueueReceiver m_receiver = null;
    private Queue m_sequenceFaultDestination = null;
    private int m_retries = 0;
    private long m_replyTimeout = 30000L;
    private long m_retryInterval = 10000L;
    private String m_endpointURL = null;
    private String m_SOAPVersion = "SOAP 1.2";
    private String m_policy = "";
    private String m_reliableMessagingVersion = "WSRMVersionFEB2005";
    private String m_transportAcceptor = null;
    private boolean m_useBytesMessage = false;
    private long m_sequenceExpires = -1L;
    private String m_offeredReturnSequenceIdentifier = null;
    private long m_offeredReturnSequenceExpires = -1L;
    private Properties m_props = new Properties();

    public void setSenderSession(Session session) {
        this.m_senderSession = session;
    }

    public void setSender(QueueSender sender) {
        this.m_sender = sender;
    }

    public void setReceiver(QueueReceiver receiver) {
        this.m_receiver = receiver;
    }

    public void setRetries(int retries) {
        this.m_retries = retries;
    }

    public void setReplyTimeout(long timeout) {
        this.m_replyTimeout = timeout;
    }

    public void setRetryInterval(long interval) {
        this.m_retryInterval = interval;
    }

    public void setEndpointURL(String url) {
        this.m_endpointURL = url;
    }

    public void setSOAPVersion(String version) {
        this.m_SOAPVersion = version;
    }

    public void setReliableMessagingVersion(String version) {
        this.m_reliableMessagingVersion = version;
    }

    public void setTransportAcceptor(String acceptor) {
        this.m_transportAcceptor = acceptor;
    }

    public void setSequenceFaultDestination(Queue sequenceFaultDestination) {
        this.m_sequenceFaultDestination = sequenceFaultDestination;
    }

    public void setUseBytesMessage(boolean use) {
        this.m_useBytesMessage = use;
    }

    public void setSequenceExpires(long ttl) {
        this.m_sequenceExpires = ttl;
    }

    public void setOfferedReturnSequenceIdentifier(String identifier) {
        this.m_offeredReturnSequenceIdentifier = identifier;
    }

    public void setOfferedReturnSequenceExpires(long ttl) {
        this.m_offeredReturnSequenceExpires = ttl;
    }

    public void setPolicy(String policy) {
        this.m_policy = policy;
    }

    public Session getSenderSession() {
        return this.m_senderSession;
    }

    public QueueSender getSender() {
        return this.m_sender;
    }

    public QueueReceiver getReceiver() {
        return this.m_receiver;
    }

    public int getRetries() {
        return this.m_retries;
    }

    public long getReplyTimeout() {
        return this.m_replyTimeout;
    }

    public long getRetryInterval() {
        return this.m_retryInterval;
    }

    public String getEndpointURL() {
        return this.m_endpointURL;
    }

    public String getSOAPVersion() {
        return this.m_SOAPVersion;
    }

    public String getReliableMessagingVersion() {
        return this.m_reliableMessagingVersion;
    }

    public String getTransportAcceptor() {
        return this.m_transportAcceptor;
    }

    public Queue getSequenceFaultDestination() {
        return this.m_sequenceFaultDestination;
    }

    public boolean getUseBytesMessage() {
        return this.m_useBytesMessage;
    }

    public long getSequenceExpires() {
        return this.m_sequenceExpires;
    }

    public String getOfferedReturnSequenceIdentifier() {
        return this.m_offeredReturnSequenceIdentifier;
    }

    public long getOfferedReturnSequenceExpires() {
        return this.m_offeredReturnSequenceExpires;
    }

    public String getPolicy() {
        return this.m_policy;
    }

    public Properties getProperties() {
        return this.m_props;
    }

    protected void validate() throws ReliableSequenceInteractorException {
        if (this.m_senderSession == null) {
            throw new ReliableSequenceInteractorException("JMS Sender Session property missing");
        }
        boolean tx = false;
        try {
            tx = this.m_senderSession.getTransacted();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tx) {
            throw new ReliableSequenceInteractorException("JMS Sender Session must not be transacted");
        }
        if (this.m_sender == null) {
            throw new ReliableSequenceInteractorException("JMS Queue Sender property missing");
        }
        if (this.m_receiver == null) {
            throw new ReliableSequenceInteractorException("JMS Queue Receiver property missing");
        }
        if (this.m_endpointURL == null) {
            throw new ReliableSequenceInteractorException("Endpoint URL is missing");
        }
    }
}

