/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.protocol;

import com.sonicsw.ws.rm.protocol.AckRequested;
import com.sonicsw.ws.rm.protocol.CreateSequence;
import com.sonicsw.ws.rm.protocol.CreateSequenceResponse;
import com.sonicsw.ws.rm.protocol.Sequence;
import com.sonicsw.ws.rm.protocol.SequenceAcknowledgement;
import com.sonicsw.ws.rm.protocol.TerminateSequence;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;

public class ReliableHeaders {
    private CreateSequence createSequence = null;
    private CreateSequenceResponse createSequenceResponse = null;
    private Vector ackRequest = null;
    private Vector sequenceAcknowledgement = null;
    private Sequence sequence = null;
    private TerminateSequence terminateSequence = null;

    public SOAPEnvelope toSOAPEnvelope(SOAPEnvelope envelope) throws Exception {
        int i;
        SOAPEnvelope env = envelope;
        if (this.createSequence != null) {
            this.createSequence.toSOAPEnvelope(env);
        }
        if (this.createSequenceResponse != null) {
            this.createSequenceResponse.toSOAPEnvelope(env);
        }
        if (this.ackRequest != null) {
            for (i = 0; i < this.ackRequest.size(); ++i) {
                AckRequested ar = (AckRequested)this.ackRequest.elementAt(i);
                ar.toSOAPEnvelope(env);
            }
        }
        if (this.sequenceAcknowledgement != null) {
            for (i = 0; i < this.sequenceAcknowledgement.size(); ++i) {
                SequenceAcknowledgement sa = (SequenceAcknowledgement)this.sequenceAcknowledgement.elementAt(i);
                sa.toSOAPEnvelope(env);
            }
        }
        if (this.sequence != null) {
            this.sequence.toSOAPEnvelope(env);
        }
        if (this.terminateSequence != null) {
            this.terminateSequence.toSOAPEnvelope(env);
        }
        return env;
    }

    public ReliableHeaders fromSOAPEnvelope(SOAPEnvelope env) throws AxisFault, SOAPException {
        if (env != null) {
            for (SOAPHeaderElement headerElement : env.getHeaders()) {
                if (headerElement.getName().equals("Sequence")) {
                    headerElement.setMustUnderstand(false);
                    this.sequence = new Sequence(headerElement);
                }
                if (headerElement.getName().equals("SequenceAcknowledgement")) {
                    this.initSequenceAcknowledgement();
                    this.sequenceAcknowledgement.add(new SequenceAcknowledgement(headerElement));
                }
                if (!headerElement.getName().equals("AckRequested")) continue;
                this.initAckRequest();
                this.ackRequest.add(new AckRequested(headerElement));
            }
            Iterator iterator = env.getBody().getChildElements();
            while (iterator.hasNext()) {
                SOAPBodyElement bodyElement = (SOAPBodyElement)iterator.next();
                if (bodyElement.getName() != null && bodyElement.getName().equals("CreateSequence")) {
                    this.createSequence = new CreateSequence(bodyElement);
                    continue;
                }
                if (bodyElement.getName().equals("CreateSequenceResponse")) {
                    this.createSequenceResponse = new CreateSequenceResponse(bodyElement);
                    continue;
                }
                if (!bodyElement.getName().equals("TerminateSequence")) continue;
                this.terminateSequence = new TerminateSequence(bodyElement);
            }
        }
        return this;
    }

    public CreateSequenceResponse getCreateSequenceResponse() {
        return this.createSequenceResponse;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public Vector getSequenceAcknowledgements() {
        return this.sequenceAcknowledgement;
    }

    public TerminateSequence getTerminateSequence() {
        return this.terminateSequence;
    }

    public void setCreateSequence(CreateSequence sequence) {
        this.createSequence = sequence;
    }

    public void setCreateSequenceResponse(CreateSequenceResponse response) {
        this.createSequenceResponse = response;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public void addSequenceAcknowledgement(SequenceAcknowledgement acknowledgement) {
        this.initSequenceAcknowledgement();
        this.sequenceAcknowledgement.add(acknowledgement);
    }

    private void initSequenceAcknowledgement() {
        if (this.sequenceAcknowledgement == null) {
            this.sequenceAcknowledgement = new Vector();
        }
    }

    public void setTerminateSequence(TerminateSequence sequence) {
        this.terminateSequence = sequence;
    }

    public void addAckRequest(AckRequested requested) {
        this.initAckRequest();
        this.ackRequest.add(requested);
    }

    private void initAckRequest() {
        if (this.ackRequest == null) {
            this.ackRequest = new Vector();
        }
    }

    public Vector getAckRequests() {
        return this.ackRequest;
    }

    public CreateSequence getCreateSequence() {
        return this.createSequence;
    }

    public boolean isAnyHeaderBlockPresent() {
        return this.sequence != null || this.ackRequest != null || this.sequenceAcknowledgement != null;
    }
}

